@extends('layouts.app')

@section('title', 'Blogs')
@section('content')



    <link href="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/css/bootstrap4-toggle.min.css" rel="stylesheet">
    <!-- Main content -->
    <section class="content">

        <div class="row">
            <div class="col-12">
                <div class="box">
                    <div class="box-body">

                        <h4 class="box-title text-info mb-0"><i class="icon-Cardboard-vr"><span class="path1"></span><span
                                    class="path2"></span></i> Blogs tag</h4>
                      

                        <hr class="my-15">
                        <div class="table-responsive">

                       
                        <div class="table-responsive">
                            <table class="table">
                                <thead class="thead-light">
                                    <tr>
                                    <th>Id</th>
                                    <th>Tag</th>

                                </tr>
                                </thead>
                        <tbody id="blog-table-body">
                                @foreach ($tags as $tag)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $tag->name }}</td>

                                    </tr>

                                    <!-- Status Modal -->
                                    <div class="modal fade" id="status-{{ $blog->id }}" role="dialog">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-body">
                                                    <div class="text-center">
                                                        <div class="avatar avatar-xl bg-danger-light rounded-circle mb-3">
                                                            <i class="ti ti-pencil fs-36 text-danger"></i>
                                                        </div>
                                                        <h4 class="mb-2">Update Blog Status?</h4>
                                                        <p class="mb-0">Are you sure you want to update the status to
                                                            {{ $blog->is_published ? 'Draft' : 'Published' }}?</p>
                                                        <form method="POST"
                                                            action="{{ route('blogs.toggle-status', $blog->slug) }}"
                                                            style="display:inline;">
                                                            @csrf
                                                            @method('PUT')
                                                            <input type="hidden" name="is_published"
                                                                value="{{ $blog->is_published ? 0 : 1 }}">
                                                            <div
                                                                class="d-flex align-items-center justify-content-center mt-4">
                                                                <a href="#" class="btn btn-light me-2"
                                                                    data-bs-dismiss="modal">Cancel</a>
                                                                <button type="submit" class="btn btn-primary">Yes</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Delete Modal -->
                                    <div class="modal fade" id="delete_activity{{ $blog->id }}" role="dialog">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-body">
                                                    <div class="text-center">
                                                        <div class="avatar avatar-xl bg-danger-light rounded-circle mb-3">
                                                            <i class="ti ti-trash-x fs-36 text-danger"></i>
                                                        </div>
                                                        <h4 class="mb-2">Remove Blog?</h4>
                                                        <p class="mb-0">Are you sure you want to remove this blog?</p>
                                                        <form method="POST"
                                                            action="{{ route('blogs.destroy', $blog->slug) }}"
                                                            style="display:inline;">
                                                            @csrf
                                                            @method('DELETE')
                                                            <div
                                                                class="d-flex align-items-center justify-content-center mt-4">
                                                                <a href="#" class="btn btn-light me-2"
                                                                    data-bs-dismiss="modal">Cancel</a>
                                                                <button type="submit"
                                                                    class="btn btn-primary">Delete</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </tbody>                            </table>
                        </div>

</div>



  </div>

                               
                        </div>
                    </div>
                </div>
            </div>
          
        </div>

    </section>

   


@endsection
