@extends('layouts.app')

@section('title', 'Event List')
@section('content')

    <!-- Main content -->
    <section class="content">

      <div class="row">        
        <div class="col-12">
          <div class="box">
           <div class="box-body">           
                    
               <h4 class="box-title text-info mb-0"><i class="icon-Cardboard-vr"><span class="path1"></span><span class="path2"></span></i>  Event List</h4>
              
          <hr class="my-15">
              <div class="table-responsive">
                <table id="tickets" class="table mt-0 table-hover" data-page-size="10">
                  <thead>
                    <tr>
                      <th>#</th>
                      <th>Title</th>
                      <th>Color</th>
                      <th>Start Date</th>
                      <th>End date</th>               
                       <th>Action</th>

                            </tr>
                  </thead>
                  <tbody>
                    @foreach($events as $key => $event)
                                <tr>
                                  <th scope="row">{{$key+1}}</th>
                                  <td>{{$event->title}}</td>
                                  <td>{{$event->color}}</td>
                                  <td>{{$event->start_date}}</td>
                                  <td>{{$event->end_date}}</td>
                                  <td>
                                  <a style="cursor:pointer;" title="Edit" class='editEvent' data-id="{{$event->id}}"  ><i class="fa fa-edit fa-lg"></i></a> 
                                    <!-- <a href="{{url('edit-event',$event->id)}}"><i class="fa fa-edit fa-lg"></i></a> -->
                                  <a  class="Delete" style="cursor:pointer;"data-eventid="{{$event->id}}" ><i class="fa fa-trash-o fa-lg"></i></a>

                    
                
                </td>
                                </tr>
                             
                                
                                @endforeach
                                
                              </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
  
      </div>
      <div class="modal fade" id="delete" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="myModalLabel">Confirm Delete</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>

                <div class="modal-body">
                  <p>You are about to delete <b><i class="title"></i></b>Event.</p>
                  <p>Do you want to proceed?</p>
                  <input type="text" class="form-control" name="event_id" value="" id="event_id">
                  
                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                  <button type="submit"name="submit" class="btn btn-danger btn-sm deleteEvent">Delete</button>
                </div>
              </div>
            </div>
        </div>
      </div>
      <div class="modal fade" id="myModal" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title" id="add-edit">Edit events</h5>
              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
              <form  >
                @csrf
                <input type="hidden" class="form-control" name="eve_id" value="" id ="eve_id" required>
                        <div class="modal-body">
                        <div class="row">
                                <div class="col-md-6">
                                    <label class="form-label">Title</label>
                                    <input class="form-control form-white" placeholder="Enter Title" type="text" name="title" id="title"/>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Choose  Color</label>
                                    <select class="form-select form-white" data-placeholder="Choose a color..." name="color"id="color">
                                        <option value="success">Success</option>
                                        <option value="danger">Danger</option>
                                        <option value="info">Info</option>
                                        <option value="primary">Primary</option>
                                        <option value="warning">Warning</option>
                                        <option value="inverse">Inverse</option>
                                    </select>
                                    <!-- <input class="form-control form-white" placeholder="Enter Title" type="color" name="color" /> -->

                                </div>
                            </div>
                                <div class="row">
                                <div class="col-md-6">
                                    <label class="form-label">Start Date</label>
                                    <input class="form-control form-white" type="datetime-local" name="start_date"id="start_date" />
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">End date</label>
                                    <input class="form-control form-white"  type="datetime-local" name="end_date"id="end_date"  />

                                </div>
                            </div>
                            
                                  <div class="modal-footer">
                                      <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                                      <button type="submit"name="submit" class="btn btn-primary btn-sm editCalender">Save</button>
                                  </div>
                        </div>
              </form>
          </div>
        </div>
      </div>
</section>
<script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>

<script>
$(".Delete").click(function () {
            var delete_id = $(this).data('eventid');
            $("#delete").modal('show');
            $("#event_id").val(delete_id);

        });
        $(document).on("click", ".deleteEvent", function () {
            // if (confirm("Are you sure you want to delete this record?")) {
            var event = $("#event_id").val();
    
            var el = this;
            $.ajax({
                url: 'delete-events/' + event,
                type: 'get',
                success: function (response) {
                    toastr.success('Campaign has been deleted successfully');
                    window.location.reload(1);
                }
            });
        });

</script>
<script>
    $(".editEvent").click(function(){
   $("#myModal").modal('show');
   var edit_id = $(this).data('id');
$("#eve_id").val(edit_id)
});

$(document).on("click", ".editCalender" , function() {
    var edit_id = $("#eve_id").val();
$.ajax({
   url: 'edit-events/'+edit_id,
   type: 'post',
   data: {
            _token: "{{ csrf_token() }}", // Add the CSRF token
            title: $('input[name="title"]').val(), // Get input values dynamically
            color: $('select[name="color"]').val(),
            start_date: $('input[name="start_date"]').val(),
            end_date: $('input[name="end_date"]').val()
        },
   success: function(response){
       console.log(response);
       toastr.success('Event has been updated successfully');
       $("#title").val(response.title);
        $('#start_date').val(response.start_date);
        $('#end_date').val(response.end_date);
        $('#color').val(response.color);

   }
});
});

    </script>
@endsection
