@extends('layouts.app')
@section('title', 'Callback')
@section('content')
<meta name="csrf-token" content="{{ csrf_token() }}">
<style>
        #tickets .tooltip .tooltip-inner {
            white-space: pre-line;
            text-align: left;
        }
        .callback-reminder-setup label{
            float: right;
            display: inline-block;
        }
    </style>
    
    <section class="content">
			<div class="row">			  
				<div class="col-lg-12 col-12">
					  <div class="box">
						
						<!-- /.box-header -->
                        <form class="form-inline" method="post">
                                @csrf
							<div class="box-body">
								<h4 class="box-title text-info mb-0"><i class="fa fa-edit me-15"></i> Callback</h4>
                                <div class="callback-reminder-setup"style="text-align:right;">
                                
                                    <input type="checkbox"  id="enable-callback-reminder" @if( $callbackStatus->callback_reminder == 'on') checked @endif>
                                    <label for="enable-callback-reminder"> Enable Callback Reminder Alert! </label>
                            </div><br>
								<hr class="my-15">
								<div class="row">
                                    <div class="row">
                                    @if(Session::get('user_level') <= 5)
								  <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="form-label">Extension</label>
                                        <div class="input-group mb-3"id="date-range2">
                                                <select class="form-select" name="extension" id="extension">
                                                        <option value="">Select</option>
                                                        @foreach($arrExtensionListRekeyed as $key => $extension)
                                                            <option  @if($extension->extension == request()->input('extension'))  selected @endif
                                                                value="{{$extension->extension}}">{{$extension->first_name}} {{$extension->last_name}}-{{$extension->extension}}</option>
                                                        @endforeach
                                                </select>
                                        </div> 
                                    </div>
								  </div>
                                  @else
                                    <input type="hidden" value="{{Session::get('extension')}}" name="extension">
                                @endif
                          
                                <div class="col-md-3">
                                  <div class="form-group">
									<label class="form-label">Campaign</label>
									<div class="input-group mb-3">
                                        <select name="campaign" class="form-control js-example-basic-single" id="campaign">
                                                <option value="">Select</option>
                                                @foreach($arrCampaignListRekeyed as $key => $campaign)
                                                @if($campaign->status==1) 
                                                <option @if($campaign->id == request()->input('campaign'))  selected @endif value="{{$campaign->id}}">{{$campaign->title}}</option>
                                                    @endif
                                                @endforeach
                                            </select>
                                      
                                	</div>
								</div>
                                </div> 
                               
                                <div class="col-md-6">
                                <div class="form-group">
                                    <label>Date Range</label>
                                    <div>
                                        <div class="input-group datepicker" id="date-range"
                                             >
                                            <input type="text" autocomplete="off" class="form-control col-md-6"
                                                   id="start_date" name="start_date"
                                                   value="<?php $current_date = date("Y-m-d");// current date

                                                   $str_date = strtotime(date("Y-m-d", strtotime($current_date)) . " -15 day");

                                                   echo date('Y-m-d', $str_date); ?>">
                                            <span class="input-group-addon bg-primary text-white b-0">to</span>
                                            <input type="text" autocomplete="off"
                                                   class="form-control col-md-6 datepicker" id="end_date"
                                                   name="end_date" value="<?php echo date('Y-m-d'); ?>">
                                        </div>
                                    </div>
                                </div>
                                </div>
                                    <div class="form-group m-l-10">
                                    <label style="color: transparent;">Filter</label>
                                    <div>
								 
                        
                    
                                </div>
                            	<!-- /.box-body -->
							<div class="box-footer text-end">
                            <button type="submit" name="submit" value="Search" class="btn btn btn-primary waves-effect waves-light"><i class="fa fa-search" aria-hidden="true"></i> Search</button>
							</div>    
                            </div>
                        
                          
                      
                          
                           
						 
						</form>
					  </div>
					  <!-- /.box -->			

                    </div>  

		
		  </div>
  
        <div class="row">        
            <div class="col-lg-12 col-12">
                <div class="box">            
                   <div class="box-body">                          
                            <div class="table-responsive">
                                <table  id="tickets" class="table mt-0 table-hover no-wrap">

                                    <thead>
                                    <tr>
                                    <th>#</th>
                                            <th>Extension</th>
                                            <th>Campaign Name</th>
                                            <th>Lead Id</th>
                                            <th>Phone No</th>
                                            <th>Callback Time</th>
                                            <th>Actions</th>

                                            </tr>
                                    </thead>
                                    <tbody>
                                    @if(!empty($callback))
                                            @php
                                                $lead_data_values = $lead_data_headers = [];
                                                $leadIds = array_column($callback, 'lead_id'); @endphp
                                            @foreach($callback as $key => $value)
                            
                                                                <tr>
                                                    <th scope="row"><?php echo $key + 1; ?></th>
                                                    <td> @if(isset($arrExtensionListRekeyed[$value->extension]))
                                                            {{$arrExtensionListRekeyed[$value->extension]->first_name}} {{$arrExtensionListRekeyed[$value->extension]->last_name}} -
                                                        @elseif(isset($arrExtensionListRekeyedByAltExtension[$value->extension]))
                                                            {{$arrExtensionListRekeyedByAltExtension[$value->extension]->first_name}} {{$arrExtensionListRekeyedByAltExtension[$value->extension]->last_name}} -
                                                        @else
                                                            (User Deleted) -
                                                        @endif
                                                        <?php echo $value->extension;?></td>
                                                    <td>@if(isset($arrCampaignListRekeyed[$value->campaign_id]))
                                                            {{$arrCampaignListRekeyed[$value->campaign_id]->title}}
                                                        @else
                                                            -
                                                        @endif</td>
                                                    <td>@php
                                                            $list_values = $lead_data_values[$value->lead_id] = explode(",",$value->list_values);
                                                            $list_headers = $lead_data_header[$value->lead_id] = explode(",",$value->list_headers);

                                                        @endphp
                                                        <?php echo $value->lead_id;?>
                                                        <i data-toggle="tooltip" data-placement="right" title="
                                                            @foreach($list_headers as $key => $heading)
                                                            @if(isset($list_values[$key]))
                                                            {{$heading}} : {{$list_values[$key]}}
                                                            @endif
                                                            @endforeach" class="fa fa-info-circle" aria-hidden="true"></i>

                                    </td>
                                                    <td>   @php
                                                        $intPhoneNumber = '-';
                                                        if ($value->is_dialing_selected_column) {
                                                            $isDialingSelectedColumn = $value->is_dialing_selected_column;
                                                            $rawPhoneNumber = $value->$isDialingSelectedColumn;
                                                            
                                                            // Remove any non-digit characters from the phone number
                                                            $cleanedPhoneNumber = preg_replace('/[^0-9]/', '', $rawPhoneNumber);
                                                            
                                                            // Check if the cleaned phone number is 10 digits long
                                                            if (strlen($cleanedPhoneNumber) === 10) {
                                                                // Format the phone number as (999) 999-9999
                                                                $formattedPhoneNumber = '('.substr($cleanedPhoneNumber, 0, 3).') '.substr($cleanedPhoneNumber, 3, 3).'-'.substr($cleanedPhoneNumber, 6);
                                                                $intPhoneNumber = $formattedPhoneNumber;
                                                            }
                                                        }
                                                        @endphp
                                                        {{$intPhoneNumber}}</td>
                                                    <td>{{$value->callback_time}}</td>
                                                    <td>
                                                        <a style="cursor:pointer;color:blue;"
                                                        href="{{url('/lead-activity')}}?phone_number={{$intPhoneNumber}}"
                                                        title="View Lead Activity" class=''><i
                                                                class="fa fa-eye fa-lg"></i></a>
                                                        <span style="padding: 0px 2px;"></span>
                                                        <a style="cursor:pointer;color:blue;"  class='editCallback' title='Edit Callback' data-window="window-{{$value->lead_id}}">
                                                        <i class="fa fa-edit fa-lg"></i>
                                                        </a>
                                                        <span style="padding: 0px 2px;"></span>
                                                        <input type="hidden" name="extension" class="extension" value="{{Session::get('extension')}}">
                                                        <input type="hidden" name="phone_number" class="phone_number" value="{{$intPhoneNumber}}">
                                                        <input type="hidden" name="alt_extension" class="alt_extension" value="{{Session::get('private_identity')}}">
                                                        <a href="javascript:void(0)" style="cursor:pointer;color:green;" class="callLead" data-source="siblings"><i
                                                                class="fa fa-phone fa-lg"></i></a>
                                                                                        
                                                                <div class="modal fade" id="window-{{$value->lead_id}}" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
                                                        <div class="modal-dialog modal-lg">
                                                            <div class="modal-content">
                                                                <div class="modal-header">
                                                                <h5 class="modal-title" id="add-edit">Edit Callback</h5>
                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                </div>
                                                            
                                                                
                                                                    <div class="modal-body">
                                                            <label class="form-label">Lead Details </label>
                                                            <table style="text-align: left;margin: 0 auto;width: 100%;" class="table  table-striped table-bordered table-hover">
                                                                @foreach($list_headers as $key => $heading)
                                                                    <tr>
                                                                    @if(isset($list_values[$key]))
                                                                            <td>{{$heading}}</td>
                                                                            <td>{{$list_values[$key]}}</td> @endif
                                                                    </tr>
                                                                @endforeach
                                                            </table>
                                                            <div class="form-group">
                                                                <label class="form-label">Callback Time</label>
                                                                <div class="input-daterange input-group col-md-12">
                                                                    <div class="col-md-6">
                                                                        <input type="date" class="form-control callback_date" min="{{date('Y-m-d',strtotime($value->callback_time))}}" required=""  value="{{date('Y-m-d',strtotime($value->callback_time))}}">
                                                                    </div>
                                                                    <div class="col-md-6 callback-time">
                                                                        <input type="time" class="form-control callback_time" required="" value="{{date('H:i:s',strtotime($value->callback_time))}}" name="callback_time" >
                                                                    </div>
                                                                </div>
                                                                <span style="color:red;" id="errorsms_run_time"></span>
                                                            </div>
                                                            <div class="form-group">
                                                            <div class="mark-section" style="margin: 15px 0px;">
                                                                <label class="form-label">Callback Done? </label>
                                                                <div>
                                                                    <select class="form-select package-control-selected mark-as-called" name="mark-as-called">
                                                                        <option value="#" {{$value->mark_as_called}}>Select</option>
                                                                        <option value="0" @php if($value->mark_as_called == '0') echo 'selected="selected"'; @endphp>No</option>
                                                                        <option value="1" @php if($value->mark_as_called == '1') echo 'selected="selected"'; @endphp>Yes</option>
                                                                        <option value="2" @php if($value->mark_as_called == '2') echo 'selected="selected"'; @endphp>Cancel</option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            </div>
                                                            @if(Session::get('level') >= 7)
                                                            <div class="form-group">
                                                                <div class="assign-section" style="margin: 15px 0px;">
                                                                    <label class="form-label">Assign callback </label>
                                                                    <div>
                                                                        <select class="form-select package-control-selected reassign-callback" name="reassign-callback">
                                                                        @foreach($arrExtensionListRekeyed as $key => $extension)
                                                                                    <option value="{{$extension->extension}}" @php if($extension->extension == $value->extension) echo 'selected="selected"'; @endphp>{{$extension->first_name}} {{$extension->last_name}} (Extension - {{$extension->extension}})</option>
                                                                        @endforeach
                                                                        </select>
                                                                    </div>
                                                                </div>
                                                                </div>
                                                            @endif
                                                        </div>
                                                        <div class="modal-footer ">
                                                            <button type="submit" id="submitCallback" class="btn btn-primary"
                                                                    value="" data-identifier="{{$value->cdr_id}}-{{$value->extension}}-{{$value->campaign_id}}-{{$value->lead_id}}">Submit</button>
                                                        </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    </td>                                        
                                            </tr>
                                            


                                                @endforeach
                                        @endif
                                    </tbody>
                                </table>
                            </div>
                    </div>                
                </div>
            </div>                                              
        </div>
    </section>
@push('styles')

<link rel="stylesheet" type="text/css"
    href="{{ asset('assets/plugins/dashboard_date/bootstrap-datepicker.min.css') }}">
    <link rel="stylesheet" type="text/css"
    href="{{ asset('assets/plugins/dashboard_date/bootstrap-datepicker.css') }}">
    <style>
     .tooltip .tooltip-inner {
            white-space: pre-line;
            text-align: left;
        }
        </style>
@endpush
   
@push('scripts')
	<!-- Vendor JS -->
    <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>

    <script src="{{asset('assets/plugins/dashboard_date/moment.min.js') }}"></script>
    <script src="{{asset('assets/plugins/dashboard_date/bootstrap-datepicker.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/dashboard_date/daterangepicker.js') }}"></script>
    <script src="{{ asset('assets/js/call-lead-activity.js') }}"></script>
    <script>
    $(document).ready(function () {
        $('#tickets').DataTable();
    });
</script>
    <script>

$(document).ready(function() {
    $('#date-range').daterangepicker({       
    });
});
$(document).on('click', '.editCallback', function (e) {
            e.preventDefault();
            var modelToShow = $(this).data("window");
            $('#' + modelToShow).modal('show');
        });
        $(document).on('click', '#submitCallback', function (e) {
    e.preventDefault();
    
    // Get the CSRF token value from the <meta> tag
    var csrfToken = $('meta[name="csrf-token"]').attr('content');

    var markAsCalled = $(this).parent('.modal-footer').siblings('.modal-body').find('.mark-as-called').val();
    var reassignCallback = $(this).parent('.modal-footer').siblings('.modal-body').find('.reassign-callback').val();
    var callbackDate = $(this).parent('.modal-footer').siblings('.modal-body').find('.callback_date').val();
    var callbackTime = $(this).parent('.modal-footer').siblings('.modal-body').find('.callback_time').val();
    var convertedToUtc = callbackDate + ' ' + callbackTime;

    var callbackIdentifier = $(this).data("identifier");

    $.ajax({
        url: '/callback/edit',
        type: 'POST',

        // Set the CSRF token in the headers
        headers: {
            'X-CSRF-TOKEN': csrfToken
        },

        data: {
            mark_as_called: markAsCalled,
            converted_to_utc: convertedToUtc,
            callback_identifier: callbackIdentifier,
            reassign_callback: reassignCallback,
        },
        dataType: "json",
        success: function (response) {
            location.reload();
        }
    });
});
jQuery(document).ready(function () {
            $(".callback_date").each(function(i, element) {
                var utcTime = $(element).data("utc-time");
                if (utcTime) {
                    var localTime = moment.utc(utcTime).local();
                    $(element).attr('value',localTime.format('YYYY-MM-DD'));
                    $(element).parent().siblings(".callback-time").find("input.callback_time").attr('value',localTime.format('HH:mm'));
                }
            });

            $("#enable-callback-reminder").change(function() {
                if(this.checked){
                    $.ajax({
                        url: 'callback-reminder/show',
                        type: 'GET',
                        success: function (response){
                            window.location.reload();
                        },
                        error: function (response) {
                            console.log(response);
                        }
                    });
                } else {
                    $.ajax({
                        url: 'callback-reminder/stop',
                        type: 'GET',
                        success: function (response){
                            window.location.reload();
                        },
                        error: function (response) {
                            console.log(response);
                        }
                    });
                }
            });

            function convertLocalToUTC(dt, dtFormat) {
                return moment(dt, dtFormat).utc().format('YYYY-MM-DD hh:mm:ss A');
            }
        });
</script>


<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
$(document).ready(function() {
    $('.js-example-basic-single').select2({
        width: '100%' 
    });

    $('.select2-container .select2-selection--single').css({
        'height': '34px',
        'border-radius': '3px',
        'border': '1px solid #ced4da',
        'padding': '4px 8px'
    });
});
</script>

  
@endpush
@endsection



