@extends('layouts.app')
@section('title', 'Add Campaign')
@section('content')
<!-- Content Wrapper. Contains page content -->


    <!-- Main content -->
    <section class="content">
        <div class="row">
        <div class="col-lg-12 col-12">
                <div class="box">

                         <form method="post" action="">
                             @csrf
                             <div class="box-body"><!--bg-lightest-->
                             <h4 class="box-title text-info mb-0"><i class="fa fa-plus"></i> Add Campaign</h4>
            <a href="{{url('/campaign')}}" type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-eye fa-sx"></i> Campaigns</a>
            <hr class="my-15">

                    <div class="row col-md-12">
                        <div class="form-group col-md-6">
                            <label class="form-label">Name </label>
                           <div class="input-group">
                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                <input type="text" class="form-control" name="title" value="{{ old('title') }}" id="campaign_name" required="">
                            </div>
                        </div>
                        <div class="form-group col-md-6">
                            <label class="form-label">Description </label>
                           <div class="input-group">
                                <textarea type="textarea" class="form-control" name="description" value="{{ old('description') }}" id="campaign_description"></textarea>
                            </div>
                        </div>

                        <div class="form-group col-md-3" id="show_predictive_status">
                            <label class="form-label">Status </label>
                           <div class="input-group">
                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                <select name="status" class="form-select" id="status">
                                    <option value="1">Active</option>
                                    <option value="0">Inactive</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group col-md-3" id="show_predictive">
                            <label class="form-label">Dialing Mode </label>
                           <div class="input-group">
                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                <select name="dial_mode" class="form-select" id="dial-mode" required="">
                                            <option value="">Select Dialing Mode</option>

                                @if (!empty($campaign_type_list))
                                    @foreach ($campaign_type_list as $type)
                                        @if ($type->status == 1)
                                            <option value="{{ $type->title_url }}">{{ $type->title }}</option>
                                        @endif
                                    @endforeach
                                @endif
                                </select>
                            </div>
                        </div>
                    
                        <div class="form-group col-md-3" style="display: none;" id="call_ratio_div">
                            <label class="form-label"id="label_id">Call Ratio </label>
                            <div class="input-group">
                             <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                <select name="call_ratio" class="form-select" id="call_ratio">

                                </select>
                            </div>
                        </div>

                        <div class="form-group col-md-3" style="display: none;" id="duration_div">
                            <label class="form-label"id="label_id_duration">Duration </label>
                           <div class="input-group">
                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                <select name="duration" class="form-select" id="duration">





                                </select>
                            </div>
                        </div>

         
                                 <div class="form-group col-md-6">
                            <label class="form-label">Call Time </label>
                            <div>
                                <div class="input-group">
                                <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                    <input type="time" class="form-select" value="09:30" name="call_time_start" id="timepicker">
                                    <span class="input-group-addon bg-primary text-white b-0">to</span>
                                    <input type="time" class="form-select" value="21:30" name="call_time_end" id="timepicker3">
                                </div>
                            </div>
                        </div>
                             <div class="form-group col-md-3">
                                    <label class="form-label">Time Based Calling </label>
                                   <div class="input-group">
                                   <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                        <select name="time_based_calling" class="form-select" id="time_based_calling" required="">
                                            <option value="1">Yes</option>
                                            <option value="0">No</option>
                                        </select>
                                    </div>
                                </div>
                        <div class="form-group col-md-3" style="display: none;" id="redirect_to_div">
                            <label class="form-label">Redirect To</label>
                           <div class="input-group">
                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                <select name="redirect_to" class="form-select" id="redirect_to">
                                    <option value="">Select Redirect To</option>

                                    <option value="1">Audio Message</option>
                                    <option value="2">Voice Template</option>
                                    <option value="3">Extension</option>
                                    <option value="4">Ring Group</option>
                                    <option value="5">IVR</option>
                                    <option value="6">Voice Ai</option>

                                </select>
                            </div>
                        </div>

                         <div class="form-group col-md-6" style="display: none;" id="redirect_to_div_voicemail">
                            <label class="form-label">Redirect To</label>
                           <div class="input-group">
                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                <select name="redirect_to_voice_mail" class="form-select" id="redirect_to_voice_mail">
                                    <option value="">Select Redirect To</option>

                                    <option value="1">Audio Message</option>
                                    <option value="2">Voice Template</option>

                                </select>
                            </div>
                        </div>

                        <div class="form-group col-md-3" style="display: none;" id="voice_message">
                            <label class="form-label">Voice Template </label>
                           <div class="input-group">                    <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                <select name="outbound_ai_dropdown_voice_message" class="form-select" id="">
                                     @if (isset($voice_templete_list))
                                                @foreach($voice_templete_list as $voice_lst)
                                                <option
                                                    value={{$voice_lst->templete_id}}> {{$voice_lst->templete_name}}
                                                </option>
                                                @endforeach
                                                @endif


                                </select>
                            </div>
                        </div>

                          <div class="form-group col-md-3" style="display: none;" id="audio_message">
                            <label class="form-label">Audio Message </label>
                           <div class="input-group">
                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                <select name="outbound_ai_dropdown_audio_message" class="form-select" id="">
                                     @if (isset($audio_message))
                                                @foreach($audio_message as $audio_lst)
                                                <option
                                                    value={{$audio_lst->ivr_id}}>{{$audio_lst->ivr_desc}} - {{$audio_lst->ivr_id}}
                                                </option>
                                                @endforeach
                                                @endif


                                </select>
                            </div>
                        </div>

                        <div class="form-group col-md-3" style="display: none;" id="extension">
                            <label class="form-label">Extension </label>
                           <div class="input-group">
                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                <select name="outbound_ai_dropdown_extension" class="form-select" id="">
                                    @foreach($extension_list as $extension)
                                            @if($extension->id)
                                                <option  value="{{$extension->id}}">{{$extension->first_name}} {{$extension->last_name}} - {{$extension->extension}} </option>
                                            @endif
                                        @endforeach


                                </select>
                            </div>
                        </div>

                        <div class="form-group col-md-3" style="display: none;" id="ivr">
                            <label class="form-label">IVR </label>
                           <div class="input-group">
                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                <select name="outbound_ai_dropdown_ivr" class="form-select" id="voicedrop_option_user_id">

                                    @if (isset($ivr_list))
                                                @foreach($ivr_list as $ivr_lst)
                                                <option
                                                    value={{$ivr_lst->id}}>{{$ivr_lst->ivr_desc}} - {{$ivr_lst->ivr_id}}
                                                </option>
                                                @endforeach
                                                @endif


                                </select>
                            </div>
                        </div>

                        <div class="form-group col-md-3" style="display: none;" id="ring_group">
                            <label class="form-label">Ring Group </label>
                           <div class="input-group">
                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                <select name="outbound_ai_dropdown_ring_group" class="form-select" id="voicedrop_option_user_id">

                                    @if (isset($ring_group_list))
                                                @foreach($ring_group_list as $rgroup_lst)
                                                <option  value={{$rgroup_lst->id}}>{{$rgroup_lst->description}} - {{$rgroup_lst->title}}
                                                </option>
                                                @endforeach
                                                @endif

                                </select>
                            </div>
                        </div>

                           <div class="form-group col-md-3" style="display: none;" id="voice_ai">
                            <label class="form-label">Voice Ai </label>
                           <div class="input-group">                    <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                <select name="outbound_ai_dropdown_voice_ai" class="form-select" id="">
                                      <option>Select Prompt</option>
                                                    @if (isset($prompts) && is_array($prompts) && !empty($prompts))
                                                        @foreach($prompts as $prompt)
                                                            <option value={{$prompt->id}}>{{$prompt->title}}</option>
                                                        @endforeach
                                                    @endif


                                </select>
                            </div>
                        </div>
              <div class="form-group col-md-3" style="display: none;" id="amd_call">
                            <label class="form-label">AMD </label>
                           <div class="input-group">
                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                <select name="amd" class="form-select" id="amd">
                                    <option value="0">Off</option>
                                    <option value="1">On</option>
                                </select>
                            </div>
                        </div>

                        <div class="form-group col-md-6" style="display: none;" id="automated_duration">
                            <label class="form-label">Automated Duration </label>
                           <div class="input-group">
                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                <select name="automated_duration" class="form-select" id="autoduration">
                                    <option value="0">No</option>
                                    <option value="1">Yes</option>
                                </select>
                            </div>
                        </div>

          

                        <div class="form-group col-md-3" style="display: none;" id="amd_drop">
                            <label class="form-label">AMD Drop Action</label>
                           <div class="input-group">
                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                <select name="amd_drop_action" class="form-select" id="amd_drop_action">
                                    <option value="1">HangUp</option>
                                    <option value="2">Audio Message</option>
                                    <option value="3">Voice Template</option>

                                </select>
                            </div>
                        </div>

                        <div class="form-group col-md-3" style="display: none;" id="VoiceDrop">
                            <label class="form-label">Voice Template AMD </label>
                           <div class="input-group">
                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                <select name="voice_message_amd" class="form-select" id="">
                                     @if (isset($voice_templete_list))
                                                @foreach($voice_templete_list as $voice_lst)
                                                <option
                                                    value={{$voice_lst->templete_id}}> {{$voice_lst->templete_name}}
                                                </option>
                                                @endforeach
                                                @endif


                                </select>
                            </div>
                        </div>

                          <div class="form-group col-md-3" style="display: none;" id="audio_message_amd">
                            <label class="form-label">Audio Message AMD </label>
                           <div class="input-group">
                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                <select name="audio_message_amd" class="form-select" id="">
                                     @if (isset($audio_message))
                                                @foreach($audio_message as $audio_lst)
                                                <option
                                                    value={{$audio_lst->id}}>{{$audio_lst->ivr_desc}} - {{$audio_lst->ivr_id}}
                                                </option>
                                                @endforeach
                                                @endif


                                </select>
                            </div>
                        </div>


                        <div class="form-group col-md-6" style="display: none;" id="no_agent_available_action">
                            <label class="form-label">No Agent available Action</label>
                           <div class="input-group">
                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                <select name="no_agent_available_action" class="form-select" id="no_agent_available">
                                    <option value="1">Hang Up</option>
                                    <option value="2">Voice Drop</option>
                                    <option value="3 ">Inbound IVR</option>
                                    <option value="4">Extension</option>
                                    <option  value="5">Assistant AI</option>

                                </select>
                            </div>
                        </div>

                        <div class="form-group col-md-6" style="display: none;" id="VoiceDropAction">
                            <label class="form-label">Voice Drop Option </label>
                           <div class="input-group">
                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                <select name="voicedrop_no_agent_available_action" class="form-select" id="">
                                    @foreach($extension_list as $extension)
                                            @if($extension->id)
                                                <option value="{{$extension->id}}">{{$extension->first_name}} {{$extension->last_name}} - {{$extension->extension}} </option>
                                            @endif
                                        @endforeach


                                </select>
                            </div>
                        </div>

                        <div class="form-group col-md-6" style="display: none;" id="IvrAction">
                            <label class="form-label">Inbound IVR Option </label>
                           <div class="input-group">
                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                <select name="inbound_ivr_no_agent_available_action" class="form-select" id="voicedrop_option_user_id">

                                    @if (isset($ivr_list))
                                                @foreach($ivr_list as $ivr_lst)
                                                <option
                                                    value={{$ivr_lst->ivr_id}}>{{$ivr_lst->ivr_desc}} - {{$ivr_lst->ivr_id}}
                                                </option>
                                                @endforeach
                                                @endif


                                </select>
                            </div>
                        </div>


                   <div class="col-md-6"style="display: none;" id="extensionAction">
                                  <div class="form-group">
                                    <label class="form-label">Extension List </label>
                                    <div class="input-group mb-3">
                                        <span class="input-group-text"><i class="ti-user"></i></span>
                                        <select name="extension_no_agent_available_action"class="form-select" id="">
                                    @foreach($extension_list as $extension)
                                            @if($extension->id)
                                                <option value="{{$extension->id}}">{{$extension->first_name}} {{$extension->last_name}} - {{$extension->extension}} </option>
                                            @endif
                                        @endforeach


                                </select>
                                    </div>
                                </div>
                                </div>


                          <div class="col-md-6"style="display: none;" id="AssistantAIAction">
                                  <div class="form-group">
                                    <label class="form-label">Assistant ID</label>
                                    <div class="input-group mb-3">
                                        <span class="input-group-text"><i class="ti-user"></i></span>
                                        <select name="assistant_no_agent_available_action"class="form-select" id="">
                                   <option value="123">Assistant</option>

                                </select>
                                    </div>
                                </div>
                                </div>


                        <div class="form-group col-md-3">
                            <label class="form-label">Caller Id </label>
                           <div class="input-group">
                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                <select name="caller_id" class="form-select" id="caller_id" required="">
                                    <option value="custom">Custom</option>
                                    <option value="area_code">Area Code</option>
                                    <option value="area_code_random">AreaCode And Randomizer</option>
                                 


                                </select>
                            </div>
                        </div>
                        <div class="form-group col-md-3">
                            <label class="form-label">Custom Caller Id </label>
                            <div class="input-group">
                            <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                            <select  class="form-select" name="custom_caller_id" value="" id="custom-caller-id">
                                <option value="">Select DID</option>
                                @if(count($did_list) > 0)
                                    @foreach(array_reverse($did_list) as $key => $lists)
                                    <option data-cnam="{{$lists->cnam}}" value="<?php echo $lists->cli ?>"><?php echo $lists->cli ?>
                                    @php
                                        $role = Session::get('role');
                                    @endphp

@if(in_array($role, ['system_admin', 'system_administrator']))(<?php echo $lists->voip_provider ?>)
                                    @endif<?php if(!empty($lists->cnam)) echo '-'.$lists->cnam ?>
                                                            @if($lists->dest_type>0)
                                    -{{ !empty($destTypeList[$lists->dest_type]) ? $destTypeList[$lists->dest_type] : ''  }}
                                @else
                                    @if($lists->cnam != null)
                                        -IVR
                                    @else

                                    @endif
                                @endif
                                @if($lists->dest_type > 0)
                                    @if($lists->dest_type == 1)
                                        @foreach($extension_list as $extension)
                                            @if($lists->extension == $extension->id)
                                                -{{$extension->first_name}} {{$extension->last_name}} - {{$extension->extension}}
                                            @endif
                                        @endforeach
                                    @elseif($lists->dest_type == 2)
                                        @foreach($extension_list as $extension)
                                            @if($lists->voicemail_id == $extension->id)
                                                -{{$extension->first_name}} {{$extension->last_name}} - {{$extension->extension}}
                                            @endif
                                        @endforeach
                                    @elseif($lists->dest_type == 8)
                                        @foreach($ring_group_list as $ring)
                                            @if($lists->ingroup == $ring->id)
                                                -{{$ring->description}} - {{$ring->title}}
                                            @endif
                                        @endforeach
                                    @elseif($lists->dest_type == 5)
                                        @foreach($conferencing as $conf)
                                            @if($lists->conf_id == $conf->id)
                                                -{{$conf->title}} - {{$conf->conference_id}}
                                            @endif
                                        @endforeach
                                    @elseif($lists->dest_type == 4)
                                        {{$lists->forward_number}}
                                        @elseif($lists->dest_type == 10)
                                        Run CNAM

                                         @elseif($lists->dest_type == 12)
                                        Voice AI
                                    @else
                                        -{{$destTypeList[$lists->dest_type]}}
                                    @endif
                                @else
                                    @foreach($ivr_list as $ivr)
                                        @if($lists->ivr_id == $ivr->ivr_id)
                                            -{{$ivr->ivr_desc}}
                                        @endif
                                    @endforeach
                                @endif
                                            </option>
                                    @endforeach
                                @endif
                            </select>
                        </div>
                        </div>

                       

                        <div class="form-group col-md-3">
                            <label class="form-label">Caller Group </label>
                           <div class="input-group">
                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                <select name="group_id" class="form-select" id="group_id" required="">
                                     @foreach($group as $key => $ext_group)
                                        <option value="{{$ext_group->id}}">{{$ext_group->title}}</option>

                                    @endforeach

                                                                    </select>
                            </div>
                        </div>


                                    <div class="form-group col-md-3">
                                        <label class="form-label">Country Code </label>
                                       <div class="input-group">
                                       <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                            <select class="form-select"  name="country_code" id="country_code">
                                                                @if (is_array($phone_country))
                                                                @foreach($phone_country as $code)
                                                                <option  value={{$code->phonecode}}>{{$code->name}} (+{{$code->phonecode}})
                                                                </option>
                                                                @endforeach
                                                                @endif
                                            </select>
                                        </div>
                                    </div>

                              


                    @if(!empty($crm_lists))
                     <div class="form-group col-md-6">
                        <label>CRM Integration </label>
                       <div class="input-group">
                       <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                            <select name="crm_title_url" class="form-select" id="select_crm" >
                                <option >Select CRM</option>
                                <option value="0">No CRM</option>
                                    @foreach($crm_lists as $list)
                                        <option value="{{$list->title_url}}">{{$list->title}}</option>
                                    @endforeach

                            </select>
                        </div>
                    </div>

                    @endif



                    @if(!empty($hubspot_lists))
                    <div class="form-group col-md-6"  style="display: none;" id="show_select_crm">
                        <label>Lists</label>
                       <div class="input-group">
                       <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                        <select class="select2" required multiple="multiple" name="hubspot_lists[]" autocomplete="off" data-placeholder="Select Lists" style="width: 100%;">
                            <option value="">select Lists</option>

                                @foreach($hubspot_lists as $lst)
                                <option value="{{$lst->listId}}">{{$lst->name}}</option>
                                @endforeach

                        </select>
                        </div>
                    </div>

                    @endif

                    <div class="form-group col-md-6"  style="display: none;" id="send_to_crm">
                        <label lass="form-label">Send to CRM </label>
                       <div class="input-group">
                       <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                            <select name="send_crm" class="form-select" id="send_crm" >
                                <option value="0">No</option>
                                <option value="1">Yes</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group col-md-6" style="display: none;" id="show_send_to_crm">
                        <label lass="form-label">API Template </label>
                       <div class="input-group">
                       <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                            <select name="api_id" class="form-select" required id="api_id" >
                                @if(!empty($api_list))
                        @foreach($api_list as $key => $api)
                         @if($api->is_default == '1')
                                <option value="{{$api->id}}">{{$api->title}} ({{$api->url}})</option>
                        @endif

                                 @endforeach
                        @endif
                            </select>
                        </div>
                    </div>


                    <div class="form-group col-md-6" style="display:none;">
                        <label lass="form-label">Send Email </label>
                       <div class="input-group">
                       <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                            <select name="email" class="form-select" id="email" >
                                <option value="0">No</option>
                                <option value="1">With User Email</option>
                                <option value="2">With Campaign Email</option>
                                <option value="3">With System Email</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group col-md-6"style="display:none;">
                        <label class="form-label">Send SMS</label>
                       <div class="input-group">
                       <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                            <select name="sms" class="form-select" id="sms" >
                                <option value="1">Yes</option>
                                <option value="0">No</option>
                            </select>
                        </div>
                    </div>


                    <div class="form-group col-md-6" style="display:none;">
                        <label class="form-label">Send Report</label>
                       <div class="input-group">
                       <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                        <select name="send_report" class="form-select" id="campaign_send_report">
                                <option value="1">Yes</option>
                                <option value="0">No</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group col-md-6" style="display:none;">
                        <label class="form-label">Call Transfer</label>
                       <div class="input-group">
                       <span class="input-group-text @error('call_transfer') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                        <select name="call_transfer" class="form-select" id="call_transfer">
                                <option value="0">No</option>
                                <option value="1">Yes</option>
                            </select>
                        </div>
                    </div>
                @if(!empty($voip_configurations))
                    <div class="form-group col-md-3"style="display:none;>
                        <label class="form-label">Outbound Line </label>
                        <div class="input-group">
                             <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                            <select class="form-select" required name="voip_configurations" autocomplete="off" data-placeholder="Select Disposition" >
                                <option value="">Select VOIP</option>
                                @foreach($voip_configurations as $key => $voip)
                                <option value="{{$voip->id}}">{{$voip->name}}</option>
                                @endforeach;
                            </select>
                        </div>
                    </div>
                @endif
                @if ($callchex == 1)
                       <div class="form-group col-md-3"style="display:none;>
                        <label class="form-label">Call Metric</label>
                        <div class="input-group">
                             <span class="input-group-text @error('call_metric') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                            <select class="form-select" required name="call_metric" autocomplete="off" data-placeholder="Select" >
                                <option value="0">No</option>
                                <option value="1">Yes</option>
                            </select>
                        </div>
                    </div>
                @endif               
                    @if(!empty($disposition_list))
                    <div class="form-group col-md-6" style="display:none;">
                        <label class="form-label">Disposition</label>
                       <div class="input-group">

                        <select class="select2" multiple="multiple" name="disposition[]" autocomplete="off" data-placeholder="Select Disposition" style="width: 100%;">
                            <option value="">select disposition</option>
                            @foreach($disposition_list as $key => $disposition)
                            @if($disposition->status == 1 && $disposition->is_deleted == 0)
                            <option value="{{$disposition->id}}">{{$disposition->title}}</option>
                            @endif
                            @endforeach;
                        </select>
                        </div>
                    </div>
                    @else

                    <div class="col-md-6" style="display:none;">
                        <label class="form-label">Disposition <span style="color:red;">*</span><span style="color:green" id="successGroup"></span></label>
                               <div class="input-group">

                                                <select class="select2" multiple="multiple" name="disposition[]" autocomplete="off" id="disposition_add" data-placeholder="Select Disposition" style="width: 100%;">
                                                    <option value="">select disposition</option>
                                                    @foreach($disposition_list as $key => $disposition)
                                                    <option value="{{$disposition->id}}">{{$disposition->title}}</option>
                                                    @endforeach;
                                                </select>
                                            @if(empty($disposition_list))
                                                <div id="hiddenDiv" class="input-group-btn">
                                                  <a id="openDispositionForm" style="float:right;" type="submit" class="btn btn-danger"><i class="fa fa-plus"></i> Add Disposition</a>
                                                </div>
                                            @endif
                                </div>
                    </div>

                    @endif

                    <div class="form-group col-md-6" style="display:none;">
                        <label class="form-label">Hopper Mode Type </i></label>
                        <div class="input-group">
                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                            <select name="hopper_mode" class="form-select" id="hopper_mode">
                                <option value="1">Linear</option>
                                <option value="2">Random</option>
                            </select>
                        </div>
                    </div>


             









                  <!--   <div class="form-group col-md-6">
                        <label>Disposition</label>
                       <div class="input-group">
                            <span class="multiselect-native-select">
                                <select name="disposition[]" class="form-select" multiple="multiple" id="disposition-multiple-selected" required="">

                                            <option value="">select disposition</option>


                                            @foreach($disposition_list as $key => $disposition)

                                            <option value="{{$disposition->id}}">{{$disposition->title}}</option>

                                            @endforeach
                                </select>
                        </div>
                    </div> -->
                </div>


                    <div class="box-footer text-end">
                    <input type="hidden" class="form-select" name="username" value="" id ="first-name" required>
                    <button type="submit" name="submit" value="Save" class="btn btn btn-primary waves-effect waves-light">Save</button>
                </div>
            </form>
                    </div>
                <div class="row lead_status">
                </div>

                    </div><!-- /.box-body -->
                </div><!-- /.box -->

            </div><!-- /.col -->
        </div><!-- /.row -->
    </section><!-- /.content -->
</div>

<div class="modal fade" id="myModalGrp" role="dialog">
                    <div class="modal-dialog">
                        <div class="modal-content" style="">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                <h4 class="modal-title" id="add-edit-Grp"></h4>
                            </div>

                            <form method="post" action="">
                                @csrf
                                <div class="modal-body">
                                    <input type="hidden" class="form-control" name="id" value="" id="edit-group-id" required>
                                    <div class="form-group">
                                    <label class="form-label" class="form-label class="form-label""class="form-label">Name</label>
                                    <div class="input-group">
                                      <span class="input-group-text @error('name') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                      <input type="text" class="form-control @error('name') border-danger @enderror"  name="title"id="title_grp" autocomplete="off"  placeholder="Type  Name">
                                    </div>

                                     </div>
                                    <span id="errorGroup" style="color:red;"></span>
                                    <div class="form-group">
                                    <label class="form-label"for="inputPassword3" id="" class="form-label">Extension</label>

                                    <select class="select2" multiple="multiple"  name="extensions[]" id="extensions" autocomplete="off" data-placeholder="Select Extension" style="width: 100%;">

                                    </select>
                                    </div>
                                    <input type="hidden" class="form-control" name="status" value="1" id="status" >

                                </div>
                                <div class="modal-footer">
                                    <a href="/extension-group" type="button" class="btn btn btn-danger waves-effect waves-light" data-dismiss="modal"><i class="fa fa-reply fa-lg"></i> Cancel</a>

                                     <a onclick="window.location.reload();" type="button" class="btn btn btn-warning waves-effect waves-light" data-dismiss="modal"><i class="fa fa-refresh fa-lg"></i> Reset</a>
                                    <button type="button" id="submitGroup" name="submit" class="btn btn btn-primary waves-effect waves-light"><i class="fa fa-check-square-o fa-lg"></i> Submit</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
<div class="modal fade" id="myModal" role="dialog">
    <div class="modal-dialog">

      <!-- Modal content-->
      <div class="modal-content">
        <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal">&times;</button>
          <h4 class="modal-title" id="add-edit"></h4>
        </div>
                <div class="modal-body">
                    <form method="post" action="">
                                @csrf
                        <div class="box-body">

                                <input type="hidden" class="form-control" name="id" value="" id ="id" required>


                                    <input type="hidden" class="form-control" name="username" value="" id ="first-name" required>

                            <div class="form-group row">
                                <div class="col-sm-12">
                                    <class="form-label"for="inputEmail3" class="form-label">Name</label>
                                    <input type="text" class="form-control" required  name="title" id="title" placeholder="Enter Name">
                                    <span id="errorDisposition" style="color:red;"></span>
                                </div>

                                <div class="col-sm-12">
                                    <label class="form-label"for="inputEmail3" class="form-label">State</label>
                                    <select name="d_type" class="form-control" id="d_type" >
                                    <option value="1">Status</option>
                                    <option value="2">Do Not Call</option>
                                    <option value="3">Callback</option>
                                    </select>
                                </div>
                                <div class="col-sm-12">
                            <label class="form-label"for="inputEmail3" class="form-label">Enable SMS Pop Up <i data-toggle="tooltip" data-placement="right" title="Select Enable Sms" class="fa fa-info-circle" aria-hidden="true"></i></label>
                            <select name="enable_sms" class="form-control" id="enable_sms" >
                            <option value=""Selected>--Select--</option>
                            <option value="1">Yes</option>
                            <option value="0">No</option>
                            </select>
                        </div>

                            </div>






                            <button type="button" id="submitDisposition" name ="submit"  class="btn btn btn-primary waves-effect waves-light">Save</button>


                        </div><!-- /.box-body -->
                    </form>
               </div>
        <!-- <div class="modal-footer">
          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        </div> -->
      </div>

    </div>
</div>
<!-- /.content-wrapper -->
<script>
     $(document).on("click", "#openGrpForm", function () {
    $("#add-edit-Grp").html('Add Extension Group');
    $("#edit-group-id").val('');
    $("#title_grp").val('');
    loadExtensionOptions([], null);
    $("#myModalGrp").modal('show');
});

function loadExtensionOptions(selectedExtensions, selectedGroupID) {
    $.ajax({
        url: 'mapExtensionGroup/',
        type: 'get',
        success: function (response) {
            var options = '';

            if (response.success && response.data && response.data.length > 0) {
                var uniqueExtensions = [];
                response.data.forEach(function (extension) {
                    if (extension.is_deleted === 0 && !uniqueExtensions.includes(extension.extension)) {
                        uniqueExtensions.push(extension.extension);
                        options += '<option value="' + extension.extension + '">' + extension.first_name + ' ' + extension.last_name + '-' + extension.extension + '</option>';
                    }
                });
            }

            $("#extensions").html(options);

            if (selectedGroupID) {
                loadSelectedExtensions(selectedGroupID, selectedExtensions);
            } else {
                $('#extensions').val(selectedExtensions).trigger('change');
            }
        }
    });
}

function loadSelectedExtensions(group_id, selectedExtensions) {
    $.ajax({
        url: 'mapExtensionGroup/',
        type: 'get',
        success: function (response) {
            var extensions = [];

            if (response.success && response.data && response.data.length > 0) {
                response.data.forEach(function (extension) {
                    if (extension.group_id === group_id && extension.is_deleted === 0) {
                        extensions.push(extension.extension);
                    }
                });
            }

            if (selectedExtensions) {
                selectedExtensions.forEach(function (extension) {
                    if (!extensions.includes(extension)) {
                        extensions.push(extension);
                    }
                });
            }

            $('#extensions').val(extensions).trigger('change');
        }
    });
}
    $(document).on("change", "#send_crm", function ()
    {
        var send_crm = $("#send_crm").val();

        if(send_crm == 1)
        {
            $("#show_send_to_crm").show();
        }
        else
        {
            $("#show_send_to_crm").hide();

        }


    });

    $(document).on("change", "#select_crm", function ()
    {
        var send_crm = $("#select_crm").val();


        if(send_crm == '0') //no crm
        {
            $("#send_to_crm").hide();
        }

       else if(send_crm == 'hubspot') //hubspot
        {
            $("#show_select_crm").show();
            $("#send_to_crm").show();

        }

      else  if(send_crm == 'mca_crm') //hubspot
        {
            $("#send_to_crm").show();

        }
        else
        {
            $("#show_select_crm").hide();

        }


    });


    $(document).on("change", "#redirect_to", function ()
    {
        var redirect_to = $("#redirect_to").val();

        if(redirect_to == '1')
        {
            $("#audio_message").show();
            $("#extension").hide();
              $("#ivr").hide();
              $("#voice_message").hide();
              $("#ring_group").hide();
              $("#voice_ai").hide();



        }

         if(redirect_to == '2')
        {
            $("#voice_message").show();
            $("#extension").hide();
              $("#ivr").hide();
              $("#audio_message").hide();
              $("#ring_group").hide();
              $("#voice_ai").hide();



        }
        if(redirect_to == '3')
        {
            $("#audio_message").hide();
            $("#extension").show();
              $("#ivr").hide();
              $("#audio_message").hide();
              $("#ring_group").hide();
              $("#voice_message").hide();
             $("#voice_ai").hide();




        }

        else
            if(redirect_to == '5')
        {
              $("#ivr").show();
            $("#extension").hide();
              $("#audio_message").hide();
              $("#audio_message").hide();
              $("#ring_group").hide();
              $("#voice_message").hide();
               $("#voice_ai").hide();




        }

         else
            if(redirect_to == '4')
        {
              $("#ivr").hide();
            $("#extension").hide();
              $("#audio_message").hide();
              $("#ring_group").show();
              $("#audio_message").hide();
              $("#voice_message").hide();
            $("#voice_ai").hide();





        }

          else
            if(redirect_to == '1')
        {
              $("#ivr").hide();
            $("#extension").hide();
              $("#audio_message").hide();
              $("#ring_group").hide();
              $("#audio_message").show();
                $("#voice_ai").hide();





        }
          if(redirect_to == '6')
        {
            $("#audio_message").hide();
            $("#extension").hide();
              $("#ivr").hide();
              $("#voice_message").hide();
              $("#ring_group").hide();
              $("#voice_ai").show();



        }
        else
        {
            $("#VoiceDropAction").hide();
            $("#IvrAction").hide();

        }

    });


     $(document).on("change", "#redirect_to_voice_mail", function ()
    {
        var redirect_to = $("#redirect_to_voice_mail").val();

        if(redirect_to == '1')
        {
            $("#audio_message").show();
            $("#extension").hide();
              $("#ivr").hide();
              $("#voice_message").hide();
              $("#ring_group").hide();



        }

         if(redirect_to == '2')
        {
            $("#voice_message").show();
            $("#extension").hide();
              $("#ivr").hide();
              $("#audio_message").hide();
              $("#ring_group").hide();



        }
        if(redirect_to == '3')
        {
            $("#audio_message").hide();
            $("#extension").show();
              $("#ivr").hide();
              $("#audio_message").hide();
              $("#ring_group").hide();
              $("#voice_message").hide();




        }

        else
            if(redirect_to == '5')
        {
              $("#ivr").show();
            $("#extension").hide();
              $("#audio_message").hide();
              $("#audio_message").hide();
              $("#ring_group").hide();
              $("#voice_message").hide();




        }

         else
            if(redirect_to == '4')
        {
              $("#ivr").hide();
            $("#extension").hide();
              $("#audio_message").hide();
              $("#ring_group").show();
              $("#audio_message").hide();
              $("#voice_message").hide();





        }

          else
            if(redirect_to == '1')
        {
              $("#ivr").hide();
            $("#extension").hide();
              $("#audio_message").hide();
              $("#ring_group").hide();
              $("#audio_message").show();




        }

        else
        {
            $("#VoiceDropAction").hide();
            $("#IvrAction").hide();

        }

    });


    $("#openDispositionForm").click(function(){
        $("#myModal").modal();
        $("#name").val('');
        $("#status").val('1');
        $("#id").val('');
        $("#add-edit").html('Add dispositon');
    });

    $(document).on("change", "#amd", function ()
    {
        var amd = $("#amd").val();
        if(amd == 0)
        {
            $("#amd_drop").hide();
            $("#VoiceDrop").hide();
            $("#audio_message_amd").hide();


        }
        else
        {
            $("#amd_drop").show();
            var amd_drop_action = $("#amd_drop_action").val();
        if(amd_drop_action == 2)
        {
            $("#VoiceDrop").show();

        }
        else
        {
            $("#VoiceDrop").hide();
        }

        }

    });

    $(document).on("change", "#no_agent_available", function ()
    {
        var no_agent_available = $("#no_agent_available").val();
        if(no_agent_available == 2)
        {
            $("#VoiceDropAction").show();
            $("#IvrAction").hide();
             $("#AssistantAIAction").hide();
            $("#extensionAction").hide();

        }

        else
            if(no_agent_available == 3)
        {
            $("#IvrAction").show();
            $("#VoiceDropAction").hide();
            $("#AssistantAIAction").hide();
            $("#extensionAction").hide();

        }
         else
            if(no_agent_available == 4)
        {
            $("#IvrAction").hide();
            $("#extensionAction").show();

            $("#VoiceDropAction").hide();
            $("#AssistantAIAction").hide();


        }
           else
            if(no_agent_available == 5)
        {
            $("#IvrAction").hide();
            $("#AssistantAIAction").show();
            $("#extensionAction").hide();

            $("#VoiceDropAction").hide();

        }
        else
        {
            $("#VoiceDropAction").hide();
            $("#IvrAction").hide();

        }

    });

    $(document).on("change", "#amd_drop_action", function ()
    {
        var amd_drop_action = $("#amd_drop_action").val();
        if(amd_drop_action == 2)
        {
            //$("#VoiceDrop").show();

            $("#audio_message_amd").show();
           $("#VoiceDrop").hide();


        }


       else if(amd_drop_action == 3)
        {
            $("#VoiceDrop").show();
            $("#audio_message_amd").hide();


            //$("#audio_message_amd").show();

        }
        else
        {
                        $("#VoiceDrop").hide();
            $("#audio_message_amd").hide();
        }


    });


    $(document).on("change", "#dial-mode", function ()
    {
        var dial_mode = $("#dial-mode").val();
        if(dial_mode == 'predictive_dial')
        {
            $("#label_id").text('Call Ratio ');
            $("#call_ratio_div").show();
            var html='';

            html +=' <option value="1">1</option><option value="1.5">1.5</option><option value="2">2</option><option value="2.5">2.5</option><option value="3">3</option><option value="3.5">3.5</option><option value="4">4</option><option value="4.5">4.5</option><option value="5">5</option>';

            $("#call_ratio").html(html);
            $("#duration_div").show();

            $("#label_id_duration").text('Duration In Sec ');


            var duration='';
            for(i=0;i<16;i++)
            {
             duration+='<option value="'+i+'">'+i+'</option>';

            }

            $("#duration").html(duration);
            $("#automated_duration").show();
            $("#amd_call").show();
            $("#no_agent_available_action").show();
            $("#redirect_to_div").hide();
            $("#redirect_to_div_voicemail").hide();






            $('#show_predictive').removeClass('col-md-6');
            $('#show_predictive').addClass('col-md-3');

            $('#show_predictive_status').removeClass('col-md-6');
            $('#show_predictive_status').addClass('col-md-3');

        }

        else
            if(dial_mode == 'outbound_ai')
        {



            $("#call_ratio_div").show();

            $("#label_id").text('Simultaneous Calls ');

            var html='';

            for(i=1;i<31;i++)
{

            html +='<option value="'+i+'">'+i+'</option>';
}

            $("#call_ratio").html(html);
            $("#duration_div").show();


            $("#label_id_duration").text('Time Interval ');


            var duration = '';

             //duration+='<option value="0.5">30 Sec</option><option value="1">1 Min</option><option value="2">2 Min</option><option value="5">5 Min</option><option value="10">10 Min</option><option value="20">20 Min</option><option value="30">30 Min</option>';

             duration+='<option value="60">1 Min</option><option value="120">2 Min</option><option value="300">5 Min</option><option value="600">10 Min</option><option value="1200">20 Min</option><option value="1800">30 Min</option>';


            $("#duration").html(duration);
            $("#automated_duration").hide();
            $("#amd_call").show();
            $("#no_agent_available_action").hide();
            $("#redirect_to_div").show();
            $("#redirect_to_div_voicemail").hide();


            $("#IvrAction").hide();
            $("#VoiceDropAction").hide();

            $('#show_predictive').removeClass('col-md-6');
            $('#show_predictive').addClass('col-md-3');

            $('#show_predictive_status').removeClass('col-md-6');
            $('#show_predictive_status').addClass('col-md-3');

        }

         else
            if(dial_mode == 'voicemail_drop')
        {



            $("#call_ratio_div").show();

            $("#label_id").text('Simultaneous Calls ');

            var html='';

            for(i=1;i<31;i++)
{

            html +='<option value="'+i+'">'+i+'</option>';
}

            $("#call_ratio").html(html);
            $("#duration_div").show();


            $("#label_id_duration").text('Time Interval ');


            var duration = '';

             //duration+='<option value="0.5">30 Sec</option><option value="1">1 Min</option><option value="2">2 Min</option><option value="5">5 Min</option><option value="10">10 Min</option><option value="20">20 Min</option><option value="30">30 Min</option>';

             duration+='<option value="60">1 Min</option><option value="120">2 Min</option><option value="300">5 Min</option><option value="600">10 Min</option><option value="1200">20 Min</option><option value="1800">30 Min</option>';


            $("#duration").html(duration);
            $("#automated_duration").hide();
            $("#amd_call").hide();
            $("#no_agent_available_action").hide();
            $("#redirect_to_div_voicemail").show();
            $("#redirect_to_div").hide();

            $("#IvrAction").hide();
            $("#VoiceDropAction").hide();

            $('#show_predictive').removeClass('col-md-6');
            $('#show_predictive').addClass('col-md-3');

            $('#show_predictive_status').removeClass('col-md-6');
            $('#show_predictive_status').addClass('col-md-3');
            $("#amd_drop").hide();

        }

        else
        {
             $("#call_ratio_div").hide();
            $("#duration_div").hide();
            $("#automated_duration").hide();
            $("#amd_call").hide();
            $("#no_agent_available_action").hide();
            $("#redirect_to_div").hide();
            $("#redirect_to_div_voicemail").hide();

            $("#amd_drop").hide();
            $("#VoiceDrop").hide();
            $("#audio_message_amd").hide();
            $("#IvrAction").hide();









            $('#show_predictive').addClass('col-md-6');
            $('#show_predictive').removeClass('col-md-3');

            $('#show_predictive_status').addClass('col-md-6');
            $('#show_predictive_status').removeClass('col-md-3');

        }
    });

    $(document).on("click", "#submitDisposition", function () {
            var title = $('#title').val();
            var d_type = $('#d_type').val();
            var enable_sms = $('#enable_sms').val();

            /* alert(title);
            alert(d_type);*/


            if(title == ""){
                $("#errorDisposition").html("Please enter title");
            }
            $.ajax({
                url: 'addDisposition/'+title+'/'+d_type+'/'+enable_sms,
                type: 'get',
                success: function (json)
                {
                    for(var i = 0; i < json.length; i++)
                    {
                        var obj = json[i];
                        optionText = obj.title;
                        optionValue = obj.id;
                        $('#disposition_add').append(new Option(optionText, optionValue));
                    }
                    $("#successGroup").html("Disposition added successful! Please select");
                    $("#hiddenDiv").hide();
                    $('#myModal').modal('hide');
                }
            });
        });

        $(document).on("click", "#submitGroup", function () {
            console.log('hi');
            var title = $('#title_grp').val();
            var extensions = $('#extensions').val();
            if(title == ""){
                $("#errorGroup").html("Please enter group title");
            }
            $.ajax({
                url: 'campaignAddGroup/'+title+'/'+extensions,
                type: 'get',

                success: function (json)
                {
                    for(var i = 0; i < json.length; i++)
                    {
                        var obj = json[i];
                        optionText = obj.title;
                        optionValue = obj.id;
                        $('#groups').append(new Option(optionText, optionValue));
                    }
                    $("#successGroup").html("Group added successful! Please select");
                    $("#hiddenDivGrp").hide();
                    $('#myModalGrp').modal('hide');
                }
            });
        });

</script>
<script>
    const callerIdSelect = document.getElementById('caller_id');
    const customCallerIdSelect = document.getElementById('custom-caller-id');

    // Initially, set the disabled property based on the selected option
    customCallerIdSelect.disabled = callerIdSelect.value !== 'custom';

    // Add an event listener to the "Caller Id" select field
    callerIdSelect.addEventListener('change', function () {
        customCallerIdSelect.disabled = this.value !== 'custom';
    });
</script>
@endsection
