@extends('layouts.app')
@section('title', ' Campaign List')
@section('content')

<style>
    /* Style for the active state */
.btn-toggle.active {
    background-color: green; /* Set to the desired green color */
    color: white; /* Set to the desired text color */
    border-color: green; /* Set to the desired border color */
}

/* Style for the inactive state */
.btn-toggle:not(.active) {
    background-color: red; /* Set to the desired red color */
    color: white; /* Set to the desired text color */
    border-color: red; /* Set to the desired border color */
}
    </style>
    <style>
  .badge
{font-size: 1rem;
    font-style: normal;
    font-weight: 400;
    font-family: "IBM Plex Sans", sans-serif;
    line-height: 1.5;}
    .table > tbody > tr > td, .table > tbody > tr > th {
     padding: 0.5rem; 
    vertical-align: middle;
}
.table > tbody > tr > td, .table > tbody > tr > th {
     padding: 0.5rem; 
    vertical-align: middle;
}

  </style>

<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">


    <section class="content">

<div class="row">

 
  
  <div class="col-12">
    <div class="box">
  
     <div class="box-body">   
      <h4 class="box-title text-info mb-0"><i class="fa fa-list"></i> Campaign List</h4>
            <a href="{{url('/campaign')}}" type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-eye fa-sx"></i> Campaigns</a>
            <hr class="my-15">        
        <div class="table-responsive">
          <table id="tickets" class="table mt-0 table-hover no-wrap" data-page-size="10">
            <thead>
              <tr>
                        <th>#</th>
                        <th>Campaign Name</th>
                        <th>List Name</th>
                        <th>Dialled Leads/Total Leads</th>                
                        <th>Status</th>
                        <th>Action</th>

                      </tr>
            </thead>
            <tbody>
            @foreach($camp_list as $key => $campaignlst)
                          <tr>
                            <th scope="row">{{$key+1}}</th>
                            <td>{{$campaignlst->title}}</td>
                            <td>{{$campaignlst->l_title}}</td>
                            <td>{{$campaignlst->rowLeadReport}} / {{$campaignlst->rowListData}}</td>
                                                  <td>       @if($campaignlst->status == '0')
                                              <span class="badge badge-sm badge-danger">Inactive</span>
                                          @else ($campaignlst->status == '1')
                                              <span class="badge badge-sm badge-success">Active</span>
                                          @endif</td>
                                          <td>
                                          @if($campaignlst->crm_title_url == 'hubspot')
                                          
                                        <a style="cursor:pointer;" href="{{url('campaign/list')}}/contact/{{$campaignlst->list_id}}" 
                                    class=''   ><i class="fa fa-eye"></i></a>
                                        @else
                                        <a style="cursor:pointer;"class='openCampaignDelete' data-camid="{{$campaignlst->campaign_id}}" data-id="{{$campaignlst->list_id}}"  ><i class="fa fa-trash"></i></a> 
                                        @endif
          
                                    <a style="cursor:pointer;color:blue;"  class='openrecycle'  data-camid="{{$campaignlst->campaign_id}}" data-id="{{$campaignlst->list_id}}"><i class="fas fa-recycle"></i></a> 
                                     <button type="button" data-campaignid="{{$campaignlst->campaign_id}}" data-listid="{{$campaignlst->list_id}}"class="btn btn-sm btn-toggle  @if($campaignlst->status == '1') active @endif" data-bs-toggle="button" aria-pressed="true" autocomplete="off">
                                  <div class="handle"></div>
                            </td>
                            
                       
                          </tr>


                      @endforeach
                   
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="recycleListModal" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="myModalLabel">Recycle List</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form method="post">
                    @csrf
                    <div class="modal-body">
                        <div class="row">
                        <div class="col-md-1"></div>
                            <div class="col-md-5">Disposition</div>
                            <div class="col-md-2">Records</div>
                            <div class="col-md-3">Call times</div>
                        </div>
                
                                        <div id="disposition" style="display: inline-block">

                                        </div>
                    </div>
                    <div class="modal-footer">
                                            <input type="hidden" name="param[id]" value="" id="recycle_list_id"/>
                                            <input type="hidden" name="param[cid]" value="" id="recycle_campaign_id"/>
                                    <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                                    <button id="recyle"type="submit"name="submit" value="recycle"class="btn btn-danger btn-sm deleteCampaignList">Recycle</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<!-- /.row -->
<div class="modal fade" id="delete" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
<div class="modal-dialog">
<div class="modal-content">
<div class="modal-header">
  <h5 class="modal-title" id="myModalLabel">Confirm Delete</h5>
  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
</div>
<form method="post" action="" enctype="multipart/form-data">
@csrf
<div class="modal-body">
<p>You are about to delete <b><i class="title"></i></b> list.</p>
   <p>Do you want to proceed?</p>
   <input type="hidden" class="form-control" name="list_id" value="" id ="list_id" >
                      <input type="hidden" class="form-control" name="camid" value="" id ="camid" > 
</div>
<div class="modal-footer">
  <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
  <button type="submit"name="submit" class="btn btn-danger btn-sm deleteCampaignList">Delete</button>
</div>
  </form>
</div>
</div>
</div>

</section>

    <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>

 
<script>

$(".openrecycle").click(function() {
    var list_id = $(this).data("id");
    var campaign_id = $(this).data("camid");
    $('#recycle_list_id').val(list_id);
    $('#recycle_campaign_id').val(campaign_id);
    $.ajax({
        url: '/listDisposition/' + list_id,
        type: 'get',
        success: function(response) {
            $('#recycleListModal').modal('show');
            $('#disposition').html("");
            var enableRecycleButton = true; // Flag to enable/disable the recycle button

            for (var i = 0; i < response.length; i++) {
                var id = response[i].id;
                var name = response[i].name;
                var record_count = response[i].record_count;

                if (record_count === undefined || record_count === null) {
                    // Show a toastr message for "Data not found"
                    toastr.warning('Data not found for recycle.');
                    enableRecycleButton = false; // Disable the recycle button
                    break;
                }

                var checkboxId = "custom_checkbox_" + id;
                var checkboxHtml = '<input type="checkbox" id="' + checkboxId + '" class="custom-checkbox" value="' + id + '" name="param[disposition][]"/>' +
                    '<label for="' + checkboxId + '" class="custom-label">' + name + '</label>';

                $('#disposition').append('<div class="row">' +
                    '<div class="col-md-1">' + checkboxHtml + '</div>' +
                    '<div class="col-md-6"></div>' +
                    '<div class="col-md-2">' + record_count + '</div>' +
                    '<div class="col-md-3">' +
                    '<select class="form-select" name="param[select_id_' + id + ']">' +
                    '<option value="1">1</option>' +
                    '<option value="2">less than or equal to 2</option>' +
                    '<option value="3">less than or equal to 3</option>' +
                    '<option value="4">less than or equal to 4</option>' +
                    '<option value="5">less than or equal to 5</option>' +
                    '<option value="6">less than or equal to 6</option>' +
                    '<option value="7">less than or equal to 7</option>' +
                    '<option value="8">less than or equal to 8</option>' +
                    '<option value="9">less than or equal to 9</option>' +
                    '<option value="10">less than or equal to 10</option>' +
                    '<option value="11">less than or equal to 11</option>' +
                    '<option value="12">less than or equal to 12</option>' +
                    '<option value="13">less than or equal to 13</option>' +
                    '<option value="14">less than or equal to 14</option>' +
                    '<option value="15">less than or equal to 15</option>' +
                    '</select>' +
                    '</div>' +
                    '</div><hr>');
            }

            // Enable/disable or hide the recycle button based on the flag
            if (enableRecycleButton) {
                $("#recyle").prop("disabled", false);
                $("#recyle").show(); // Show the button
            } else {
                $("#recyle").prop("disabled", true);
                $("#recyle").hide(); // Hide the button
            }
        },
        error: function(xhr, textStatus, errorThrown) {
            // Show a toastr error message
            toastr.error('An error occurred while fetching data.');
        }
    });
});



$(".openCampaignDelete").click(function() {
   var delete_id = $(this).data('camid');
   var list_id = $(this).data('id');
   $("#delete").modal('show');
   $("#camid").val(delete_id);
   $("#list_id").val(list_id);

});

     $(document).on("click", ".deleteCampaignList" , function() {
//if(confirm("Are you sure you want to delete this?")){
   var list_id = $('#list_id').val();
   var camid = $('#camid').val();

  //alert(group_id);
   var el = this;
   $.ajax({
       url: '/deleteListData/'+list_id+'/'+camid,
       type: 'get',
       success: function(response){
            window.location.href = "/campaign";
       }
   });
//   window.location.reload(1);

});




</script>



<script>
    $(function()
    {
        $("#tickets").on("click", ".btn-toggle", function ()
        {
            var status = $(this).hasClass('active') ? 1 : 0;

            var campaignid = $(this).data('campaignid');             
            var listid = $(this).data('listid');             

            $.ajax({
                type: "GET",
                dataType: "json",
                url: '/updateCampaignList/'+campaignid+'/'+listid+'/'+status+'/4',
                success: function(data)
                {
                    if(data.status == 'true')
                    {
                        toastr.success(data.message);
                    }
                    else
                    {
                        toastr.error(data.message);

                    }

                    console.log(data.success);
                    window.location.reload(1);
                }
            });
        })
    })
    
</script>
</script>


@endsection
