@extends('layouts.app')

@section('title', 'Campaign List')
@section('content')
    <style>
        .badge {
            font-size: 1rem;
            font-style: normal;
            font-weight: 400;
            font-family: "IBM Plex Sans", sans-serif;
            line-height: 1.5;
        }
    </style>
    <style>
        .extension-item {
            display: inline-block;
            margin-right: 5px;
            /* Adjust the margin as needed */
        }

        * {
            user-select: none;
            -webkit-tap-highlight-color: transparent;
        }

        .switch {
            transform: scale(0.5);
            /* Adjust the scale value as needed to reduce the size */
        }

        /* Style for the active state */
        .btn-toggle.active {
            background-color: #2196f3;
            /* Set to the desired green color */
            color: white;
            /* Set to the desired text color */
            border-color: green;
            /* Set to the desired border color */
        }

        /* Style for the inactive state */
        .btn-toggle:not(.active) {
            background-color: red;
            /* Set to the desired red color */
            color: white;
            /* Set to the desired text color */
            border-color: red;
            /* Set to the desired border color */
        }

    
    </style>

<style>
.lender-modal {
    border-radius: 10px;
    background-color: #fff;
    font-family: "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
}

.lender-modal > .modal-header {
    border-bottom: 1px solid #ddd !important;
    padding-bottom: 10px !important;
    margin-bottom: 18px !important;
}

.lender-modal .col-md-4 {
    margin-bottom: 14px;
}

.lender-modal label {
    font-size: 1.05rem;    
    font-weight: 500;       
    color: #000;            
    display: inline-flex;
    align-items: center;
    margin-bottom: 3px;
    letter-spacing: 0.2px;
}


.text-icon {
    color: #0d3c7d;
    font-size: 1.2rem;
    margin-right: 6px;
    vertical-align: middle;
    font-weight: 600;
    line-height: 1;
}


.value-text {
    display: inline-block;
    background-color: #46aaf5;
    color:  #ffffff;
    font-size: 0.98rem;
    font-weight: 400;
    padding: 4px 10px;
    border-radius: 6px;
    margin-top: 5px;
    letter-spacing: 0.15px;
    box-shadow: 0 0 1px rgba(0,0,0,0.08);
    width: fit-content;          
    max-width: 100%;             
    word-break: break-word;
}


.lender-modal .col-md-4 > .value-text {
    display: block;
    margin-left: 22px;
}


.value-text:hover {
    background-color: #2196f3;
    color: #ffffff;
    transition: 0.25s ease;
}

.lender-modal > .modal-body {
    padding-top: 2px !important;
    padding-left: 18px !important;
    padding-right: 18px !important;
}

</style>


    <link href="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/css/bootstrap4-toggle.min.css" rel="stylesheet">
    <!-- Main content -->
    <section class="content">

        <div class="row">
            <div class="col-12">
                <div class="box">
                    <div class="box-body">

                        <h4 class="box-title text-info mb-0"><i class="icon-Cardboard-vr"><span class="path1"></span><span
                                    class="path2"></span></i> Campaign Types</h4>
                        

                        <hr class="my-15">
                        <div class="table-responsive">

                            <table id="campaignTable" class="display table mt-0 table-hover" data-page-size="10"
                                style="width:100%">
                                <thead>
                                    <tr>


                                        <th>#</th>
                                        <th>Title</th>
                                        <th>Title url</th>
                                        <th>Status</th>

                                    </tr>
                                </thead>
                                <tbody>
                                        <tr>
                                            <th scope="row"></th>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                        

                                          


                                        </tr>





                                </tbody>


                            </table>
                        </div>
                    </div>
                </div>
            </div>
            
        </div>

    </section>

    <!-- /.content -->
    <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM="
        crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/js/bootstrap4-toggle.min.js"></script>


   
    <script>
        $(function() {

$('#campaignTable').DataTable({
    processing: true,
    serverSide: true,
    ajax: "{{ url('campaign-types-table') }}",
    columns: [
        { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false },
        { data: 'title', name: 'title' },
        { data: 'title_url', name: 'title_url' },

        { data: 'status', name: 'status' }
    ]
});




        });
    </script>
    <script>
        $(function() {
            $("#campaignTable").on("click", ".btn-toggle", function() {
              
  let TypeId = $(this).data("listid");
  //alert(TypeId);
    let newStatus = $(this).hasClass("active") ? 0 : 1;

    $.ajax({
        url: "/campaign-type/update-status",
        type: "POST",
        data: {
            TypeId: TypeId,
            status: newStatus,
            _token: "{{ csrf_token() }}"
        },
        success: function (res) {
            console.log(res);
            if (res.success) {
                toastr.success(res.message);
            } else {
                toastr.error(res.message);
            }
        },
        error: function () {
            toastr.error("Something went wrong");
        }
    });

          
                });
            })
    </script>

@endsection
