@extends('layouts.app')
@section('title', 'Disposition')

@section('content')
    <style>
        .badge {
            font-size: 1rem;
            font-style: normal;
            font-weight: 400;
            font-family: "IBM Plex Sans", sans-serif;
            line-height: 1.5;
        }

        .table>tbody>tr>td,
        .table>tbody>tr>th {
            padding: 0.8rem;
            vertical-align: middle;
        }

        /* Style for the active state */
        .btn-toggle.active {
            background-color: #2196f3;
            /* Set to the desired green color */
            color: white;
            /* Set to the desired text color */
            border-color: green;
            /* Set to the desired border color */
        }

        /* Style for the inactive state */
        .btn-toggle:not(.active) {
            background-color: red;
            /* Set to the desired red color */
            color: white;
            /* Set to the desired text color */
            border-color: red;
            /* Set to the desired border color */
        }
    </style>
    <link href="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/css/bootstrap4-toggle.min.css" rel="stylesheet">

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-12">
                <div class="box">
                    <div class="box-body">

                        <h4 class="box-title text-info mb-0"><i class="fa fa-user fa-sx"></i> Disposition</h4>
                        <a id="openDispositionForm" type="submit" style="float:right"
                            class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i
                                class="fa fa-plus"></i>Add Disposition</a>

                        <hr class="my-15">
                        <div class="table-responsive">
                            <table id="tickets" class="display table mt-0 table-hover" data-page-size="10""
                                style="width:100%">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Name</th>
                                        <th>Type</th>
                                        <th>Enable Sms</th>
                                        <th>Status</th>
                                        <th>Action</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($disposition_list as $key => $disposition)
                                        <tr>
                                            <th scope="row">{{ $key + 1 }}</th>
                                            <td>{{ $disposition->title }}</td>
                                       <td>
    @if ($disposition->d_type == '1')
        Status
    @elseif ($disposition->d_type == '2')
        Do Not Call
    @elseif ($disposition->d_type == '3')
        Callback
    @endif
</td>

                                            <td>
                                                @if ($disposition->enable_sms == '0')
                                                    <span class="badge badge-sm badge-warning">NO</span>
                                                @elseif($disposition->enable_sms == '1')
                                                    <span class="badge badge-sm badge-success">YES</span>
                                                @elseif($disposition->enable_sms == null)
                                                @endif
                                            </td>
                                            <td>
                                                <!-- @if ($disposition->status == '1')
    <span class="badge badge-sm badge-success">Active</span>
@else
    ($disposition->status == '0')
    <span class="badge badge-sm badge-warning">Inactive</span>
    @endif -->
                                                <button type="button"data-listid="{{ $disposition->id }}"
                                                    class="btn btn-sm btn-toggle  @if ($disposition->status == '1') active @endif"
                                                    data-bs-toggle="button" aria-pressed="true" autocomplete="off">
                                                    <div class="handle"></div>
                                            </td>
                                            <td><a style="cursor:pointer;margin-right:5x;" title="Edit"
                                                    class='editDisposition' data-id="{{ $disposition->id }}"><i
                                                        class="fa fa-edit fa-lg"></i></a>
                                                <a style="cursor:pointer;"title="Delete" class='openDeleteDisposition'
                                                    data-id="{{ $disposition->id }}"><i class="fa fa-trash-o fa-lg"></i></a>
                                            </td>


                                        </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade" id="delete" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Confirm Delete</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <div class="modal-body">
                            <p>You are about to delete <b><i class="title"></i></b> Disposition </p>
                            <p>Do you want to proceed?</p>
                            <input type="hidden" class="form-control" name="disposition_id" value=""
                                id="disposition_id">


                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                            <button type="submit"name="submit"
                                class="btn btn-danger btn-sm deleteDisposition">Delete</button>
                        </div>

                    </div>
                </div>
            </div>
            <div class="modal fade" id="myModal" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="add-edit"></h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <form method="post" action="">
                            @csrf
                            <input type="hidden" class="form-control" name="id" value="" id ="id"
                                required>
                            <input type="hidden" class="form-control" name="username" value="" id ="first-name"
                                required>
                            <div class="modal-body">
                                <div class="form-group">
                                    <label for="inputEmail3" class="form-label closed number">Name </label>
                                    <div class="input-group mb-3">
                                        <span class="input-group-text"><i class="ti-user"></i></span>

                                        <input type="text" class="form-control closed" required name="title"
                                            id="title" placeholder="Please enter name">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="inputEmail3" class="form-label ">Type </label>
                                    <div class="input-group mb-3">
                                        <span class="input-group-text"><i class="ti-user"></i></span>
                                        <select name="d_type" class="form-select" id="d_type">
                                            <option value="1">Status</option>
                                            <option value="2">Do Not Call</option>
                                            <option value="3">Callback</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="inputEmail3" class="form-label ">Enable Sms Pop Up </label>
                                    <div class="input-group mb-3">
                                        <span class="input-group-text"><i class="ti-user"></i></span>

                                        <select required name="enable_sms" required class="form-select" id="enable_sms">
                                            <option value=""Selected>--Select--</option>
                                            <option value="1">Yes</option>
                                            <option value="0">No</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="modal-footer" style="justify-content: flex-end; padding-left: 2px !important;">
                                    <button type="button" class="btn btn-secondary btn-sm"
                                        data-bs-dismiss="modal">Close</button>
                                    <button type="submit"name="submit" class="btn btn-primary btn-sm">Save</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div>
        <!-- /.row -->



    </section>
    <!-- /.content -->


    <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM="
        crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/js/bootstrap4-toggle.min.js"></script>

    <script>
        $(".openDeleteDisposition").click(function() {
            var delete_id = $(this).data('id');
            console.log(delete_id);
            $("#delete").modal('show');
            $("#disposition_id").val(delete_id);

        });


        $("#openDispositionForm").click(function() {
            $("#myModal").modal('show');
            $("#name").val('');
            $("#status").val('1');
            $("#enable_sms").val('');
            $("#id").val('');
            $("#add-edit").html('Add dispositon');
        });

        $(document).on("click", ".editDisposition", function() {
            $("#myModal").modal('show');
            $("#add-edit").html('Edit Disposition');
            var edit_id = $(this).data('id');
            $.ajax({
                url: 'editDisposition/' + edit_id,
                type: 'get',
                success: function(response) {
                    console.log(response);
                    $("#title").val(response[0].title);
                    $("#id").val(response[0].id);
                    $('#d_type').val(response[0].d_type);
                    $('#enable_sms').val(response[0].enable_sms);
                }
            });
        });


        $(document).on("click", ".deleteDisposition", function() {
            var delete_id = $("#disposition_id").val();
            var el = this;
            $.ajax({
                url: 'deleteDisposition/' + delete_id,
                type: 'get',
                success: function(response) {
                    window.location.reload(1);
                }
            });
        });
    </script>

    <script>
        $(function() {
            $("#tickets").on("click", ".btn-toggle", function() {
                console.log('hi');
                var status = $(this).hasClass('active') ? 1 : 0;
                var listid = $(this).data('listid');


                $.ajax({
                    type: "GET",
                    dataType: "json",
                    url: '/updateDispositionStatus/' + listid + '/' + status,

                    success: function(data) {
                        if (data.status == 'true') {
                            toastr.success(data.message);
                        } else {
                            toastr.error(data.message);

                        }

                        console.log(data.success);
                        window.location.reload(1);
                    }
                });
            })
        })
    </script>


    <script>
        < script >
            $(document).ready(function() {
                $('#tickets').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: "{{ url('disposition') }}",
                    columns: [{
                            data: 'DT_RowIndex',
                            name: 'DT_RowIndex',
                            orderable: false,
                            searchable: false
                        },
                        {
                            data: 'title',
                            name: 'title'
                        },
                        {
                            data: 'd_type',
                            name: 'd_type'
                        },
                        {
                            data: 'enable_sms',
                            name: 'enable_sms',
                            orderable: false,
                            searchable: false
                        },
                        {
                            data: 'status',
                            name: 'status',
                            orderable: false,
                            searchable: false
                        },
                        {
                            data: 'action',
                            name: 'action',
                            orderable: false,
                            searchable: false
                        }
                    ],
language: {
    processing: `
        <span style="display:flex; align-items:center; justify-content:center; gap:8px;">
            <img src="https://i.gifer.com/ZZ5H.gif"
                 alt="Loading..." style="width:20px; height:20px;">
            Processing...
        </span>
    `
}
                });
            });
    </script>
    </script>

@endsection
