@extends('layouts.app')
@section('title', 'Edit Campaign')
@section('content')


<section class="content">
  <div class="row">       
    <div class="col-lg-11 col-12">
      <div class="box">
        <form class="form" method="post">
          @csrf
          <div class="box-body"><!--bg-lightest-->
         
            <h4 class="box-title text-info mb-0"><i class="fa fa-edit"></i> Edit Campaign</h4>
            <a href="{{url('/campaign')}}" type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-eye fa-sx"></i> Campaigns</a>

            <hr class="my-15">
            
            <div class="row">
              <div class="col-md-3">
                <div class="form-group @error('name') has-error @enderror">
                  <input type="hidden" class="form-control" name="campaign_id" value="{{$campaign_list[0]->id}}" id="campaign_name" required="">
                  <label class="form-label">Name</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('name') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <input type="text" class="form-control @error('name') border-danger @enderror"  style="text-transform: capitalize;" autocomplete="off"  placeholder="Type  Name" name="title" value="{{$campaign_list[0]->title}}" id="campaign_name">
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group @error('caller_id') has-error @enderror">
                  <label class="form-label">Caller Id </label> 
                    <div class="input-group mb-3">
                      <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                  <select name="caller_id" class="form-select" id="caller_id" required="">
                                  <option @if($campaign_list[0]->caller_id == 'custom') selected @endif value="custom">Custom</option>
                                                <option @if($campaign_list[0]->caller_id == 'area_code') selected @endif value="area_code">Area Code</option>
                                                <option @if($campaign_list[0]->caller_id == 'area_code_random') selected @endif value="area_code_random">AreaCode And Randomizer</option>

                                                <option @if($campaign_list[0]->caller_id == 'area_code_3') selected @endif value="area_code_3">Area Code + 3</option>

                                                <option @if($campaign_list[0]->caller_id == 'area_code_4') selected @endif value="area_code_4">Area Code + 4</option>

                                                <option @if($campaign_list[0]->caller_id == 'area_code_5') selected @endif value="area_code_5">Area Code + 5</option>


                                  </select>                  
                    </div>
                </div>
              </div>

              <div class="col-md-3">
                <div class="form-group @error('description') has-error @enderror">
                  <label class="form-label">Custom Caller Id</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <select required class="form-select" name="custom_caller_id" id="custom-caller-id" @if($campaign_list[0]->caller_id !='custom') disabled @endif>

                    @if(count($did_list) > 0)
                                            @foreach(array_reverse($did_list) as $key => $lists)
                                            <option  data-cnam="{{$lists->cnam}}" @if($campaign_list[0]->custom_caller_id == $lists->cli) selected @endif value="<?php echo $lists->cli ?>"><?php echo $lists->cli ?> <?php if(!empty($lists->cnam)) echo '-'.$lists->cnam ?>
                                            @if($lists->dest_type>0)
                                    -{{ !empty($destTypeList[$lists->dest_type]) ? $destTypeList[$lists->dest_type] : ''  }}
                                @else
                                    @if($lists->cnam != null)
                                        -IVR
                                    @else
                                        
                                    @endif
                                @endif
                                @if($lists->dest_type > 0)
                                    @if($lists->dest_type == 1)
                                        @foreach($extension_list as $extension)
                                            @if($lists->extension == $extension->id)
                                                -{{$extension->first_name}} {{$extension->last_name}} - {{$extension->extension}} 
                                            @endif
                                        @endforeach
                                    @elseif($lists->dest_type == 2)
                                        @foreach($extension_list as $extension)
                                            @if($lists->voicemail_id == $extension->id)
                                                -{{$extension->first_name}} {{$extension->last_name}} - {{$extension->extension}} 
                                            @endif
                                        @endforeach
                                    @elseif($lists->dest_type == 8)
                                        @foreach($ring_group_list as $ring)
                                            @if($lists->ingroup == $ring->id)
                                                -{{$ring->description}} - {{$ring->title}}
                                            @endif
                                        @endforeach
                                    @elseif($lists->dest_type == 5)
                                        @foreach($conferencing as $conf)
                                            @if($lists->conf_id == $conf->id)
                                                -{{$conf->title}} - {{$conf->conference_id}}
                                            @endif
                                        @endforeach
                                    @elseif($lists->dest_type == 4)
                                        {{$lists->forward_number}}

                                        @elseif($lists->dest_type == 10)
                                        Run CNAM

                                         @elseif($lists->dest_type == 11)
                                        Voice AI
                                    @else
                                        -{{$destTypeList[$lists->dest_type]}}
                                    @endif
                                @else
                                    @foreach($ivr_list as $ivr)
                                        @if($lists->ivr_id == $ivr->ivr_id)
                                            -{{$ivr->ivr_desc}} 
                                        @endif
                                    @endforeach
                                @endif
                                            </option>
                                        @endforeach
                                    @endif
                                   </select>
                  </div>
                </div>
              </div>
              <div class="col-md-3"id="show_predictive">
                <div class="form-group @error('dial_mode') has-error @enderror">
                  <label class="form-label">Dialing Mode</label>
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('dial_mode') text-danger border-danger @enderror"><i class="ti-mobile"></i></span>
                    <select name="dial_mode" class="form-select" id="dial-mode" required="">
                    @if(!empty($campaign_type_list))
                                    @foreach($campaign_type_list as $type)
                                     <option @if($campaign_list[0]->dial_mode == $type->title_url) selected @endif value="{{$type->title_url}}">{{$type->title}}</option>
                                    @endforeach
                                    @endif
                                </select>
                  </div>
                </div>
        </div>
            </div>
     
     
      <div class="row">
       
                <div class="col-md-2" >
                    <div class="form-group">
                      <label class="form-label">Status </label>
                      <div class="input-group mb-3">
                    <span class="input-group-text @error('dial_mode') text-danger border-danger @enderror"><i class="ti-mobile"></i></span>
                      <select name="status" class="form-select" id="status">
                      <option @if($campaign_list[0]->status == 1) selected @endif  value="1">Active</option>
                                                <option @if($campaign_list[0]->status == 0) selected @endif  value="0">Inactive</option>
                                  </select>
                        </div>
                    </div>
                </div>
      <div class="col-md-2">
                <div class="form-group @error('description') has-error @enderror">
                  <label class="form-label">Caller Group</label> 
                  <div class="input-group mb-3">
                  <span class="input-group-text @error('dial_mode') text-danger border-danger @enderror"><i class="ti-mobile"></i></span>

                  <select name="group_id" class="form-select" id="group_id" required="">
                  @foreach($group as $key => $ext_group)
                                        <option @if($campaign_list[0]->group_id == $ext_group->id) selected @endif value="{{$ext_group->id}}">{{$ext_group->title}}</option>

                                    @endforeach

                  </select>
                  </div>
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group @error('caller_id') has-error @enderror">
                  <label class="form-label">Country Code </label> 
                    <div class="input-group mb-3">
                        <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                            <select class="form-select"  name="country_code" id="country_code">
                                            @if (is_array($phone_country))
                                                @foreach($phone_country as $code)
                                                <option @if($campaign_list[0]->country_code == $code->phonecode ) selected @endif value={{$code->phonecode}}>{{$code->name}} (+{{$code->phonecode}})
                                                </option>
                                                @endforeach
                                                @endif
                                            </select>
                    </div>
                </div>
              </div>

            <div class="col-md-2">
                <div class="form-group @error('description') has-error @enderror">
                  <label class="form-label">Time Based Calling</label> 
                    <div class="input-group mb-3">
                        <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                       <select name="time_based_calling" class="form-select" id="time_based_calling" required="">
                       <option @if($campaign_list[0]->time_based_calling == 1) selected @endif value="1">Yes</option>
                                    <option @if($campaign_list[0]->time_based_calling == 0) selected @endif value="0">No</option>
                                        </select>
                   </div>
                </div>       
            </div>
            <div class="col-md-2"  id="send_to_crm">
                <div class="form-group @error('caller_id') has-error @enderror">
                  <label class="form-label">Send to crm </label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <select name="send_crm" class="form-select" id="send_crm" >
                    <option @if($campaign_list[0]->send_crm == 0) selected @endif value="0">No</option>
                                    <option @if($campaign_list[0]->send_crm == 1) selected @endif value="1">Yes</option>
                            </select>
                                                           
                          </div>
                </div>
              </div>
      </div>

      <div class="row">
   
      <div class="col-md-2" >
                <div class="form-group @error('description') has-error @enderror">
                    
                  <label class="form-label">Send Email</label> 
                    <div class="input-group mb-3">
                    <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                              <select name="email" class="form-select" id="email" >
                              <option @if($campaign_list[0]->email == 0) selected @endif value="0">No</option>
                                        <option @if($campaign_list[0]->email == 1) selected @endif value="1">With User Email</option>
                                        <option @if($campaign_list[0]->email == 2) selected @endif value="2">With Campaign Email</option>
                                        <option @if($campaign_list[0]->email == 3) selected @endif value="3">With System Email</option>
                              </select>
                    </div>
                </div>
              </div>
    
      <div class="col-md-3">
                <div class="form-group @error('caller_id') has-error @enderror">
                  <label class="form-label">Call Time  </label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <input type="time" class="form-control" value="{{$campaign_list[0]->call_time_start}}" name="call_time_start" id="timepicker">
                                    <span class="input-group-addon bg-primary text-white b-0">to</span>
                                    <input type="time" class="form-control" value="{{$campaign_list[0]->call_time_end}}" name="call_time_end" id="timepicker3">                 </div>
                </div>
              </div>
     
              <div class="col-md-3">
                <div class="form-group @error('caller_id') has-error @enderror">
                  <label class="form-label">Send Sms </label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <select name="sms" class="form-select" id="sms" >
                            <option @if($campaign_list[0]->sms == 0) selected @endif value="0">No</option>
                            <option @if($campaign_list[0]->sms == 1) selected @endif value="1">With User Phone No</option>
                            </select>
                     </div>
                </div>
              </div>
              <div class="col-md-2">
                <div class="form-group @error('description') has-error @enderror">
                  <label class="form-label">Send Report </label> 
                  <div class="input-group mb-3">
                  <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                  <select name="send_report" class="form-select" id="campaign_send_report">
                  <option @if($campaign_list[0]->send_report == 1) selected @endif value="1">Yes</option>
                                <option @if($campaign_list[0]->send_report == 0) selected @endif value="0">No</option>
                            </select>
                  </div>
                </div>
              </div>
         
            <div class="col-md-2">
                <div class="form-group @error('caller_id') has-error @enderror">
                  <label class="form-label">Hopper Mode Type </label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <select name="hopper_mode" class="form-select" id="hopper_mode">
                    <option @if($campaign_list[0]->hopper_mode == 1) selected @endif value="1">Linear</option>
                                <option @if($campaign_list[0]->hopper_mode == 2) selected @endif value="2">Random</option>
                            </select>
                     </div>
                </div>
              </div>
            </div>
              
            
      
   
      <div class="row">
            <div class="col-md-6">
                <div class="form-group @error('description') has-error @enderror">
                  <label class="form-label">Description</label> 
                  <div class="input-group mb-3">
                  <textarea class="form-select" required name="description" id="campaign_description">{{$campaign_list[0]->description}}</textarea>

                  </div>
                </div>
            </div>
           
              <div class="col-md-6">
                <div class="form-group @error('caller_id') has-error @enderror">
                  <label class="form-label">Disposition </label> 
                  <div class="input-group mb-3">
                  <select name="edit_disposition[]" class="form-select select2" multiple="multiple" id="disposition-multiple-selected" required="" data-placeholder="Select Disposition" style="width: 100%;">
                            <option value="">select disposition</option>
                            @foreach($disposition_list as $key => $dlist)
                            <option @if(in_array($dlist->id, $userDisposition))  selected  @endif value="{{$dlist->id}}">{{$dlist->title}}</option>
                            @endforeach
                        </select>
                     </div>
                </div>
              </div>
         
            
      </div>
      <div class="row">
      <div class="col-md-2"style="display: none;" id="call_ratio_div">
                <div class="form-group @error('description') has-error @enderror">
                  <label class="form-label">Call Ratio</label> 
                  <div class="input-group mb-3">
                  <select name="call_ratio" class="form-select" id="call_ratio">
                                    
                                </select>
                  </div>
                </div>
            </div>
            <div class="col-md-2"style="display: none;" id="duration_div">
                <div class="form-group @error('description') has-error @enderror">
                  <label class="form-label">Duration</label> 
                  <div class="input-group mb-3">
                  <select name="duration" class="form-select" id="duration">
                  </select>
                  </div>
                </div>
            </div>
            <div class="col-md-2"style="display: none;" id="redirect_to_div">
                <div class="form-group @error('description') has-error @enderror">
                  <label class="form-label">Redirect To</label> 
                  <div class="input-group mb-3">
                  <select name="redirect_to" class="form-select" id="redirect_to">

                    <option value="">Select Redirect To</option>
                    <option @if($campaign_list[0]->redirect_to == '1') selected @endif value="1">Audio Message</option>
                    <option @if($campaign_list[0]->redirect_to == '2') selected @endif value="2">Voice Template</option>

                    <option @if($campaign_list[0]->redirect_to == '3') selected @endif value="3">Extension</option>
                    <option @if($campaign_list[0]->redirect_to == '4') selected @endif value="4">Ring Group</option>
                    <option @if($campaign_list[0]->redirect_to == '5') selected @endif value="5">IVR</option>

                    </select>
                  </div>
                </div>
            </div>
            <div class="col-md-2" style="display: none;" id="automated_duration">
                <div class="form-group @error('description') has-error @enderror">
                  <label class="form-label">Automated Duration</label> 
                  <div class="input-group mb-3">
                  <select name="automated_duration" class="form-select" id="autoduration">
                                    <option @if($campaign_list[0]->automated_duration == 0) selected @endif value="0">No</option>
                                    <option @if($campaign_list[0]->automated_duration == 1) selected @endif value="1">Yes</option>
                                </select>
                  </div>
                </div>
            </div>
        
            <div class="col-md-2"style="display: none;" id="amd_call">
                <div class="form-group @error('description') has-error @enderror">
                  <label class="form-label">AMD</label> 
                  <div class="input-group mb-3">
                  <select name="amd" class="form-control" id="amd">
                                    <option @if($campaign_list[0]->amd == 0) selected @endif value="0">Off</option>
                                    <option @if($campaign_list[0]->amd == 1) selected @endif value="1">On</option>
                                </select>
                  </div>
                </div>
            </div>
            <div class="col-md-2" style="display: none;" id="no_agent_available_action">
                <div class="form-group @error('description') has-error @enderror">
                  <label class="form-label">No Agent available Action</label> 
                  <div class="input-group mb-3">
                  <div class="input-daterange input-group col-md-12">
                                <select name="no_agent_available_action" class="form-select" id="no_agent_available">
                                    <option @if($campaign_list[0]->no_agent_available_action == 1) selected @endif value="1">Hang Up</option>
                                    <option @if($campaign_list[0]->no_agent_available_action == 2) selected @endif value="2">Voice Drop</option>
                                    <option @if($campaign_list[0]->no_agent_available_action == 3) selected @endif value="3 ">Inbound IVR</option>

                                </select>
                  </div>
                </div>
            <div class="col-md-2" @if($campaign_list[0]->amd == 0) style="display: none;" @endif id="amd_drop">
                <div class="form-group @error('description') has-error @enderror">
                  <label class="form-label">AMD Drop Action</label> 
                  <div class="input-group mb-3">
                  <select name="amd_drop_action" class="form-control" id="amd_drop_action">
                                    <option @if($campaign_list[0]->amd_drop_action == 1) selected @endif value="1">HangUp</option>
                                    <option @if($campaign_list[0]->amd_drop_action == 2) selected @endif value="2">Audio Message</option>
                                    <option @if($campaign_list[0]->amd_drop_action == 3) selected @endif value="3">Voice Template</option>

                                </select>
                  </div>
                </div>
            </div>
           
            <div class="col-md-2"@if($campaign_list[0]->amd == 0 || $campaign_list[0]->amd_drop_action == 3) style="display: none;" @endif id="VoiceDrop">
                <div class="form-group @error('description') has-error @enderror">
                  <label class="form-label">Voice Template AMD</label> 
                  <div class="input-group mb-3">
                  <select name="voice_message_amd" class="form-select" id="">
                                     @if (isset($voice_templete_list))
                                                @foreach($voice_templete_list as $voice_lst)
                                                <option  
                                                    value={{$voice_lst->templete_id}}> {{$voice_lst->templete_name}}
                                                </option>
                                                @endforeach
                                                @endif

                                    
                                </select>
                  </div>
                </div>
                <div class="col-md-2"@if($campaign_list[0]->amd == 0 || $campaign_list[0]->amd_drop_action == 2) style="display: none;" @endif id="audio_message_amd">
                <div class="form-group @error('description') has-error @enderror">
                  <label class="form-label">Audio Message AMD</label> 
                  <div class="input-group mb-3">
                  <select name="audio_message_amd" class="form-select" id="">
                                     @if (isset($audio_message))
                                                @foreach($audio_message as $audio_lst)
                                                <option  
                                                    value={{$audio_lst->id}}>{{$audio_lst->ivr_desc}} - {{$audio_lst->ivr_id}}
                                                </option>
                                                @endforeach
                                                @endif

                                    
                                </select>
                  </div>
                </div>
                <div class="col-md-2"style="display: none;" id="audio_message">
                <div class="form-group @error('description') has-error @enderror">
                  <label class="form-label">Audio Message </label> 
                  <div class="input-group mb-3">
                  <select name="outbound_ai_dropdown_audio_message" class="form-control" id="">
                                     @if (isset($audio_message))
                                                @foreach($audio_message as $audio_lst)
                                                <option  
                                                    value={{$audio_lst->ivr_id}}>{{$audio_lst->ivr_desc}} - {{$audio_lst->ivr_id}}
                                                </option>
                                                @endforeach
                                                @endif

                                    
                                </select>
                  </div>
                </div>
                <div class="col-md-2"style="display: none;" id="voice_message">
                <div class="form-group @error('description') has-error @enderror">
                  <label class="form-label">Voice Template </label> 
                  <div class="input-group mb-3">
                  <select name="outbound_ai_dropdown_voice_message" class="form-select" id="">
                                     @if (isset($voice_templete_list))
                                                @foreach($voice_templete_list as $voice_lst)
                                                <option  
                                                    value={{$voice_lst->templete_id}}>{{$voice_lst->templete_name}}
                                                </option>
                                                @endforeach
                                                @endif

                                    
                                </select>
                  </div>
                </div>
                <div class="col-md-2"style="display: none;" id="extension">
                <div class="form-group @error('description') has-error @enderror">
                  <label class="form-label">Extension </label> 
                  <div class="input-group mb-3">
                  <select name="outbound_ai_dropdown_voice_message" class="form-select" id="">
                                     @if (isset($voice_templete_list))
                                                @foreach($voice_templete_list as $voice_lst)
                                                <option  
                                                    value={{$voice_lst->templete_id}}>{{$voice_lst->templete_name}}
                                                </option>
                                                @endforeach
                                                @endif

                                    
                                </select>
                  </div>
                </div>
                <div class="col-md-2"style="display: none;" id="ivr">
                <div class="form-group @error('description') has-error @enderror">
                  <label class="form-label">IVR </label> 
                  <div class="input-group mb-3">
                  <select name="outbound_ai_dropdown_ivr" class="form-control" id="voicedrop_option_user_id">

                                    @if (isset($ivr_list))
                                                @foreach($ivr_list as $ivr_lst)
                                                <option @if($campaign_list[0]->redirect_to_dropdown == $ivr_lst->ivr_id) selected @endif 
                                                    value={{$ivr_lst->ivr_id}}>{{$ivr_lst->ivr_desc}} - {{$ivr_lst->ivr_id}}
                                                </option>
                                                @endforeach
                                                @endif

                                    
                                </select>
                  </div>
                </div>
                <!-- <div class="col-md-2" style="display: none;" id="no_agent_available_action">
                <div class="form-group @error('description') has-error @enderror">
                  <label class="form-label">No Agent available Action</label> 
                  <div class="input-group mb-3">
                  <div class="input-daterange input-group col-md-12">
                                <select name="no_agent_available_action" class="form-select" id="no_agent_available">
                                    <option @if($campaign_list[0]->no_agent_available_action == 1) selected @endif value="1">Hang Up</option>
                                    <option @if($campaign_list[0]->no_agent_available_action == 2) selected @endif value="2">Voice Drop</option>
                                    <option @if($campaign_list[0]->no_agent_available_action == 3) selected @endif value="3 ">Inbound IVR</option>

                                </select>
                  </div>
                </div>
            </div> -->
           
              <div class="col-md-6"style="display: none;" id="VoiceDropAction">
                <div class="form-group @error('caller_id') has-error @enderror">
                  <label class="form-label">Voice Drop Option  </label> 
                  <div class="input-group mb-3">
                  <select name="no_agent_available_action" class="form-select">
                                    <option @if($campaign_list[0]->no_agent_available_action == 1) selected @endif value="1">Hang Up</option>
                                    <option @if($campaign_list[0]->no_agent_available_action == 2) selected @endif value="2">Voice Drop</option>
                                    <option @if($campaign_list[0]->no_agent_available_action == 3) selected @endif value="3 ">Inbound IVR</option>

                                </select>
                     </div>
                </div>
              </div>
         
        
              <div class="col-md-6"style="display: none;" id="IvrAction">
                <div class="form-group @error('caller_id') has-error @enderror">
                  <label class="form-label">Inbound IVR Option</label> 
                  <div class="input-group mb-3">
                  <select name="inbound_ivr_no_agent_available_action" class="form-select" id="voicedrop_option_user_id">

                    @if (isset($ivr_list))
                                @foreach($ivr_list as $ivr_lst)
                                <option @if($campaign_list[0]->no_agent_dropdown_action == $ivr_lst->ivr_id) selected @endif 
                                    value={{$ivr_lst->ivr_id}}>{{$ivr_lst->ivr_desc}} - {{$ivr_lst->ivr_id}}
                                </option>
                                @endforeach
                                @endif


                    </select>
                     </div>
                </div>
              </div>
      </div>
    
      <!-- /.row -->
     <!-- /.box-body -->
     <div class="box-footer text-end">
     <input type="hidden" class="form-control" name="username" value="" id ="first-name" required>

              
                <button type="submit" name="submit" value="Save" class="btn btn-primary">
                  <i class="ti-save-alt"></i> Save
                </button>
              </div>  
            </form>
            </div>
            <!-- /.box -->      
        </div>  
        <div class="modal fade" id="myModalGrp" role="dialog">
                    <div class="modal-dialog">
                        <div class="modal-content" style="">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                <h4 class="modal-title" id="add-edit-Grp"></h4>
                            </div>

                            <form method="post" action="">
                                @csrf
                                <div class="modal-body">
                                    <input type="hidden" class="form-control" name="id" value="" id="edit-group-id" required>
                                    <div class="form-group">
                                    <label for="inputEmail3" class="col-form-label">Name</label>
                                    <input type="text" class="form-control" required name="title" id="title_grp" placeholder="Enter Name" value="" />
                                     </div>
                                    <span id="errorGroup" style="color:red;"></span>
                                    <div class="form-group">
                                    <label for="inputPassword3" id="" class="col-form-label">Extension <i data-toggle="tooltip" data-placement="right" title="select multiple extension from drop down" class="fa fa-info-circle" aria-hidden="true"></i></label>
                                    
                                    <select class="select2" multiple="multiple"  name="extensions[]" id="extensions" autocomplete="off" data-placeholder="Select Extension" style="width: 100%;">
                                        
                                    </select>
                                    </div>
                                    <input type="hidden" class="form-control" name="status" value="1" id="status" >

                                </div>
                                <div class="modal-footer">
                                    <a href="/extension-group" type="button" class="btn btn btn-danger waves-effect waves-light" data-dismiss="modal"><i class="fa fa-reply fa-lg"></i> Cancel</a>

                                     <a onclick="window.location.reload();" type="button" class="btn btn btn-warning waves-effect waves-light" data-dismiss="modal"><i class="fa fa-refresh fa-lg"></i> Reset</a>
                                    <button type="button" id="submitGroup" name="submit" class="btn btn btn-primary waves-effect waves-light"><i class="fa fa-check-square-o fa-lg"></i> Submit</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
<div class="modal fade" id="myModal" role="dialog">
    <div class="modal-dialog">
    
      <!-- Modal content-->
      <div class="modal-content">
        <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal">&times;</button>
          <h4 class="modal-title" id="add-edit"></h4>
        </div>
                <div class="modal-body">
                    <form method="post" action="">
                                @csrf
                        <div class="box-body">

                                <input type="hidden" class="form-control" name="id" value="" id ="id" required>


                                    <input type="hidden" class="form-control" name="username" value="" id ="first-name" required>

                            <div class="form-group row">
                                <div class="col-sm-12">
                                    <label for="inputEmail3" class="col-form-label">Name</label>
                                    <input type="text" class="form-control" required  name="title" id="title" placeholder="Enter Name">
                                    <span id="errorDisposition" style="color:red;"></span>
                                </div>

                                <div class="col-sm-12">
                                    <label for="inputEmail3" class="col-form-label">State</label>
                                    <select name="d_type" class="form-control" id="d_type" >
                                    <option value="1">Status</option>
                                    <option value="2">Do Not Call</option>
                                    <option value="3">Callback</option>
                                    </select>
                                </div>
                                <div class="col-sm-12">
                            <label for="inputEmail3" class="col-form-label">Enable SMS Pop Up <i data-toggle="tooltip" data-placement="right" title="Select Enable Sms" class="fa fa-info-circle" aria-hidden="true"></i></label>
                            <select name="enable_sms" class="form-control" id="enable_sms" >
                            <option value=""Selected>--Select--</option>
                            <option value="1">Yes</option>
                            <option value="0">No</option>
                            </select>
                        </div>
                                
                            </div>


                        



                            <button type="button" id="submitDisposition" name ="submit"  class="btn btn btn-primary waves-effect waves-light">Save</button>
                        

                        </div><!-- /.box-body -->
                    </form>
               </div>
        <!-- <div class="modal-footer">
          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        </div> -->
      </div>
      
    </div>
</div>
    </section>

    <section class="content">

<div class="row">

 
  
  <div class="col-12">
    <div class="box">
    
     <div class="box-body">           
        <div class="table-responsive">
          <table id="tickets" class="table mt-0 table-hover no-wrap" data-page-size="10">
            <thead>
              <tr>
                        <th>#</th>
                        <th>Campaign Name</th>
                        <th>List Name</th>
                        <th>Dialled Leads/Total Leads</th>                
                        <th>Status</th>
                        <th>Action</th>

                      </tr>
            </thead>
            <tbody>
            @foreach($no_of_campaign_list as $key => $campaignlst)
                          <tr>
                            <th scope="row">{{$key+1}}</th>
                            <td>{{$campaignlst->title}}</td>
                            <td>{{$campaignlst->l_title}}</td>
                            <td>{{$campaignlst->rowLeadReport}} / {{$campaignlst->rowListData}}</td>
                                                  <td>       @if($campaignlst->status == '0')
                                              <span class="badge badge-sm badge-danger">Inactive</span>
                                          @else ($campaignlst->status == '1')
                                              <span class="badge badge-sm badge-success">Active</span>
                                          @endif</td>
                                          <td>
                                          @if($campaignlst->crm_title_url == 'hubspot')
                                        @else
                                        <a style="cursor:pointer;"
                                    class='openCampaignDelete' data-camid="{{$campaignlst->campaign_id}}" data-id="{{$campaignlst->list_id}}"  ><i class="fa fa-trash-o"></i></a> 
                                        @endif
                            </td>
                            
                       
                          </tr>


                      @endforeach
                   
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- /.row -->
<div class="modal fade" id="delete" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
<div class="modal-dialog">
<div class="modal-content">
<div class="modal-header">
  <h5 class="modal-title" id="myModalLabel">Confirm Delete</h5>
  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
</div>
<form method="post" action="" enctype="multipart/form-data">
@csrf
<div class="modal-body">
<p>You are about to delete <b><i class="title"></i></b> list.</p>
   <p>Do you want to proceed?</p>
   <input type="hidden" class="form-control" name="list_id" value="" id ="list_id" >
                      <input type="hidden" class="form-control" name="camid" value="" id ="camid" > 
</div>
<div class="modal-footer">
  <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
  <button type="submit"name="submit" class="btn btn-danger btn-sm deleteCampaignList">Delete</button>
</div>
  </form>
</div>
</div>
</div>

</section>

    <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>

    <script>

var amd_drop_action = $("#amd_drop_action").val();
//  alert(amd_drop_action);
if(amd_drop_action == 2)
{
       $("#audio_message_amd").show();
       $("#VoiceDrop").hide();
}
else
if(amd_drop_action == 3)
{
       $("#audio_message_amd").hide();
       $("#VoiceDrop").show();
}


$(document).on("change", "#redirect_to", function ()
{
    var redirect_to = $("#redirect_to").val();
    if(redirect_to == '3')
    {
        $("#audio_message").hide();
        $("#extension").show();
        $("#ivr").hide();
        $("#ring_group").hide();
        $("#voice_message").hide();
    }

    else
    if(redirect_to == '5')
    {
        $("#ivr").show();
        $("#extension").hide();
        $("#audio_message").hide();
        $("#ring_group").hide();
        $("#audio_message").hide();
        $("#voice_message").hide();
    }

    else
    if(redirect_to == '4')
    {
        $("#ivr").hide();
        $("#extension").hide();
        $("#audio_message").hide();
        $("#ring_group").show();
        $("#audio_message").hide();
        $("#voice_message").hide();
    }
    else
    if(redirect_to == '1')
    {
        $("#ivr").hide();
        $("#extension").hide();
        $("#audio_message").hide();
        $("#ring_group").hide();
        $("#audio_message").show();
        $("#voice_message").hide();
    }

    else
    if(redirect_to == '2')
    {
        $("#ivr").hide();
        $("#extension").hide();
        $("#audio_message").hide();
        $("#voice_message").show();

        $("#ring_group").hide();
        $("#audio_message").hide();
    }
    else
    {
        $("#VoiceDropAction").hide();
        $("#IvrAction").hide();
        $("#ivr").hide();
        $("#extension").hide();
        $("#audio_message").hide();
        $("#ring_group").hide();
        $("#audio_message").hide();
        $("#call_ratio_div").hide();
        $("#voice_message").hide();
    }
});


  @if($campaign_list[0]->redirect_to == '5')

  $("#ivr").show();

  @endif

   @if($campaign_list[0]->redirect_to == '3')

  $("#extension").show();

  @endif

   @if($campaign_list[0]->redirect_to == '4')

  $("#ring_group").show();

  @endif


   @if($campaign_list[0]->redirect_to == '1')

  $("#audio_message").show();

  @endif

   @if($campaign_list[0]->redirect_to == '2')

  $("#voice_message").show();

  @endif



  @if($campaign_list[0]->dial_mode == 'outbound_ai')
    $("#call_ratio_div").show();

        $("#label_id").text('Simultaneous Calls');


   var html='';

        for(i=1;i<31;i++)
{

        html +='<option value="'+i+'">'+i+'</option>';
}

        $("#call_ratio").html(html);

        $("#call_ratio").val(<?php echo $campaign_list[0]->call_ratio; ?>);



     $("#duration_div").show();


        $("#label_id_duration").text('Duration In Min ');


        var duration = '';
        
         duration+='<option value="0.5">30 Sec</option><option value="1">1 Min</option><option value="2">2 Min</option><option value="5">5 Min</option><option value="10">10 Min</option><option value="20">20 Min</option><option value="30">30 Min</option>';

       

        $("#duration").html(duration);
        $("#duration").val(<?php echo $campaign_list[0]->duration; ?>);

    $("#automated_duration").hide();
    $("#amd_call").show();
    $("#no_agent_available_action").hide();

    var redirect_to = $("#redirect_to").val();
    if(redirect_to == 'extension')
    {
        $("#extension").show();
       // $("#IvrAction").hide();

    }

    else
        if(no_agent_available == 3)
    {
        $("#IvrAction").show();
        $("#VoiceDropAction").hide();

    }
    else
    {
        $("#VoiceDropAction").hide();
        $("#IvrAction").hide();

    }

        $("#redirect_to_div").show();






@endif

@if($campaign_list[0]->dial_mode == 'predictive_dial')
    $("#call_ratio_div").show();

        $("#label_id").text('Call Ratio');


     var html='';

        html +=' <option value="1">1</option><option value="1.5">1.5</option><option value="2">2</option><option value="2.5">2.5</option><option value="3">3</option><option value="3.5">3.5</option><option value="4">4</option><option value="4.5">4.5</option><option value="5">5</option>';

        $("#call_ratio").html(html);

        $("#call_ratio").val(<?php echo $campaign_list[0]->call_ratio; ?>);
    $("#duration_div").show();

        $("#label_id_duration").text('Duration In Sec ');


        var duration='';
        for(i=0;i<16;i++)
        {
         duration+='<option value="'+i+'">'+i+'</option>';

        }

        $("#duration").html(duration);
        $("#duration").val(<?php echo $campaign_list[0]->duration; ?>);

    $("#automated_duration").show();
    $("#amd_call").show();
    $("#no_agent_available_action").show();

    var no_agent_available = $("#no_agent_available").val();
    if(no_agent_available == 2)
    {
        $("#VoiceDropAction").show();
        $("#IvrAction").hide();

    }

    else
        if(no_agent_available == 3)
    {
        $("#IvrAction").show();
        $("#VoiceDropAction").hide();

    }
    else
    {
        $("#VoiceDropAction").hide();
        $("#IvrAction").hide();

    }

        $("#redirect_to_div").hide();




@endif


$(document).on("change", "#amd", function ()
{
    var amd = $("#amd").val();
    if(amd == 0)
    {
        $("#amd_drop").hide();
        $("#VoiceDrop").hide();

    }
    else
    {
        $("#amd_drop").show();
        var amd_drop_action = $("#amd_drop_action").val();
    if(amd_drop_action == 2)
    {
        $("#VoiceDrop").show();
    }
    else
    {
        $("#VoiceDrop").hide();
    }
       
    }

});


 $(document).on("change", "#no_agent_available", function ()
{
    var no_agent_available = $("#no_agent_available").val();
    if(no_agent_available == 2)
    {
        $("#VoiceDropAction").show();
        $("#IvrAction").hide();

    }

    else
        if(no_agent_available == 3)
    {
        $("#IvrAction").show();
        $("#VoiceDropAction").hide();

    }
    else
    {
        $("#VoiceDropAction").hide();
        $("#IvrAction").hide();

    }

});

$(document).on("change", "#amd_drop_action", function ()
{
    var amd_drop_action = $("#amd_drop_action").val();
    if(amd_drop_action == 2)
    {
        //$("#VoiceDrop").show();

        $("#audio_message_amd").show();
       $("#VoiceDrop").hide();


    }
   

   else if(amd_drop_action == 3)
    {
        $("#VoiceDrop").show();
        $("#audio_message_amd").hide();


        //$("#audio_message_amd").show();

    }
    else
    {
                    $("#VoiceDrop").hide();
        $("#audio_message_amd").hide();
    }
   

});

$(document).on("change", "#dial-mode", function ()
{
    var dial_mode = $("#dial-mode").val();
    if(dial_mode == 'predictive_dial')
    {
        $("#call_ratio_div").show();

        $("#label_id").text('Call Ratio');


         var html='';

        html +=' <option value="1">1</option><option value="1.5">1.5</option><option value="2">2</option><option value="2.5">2.5</option><option value="3">3</option><option value="3.5">3.5</option><option value="4">4</option><option value="4.5">4.5</option><option value="5">5</option>';

        $("#call_ratio").html(html);


        $("#duration_div").show();

        $("#label_id_duration").text('Duration In Sec ');


        var duration='';
        for(i=0;i<16;i++)
        {
         duration+='<option value="'+i+'">'+i+'</option>';

        }

        $("#duration").html(duration);
        $("#automated_duration").show();
    $("#amd_call").show();
    $("#no_agent_available_action").show();
        $("#redirect_to_div").hide();

         $("#call_ratio_div").show();
         $("#duration_div").show();

            $("#call_ratio").show();
        $("#duration").show();





    }

    else
        if(dial_mode == 'outbound_ai')
    {
        $("#call_ratio_div").show();

         var html='';

        for(i=1;i<31;i++)
{

        html +='<option value="'+i+'">'+i+'</option>';
}

        $("#call_ratio").html(html);

        $("#label_id").text('Simultaneous Calls ');


        $("#duration_div").show();


        $("#label_id_duration").text('Time Interval ');


        var duration = '';
        
         duration+='<option value="0.5">30 Sec</option><option value="1">1 Min</option><option value="2">2 Min</option><option value="5">5 Min</option><option value="10">10 Min</option><option value="20">20 Min</option><option value="30">30 Min</option>';

       

        $("#duration").html(duration);
        $("#automated_duration").hide();
    $("#amd_call").show();
    $("#no_agent_available_action").hide();
        $("#redirect_to_div").show();

          $("#call_ratio_div").show();
         $("#duration_div").show();

          $("#call_ratio").show();
        $("#duration").show();

        $("#IvrAction").hide();
        $("#VoiceDropAction").hide();





    }

    else
    {
        $("#call_ratio").hide();
        $("#duration").hide();
        $("#automated_duration").hide();
    $("#amd_call").hide();
        $("#redirect_to_div").hide();
         $("#call_ratio_div").hide();
         $("#duration_div").hide();
         $("#ivr").hide();
         $("#amd_drop").hide();
         $("#no_agent_available_action").hide();





    }
});

$(".openrecycle").click(function()
{
    $("#recycleListModal").modal();
    var list_id = $(this).data("id");
    var campaign_id = $(this).data("camid");
    $('#recycle_list_id').val(list_id);
    $('#recycle_campaign_id').val(campaign_id);
    $.ajax({
        url: '/listDisposition/'+list_id,
        type: 'get',
        success: function(response){
            $('#disposition').html("");
             for(var i = 0; i < response.length; i++) {
            var elem = document.getElementById('disposition');
            
              var id = response[i].id;
              var name = response[i].name;
              var record_count = response[i].record_count;

              

              elem.innerHTML = elem.innerHTML + "<div class='col-md-12 p-b-10'><div class='col-md-1'><input type='checkbox' value='"+id+"' name='param[disposition][]'/></div><div class='col-md-6'>"+name+"</div><div class='col-md-2'>"+record_count+"</div><div class='col-md-3'><select class='form-control' name='param[select_id_"+id+"]'><option value='1'>1</option><option value='2'> less than or equal to 2</option><option value='3'> less than or equal to 3</option><option value='4'>less than or equal to 4</option><option value='5'>less than or equal to 5</option><option value='6'>less than or equal to 6</option><option value='7'>less than or equal to 7</option><option value='8'> less than or equal to 8</option><option value='9'> less than or equal to 9</option><option value='10'>less than or equal to 10</option><option value='11'>less than or equal to 11</option><option value='12'>less than or equal to 12</option><option value='13'>less than or equal to 13</option><option value='14'>less than or equal to 14</option><option value='15'>less than or equal to 15</option></select></div><hr></div>";

              

            
          }
        }
    });
    /*.done(function( response ) {
        $('#disposition').html(response);
    });*/

});


 $(".openCampaignDelete").click(function() {
    var delete_id = $(this).data('camid');
    var list_id = $(this).data('id');
    $("#delete").modal('show');
    $("#camid").val(delete_id);
    $("#list_id").val(list_id);

});

      $(document).on("click", ".deleteCampaignList" , function() {
//if(confirm("Are you sure you want to delete this?")){
    var list_id = $('#list_id').val();
    var camid = $('#camid').val();

   //alert(group_id);
    var el = this;
    $.ajax({
        url: '/deleteListData/'+list_id+'/'+camid,
        type: 'get',
        success: function(response){
             window.location.href = "/campaign";
        }
    });
 //   window.location.reload(1);

});




</script>

<script>
$(document).ready(function() {
    var oTable = $('#example').dataTable({
        "aoColumnDefs": [{
            "bSortable": false,
            "aTargets": [2, 3]
        }]
    });
});
</script>
<script>
$(function()
{
    $("#example").on("change", ".toggle-class", function ()
    {
        $('#loading').show();
        var status = $(this).prop('checked') == true ? 1 : 0; 
        var campaignid = $(this).data('campaignid');             
        var listid = $(this).data('listid');             

        $.ajax({
            type: "GET",
            dataType: "json",
            url: '/updateCampaignList/'+campaignid+'/'+listid+'/'+status+'/4',
            success: function(data)
            {
                if(data.status == 'true')
                {
                    toastr.success(data.message);
                }
                else
                {
                    toastr.error(data.message);

                }
                $('#loading').show();

                console.log(data.success);
                window.location.reload(1);
            }
        });
    })
})
</script>


@endsection
