@extends('layouts.app')
@section('title', 'Call Data Report')

@push('styles')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/plugins/dashboard_date/bootstrap-datepicker.min.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/plugins/dashboard_date/bootstrap-datepicker.css') }}">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
@endpush

@section('content')
    <?php
    error_reporting(0);
    if (!empty(request()->input('start_date'))) {
        $startDate = request()->input('start_date');
    } else {
        $current_date = date("Y-m-d");
        $str_date = strtotime(date("Y-m-d", strtotime($current_date)) . " -15 day");
        $startDate = date('Y-m-d', $str_date);
    }

    if (!empty(request()->input('end_date'))) {
        $endDate = request()->input('end_date');
    } else {
        $endDate = date('Y-m-d');
    }
    ?>

    <style>
        div.dataTables_wrapper div.dataTables_paginate ul.pagination {
            white-space: nowrap;
            justify-content: flex-end;
        }

        .modal-content {
            border-radius: 12px !important;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.25);
            border: none;
        }

        .modal-header {
            border-bottom: 1px solid #dee2e6;
            background: #f8f9fa;
            border-top-left-radius: 12px;
            border-top-right-radius: 12px;
        }

        .modal-body {
            padding: 20px 25px;
        }

        .modal-footer {
            border-top: 1px solid #dee2e6;
            background: #f8f9fa;
            border-bottom-left-radius: 12px;
            border-bottom-right-radius: 12px;
        }

        .table td {
            vertical-align: middle !important;
        }

        .info-bar {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 10px;
        }

        audio {
            width: 150px;
            height: 30px;
        }x
    </style>

    <section class="content">
        <div class="row">
            <div class="col-12">
                <div class="box">
                    <div class="box-body">
                        <div class="d-flex justify-content-between align-items-center mb-0">
                            <h4 class="box-title text-info mb-0">
                                <i class="fa fa-phone"></i> Call Data Report
                            </h4>
                            <button type="button" onclick="window.location.href = window.location.pathname;"
                                class="btn btn-secondary waves-effect waves-light">
                                <i class="fa fa-refresh"></i> Reset
                            </button>
                        </div>

                        <hr class="my-15">

                        {{-- Flash messages --}}
                        @if (session('success'))
                            <div class="alert alert-success">{{ session('success') }}</div>
                        @endif
                        @if (session('error'))
                            <div class="alert alert-danger">{{ session('error') }}</div>
                        @endif
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul class="mb-0">
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        <form class="needs-validation" action="" method="get">
                            @csrf
                            <div class="row">
                                {{-- Phone Number (Select2 Multi) --}}
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="form-label">Phone Number</label>
                                        <div class="input-group mb-3">
                                            <select name="number[]" class="form-select select2" id="number" multiple>
                                                @foreach($filterNumbers as $num)
                                                    <option value="{{ $num }}"
                                                        {{ collect(request()->input('number', []))->contains($num) ? 'selected' : '' }}>
                                                        {{ $num }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                {{-- Campaign ID --}}
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="form-label">Campaign ID</label>
                                        <div class="input-group mb-3">
                                            <span class="input-group-text"><i class="ti-bolt"></i></span>
                                            <select name="campaign_id" class="form-select" id="campaign_id">
                                                <option value="">Select</option>
                                                @foreach($filterCampaigns as $cid)
                                                    <option value="{{ $cid->id }}" {{ request()->input('campaign_id') == $cid->id ? 'selected' : '' }}>
                                                        {{ $cid->title }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="form-label">Duration</label>
                                    <div class="input-group mb-3">
                                        <span class="input-group-text"><i class="ti-bolt"></i></span>
                                        <select name="duration" class="form-select" id="duration">
                                            <option value="">Select</option>

                                            <option value="60" {{ request('duration') == '60' ? 'selected' : '' }}>
                                                1 Min
                                            </option>

                                            <option value="120" {{ request('duration') == '120' ? 'selected' : '' }}>
                                                2 Min
                                            </option>

                                            <option value="300" {{ request('duration') == '300' ? 'selected' : '' }}>
                                                5 Min
                                            </option>

                                            <option value="600" {{ request('duration') == '600' ? 'selected' : '' }}>
                                                10 Min
                                            </option>

                                            <option value="1200" {{ request('duration') == '1200' ? 'selected' : '' }}>
                                                20 Min
                                            </option>

                                            <option value="1800" {{ request('duration') == '1800' ? 'selected' : '' }}>
                                                30 Min
                                            </option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                                {{-- Date Range --}}
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="form-label">Date range:</label>
                                        <div class="input-group mb-3">
                                            <div class="input-group-addon">
                                                <i class="fa fa-calendar"></i>
                                            </div>
                                            <input type="text" class="form-control pull-right cdr-range" id="reservation">
                                            <input type="hidden" id="start_date" name="start_date" value="{{ $startDate }}">
                                            <input type="hidden" id="end_date" name="end_date" value="{{ $endDate }}">
                                        </div>
                                    </div>
                                </div>

                                {{-- Search Button --}}
                                <!-- <div class="col-md-3 d-flex justify-content-end p-4">
                                    <button type="submit" name="submit" id="form_submit" value="Search"
                                        class="btn btn-primary waves-effect waves-light">
                                        <i class="fa fa-search"></i> Search
                                    </button>
                                </div> -->
                                   <div class="col-md-12 text-end mt-3">
                                    <button type="submit"
                                        class="btn btn-primary">
                                        <i class="fa fa-search"></i> Search
                                    </button>
                                </div>
                            </div>
                        </form>
<br>
                        {{-- Call Summary Stats --}}
                        @if(isset($summaryStats) && ($summaryStats['total']['calls'] > 0))
                        <div class="card mb-4">
                            <div class="card-header bg-info text-white">
                                <h5 class="mb-0"><i class="fa fa-bar-chart"></i> Call Summary</h5>
                            </div>
                            <div class="card-body p-0">
                                <table class="table table-bordered mb-0">
                                    <thead class="table-secondary">
                                        <tr>
                                            <th>IN/OUT</th>
                                            <th class="text-center">Total Calls</th>
                                            <th class="text-center">Total Talk Time</th>
                                            <th class="text-center">Avg Duration</th>
                                            <th class="text-center">Billable Minutes</th>
                                            <th class="text-end">Total Charge</th>
                                            <th class="text-center">% of Total</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        {{-- Outgoing Row --}}
                                        <tr>
                                            <td><strong>Outgoing (OUT)</strong></td>
                                            <td class="text-center">{{ number_format($summaryStats['outbound']['calls']) }}</td>
                                            <td class="text-center">{{ gmdate('H:i:s', $summaryStats['outbound']['duration']) }}</td>
                                            <td class="text-center">
                                                @if($summaryStats['outbound']['calls'] > 0)
                                                    {{ gmdate('i:s', $summaryStats['outbound']['duration'] / $summaryStats['outbound']['calls']) }}
                                                @else
                                                    00:00
                                                @endif
                                            </td>
                                            <td class="text-center">{{ number_format($summaryStats['outbound']['billable_minutes'], 2) }}</td>
                                            <td class="text-end">₹{{ number_format($summaryStats['outbound']['cost'], 2) }}</td>
                                            <td class="text-center">
                                                @if($summaryStats['total']['calls'] > 0)
                                                    {{ number_format(($summaryStats['outbound']['calls'] / $summaryStats['total']['calls']) * 100, 1) }}%
                                                @else
                                                    0%
                                                @endif
                                            </td>
                                        </tr>
                                        {{-- Incoming Row --}}
                                        <tr>
                                            <td><strong>Incoming (IN)</strong></td>
                                            <td class="text-center">{{ number_format($summaryStats['inbound']['calls']) }}</td>
                                            <td class="text-center">{{ gmdate('H:i:s', $summaryStats['inbound']['duration']) }}</td>
                                            <td class="text-center">
                                                @if($summaryStats['inbound']['calls'] > 0)
                                                    {{ gmdate('i:s', $summaryStats['inbound']['duration'] / $summaryStats['inbound']['calls']) }}
                                                @else
                                                    00:00
                                                @endif
                                            </td>
                                            <td class="text-center">{{ number_format($summaryStats['inbound']['billable_minutes'], 2) }}</td>
                                            <td class="text-end">₹{{ number_format($summaryStats['inbound']['cost'], 2) }}</td>
                                            <td class="text-center">
                                                @if($summaryStats['total']['calls'] > 0)
                                                    {{ number_format(($summaryStats['inbound']['calls'] / $summaryStats['total']['calls']) * 100, 1) }}%
                                                @else
                                                    0%
                                                @endif
                                            </td>
                                        </tr>
                                        {{-- Total Row --}}
                                        <tr class="table-secondary">
                                            <td><strong>TOTAL</strong></td>
                                            <td class="text-center"><strong>{{ number_format($summaryStats['total']['calls']) }}</strong></td>
                                            <td class="text-center"><strong>{{ gmdate('H:i:s', $summaryStats['total']['duration']) }}</strong></td>
                                            <td class="text-center">
                                                @if($summaryStats['total']['calls'] > 0)
                                                    <strong>{{ gmdate('i:s', $summaryStats['total']['duration'] / $summaryStats['total']['calls']) }}</strong>
                                                @else
                                                    00:00
                                                @endif
                                            </td>
                                            <td class="text-center"><strong>{{ number_format($summaryStats['total']['billable_minutes'], 2) }}</strong></td>
                                            <td class="text-end"><strong>₹{{ number_format($summaryStats['total']['cost'], 2) }}</strong></td>
                                            <td class="text-center"><strong>100%</strong></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        @endif


                        <div class="info-bar">
                            <div><strong>Total Rows:</strong> {{ number_format($totalRows ?? 0) }}</div>
                            <div>
                                Show:
                                <select id="entriesCount" class="form-select form-select-sm d-inline-block"
                                    style="width:auto;">
                                    <option value="10" selected>10</option>
                                    <option value="25">25</option>
                                    <option value="50">50</option>
                                    <option value="100">100</option>
                                </select> entries
                            </div>
                        </div>

                        {{-- Data Table --}}
                        <div class="table-responsive">
                            <table id="cdrTable" class="table mt-0 table-hover no-wrap">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Campaign</th>
                                        <th>CLI</th>
                                        <th>Route</th>
                                        <th>Number</th>
                                        <th>Duration</th>
                                        <th>Cost</th>
                                        <th>Start Time</th>
                                        <th>End Time</th>
                                        <th>Recording</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($cdrs as $key => $cdr)
                                        <tr>
                                            <td>{{ $loop->iteration }}</td>
                                            <td>{{ $cdr->campaign_title ?? 'N/A' }}</td>
                                            <td>{{ $cdr->cli ? '+' . $cdr->cli : '-' }}</td>
                                            <td>{{ $cdr->route ?? '-' }}</td>
                                            <td>{{ $cdr->number ?? '-' }}</td>
                                            <td>
                                                @if (!empty($cdr->duration))
                                                    {{ gmdate('H:i:s', $cdr->duration) }}
                                                @else
                                                    -
                                                @endif
                                            </td>
                                            <td>{{ $cdr->cost ?? '-' }}</td>
                                            <td>{{ $cdr->start_time ?? '-' }}</td>
                                            <td>{{ $cdr->end_time ?? '-' }}</td>
                                            <td>
                                                @if (!empty($cdr->call_recording))
                                                    <audio controls>
                                                        <source src="{{ $cdr->call_recording }}" type="audio/mpeg">
                                                    </audio>
                                                @else
                                                    -
                                                @endif
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="14" class="text-center text-muted">No records found</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.7.0.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.5/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    @push('scripts')
        <script src="{{ asset('assets/plugins/dashboard_date/moment.min.js') }}"></script>
        <script src="{{ asset('assets/plugins/dashboard_date/bootstrap-datepicker.min.js') }}"></script>
        <script src="{{ asset('assets/plugins/dashboard_date/daterangepicker.js') }}"></script>

        <script type="text/javascript">
            $(function () {
                // Date Range Picker
                $('#reservation').daterangepicker({
                    locale: { format: 'YYYY-MM-DD' },
                    "startDate": "{{ $startDate }}",
                    "endDate": "{{ $endDate }}",
                    opens: 'right'
                }, function (start, end) {
                    $("#start_date").val(start.format('YYYY-MM-DD'));
                    $("#end_date").val(end.format('YYYY-MM-DD'));
                });

                // DataTable Init
                const table = $('#cdrTable').DataTable({
                    pageLength: 10,
                    lengthChange: false,
                    order: [[0, 'asc']],
                });

                $('#entriesCount').on('change', function () {
                    table.page.len($(this).val()).draw();
                });

                // Select2 Init
                $('.select2').select2({
                    placeholder: 'Select numbers',
                    allowClear: true,
                    width: '100%'
                });
            });
        </script>
    @endpush
@endsection
