@extends('layouts.app')
@section('title', 'Do Not Call List')

@section('content')
<style>
    /* Custom style for pagination links */
    .pagination {
        margin: 0; /* Remove default margin */
        padding: 0; /* Remove default padding */
        list-style: none; /* Remove list bullet points */
        display: flex; /* Use flex layout for horizontal alignment */
    }

    .pagination li a {
        padding:6px;
    }

    .pagination a {
        display: inline-block;
        padding: 0; /* Adjust the padding as needed */
        text-decoration: none;
        background-color: #f0f0f0;
        border: 1px solid #ccc;
        color: #333;
        transition: background-color 0.3s ease, color 0.3s ease;
    }

    .pagination a:hover {
        background-color: #ccc;
        color: #fff;
    }

    .pagination .active a {
        background-color: #007bff;
        color: #fff;
    }
    .table > tbody > tr > td, .table > tbody > tr > th {
     padding: 0.7rem; 
    vertical-align: middle;
}

</style>
<!-- Main content -->
        <section class="content">

      <div class="row">

      <?php
        $url_page = explode('?',str_replace('/','',$_SERVER['REQUEST_URI']));
        $url = $url_page[0];
           
               
           

            if($page == 1)
            {
                $currentPage = 1;
            }

            else
            {
                $currentPage = isset($_GET['page']) ? (int) $_GET['page'] : 1;
            }

            $perPage = $show;
            $paginator = new Illuminate\Pagination\LengthAwarePaginator($dnc_list, $record_count ,$perPage,$currentPage,['path' => url($url)]);
            $record_count = $paginator->total();
        ?>
        
        <div class="col-12">
          <div class="box">
           <div class="box-body">   
                      
              <h4 class="box-title text-info mb-0"><i class="fa fa-list fa-sx"></i> Ivr Logs Press 1 Campaign</h4> 
             

       <hr class="my-15">
                    <b>Total Rows :<?= $record_count ?></b>       
                          
              <div class="table-responsive">
                <table  class="table mt-0 table-hover no-wrap" >
                  <thead>
                    <tr>
                              <th>#</th>
                              <th>Number</th>
                              <th>CLI</th>
                              <th>Ivr Id</th>
                              <th>Campaign Id</th>
                              <th>Lead Id</th>


                              <th>Created At</th>



                              @if(session()->get('level') >= 7)                             
                              <!-- <th>Action</th> -->
                              @endif

                            </tr>
                  </thead>
                  <tbody>
                           @foreach($dnc_list as $key => $dnc)
                                <tr>
                                  <th scope="row">{{ ($paginator->currentPage() - 1) * $paginator->perPage() + $key + 1 }}</th>
                                  <td class="phone">{{$dnc->number}}</td>   
                                  <td class="phone">{{$dnc->cli}}</td>   
                                  <td class="phone">{{$dnc->ivr_id}}</td> 
                                  <td class="phone">{{$dnc->campaign_id}}</td>                            
                                  <td class="phone">{{$dnc->lead_id}}</td>                            
                                  <td class="phone">{{$dnc->created_at}}</td>                            



                               <!--    <td> @if(session()->get('level') >= 7)
                                    <a style="cursor:pointer;margin-right:5px;"title="Edit" class='editDnc' data-number="{{$dnc->number}}" ><i class="fa fa-edit fa-lg"></i></a> 
                                   <a style="cursor:pointer;"title="Delete" class='openDncDelete' data-number="{{$dnc->number}}"><i class="fa fa-trash-o fa-lg"></i></a>@endif
                                  </td>   -->                           
                                </tr>  
                            @endforeach                         
                  </tbody>
                </table>
                <div style="float:right;">
                        {{$paginator->appends(Request::all())->links()}}
                       </div>
                    </div><!-- /.box-body -->


      

              </div>
     
            </div>
          </div>
        </div>
      </div>
      <!-- /.row -->
   
      <!-- Button trigger modal -->


<!-- Modal -->
<div class="modal fade" id="myModalExcel" tabindex="-1" aria-labelledby="myModalExcelLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="upload-excel">Upload Excel</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form method="post" action="" enctype="multipart/form-data">
      @csrf
      <div class="modal-body">
      <input type="hidden" class="form-control" name="dnc" value="" >
      <label class="form-label" for="inputEmail3" class="col-form-label closed">Excel</label>
      <input class="form-control closed" type="file" required name="dnc_file" id="dnc_file" placeholder="Select Excel File">
       
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
        <button type="submit"name="submit" class="btn btn-primary btn-sm">Save changes</button>
      </div>
        </form>
    </div>
  </div>
</div>
            
        
    <!-- Modal -->
<div class="modal fade" id="myModal" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="add-edit"></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      
    </div>
  </div>
</div>
<div class="modal fade" id="delete" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="myModalLabel">Confirm Delete</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
    
      <div class="modal-body">
      <p>You are about to delete <b><i class="title"></i></b> Do Not Call record.</p>
         <p>Do you want to proceed?</p>
         <input type="hidden" class="form-control" name="dnc_number" value="" id="dnc_number">
       
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
        <button type="submit"name="submit" class="btn btn-danger btn-sm deleteDNC">Delete</button>
      </div>
    </div>
  </div>
</div>

    <?php  ?>
        </div>
    </section>
        <!-- /.content -->
        <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>
        <script src="https://cdn.jsdelivr.net/npm/imask"></script>
<script>
      var phoneInput = document.getElementById('number');
    var phoneMask = new IMask(phoneInput, {
        mask: '(000) 000-0000'
    }); 
  
$(document).ready(function() {
    // Format mobile numbers
    $('.phone').each(function() {
        const phoneText = $(this).text();
        
        const countryCode = phoneText.slice(0, -10); // Extract the country code from the beginning
        const phoneNumber = phoneText.slice(-10); // Extract the last 10 digits

        const formattedMobile = `${countryCode}(${phoneNumber.substr(0, 3)})-${phoneNumber.substr(3, 3)}-${phoneNumber.substr(6)}`;
        
        $(this).text(formattedMobile);
    });
});
</script>
<script>
    var maxLength = 300;
    $('#comment').keyup(function()
    {
        var textlen = maxLength - $(this).val().length;
        $('#rchars').text(textlen);
    });

</script>
    <script>

          $("#openExcelForm").click(function() {
            $("#myModalExcel").modal();
            $("#name").val('');
            $("#status").val('1');
            $("#id").val('');
            $(".closed").show();
            $("#upload-excel").html('Upload Excel');
            console.log('dnc_file');
            });

            $(".openDncDelete").click(function(){
                var dnc_number = $(this).data('number');
                $("#delete").modal('show');
                $("#dnc_number").val(dnc_number);      
            });

            $(document).on("click", ".deleteDNC", function() {
                var delete_id = $("#dnc_number").val();

                var el = this;
                $.ajax({
                    url: 'deleteDnc/' + delete_id,
                    type: 'get',
                    success: function(response) {
                      window.location.reload(1);
                    }
                });
        
            });
            $(document).on("click", ".editDnc", function() {
        $("#myModal").modal('show');
        $("#add-edit").html('Edit DNC');
        var edit_number = $(this).data('number');
        //$(".closed").hide();
        $(".number").hide();
        $("#number").hide();

        $.ajax({
            url: 'editDnc/' + edit_number,
            type: 'get',
            success: function(response) {

                $("#number").val(response[0].number);


                $("#extension").val(response[0].extension);
                $("#comment").val(response[0].comment);

                 $("#id").val(response[0].number);
            }
        });
    });

    $("#openDNCForm").click(function() {

$("#myModal").modal('show');
$("#number").val('');
$("#extension").val('');
$("#comment").val('');

$(".closed").show();
$("#add-edit").html('Add DNC');
});

    </script>  





@endsection
