@extends('layouts.app')
@section('title', 'Live List')

@section('content')
<style>
    .table > tbody > tr > td, .table > tbody > tr > th {
     padding: 0.5rem; 
    vertical-align: middle;
}
    </style>
<?php
use \App\Http\Controllers\InheritApiController;
$userdetails = InheritApiController::headerUserDetails();
?>

<!-- Main content -->
        <section class="content">

      <div class="row">

       
        
        <div class="col-12">
          <div class="box">
             <div class="box-body">           
              <h4 class="box-title text-info mb-0"><i class="fa fa-user fa-sx"></i> Live Call List ( <i class="fa fa-refresh" aria-hidden="true"></i> refreshing in <span id="timer"></span> sec )</h4>
           <hr class="my-15">

              <div class="table-responsive">
              <form class="form-inline form-dialer" method="post">
                @csrf
                <table id="tickets" class="table mt-0 table-hover no-wrap" data-page-size="10">
                  <thead>
                    <tr>
                              <th>#</th>
                              <th>Agent Name(Extension)</th>
                              <th>Number</th>
                              <th>Route</th>
                              <th>Campaign Name</th>
                              <th>Call Type</th>
                              <th>Start Time</th>
                              <th>Duration</th>                             
                              <th>Action</th>

                            </tr>
                  </thead>
                  <tbody>
                  <input type="hidden" name="csrf-token" id="csrf-token" value="{{ csrf_token() }}"/>
                  <?php 

if(!empty($report)){
$k=0;
foreach ($report as $key=>$value){
    $timezone = $userdetails->data->timezone;
    if(!empty($timezone))
    {
        $utc = $value->start_time;
        $dt = new DateTime($utc);
        $tz = new DateTimeZone($timezone); // or whatever zone you're after
        $dt->setTimezone($tz);
        $start_time = $dt->format('Y-m-d H:i:s');
    }
    else
    {
        $start_time = $value->start_time;
    }
?>
                                <tr>
                                  <th scope="row"><?php echo ++$k; ?></th>
                                  <td>@foreach($extension_list as $extension)
                                            @if($value->extension == $extension->extension)
                                                {{$extension->first_name}} {{$extension->last_name}}  ({{$extension->extension}}) 
                                            @elseif($value->extension == $extension->alt_extension)
                                                {{$extension->first_name}} {{$extension->last_name}}  ({{$extension->extension}}) 
                                            @endif
                                        @endforeach

                                    </td>
                                    <td><?php echo $value->number;?>   
                                   </td>
                                    <td>
                                    <?php  if($value->route == 'IN') { echo 'Inbound'; } else if($value->route == 'OUT') { echo "Outbound"; }?>
                                </td>                            
                                <td>
                                @if(empty($value->campaign_id))
                                            N/A
                                            @else
                                            @foreach($campaign_list as $campaign)
                                            @if($campaign->id == $value->campaign_id)
                                            {{$campaign->title}}
                                            @endif
                                            @endforeach
                                            @endif
                                </td>
                                <td>
                                <?php echo ucfirst($value->type);?>
                                    
                                </td>
                                <td> 
                                <?php echo $start_time;?>
                                </td>
                                <td>
                                <?php  echo substr($value->duration,1); ?>
                                </td>
                                   
                                <td><a type="button" data-barge_id='{{$value->id}}' class="btn btn-primary barge_call_btn">Barge</a> 
                                        <a type="button" data-listen_id='{{$value->id}}' data-call_type="{{$value->type}}" class="btn btn-primary listen_call_btn">Listen</a>
                                </td>
                                  
                             
                                </tr>
                                <?php } }

                                else { ?>

                                    <tr><td style="color:red;">No Live Calls found</td></tr>
                                <?php }?>
                         
                  </tbody>
                </table>
                </form>
              </div>
            </div>
          </div>
        </div>
  

   
      </div>
      <!-- /.row -->

    </section>
        <!-- /.content -->
        <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>
 <!-- SweetAlert2 -->
 <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
        $(document).on('click', '.listen_call_btn', function (e)
{
    const swalWithBootstrapButtons = Swal.mixin({
        customClass:{
            confirmButton: 'btn btn-success',
            cancelButton: 'btn btn-danger'
        },

        buttonsStyling: false
    })

    swalWithBootstrapButtons.fire({
        title: 'Which phone do you want to use to make it listen',
        text: "",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Primary Phone',
        cancelButtonText: 'Webphone',
        reverseButtons: true
    }).then((result) =>
    {
        if (result.isConfirmed)
        {
            var extension = "<?= Session::get('extension'); ?>";
            $.ajax({
                type: 'POST',
                url: '/listen-call',
                data:
                {         
                    extension: extension,
                    listen_id: $(this).data('listen_id'),
                    call_type: $(this).data('call_type'),
                    "_token": "{{ csrf_token() }}",
                },
                success: function (data)
                {
                    var res = $.parseJSON(data);
                    if (res.status == 'true')
                    {
                        $(".listen_call_btn :input").attr("disabled", true);
                    }
                }
            });
        }

        else if(result.dismiss === Swal.DismissReason.cancel)
        {
            var extension = "<?= Session::get('private_identity'); ?>";
            $.ajax({
                type: 'POST',
                url: '/listen-call',
                data: 
                {         
                    extension: extension,
                    listen_id: $(this).data('listen_id'),
                    call_type: $(this).data('call_type'),
                    "_token": "{{ csrf_token() }}",
                },

                success: function (data)
                {
                    var res = $.parseJSON(data);
                    if (res.status == 'true')
                    {
                        $(".listen_call_btn :input").attr("disabled", true);
                    }
                    else if(res.status == false)
                    {
                        Swal.fire(res.message);
                    }
                }
            });
        }
    })
});



/*$('.barge_call_btn').on('click', function(){
	$.ajax({
		type: 'POST',
		url: '/barge-call',
		data: {			
			listen_id: $(this).data('barge_id'),
			call_type: $(this).data('call_type'),
			"_token": "{{ csrf_token() }}",
		},
		success: function (data) {
			var res = $.parseJSON(data);
			if (res.status == 'true') {
				$(".barge_call_btn :input").attr("disabled", true);

			}
		}
	});
});*/

$(document).on('click', '.barge_call_btn', function (e)
{
    const swalWithBootstrapButtons = Swal.mixin({
        customClass:{
            confirmButton: 'btn btn-success',
            cancelButton: 'btn btn-danger'
        },

        buttonsStyling: false
    })

    swalWithBootstrapButtons.fire({
        title: 'Which phone do you want to use to make it barge',
        text: "",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Primary Phone',
        cancelButtonText: 'Webphone',
        reverseButtons: true
    }).then((result) =>
    {
        if (result.isConfirmed)
        {
            var extension = "<?= Session::get('extension'); ?>";
            $.ajax(
            {
                type: 'POST',
                url: '/barge-call',
                data: 
                {       
                    extension: extension,  
                    listen_id: $(this).data('barge_id'),
                    call_type: $(this).data('call_type'),
                    "_token": "{{ csrf_token() }}",
                },

                success: function (data)
                {
                    var res = $.parseJSON(data);
                    if (res.status == 'true')
                    {
                        $(".barge_call_btn :input").attr("disabled", true);
                    }
                }
            });
        }

        else if(result.dismiss === Swal.DismissReason.cancel)
        {
            var extension = "<?= Session::get('private_identity'); ?>";

            $.ajax(
            {
                type: 'POST',
                url: '/barge-call',
                data: 
                {       
                    extension: extension,  
                    listen_id: $(this).data('barge_id'),
                    call_type: $(this).data('call_type'),
                    "_token": "{{ csrf_token() }}",
                },

                success: function (data)
                {
                    var res = $.parseJSON(data);
                    if (res.status == 'true')
                    {
                        $(".listen_call_btn :input").attr("disabled", true);
                    }
                    else if(res.status == false)
                    {
                        Swal.fire(res.message);
                    }
                }
            });
        }
    })
});
</script>
<!-- /.content-wrapper -->

<script>
    var counter = 16;
    var interval = setInterval(function()
    {
        counter--;
        $("#timer").html(counter);
        if (counter == 0)
        {
            clearInterval(interval);
            window.location.reload();
        }
    },1000);

</script>








@endsection
