@extends('layouts.app')
@section('title', 'Live List')

@section('content')
<style>
    .table > tbody > tr > td, .table > tbody > tr > th {
     padding: 0.5rem; 
    vertical-align: middle;
}
    </style>
<?php
use \App\Http\Controllers\InheritApiController;
$userdetails = InheritApiController::headerUserDetails();
?>

<!-- Main content -->
        <section class="content">

      <div class="row">

       
        
        <div class="col-12">
          <div class="box">
             <div class="box-body">           
              <h4 class="box-title text-info mb-0"><i class="fa fa-user fa-sx"></i> Live Call List </h4>
           <hr class="my-15">

              <div class="table-responsive">

   
    <div id="like_button_container"></div>
<!-- <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css"> -->
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.3/jquery.min.js"></script>
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
    <!-- Load React. -->
    <!-- Note: when deploying, replace "development.js" with "production.min.js". -->
    <script crossorigin src="https://unpkg.com/react@17/umd/react.development.js"></script>
<script crossorigin src="https://unpkg.com/react-dom@17/umd/react-dom.development.js"></script>
<script src="https://unpkg.com/@babel/standalone/babel.min.js"></script>

    <!-- Load our React component. -->
     <script type="text/babel">
  class App extends React.Component {
   
    // Constructor 
    constructor(props) {
        super(props);
   
        this.state = {
            items: [],
            DataisLoaded: false
        };
    }
   
    // ComponentDidMount is used to
    // execute the code 
    componentDidMount() {
    setInterval(() => {
        fetch(
"/live-call-api")
            .then((res) => res.json())
            .then((json) => {
                this.setState({
                    items: json,
                    DataisLoaded: true
                });
            })
  }, 5000);
    }
    render() {
        const { DataisLoaded, items } = this.state;
        if (!DataisLoaded) return <div>
            <h2> Please wait for some time.... </h2> </div> ;
   
        return (
        <div className = "App">
            <table class="table mt-0 table-hover no-wrap">
    <thead>
      <tr>
        <th>Agent Name(Extension)</th>
                                <th>Number</th>
                                <th>Route</th>
                                <th>Campaign Name</th>
                                <th>Call Type</th>
                                <th>Start Time</th>
                                <th>Duration</th>
                                <th>Action</th>


       
      </tr>
    </thead>
    <tbody>  {
                items.data.map((item) => ( 
                <tr>
        <td>{ item.extension }</td>
        <td>{ item.number }</td>
        <td>{ item.route }</td>
        <td>Campaign</td>

        <td>{ item.type }</td>
        <td>{ item.start_time }</td>
        <td>{ item.duration }</td>
        

        <td>
                                        <a type="button" data-barge_id='{$item->id}' class="btn btn-primary barge_call_btn">Barge</a> 
                                        <a type="button" data-listen_id='{$item->id}' data-call_type="{$item->type}" class="btn btn-primary listen_call_btn">Listen</a></td>

      </tr>
                ))
            }
            </tbody>
  </table>
        </div>
    );
}
}

    //render the component to the DOM
    ReactDOM.render(<App />, document.getElementById('like_button_container'));
</script>
       </div><!-- /.box-body -->
                </div><!-- /.box -->
            </div><!-- /.col -->
        </div><!-- /.row -->
    </section><!-- /.content -->
</div>


  
<script>
/*$('.listen_call_btn').on('click', function(){
	$.ajax({
		type: 'POST',
		url: '/listen-call',
		data: {			
			listen_id: $(this).data('listen_id'),
			call_type: $(this).data('call_type'),
			"_token": "{{ csrf_token() }}",
		},
		success: function (data) {
			var res = $.parseJSON(data);
			if (res.status == 'true') {
				$(".listen_call_btn :input").attr("disabled", true);

			}
		}
	});
});*/


$(document).on('click', '.listen_call_btn', function (e)
{
    const swalWithBootstrapButtons = Swal.mixin({
        customClass:{
            confirmButton: 'btn btn-success',
            cancelButton: 'btn btn-danger'
        },

        buttonsStyling: false
    })

    swalWithBootstrapButtons.fire({
        title: 'Which phone do you want to use to make it listen',
        text: "",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Primary Phone',
        cancelButtonText: 'Webphone',
        reverseButtons: true
    }).then((result) =>
    {
        if (result.isConfirmed)
        {
            var extension = "<?= Session::get('extension'); ?>";
            $.ajax({
                type: 'POST',
                url: '/listen-call',
                data:
                {         
                    extension: extension,
                    listen_id: $(this).data('listen_id'),
                    call_type: $(this).data('call_type'),
                    "_token": "{{ csrf_token() }}",
                },
                success: function (data)
                {
                    var res = $.parseJSON(data);
                    if (res.status == 'true')
                    {
                        $(".listen_call_btn :input").attr("disabled", true);
                    }
                }
            });
        }

        else if(result.dismiss === Swal.DismissReason.cancel)
        {
            var extension = "<?= Session::get('private_identity'); ?>";
            $.ajax({
                type: 'POST',
                url: '/listen-call',
                data: 
                {         
                    extension: extension,
                    listen_id: $(this).data('listen_id'),
                    call_type: $(this).data('call_type'),
                    "_token": "{{ csrf_token() }}",
                },

                success: function (data)
                {
                    var res = $.parseJSON(data);
                    if (res.status == 'true')
                    {
                        $(".listen_call_btn :input").attr("disabled", true);
                    }
                    else if(res.status == false)
                    {
                        Swal.fire(res.message);
                    }
                }
            });
        }
    })
});



/*$('.barge_call_btn').on('click', function(){
	$.ajax({
		type: 'POST',
		url: '/barge-call',
		data: {			
			listen_id: $(this).data('barge_id'),
			call_type: $(this).data('call_type'),
			"_token": "{{ csrf_token() }}",
		},
		success: function (data) {
			var res = $.parseJSON(data);
			if (res.status == 'true') {
				$(".barge_call_btn :input").attr("disabled", true);

			}
		}
	});
});*/

$(document).on('click', '.barge_call_btn', function (e)
{
    const swalWithBootstrapButtons = Swal.mixin({
        customClass:{
            confirmButton: 'btn btn-success',
            cancelButton: 'btn btn-danger'
        },

        buttonsStyling: false
    })

    swalWithBootstrapButtons.fire({
        title: 'Which phone do you want to use to make it barge',
        text: "",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Primary Phone',
        cancelButtonText: 'Webphone',
        reverseButtons: true
    }).then((result) =>
    {
        if (result.isConfirmed)
        {
            var extension = "<?= Session::get('extension'); ?>";
            $.ajax(
            {
                type: 'POST',
                url: '/barge-call',
                data: 
                {       
                    extension: extension,  
                    listen_id: $(this).data('barge_id'),
                    call_type: $(this).data('call_type'),
                    "_token": "{{ csrf_token() }}",
                },

                success: function (data)
                {
                    var res = $.parseJSON(data);
                    if (res.status == 'true')
                    {
                        $(".barge_call_btn :input").attr("disabled", true);
                    }
                }
            });
        }

        else if(result.dismiss === Swal.DismissReason.cancel)
        {
            var extension = "<?= Session::get('private_identity'); ?>";

            $.ajax(
            {
                type: 'POST',
                url: '/barge-call',
                data: 
                {       
                    extension: extension,  
                    listen_id: $(this).data('barge_id'),
                    call_type: $(this).data('call_type'),
                    "_token": "{{ csrf_token() }}",
                },

                success: function (data)
                {
                    var res = $.parseJSON(data);
                    if (res.status == 'true')
                    {
                        $(".listen_call_btn :input").attr("disabled", true);
                    }
                    else if(res.status == false)
                    {
                        Swal.fire(res.message);
                    }
                }
            });
        }
    })
});
</script>
<!-- /.content-wrapper -->
<!-- 
<script>
    var counter = 6;
    var interval = setInterval(function()
    {
        counter--;
        $("#timer").html(counter);
        if (counter == 0)
        {
            clearInterval(interval);
            window.location.reload();
        }
    },1000);

</script> -->
@endsection