@extends('layouts.app')
@section('title', 'Login History')
<?php
    if (!empty(request()->input('start_date')))
    {
        $startDate = request()->input('start_date');
    }
    else
    {
        $current_date = date("Y-m-d"); 
        $str_date = strtotime(date("Y-m-d", strtotime($current_date)) . " -15 day");
        $startDate = date('Y-m-d', $str_date);
    }

    if (!empty(request()->input('end_date')))
    {
        $endDate = request()->input('end_date');
    }
    else
    {
        $endDate = date('Y-m-d');
    }

    $url_page = explode('?',str_replace('/','',$_SERVER['REQUEST_URI']));
    $url = $url_page[0];
?>

@section('content')
<style>
    /* Custom style for pagination links */
    .pagination {
  
        list-style: none; /* Remove list bullet points */
        display: flex; /* Use flex layout for horizontal alignment */
    }

    .pagination li a {
        padding:6px;
    }

    .pagination a {
        display: inline-block;
        padding: 0; /* Adjust the padding as needed */
        text-decoration: none;
        background-color: #f0f0f0;
        border: 1px solid #ccc;
        color: #333;
        transition: background-color 0.3s ease, color 0.3s ease;
    }

    .pagination a:hover {
        background-color: #ccc;
        color: #fff;
    }

    .pagination .active a {
        background-color: #007bff;
        color: #fff;
    }
  
   
    .table > tbody > tr > td, .table > tbody > tr > th {
     padding: 0.5rem; 
    vertical-align: middle;
}

  
</style>
    <section class="content">
			<div class="row">			  
				<div class="col-lg-12 col-12">
					  <div class="box">
						
						<!-- /.box-header -->
                        <form class="needs-validation" action="" method="post">
                            @csrf
							<div class="box-body">
								<h4 class="box-title text-info mb-0"><i class="fa fa-edit me-15"></i>Login History</h4>

								<hr class="my-15">
								<div class="row">
                                       @if(Session::get('level') >= 5)
                                
                                <div class="col-md-3">
									<div class="form-group">
									  <label class="form-label">User List</label>
                                        <div class="input-group mb-3">
                                            <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                            <select class="form-select" name="extension" id="extension">
                                        <option value="">Select</option>
                                        @foreach($extension_list as $key => $extension)

                                        @if((request()->session()->get('level') > 9))
                                        @if(($extension->user_level <= 9) || ($extension->extension == request()->session()->get('extension')))
                                        <option @if($extension->extension == request()->input('extension'))  selected @endif value="{{$extension->extension}}">{{$extension->first_name}} {{$extension->last_name}}  @if($extension->is_deleted == 1) - (Removed User) @endif</option>
                                        @endif

                                        @elseif(($extension->user_level < 9) || ($extension->extension == request()->session()->get('extension')))
                                        <option @if($extension->extension == request()->input('extension'))  selected @endif value="{{$extension->extension}}">{{$extension->first_name}} {{$extension->last_name}}  @if($extension->is_deleted == 1) - (Removed User) @endif</option>
                                        @endif


                                        @endforeach
                                    </select>								
                                        </div>
								  </div>
								</div>
                               
                                 <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="form-label">IP:</label>
                                        <div class="input-group mb-3"id="ip">
                                      <input type="text" class="form-control" name = "ip">
                                    </div>
                                </div>
                               </div>
                                @endif
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="form-label">Date range:</label>
                                        <div class="input-group mb-3"id="date-range">
                                            <div class="input-group-addon">
                                                    <i class="fa fa-calendar"></i>
                                                </div>
                                                <input type="text" class="form-control pull-right" id="cdr-range">
                                                <input type="hidden" id="start_date" name="start_date" value="{{ $startDate }}">
                                                <input type="hidden" id="end_date" name="end_date" value="{{ $endDate }}">
                                            </div>
                                        </div>
                                   </div>
                                </div>   
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="form-label"></label>
                                        <div class="input-group mb-3"style="margin-top:8px;">
                                        <button type="submit" name="submit" value="Search" class="btn btn btn-primary waves-effect waves-light btn-md"><i class="fa fa-search" aria-hidden="true"></i> Search</button>

                                               
                                    </div>
                                </div>
                                </div>
                           
								 
                        
                    
                                </div>
                               
                            </div>
						</form>
					  </div>
					  <!-- /.box -->			

                    </div>  

		
		  </div>
		  <!-- /.row -->


        <div class="row">

        <?php
            if (!empty($report)) {
                if ($lower_limit == '0')
            {
                $lower_limit = 0;
            }

            if ($lower_limit > 0)
            {
                //$lower_limit = $lower_limit - 10;
            }

            if($page == 1)
            {
                $currentPage = 1;
            }

            else
            {
                $currentPage = isset($_GET['page']) ? (int) $_GET['page'] : 1;
            }

            $perPage = 10;
            $paginator = new Illuminate\Pagination\LengthAwarePaginator($report, $record_count, $perPage, $currentPage, ['path' => url($url)]);
        ?>        
        <div class="col-lg-12 col-12">
            <div class="box">
            
               <div class="box-body">  
                <b>Total Rows :<?= $record_count ?></b>
 
                        <div class="table-responsive">
                        <table class="table mt-0 table-hover no-wrap" data-page-size="10">
                            <thead>
                            <tr>
                                        <th>#</th>
                                        <th>User Name</th>
                                        <th>IP</th>
                                        <th>User Agent</th>
                                        <th>Logged In</th>

                                    </tr>
                            </thead>
                            <tbody>
                            <?php
                                    $k = $lower_limit;
                                    foreach ($paginator->items() as $key => $value) {?>
                     
                                                        <tr>
                                            <th scope="row"><?php echo ++$k; ?></th>
                                            <td><?php echo $value->first_name.' '.$value->last_name; ?></td>
                                            <td>   <?php
                                            if(!empty($value->ip)) 
                                                echo $value->ip;
                                                else
                                                echo 'N/A'; 
                                            ?></td>
                                            <td>{{$value->user_agent}}</td>
                                            <td>{{$value->created_at}}</td>
                                         
                                        </tr>
                                        <?php } ?>


                                
                            </tbody>
                        
                        </table>
                        <!-- <div style="float:right;">{{$paginator->appends(Request::all())->links()}}</div> -->
                        <div style="float:right;">{{$paginator->appends(Request::all())->links('pagination::bootstrap-5')}}</div>

<!-- <div>Showing {{($paginator->currentpage()-1)*$paginator->perpage()+1}} to {{$paginator->currentpage()*$paginator->perpage()}} of  {{$paginator->total()}} entries </div> -->
                        </div>
                </div>
                
            </div>
        </div>
       
        <?php } ?>
        </div>
<!-- /.row -->


</section>
@push('styles')
<link rel="stylesheet" type="text/css"
    href="{{ asset('assets/plugins/dashboard_date/bootstrap-datepicker.min.css') }}">
    <link rel="stylesheet" type="text/css"
    href="{{ asset('assets/plugins/dashboard_date/bootstrap-datepicker.css') }}">
    <style>
        .margin-10{
            margin-right: 5%;
        }
        .marginTop-2{
            margin-top: 2%;
        }

        .width_fix{
            width: 195px;
        }
    </style>
@endpush
@push('scripts')
<script>
    var myAudio = document.getElementById("myAudio");
var isPlaying = false;

function togglePlay(valued) {
    $("#pause_"+valued).show();
    $("#play_"+valued).hide();

  isPlaying ? myAudio.pause() : myAudio.play();
};

function togglePause(valued) {
    $("#pause_"+valued).hide();
    $("#play_"+valued).show();

 myAudio.pause();
};

myAudio.onplaying = function() {
  isPlaying = true;
};
myAudio.onpause = function() {
  isPlaying = false;
};
</script>

    <script src="https://cdn.jsdelivr.net/npm/imask"></script>
<script>
    var phoneInput = document.getElementById('mobile');
    var phoneMask = new IMask(phoneInput, {
        mask: '(999) 999-9999'
    }); 
    </script>
   <script src="{{asset('asset/plugins/dashboard_date/moment.min.js') }}"></script>
    <script src="{{asset('asset/plugins/dashboard_date/bootstrap-datepicker.min.js') }}"></script>
    <script src="{{ asset('asset/plugins/dashboard_date/daterangepicker.js') }}"></script>
   
   
    <script type="text/javascript">
        $(function () {
            $('#cdr-range').daterangepicker({
                locale: { format: 'YYYY-MM-DD'},
                "startDate": "{{ $startDate }}",
                "endDate": "{{ $endDate }}",
                opens: 'right'

            }, function(start, end, label) {
                console.log('New date range selected: ' + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD') + ' (predefined range: ' + label + ')');
                $("#start_date").val(start.format('YYYY-MM-DD'));
                $("#end_date").val(end.format('YYYY-MM-DD'));
            });
        });
        </script>
@endpush
@endsection


