@extends('layouts.app')
@section('title', 'Report')
@section('content')
<style>
    /* Custom style for pagination links */
    .pagination {
  
  list-style: none; /* Remove list bullet points */
  display: flex; /* Use flex layout for horizontal alignment */
}

.pagination li a {
  padding:6px;
}

.pagination a {
  display: inline-block;
  padding: 0; /* Adjust the padding as needed */
  text-decoration: none;
  background-color: #f0f0f0;
  border: 1px solid #ccc;
  color: #333;
  transition: background-color 0.3s ease, color 0.3s ease;
}

.pagination a:hover {
  background-color: #ccc;
  color: #fff;
}

.pagination .active a {
  background-color: #007bff;
  color: #fff;
}

  </style>
    <section class="content">
			<div class="row">			  
				
	
<?php  if(!empty($report)){        
if($lower_limit == '0'){
  $lower_limit =0;
}


 if($lower_limit > 0){
  $lower_limit = $lower_limit -10;
}
 $currentPage  = isset($_GET['page']) ? (int) $_GET['page'] : 1;
  // Items per page
  $perPage      = 10;
  $paginator = new Illuminate\Pagination\LengthAwarePaginator($report, $record_count, $perPage, $currentPage,['path'=>url('call-report/'.$lead_id)]);
  ?>
<div class="col-lg-12 col-12">
    <div class="box">
        
        <div class="box-body">  
            <h4 class="box-title text-info mb-0"><i class="fa fa-edit me-15"></i>Report By Lead ID</h4>
            <a href="{{url('/lead')}}" type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-eye fa-sx"></i> Search Lead</a>

            <hr class="my-15">
               <!-- <b>Total Rows :<?= $record_count ?></b> -->
                        <div class="table-responsive">
                        <table id="tickets1"class="table mt-0 table-hover no-wrap" data-page-size="10">
                            <thead>
                            <tr>
                            <th>#</th>
                               
                                <th>Extension</th>
                                <th>Campaign</th>

                                <th>Route</th>
                                <th>Type</th>
                                <th>Number</th>
                               <th>Duration</th>
                                <th>Start Time</th>
                                <th>End Time</th>
                              
                               <th>Recording</th>
                                    </tr>
                            </thead>
                            <tbody>
                            <?php 


$k=$lower_limit;
foreach ($paginator->items() as $key=>$value){ ?>
    <tr>
        <td><?php echo ++$k; ?></td>
        <td><?php echo $value->extension;?></td>
        <td><?php echo $value->campaign_id;?></td>

        <td><?php echo $value->route;?></td>
        <td><?php echo $value->type;?></td>
        
        <td><?php echo $value->number;?></td>
        <td><?php echo $value->duration;?></td>
        <td><?php echo $value->start_time;?></td>
        <td><?php echo $value->end_time;?></td>
        <td><audio controls preload ='none'><source src="<?php echo $value->call_recording;?>" type='audio/wav'></audio></td>
        <!-- <td>
            <?php if(!empty($value->lead_id)){?>
                <a href="lead_detail.php?id=<?php echo $value->lead_id;?>" target="_blank"><span class="glyphicon glyphicon-search"></span></a>
        <?php } else { ?>
                NA
        <?php } ?>
        </td> -->
    </tr>
                                <?php } ?>
                           </tbody>
        </table>
        <div style="float:right;">{{$paginator->appends(Request::all())->links()}}</div>

<div>Showing {{($paginator->currentpage()-1)*$paginator->perpage()+1}} to {{$paginator->currentpage()*$paginator->perpage()}} of  {{$paginator->total()}} entries </div>
                        </div>                        </div>
                </div>
                
            </div>
        </div>
        <?php }?>

        </div>
<!-- /.row -->


</section>


@endsection



