@extends('layouts.app')
@section('title', 'Call Transfer')
@section('content')
    <section class="content">
			<div class="row">			  
				<div class="col-lg-12 col-12">
					  <div class="box">
						
						<!-- /.box-header -->
                        <form class="form-inline" method="post">
                                    @csrf
							<div class="box-body">
								<h4 class="box-title text-info mb-0"><i class="fa fa-edit me-15"></i>Call Transfer</h4>

								<hr class="my-15">
								<div class="row">
                                    <div class="row">
								  <div class="col-md-3">
                                  <div class="form-group">
									<label class="form-label">Mobile</label>
									<div class="input-group mb-3">
										<span class="input-group-text"><i class="fa fa-mobile"></i></span>
                                        <input class="form-control" type="text" name="mobile" value="" id="mobile" maxlength="12">
									</div>
								</div>
								  </div>
                                
                                
                                <div class="col-md-3">
									<div class="form-group">
									  <label class="form-label">Extension</label>
                                        <div class="input-group mb-3">
                                            <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>

                                            <select class="form-select" name="extension" id="extension">
                                                <option value="">Select</option>
                                                @isset($extension_list)
                                                @foreach($extension_list as $key => $extension)
                                                <option value="{{$extension->id}}">{{$extension->extension}}</option>
                                                @endforeach
                                                @endisset
                                            </select>							
                                        </div>
								  </div>
								</div>
                                <div class="col-md-3">
                                  <div class="form-group">
									<label class="form-label">Campaign</label>
									<div class="input-group mb-3">
										<span class="input-group-text"><i class="ti-user"></i></span>
                                        <select name="campaign" class="js-example-basic-single select2" id="campaign">
                                            <option value="">Select</option>
                                            @foreach($campaign_list as $key => $campaign)
                                            @if(!empty($campaign->title))
                                            <option value="{{$campaign->id}}">{{$campaign->title}}</option>
                                            @endif
                                            @endforeach
                                        </select>
                                	</div>
								</div>
                                </div> 
                                </div> 
                                <div class="col-md-3"  >
                                  <div class="form-group">
									<label class="form-label">Status </label>
									<div class="input-group mb-3">
										<span class="input-group-text"><i class="ti-user"></i></span>
                                        <select name="exten_status" class="form-select" id="campaign">
                                                    <option value="">Select</option>
                                                    <option value="CANCEL">CANCEL</option>
                                                    <option value="BUSY">BUSY</option>
                                                    <option value="ANSWER">ANSWER</option>
                                                    <option value="CHAN UNAVAIL">CHAN UNAVAIL</option>
                                                    <option value="NO ANSWER">NO ANSWER</option>
                                                </select>
                                	</div>
								</div>
                              </div>
                            <div class="col-md-6">
                                  <div class="form-group">
									<label class="form-label">Date range:</label>
									<div class="input-group mb-3"id="date-range">
                                            <div class="input-group-addon">
                                                <i class="fa fa-calendar"></i>
                                            </div>
                                            <input type="text" autocomplete="off" class="form-control col-md-6 datepicker" id="start_date" name="start" value="">
                                                <span class="input-group-addon bg-primary text-white b-0">to</span>
                                                <input type="text" autocomplete="off" class="form-control col-md-6 datepicker" id="end_date" name="end" value="">
                                    </div>
                                    </div>
                                    </div>
                       
                           
								 
                        
                    
                                </div>
                               
                            </div>
                        
                          
                      
                          
                           
							<!-- /.box-body -->
							<div class="box-footer text-end">
                            <button type="submit" name="submit" value="Search" class="btn btn btn-primary waves-effect waves-light"><i class="fa fa-search" aria-hidden="true"></i> Search</button>
							</div>  
						</form>
					  </div>
					  <!-- /.box -->			

                    </div>  

		
		  </div>
		  <!-- /.row -->

	</section>

    <section class="content">

        <div class="row">

        <?php if(!empty($transferData)){ ?>
        
        <div class="col-lg-12 col-12">
            <div class="box">
            
               <div class="box-body">  
                        
                        <div class="table-responsive">
                        <table id="tickets"class="table mt-0 table-hover no-wrap" data-page-size="10">
                            <thead>
                            <tr>
                                                        <th>#</th>
                                                        <th>Extension</th>
                                                        <th>Transferred</th>
                                                        <th>Campaign</th>
                                                        <th>Phone Number</th>
                                                        <th>Status</th>
                                                        <th>Start Time</th>
                                                        <th>Recording</th>
                                                        <th>Second Recording</th>
                                                        <th>Action</th>

                                    </tr>
                            </thead>
                            <tbody>
                            @isset($transferData)
                                <?php 
                                $k=0;
                                foreach ($transferData as $key=>$value){ ?>
                     
                                                        <tr>
                                            <th scope="row"><?php echo ++$k; ?></th>
                                            <td><?php echo $value->extension;?></td>
                                            <td><?php echo $value->forward_extension;?></td>
                                            <td><?php echo $value->campaign;?></td>
                                            <td><?php echo $value->number;?></td>
                                            <td><?php echo $value->status;?></td>
                                            <td><?php echo $value->datetime;?></td>
                                        </tr>
                                      


                                
                            </tbody>

                        </table>
                        <?php } ?>
                          @endisset
                        </div>
                </div>
                
            </div>
        </div>
        <?php } ?>

        </div>
<!-- /.row -->


</section>
@push('styles')
<link rel="stylesheet" type="text/css"
    href="{{ asset('assets/plugins/dashboard_date/bootstrap-datepicker.min.css') }}">
    <link rel="stylesheet" type="text/css"
    href="{{ asset('assets/plugins/dashboard_date/bootstrap-datepicker.css') }}">
@endpush
   
@push('scripts')
	<!-- Vendor JS -->

    <script src="{{asset('assets/plugins/dashboard_date/moment.min.js') }}"></script>
    <script src="{{asset('assets/plugins/dashboard_date/bootstrap-datepicker.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/dashboard_date/daterangepicker.js') }}"></script>
    <!-- <script src="https://cdn.jsdelivr.net/npm/imask"></script>
<script>
    var phoneInput = document.getElementById('mobile');
    var phoneMask = new IMask(phoneInput, {
        mask: '(999) 999-9999'
    }); 
    </script> -->
  
  <script type="text/javascript">
        $(function () {
            $('#date-range').daterangepicker({
        

            });
        });
        </script>



<script>
$(document).ready(function() {
    function initializeSelect2() {
        $('.js-example-basic-single.select2').select2({
            dropdownParent: $('#campaign')
        });

       
        $('.select2-container').css({
            'width': '86%',
            'display': 'block'
        });
      
    }

    $('#campaign').on('shown.bs.modal', function() {
        initializeSelect2(); 
    });

    if ($('#campaign').hasClass('show')) {
        initializeSelect2();
    }
});
</script>

<style>
.select2-container {
    width: 86% !important;
}
.select2-selection--single {

    display: flex;
    align-items: center;
}
.select2-selection__rendered {
    line-height: 30px !important;
}
.select2-selection__arrow {
    height: 30px !important;
}
</style>

@endpush

@endsection



