@extends('layouts.app')
@section('title', 'Count Report')

@section('content')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
<style>
.badge
{font-size: 1rem;
    font-style: normal;
    font-weight: 400;
    font-family: "IBM Plex Sans", sans-serif;
    line-height: 1.5;
    margin-top:5px;}

</style>
<?php

error_reporting(0);

if (!empty(request()->input('start_date')))
    {
        $startDate = request()->input('start_date');
    }
    else
    {
        $current_date = date("Y-m-d"); 
        //$str_date = strtotime(date("Y-m-d"));//, strtotime($current_date)) . " - day");
        $startDate = date('Y-m-d');//, $str_date);
    }

    if (!empty(request()->input('end_date')))
    {
        $endDate = request()->input('end_date');
    }
    else
    {
        $endDate = date('Y-m-d');
    }
?>
<section class="content">
    
        <!--Call tming div starts-->
        <div class="row">
            <div class="box-header with-border bg-lightest">            
              <h4 class="box-title"><i class="fa fa-user fa-sx"></i> Count Report</h4>
            </div>
            <div class="row"style="--bs-gutter-x: 0.5rem";>
               
                <div class="col-md-12"style="margin-top:20px;">
                    <div class="box box-primary box-solid">
                

                    <div class="box-body">
    <form method="post" id="mySearch">
        @csrf

        <div class="row"> <!-- Add this row container -->
            @if(Session::get('level') > 7)
                <div class="col-md-4">
                    <div class="form-group">
                        <label class="form-label">Select Client</label>
                        <div class="input-group">
                            <select class="form-select" name="client_id">
                                @if(!empty($clients))
                                    @foreach($clients as $list_client)
                                    @if(in_array($list_client->company_name, $mapping))
                                        @if($list_client->is_deleted == '0')
                                            <option @if($list_client->id == request()->input('client_id')) selected @endif value="{{$list_client->id}}">{{$list_client->company_name}}</option>
                                        @endif
                                    @endif

                                    @endforeach
                                @endif
                            </select>
                        </div>
                    </div>
                </div>
            @else
                <input type="hidden"  name="client_id" value="{{Session::get('parentId')}}" />
            @endif
            <div class="col-md-4">
                <div class="form-group">
                    <label class="form-label">Date Range</label>
                    <div class="input-group">
                        <div class="input-group-addon">
                            <i class="fa fa-calendar"></i>
                        </div>
                        <input type="text" class="form-control pull-right" id="reservation">
                        <input type="hidden" id="start_date" name="start_date" value="{{ $startDate }}">
                        <input type="hidden" id="end_date" name="end_date" value="{{ $endDate }}">
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label class="form-label"></label>
                    <div class="input-group"style="margin-top:8px;">
                    <button type="submit" name="submit_download" class="btn btn-danger waves-effect waves-light m-l-10 btn-md" value="1"style="margin-right:10px;"><i class="fa fa-file-pdf-o" aria-hidden="true"></i> Export PDF</button>
                    <button type="submit" name="submit" value="Search" class="btn btn btn-primary waves-effect waves-light btn-md"><i class="fa fa-search" aria-hidden="true"></i> Search</button>
                    </div>
                </div>
            </div>
        </div> <!-- Close the row container -->
        <div id="loader" style="display: none;">
                <img src="{{ asset('assets/giphy.gif') }}" alt="Loading..." style="height:100px;width:100px;">
            </div>
            </form>

        <div style="clear: both"></div>

     
</div>

                    </div>
                </div>
            </div>
            <div class="col-md-6"style="margin-top:20px;">
                <div class="box box-primary box-solid">
               

                    <div class="box-body">

                        <div class="row">
                            <div class="col-sm-12">
                                    <div class="table-responsive ">
                        <table class="table  ">
                                            <tbody>
                                            <tr>
                                            <p style="padding:8px;border:1px solid #ddd;padding-top:12px;padding-bottom:12px;text-align:left;background-color:#2196F3;color:white">
                                                <strong>Total Inbound/OutBound Calls</strong>
                                            </p>
                                <td style="border:1px solid #ddd;padding:8px">Total Number Of Outbound Calls Made Manually</td>
                                <td style="border:1px solid #ddd;padding:8px">{{$email_templates->total_outbound_Calls_manually}}</td>
                            </tr>

                            <tr>
                                <td style="border:1px solid #ddd;padding:8px">Total Number Of Outbound Calls via Dialer</td>
                                <td style="border:1px solid #ddd;padding:8px">{{$email_templates->total_outbound_Calls_dialer}}</td>
                            </tr>

                            <tr>
                                <td style="border:1px solid #ddd;padding:8px">Total Number Of Outbound Calls via C2C</td>
                                <td style="border:1px solid #ddd;padding:8px">{{$email_templates->total_outbound_Calls_c2c}}</td>
                            </tr>

                            <tr>
                                <td style="border:1px solid #ddd;padding:8px">Total Number Of Outbound Calls</td>
                                <td style="border:1px solid #ddd;padding:8px">{{$email_templates->total_outbound_Calls}}</td>
                            </tr>


                            <tr>
                                <td style="border:1px solid #ddd;padding:8px">Inbound Calls</td>
                                <td style="border:1px solid #ddd;padding:8px">{{$email_templates->total_inbound_Calls}}</td>
                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6"style="margin-top:20px;">
                <div class="box box-primary box-solid">
               

                    <div class="box-body">
                        <div class="row">
                            <div class="col-sm-12">
                                    <div class="table-responsive ">
                                        <table class="table ">
                                            
                                            <tbody>
                                                <tr>
                                                <p style="padding:8px;border:1px solid #ddd;padding-top:12px;padding-bottom:12px;text-align:left;background-color:#2196F3;color:white">
                                                <strong>Total SMS/FAX Report Details</strong>
                                            </p>
                                                    <td style="border:1px solid #ddd;padding:8px">Total Number Of SMS Received</td>
                                                    <td style="border:1px solid #ddd;padding:8px">{{$email_templates->total_sms_receive}}</td>
                                                    </tr>
                                                    <tr>
                                                    <td style="border:1px solid #ddd;padding:8px">Total Number Of SMS Sent</td>
                                                    <td style="border:1px solid #ddd;padding:8px">{{$email_templates->total_sms_send}}</td>
                                                </tr>
                                                <tr>
                                                    <td style="border:1px solid #ddd;padding:8px">FAX Received</td>
                                                    <td style="border:1px solid #ddd;padding:8px">0</td>
                                                </tr>
                                                
                                                <tr>
                                                    <td style="border:1px solid #ddd;padding:8px">FAX Sent</td>
                                                    <td style="border:1px solid #ddd;padding:8px">0</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--Call tming div ends-->
        @if(!empty($email_templates->campaign))

            <div class="row">
                <div class="box-header with-border">            
                <h4 class="box-title"> Campaign Wise Outbound Summary </h4>
                </div>
                <div class="col-md-12"style="margin-top:20px;">
                    <div class="box box-primary box-solid">
                

                        <div class="box-body">

                            <div class="row">
                                <div class="col-sm-12">
                                        <div class="table-responsive ">
                                            <table class="table  table-bordered ">
                                            @php
                                $total_campaign = 0;
                                @endphp

                            

                                @foreach($email_templates->campaign as $camp)
                                @php
                                $total_campaign += $camp->calls;

                                $crm = $camp->dispositions;
                                    if (in_array("108", $crm))
                                    {
                                    $campaign_name = 'CRM CALL';
                                    }
                                    else
                                    {
                                    $campaign_name = $camp->title;
                                    }
                                @endphp
                                                <tbody>
                                                <tr style="background-color: #2196F3;">
                                        <td style="color:white;">Campaign Name : {{$campaign_name}}</td>
                                        <td><span class="badge badge-sm badge-danger">{{$camp->calls}}</span></td>
                                    </tr>

                                    <tr>
                                        <td ><b>Agent Wise Summary</b></td>
                                    

                                    </tr>

                                    <tr>
                                    <th style="padding: 8px;border: 1px solid #ddd;padding-top: 12px;padding-bottom: 12px;text-align: left;color: black;">Agent Name</th>
                                    
                                    <th style="padding: 8px;border: 1px solid #ddd;padding-top: 12px;padding-bottom: 12px;text-align: left;color: black;">Total Calls</th>
                                
                                </tr>
                                @foreach($camp->ext as $camp_user)
                                <tr>
                                        <td >{{$camp_user->name}} - {{$camp_user->extension}}</td>
                                        <td ><span class="badge badge-sm badge-danger">{{$camp_user->extension_total}}</span></td>

                                    </tr>

                                @endforeach


                                     <tr>
                                        <td ><b>Disposition Wise Summary</b></td>
                                    

                                    </tr>
                                    
                                    @foreach($camp->disposition as $camp_dispo)

                                    @php

                                    if (!empty($camp_dispo->title))
                                    {
                                        $title = $camp_dispo->title;
                                    }
                                                            
                                else
                                    if($camp_dispo->disposition_id == '101')
                                    {
                                        $title = "No Agent Available";
                                    }
                                
                                    else
                                    if($camp_dispo->disposition_id == '102')
                                    {
                                        $title =  "AMD Hangup";
                                    }
                                
                                    else
                                    if($camp_dispo->disposition_id == '103')
                                    {
                                        $title = "Voice Drop";
                                        
                                    }

                                    else
                                    if($camp_dispo->disposition_id== '104')
                                    {
                                        $title = "Cancelled By User";
                                    }

                                    else
                                    if($camp_dispo->disposition_id == '105')
                                    {
                                        $title = "Channel Unavailable";
                                    }
                                    else
                                    if($camp_dispo->disposition_id == '106')
                                    {
                                        $title = "Congestion";
                                    }
                                    else
                                    if($camp_dispo->disposition_id == '107')
                                    {
                                        $title = "Line Busy";
                                    }

                                    else
                                    if($camp_dispo->disposition_id == '108')
                                    {
                                        $title = "CRM CALL";
                                    }
                                    else 
                                    {
                                        $title =  'No Disposition';
                                    }

                                    @endphp

                                    <tr>
                                        <td >{{$title}}</td>
                                        <td ><span class="badge badge-sm badge-danger">{{$camp_dispo->disposition}}</span></td>

                                    </tr>

                                    @endforeach
                                @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            
            </div>
        @endif
        <div class="row">
            <div class="box-header with-border">            
              <h4 class="box-title"> Agent Wise Summary </h4>
            </div>
            <div class="col-md-12"style="margin-top:20px;">
                <div class="box box-primary box-solid">
               

                    <div class="box-body">

                        <div class="row">
                            <div class="col-sm-12">
                                    <div class="table-responsive ">
                                        <table class="table table-bordered ">
                                            
                                                <thead class="bg-primary">
                                                    <tr>
                                                    <th>Agent Name </th>
                                                    <th>Extension </th>
                                                    <th>Total Calls</th>
                                                    <th>Outbound Calls </th>
                                                    <th>C2C Calls</th>
                                                    <th>Inbound Calls</th>
                                                    <th>Total Call Time</th>
                                                    <th>Average Handle time </th>
                                                    <th>SMS Sent</th>
                                                    <th>SMS Received </th>

                                                    </tr>

                                                </thead>

                                                <tbody>
                                                @php
                            $total_totalcalls = 0;
                            $total_outbound = 0;
                            $total_c2c = 0;

                            $total_inbound = 0;
                            $total_outgoing = 0;
                            $total_incoming = 0;

                            $total_agent_duration = 0;
                            $total_agent_aht = 0;



                            @endphp
                            @foreach($email_templates->agent as $agentcall)
                            
                            @php
                                $total_totalcalls +=$agentcall->totalcalls;
                                $total_outbound +=$agentcall->outbound;
                                $total_c2c +=$agentcall->c2c;

                                $total_inbound +=$agentcall->inbound;
                                $total_outgoing +=$agentcall->outgoing;
                                $total_incoming +=$agentcall->incoming;

                                $seconds = round($agentcall->duration);
                                $output_duration_agent = sprintf('%02d:%02d:%02d', ($seconds/ 3600),($seconds/ 60 % 60), $seconds% 60);

                                $seconds_aht = round($agentcall->aht);
                                $output_duration_aht = sprintf('%02d:%02d:%02d', ($seconds_aht/ 3600),($seconds_aht/ 60 % 60), $seconds_aht% 60);

                                $total_agent_duration +=$agentcall->duration;
                                $total_agent_aht +=$agentcall->aht;


                                $seconds = round($total_agent_duration);
                                $total_duration = sprintf('%02d:%02d:%02d', ($seconds/ 3600),($seconds/ 60 % 60), $seconds% 60);

                                $seconds = round($total_agent_aht);
                                $total_aht = sprintf('%02d:%02d:%02d', ($seconds/ 3600),($seconds/ 60 % 60), $seconds% 60);



                                @endphp
                                <tr>
                                    <td>{{$agentcall->agentName}}</td>
                                    <td >{{$agentcall->extension}}</td>
                                    <td >{{$agentcall->totalcalls}}</td>
                                    <td >{{$agentcall->outbound}}</td>
                                    <td >{{$agentcall->c2c}}</td>

                                    <td >{{$agentcall->inbound}}</td>
                                    <td >{{$output_duration_agent}}</td>
                                    <td >{{$output_duration_aht}}</td>
                                    <td >{{$agentcall->outgoing}}</td>
                                    <td >{{$agentcall->incoming}}</td>

                                </tr>

                            @endforeach
                                            </tbody>
                                            <tfoot class="bg-primary">
                                            <tr>
                                    <th>Total</th>
                                    <th></th>
                                    <th>{{$total_totalcalls}}</th>
                                    <th>{{$total_outbound}}</th>
                                    <th>{{$total_c2c}}</th>

                                    <th>{{$total_inbound}}</th>
                                    <th>{{$total_duration}}</th>
                                    <th>{{$total_aht}}</th>
                                    <th>{{$total_outgoing}}</th>
                                    <th>{{$total_incoming}}</th>

                                </tr>
								</tfoot>
                                        </table>
                                    </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
           
        </div>
        @if(!empty($email_templates->did))

        <div class="row">
            <div class="box-header with-border bg-lightest">            
              <h4 class="box-title"> Inbound DID Wise Call Report</h4>
            </div>
            <div class="col-md-12"style="margin-top:20px;">
                <div class="box box-primary box-solid">
               

                    <div class="box-body">

                        <div class="row">
                            <div class="col-sm-12">
                                    <div class="table-responsive ">
                                        <table class="table table-bordered ">
                                            
                                                <thead class="bg-primary">
                                                    <tr>
                                                    <th>DID Number</th>                           
                                                    <th>Inbound Calls</th>
                                                    <th>Total Call Time</th>
                                                    <th>Average Handle time</th>
                                                    <th>SMS Sent</th>
                                                    <th>SMS Received</th>

                                                    </tr>

                                                </thead>

                                                <tbody>
                                                @php
                            $total_did = 0;
                            $total_duration = 0;
                            $total_aht = 0;
                            $total_outgoing = 0;
                            $total_incoming = 0;




                            @endphp



                            @foreach($email_templates->did as $list)
                            @php
                            $total_did += $list->totalcalls;


                            
                            $total_outgoing += $list->outgoing;
                            $total_incoming += $list->incoming;

                            $duration = round($list->duration);
                            $output_duration = sprintf('%02d:%02d:%02d', ($duration/ 3600),($duration/ 60 % 60), $duration% 60);
                            $aht = round($list->aht);
                            $output_aht = sprintf('%02d:%02d:%02d', ($aht/ 3600),($aht/ 60 % 60), $aht% 60);

                            $total_aht += $list->aht;
                            $total_aht = round($total_aht);
                            $total_output_aht = sprintf('%02d:%02d:%02d', ($total_aht/ 3600),($total_aht/ 60 % 60), $total_aht% 60);

                            $total_duration += $list->duration;
                            $total_duration = round($total_duration);
                            $total_output_duration = sprintf('%02d:%02d:%02d', ($total_duration/ 3600),($total_duration/ 60 % 60), $total_duration% 60);




                            @endphp
                            <tr>
                                    <td>{{$list->cli}}</td>
                                    <td>{{$list->inbound}}</td>
                                    <td>{{($output_duration)}}</td>
                                    <td>{{($output_aht)}}</td>
                                    <td>{{$list->outgoing}}</td>
                                    <td>{{$list->incoming}}</td>

                                </tr>
                            @endforeach
                                            </tbody>
                                            <tfoot class="bg-primary">
                                            <tr>
                                <th >Total</th>
                                <td >{{$total_did}}</td>
                               
                                <td >{{($total_output_duration)}}</td>
                                <td >{{($total_output_aht)}}</td>
                                <td >{{$total_outgoing}}</td>
                                <td >{{$total_incoming}}</td>

                            </tr>
								</tfoot>
                                        </table>
                                    </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
           
        </div>
        @endif
        @if(!empty($email_templates->city_wise))
        <div class="row">
            <div class="box-header with-border bg-lightest">            
              <h4 class="box-title"></i> State / City / Areacode Wise Summary </h4>
            </div>
            <div class="col-md-12"style="margin-top:20px;">
                <div class="box box-primary box-solid">
               

                    <div class="box-body">

                        <div class="row">
                            <div class="col-sm-12">
                                    <div class="table-responsive ">
                                        <table class="table table-bordered ">
                                            
                                                <thead class="bg-primary">
                                                <tr>
                                                    <th >State</th>
                                                    <th >City</th>
                                                    <th >DID</th>
                                                    <th >CNAM</th>
                                                    <th >Areacode
                                                    </th>
                                                    <th >Total Calls</th>
                                
                                                 </tr>

                                                </thead>

                                                <tbody>
                                                @php
                            $total_city_wise = 0;
                            @endphp
                            @foreach($email_templates->city_wise as $areacodecall)
                            @php
                            $total_city_wise += $areacodecall->total;
                            @endphp



                            <tr>
                                    <td >{{$areacodecall->state}}</td>
                                    <td >{{$areacodecall->city}}</td>
                                    <td >{{$areacodecall->did}} 
                                    <a class="badge badge-sm badge-danger cnam" style="text-align:right;"  data-did={{$areacodecall->did}} >Run CNAM Manually</a></td>
                                    <td >{{$areacodecall->cnam}}</td>
                                    <td >{{$areacodecall->area_code}}</td>

                                    <td >{{$areacodecall->total}}</td>
                                    
                                </tr>
                            @endforeach
                                            </tbody>
                                            <tfoot class="bg-primary">
                                            <tr>
                                <th >Total</th>
                                <td ></td>
                                <td ></td>
                                <td ></td>
                                <td ></td>
                                <td >{{$total_city_wise}}</td>

                            </tr>
								</tfoot>
                                        </table>
                                    </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
           
        </div>
        @endif
    </section>

    <div class="modal fade" id="cnam_model" tabindex="-1" aria-labelledby="cnam_modelLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="upload-excel">Run CNAM Manually</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
     
      <div class="modal-body">
      <p>Please enter your phone number</p>
      <input type="hidden" class="form-control" name="did_value" value="" id="did_value">
                        <p id="mobile_message"></p>
                        <input type=""   class="form-control" name="mobile" value="" placeholder="phone number" id="mobile">
       
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
        <button type="submit"name="submit" class="btn btn-primary btn-sm search_cnam">Run</button>
      </div>
        </form>
    </div>
  </div>
</div>


@push('styles')

<link rel="stylesheet" type="text/css"
    href="{{ asset('assets/plugins/dashboard_date/bootstrap-datepicker.min.css') }}">
    <link rel="stylesheet" type="text/css"
    href="{{ asset('assets/plugins/dashboard_date/bootstrap-datepicker.css') }}">
@endpush
   
@push('scripts')
	<!-- Vendor JS -->
	
    <script src="{{asset('assets/plugins/dashboard_date/moment.min.js') }}"></script>
    <script src="{{asset('assets/plugins/dashboard_date/bootstrap-datepicker.min.js') }}"></script>
    <script src="{{ asset('assets/plugins/dashboard_date/daterangepicker.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/imask"></script>
<script>
      var phoneInput = document.getElementById('mobile');
    var phoneMask = new IMask(phoneInput, {
        mask: '(000) 000-0000'
    }); 
    </script>
	<script>

$(document).ready(function() {
    $('#reservation').daterangepicker({
        
        locale: { format: 'YYYY-MM-DD'},
        "startDate": "{{ $startDate }}",
        "endDate": "{{ $endDate }}",
        opens: 'right'
    },function(start, end, label) {
                console.log('New date range selected: ' + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD') + ' (predefined range: ' + label + ')');
                $("#start_date").val(start.format('YYYY-MM-DD'));
                $("#end_date").val(end.format('YYYY-MM-DD'));
            }
    );
});

</script>

    <script type="text/javascript">

        $(".cnam").click(function() {
            var did = $(this).data('did');
            $("#cnam_model").modal('show');
            $("#did_value").val(did);
        });

        $(".search_cnam").click(function() {
            var phone_input = $("#mobile").val();
    
    // Remove any formatting characters (e.g., parentheses, hyphens, spaces) from the phone number
    var phone_number = phone_input.replace(/[\s()-]/g, '');
    var csrfToken = $('meta[name="csrf-token"]').attr('content');

            if(phone_number == '')
            {
                $("#mobile_message").html("Enter number");
                return false;
            }

            $('#cnam_model').removeClass("in");
                    $('#cnam_model').addClass("out");

                    
            did_value = $("#did_value").val();
alert(did_value);
            $.ajax({
                type: "get",
                headers: {
                    'X-CSRF-TOKEN': csrfToken
                },
                url: "/cli-report-manually-cnam/"+phone_number+"/"+did_value,
                //data: postData,
                dataType: "json",
                success: function (data) {
                    $("#mobile_message").html('');
                    toastr.success("Manully CNAM Call created Successfully");
                }
            });
        });

   
    </script>
    <script>
  $(document).ready(function() {
    $('#mySearch').on('submit', function() {
      // Show the loader
      $('#loader').show();
    });

    $('button[name="submit_download"]').on('click', function() {
      var buttonValue = $(this).val();

      if (buttonValue === '1') {
        // Show the loader when the button value is 1
        $('#loader').show();

        // Set a timeout to hide the loader after a delay (e.g., 3 seconds)
        setTimeout(function() {
          $('#loader').hide();
        }, 3000);
      }
    });
  });
</script>
    
@endpush

@endsection