@extends('layouts.app')
@section('title', 'Chat AI ')
@section('content')
<!-- Content Wrapper. Contains page content -->


<!-- Main content -->

  <section class="content">
        <div class="row">
        <div class="col-lg-12 col-12">
                <div class="box">
<style>

@import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap');

* {
  padding: 0;
  margin: 0;
  box-sizing: border-box;
}
body {
  background-color: #bdc3c7;
  font-family: 'Poppins', sans-serif;
}
.chatbot__button {
  position: fixed;
  bottom: 35px;
  right: 40px;
  width: 50px;
  height: 50px;
  display: flex;
  justify-content: center;
  align-items: center;
  background: #227ebb;
  color: #f3f7f8;
  border: none;
  border-radius: 50%;
  outline: none;
  cursor: pointer;
}
.chatbot__button span {
  position: absolute;
}
.show-chatbot .chatbot__button span:first-child,
.chatbot__button span:last-child {
  opacity: 0;
}
.show-chatbot .chatbot__button span:last-child {
  opacity: 1;
}
.chatbot {
  position: fixed;
  bottom: 100px;
  right: 40px;
  width: 420px;
  background-color: #f3f7f8;
  border-radius: 15px;
  box-shadow: 0 0 128px 0 rgba(0, 0, 0, 0.1) 0 32px 64px -48px rgba(0, 0, 0, 0.5);
  transform: scale(0.5);
  transition: transform 0.3s ease;
  overflow: hidden;
  opacity: 0;
  pointer-events: none;
}
.show-chatbot .chatbot {
  opacity: 1;
  pointer-events: auto;
  transform: scale(1);
}
.chatbot__header {
  position: relative;
  background-color: #227ebb;
  text-align: center;
  padding: 1px 0;
}
.chatbot__header span {
  display: none;
  position: absolute;
  top: 50%;
  right: 20px;
  color: #202020;
  transform: translateY(-50%);
  cursor: pointer;
}
.chatbox__title {
  font-size: 1.4rem;
  color: #f3f7f8;
}
.chatbot__box {
  height: 430px;
  overflow: auto;
  display: flex;
  flex-direction: column-reverse;
}
.chatbot__chat {
  display: flex;
}
.chatbot__chat p {
  max-width: 75%;
  font-size: 0.95rem;
  white-space: pre-wrap;
  color: #202020;
  background-color: #019ef9;
  border-radius: 10px 10px 0 10px;
  padding: 12px 16px;
}
.chatbot__chat p.error {
  color: #721c24;
  background: #f8d7da;
}
.incoming p {
  color: #202020;
  background: #bdc3c7;
  border-radius: 10px 10px 10px 0;
}
.incoming span {
  width: 32px;
  height: 32px;
  line-height: 32px;
  color: #f3f7f8;
  background-color: #227ebb;
  border-radius: 4px;
  text-align: center;
  align-self: flex-end;
  margin: 0 10px 7px 0;
}
.outgoing {
  justify-content: flex-end;
  margin: 20px 0;
}
.incoming {
  margin: 20px 0;
}
.chatbot__input-box {
  position: absolute;
  bottom: 0;
  width: 100%;
  display: flex;
  gap: 5px;
  align-items: center;
  border-top: 1px solid #227ebb;
  background: #f3f7f8;
  padding: 5px 20px;
}
.chatbot__textarea {
  width: 100%;
  min-height: 55px;
  max-height: 180px;
  font-size: 0.95rem;
  padding: 16px 15px 16px 0;
  color: #202020;
  border: none;
  outline: none;
  resize: none;
  background: transparent;
}
.chatbot__textarea::placeholder {
  font-family: 'Poppins', sans-serif;
}
.chatbot__input-box span {
  font-size: 1.75rem;
  color: #202020;
  cursor: pointer;
  visibility: hidden;
}
.chatbot__textarea:valid ~ span {
  visibility: visible;
}

@media (max-width: 490px) {
  .chatbot {
    right: 0;
    bottom: 0;
    width: 100%;
    height: 100%;
    border-radius: 0;
  }
  .chatbot__box {
    height: 90%;
  }
  .chatbot__header span {
    display: inline;
  }
}

</style>

<!-- Created based on Youtube [CodingLab](https://www.youtube.com/@CodingLabYT)--> 
<!-- Need an individual APIkey from OpenAI to make the bot work. it's free but with limitations-->

<!-- Icon  -->
<link
      rel="stylesheet"
      href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@48,400,0,0"
    />
    <link
      rel="stylesheet"
      href="https://fonts.googleapis.com/css2?family=Material+Symbols+Rounded:opsz,wght,FILL,GRAD@48,400,1,0"
    />
<!-- Code :) -->

<meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta name="csrf-token" content="{{ csrf_token() }}" />

   <button style="z-index: 111111;" class="chatbot__button" id="chat_sand">
      <span class="material-symbols-outlined">mode_comment</span>
      <span class="material-symbols-outlined">close</span>
    </button>
    <input type="hidden" id="customer_id" name="customer_id" />
    <div class="chatbot">
      <div class="chatbot__header">
        <h3 class="chatbox__title">Chatbot</h3>
        <span class="material-symbols-outlined">close</span>
      </div>
      <ul class="chatbot__box">
       <!--  <li class="chatbot__chat incoming">
          <span class="material-symbols-outlined">smart_toy</span>
          <p>Hi there. How can I help you today?</p>
        </li>
        <li class="chatbot__chat outgoing">
          <p>...</p>
        </li> -->
      </ul>
      <br>
      <br>
      <br>

      <div class="chatbot__input-box">
        <input 
          class="chatbot__textarea" id="chatbot__textarea"
          placeholder="Enter a message..."
          required
        >

        <!-- <textarea
          class="chatbot__textarea" id="chatbot__textarea"
          placeholder="Enter a message..."
          required
        ></textarea>-->
        <span id="send-btn" class="material-symbols-outlined">send</span>
      </div>
    </div>

    <script>
    const chatbotToggle = document.querySelector('.chatbot__button');
const sendChatBtn = document.querySelector('.chatbot__input-box span');
const chatInput = document.querySelector('.chatbot__textarea');
const chatBox = document.querySelector('.chatbot__box');
const chatbotCloseBtn = document.querySelector('.chatbot__header span');

let userMessage;
// Need GPT key
const inputInitHeight = chatInput.scrollHeight;
const API_KEY = 'HERE';


chatbotToggle.addEventListener('click', () =>
  document.body.classList.toggle('show-chatbot')
);
chatbotCloseBtn.addEventListener('click', () =>
  document.body.classList.remove('show-chatbot')
);
sendChatBtn.addEventListener('click', handleChat);
</script>


<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>

$( "#chatbot__textarea" ).keypress(function( event ) {
  if ( event.which == 13 ) {
     $("#send-btn").trigger('click');
     $("#chatbot__textarea").val("");
  }
});

    
        $('#chat_sand').on('click', function () {
       

        var formData = new FormData();
       // formData.append('to', "+1" + $('#phone_number').val());
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            url: '/chat-msg-ai',
            method: 'post',
            data: formData,
            contentType: false,
            processData: false,
            success: function (response) {
                var data = JSON.parse(response);
                var customerId = data.response.customer_id;

                $("#customer_id").val(customerId);

            },
            error: function (errors) {

            },
        });
    });
    
</script>
<script src="{{ asset('asset/js/angular.min.js') }}"></script>
<div ng-app="myApp" ng-controller="myCtrl"></div>

<script>

    var app = angular.module('myApp', []);
    app.controller('myCtrl', function ($scope, $http, $interval)
    {
        i=0;
       /* if (callbackReminderSetting == 1)
        {*/
            interval = $interval(function ()
            {
                var callbackReminderSetting = $("#customer_id").val();
                //alert(callbackReminderSetting);
                if (callbackReminderSetting)
                {
                $scope.displayData(); 
                } 
            }, 1000);
      //  }

        $scope.displayData = function()
        {  
            var reminderHtml = '';
            var interval;

              var customer_id = $("#customer_id").val();
   

            $(".display").hide();
            $http.post("/chat-counts-unread-ai?customer_id="+customer_id)
            //$http.post("/chat-counts-unread-ai?customer_id=CUSTOMER-3d7de98c-3e62-484d-90e6-43875259b8a0")

            .success(function(response)
            {        

                //console.log(response.data);

                $(".send-box").hide();
                $("#reset_sms").show();




                $('#preloader').css({'opacity': 0}).fadeOut();
                $('#preloader-status').hide();


                var count_list =response.data.count;
                console.log(count_list);
                //let genders = Object.keys(response.data);

                var result_data = '';

                for(i=0;i< count_list;i++)
                {

                    var iso = response.data[i].date;//'2022-03-24T23:59:59.000+00:00';
                    var date = iso.split('T')[0];

                    var time = iso.split('T')[1].split('.')[0];
                    var time_only = time.split(':')[0]+':'+time.split(':')[1];

                    var dateTime = date + ' ' + time;
                    var time = time;

                    if(response.data[i].sms_type == 'incoming')
                    {
                   

                      result_data+='<li class="chatbot__chat incoming" style="word-wrap: break-word;"><span class="material-symbols-outlined">smart_toy</span><p>'+response.data[i].message+'</p></li>';


                   
        

                    }
                    else
                        if(response.data[i].sms_type == 'outgoing')
                    {
                      

                      result_data+='<li class="chatbot__chat outgoing" style="word-wrap: break-word;"><p>'+response.data[i].message+'</p></li>';
                    }

                }

                

        

                $(".chatbot__box").html(result_data);

                //$(".chatbot__box").animate({ scrollTop: 20000000 }, "slow");
            });
        }  
    });

     $('#send-btn').on('click', function () {



       

        var formData = new FormData();
        formData.append('text', $('.chatbot__textarea').val());
        formData.append('customer_id', $('#customer_id').val());

                $(".chatbot__textarea").val('');


        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            url: '/send-text-to-ai',
            method: 'post',
            data: formData,
            contentType: false,
            processData: false,
            success: function (response) {

               // alert(response);
                /*var data = JSON.parse(response);
                var customerId = data.response.customer_id;

                $("#customer_id").val(customerId);*/

            },
            error: function (errors) {

            },
        });
    });

</script>
</div>
</div>
</div>
</section>
@endsection
