@extends('layouts.app')
@section('title', 'Caller ID Name Reports')
@section('content')

<style>
       /* Custom style for pagination links */
       .pagination {
        margin: 0; /* Remove default margin */
        padding: 0; /* Remove default padding */
        list-style: none; /* Remove list bullet points */
        display: flex; /* Use flex layout for horizontal alignment */
    }

    .pagination li a {
        padding:6px;
    }

    .pagination a {
        display: inline-block;
        padding: 0; /* Adjust the padding as needed */
        text-decoration: none;
        background-color: #f0f0f0;
        border: 1px solid #ccc;
        color: #333;
        transition: background-color 0.3s ease, color 0.3s ease;
    }

    .pagination a:hover {
        background-color: #ccc;
        color: #fff;
    }

    .pagination .active a {
        background-color: #007bff;
        color: #fff;
    }
  
   
    .table > tbody > tr > td, .table > tbody > tr > th {
     padding: 0.3rem; 
    vertical-align: middle;
}
    </style>
    <section class="content">
   
		    <div class="row">
       
			  
				    <div class="col-lg-12 col-12">
					    <div class="box">						
                            <!-- /.box-header -->
                            <form class="form-inline form-dialer" action="{{url('/cli-report')}}" method="post">
                                    @csrf
                                <div class="box-body">
                                    <h4 class="box-title text-info mb-0"><i class="fa fa-edit me-15"></i>Caller ID Name Reports</h4>

                                    <hr class="my-15">
                                    <div class="row">                                 
                                    <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="form-label"></label>
                                        <div class="input-group mb-3">
                                        
                                                <input type="text"  id="phone_number" name="phone_number" value="" class="form-control"  placeholder="Phone Number" required="">
                                               
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label class="form-label"></label>
                                        <div class="input-group mb-3">
                                        <button type="button" id="search_lead" class="btn btn-success waves-effect waves-light btn-md" value="Search">Run Maually Call for CNAM</button>

                                               
                                        </div>
                                    </div>
                                </div>
                                            <div class="form-group" style="margin-left: 15%;">
                                                <div class="row text-danger text-center" id="form_error">
                                                </div>
                                            </div>       
                                    </div>
                                </div>                              
                            </form>
					    </div>
					  <!-- /.box -->			
                    </div>  		
		    </div>
		  <!-- /.row -->

	

        <div class="row">

        <?php
         $url_page = explode('?',str_replace('/','',$_SERVER['REQUEST_URI']));
         $url = $url_page[0];
            if (!empty($cli_report)) {
                if ($lower_limit == '0')
            {
                $lower_limit = 0;
            }

            if ($lower_limit > 0)
            {
                //$lower_limit = $lower_limit - 10;
            }

            if($page == 1)
            {
                $currentPage = 1;
            }

            else
            {
                $currentPage = isset($_GET['page']) ? (int) $_GET['page'] : 1;
            }

            $perPage = 10;
            $paginator = new Illuminate\Pagination\LengthAwarePaginator($cli_report, $record_count, $perPage, $currentPage, ['path' => url($url)]);
        ?>        
        <div class="col-lg-12 col-12">
            <div class="box">
            
               <div class="box-body">  
                <form method="GET" action="">
                    <label for="show">Show:</label>
                        <select name="show" onchange="this.form.submit()">
                            <option value="10" {{ request('show') == 10 ? 'selected' : '' }}selected>10</option>
                            <option value="25" {{ request('show') == 25 ? 'selected' : '' }}>25</option>
                            <option value="50" {{ request('show') == 50 ? 'selected' : '' }}>50</option>
                            <option value="100" {{ request('show') == 100 ? 'selected' : '' }}>100</option>
                        </select>
                        <label for="entries">entries</label>
                    </form>
                    <div style="margin-bottom:10px;text-align:right;">
                    <form action="{{ url('/cli-report') }}" method="get">
                        <input type="text" name="search"id="search" placeholder="cli or cnam">
                        <button type="submit"><i class="fa fa-search"></i></button>
                    </form>
                    </div>
                <b>Total Rows :<?= $record_count ?></b>
 
                        <div class="table-responsive">
                        <table class="table mt-0 table-hover no-wrap" data-page-size="10">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Caller ID</th>
                                    <th>Caller ID Name</th>
                                    <th>Generation Date</th>

                                </tr>
                            </thead>
                            <tbody>
                            @if(!empty($cli_report))
                                    @foreach($cli_report as $key => $smtp)

                                        <tr>
                                            <td>{{ ($paginator->currentPage() - 1) * $paginator->perPage() + $key + 1 }}</td>
                                            <td>{{$smtp->cli}}</td>
                                            
                                            <td>{{$smtp->cnam}}</td>

                                            <td>{{$smtp->created_date}}</td>
                                            


                                            

                                        </tr>

                                    @endforeach
                                @endif


                                
                            </tbody>
                        
                        </table>
                        <!-- <div style="float:right;">{{$paginator->appends(Request::all())->links()}}</div>

<div>Showing {{($paginator->currentpage()-1)*$paginator->perpage()+1}} to {{$paginator->currentpage()*$paginator->perpage()}} of  {{$paginator->total()}} entries </div>
                        </div> -->
                        <!-- <div class="d-flex justify-content-between align-items-center mt-3 flex-column flex-md-row"> -->
   
    <!-- <div class="mb-3">
        Showing {{($paginator->currentpage()-1)*$paginator->perpage()+1}}
        to {{$paginator->currentpage()*$paginator->perpage()}}
        of {{$paginator->total()}} entries
    </div> -->
                        <div style="float:right;">{{$paginator->appends(Request::all())->links('pagination::bootstrap-5')}}</div>

    <!-- <div>
        {{$paginator->appends(Request::all())->links()}}
    </div> -->
<!-- </div> -->

                </div>
                
            </div>
        </div>
       
        <?php } ?>
        <div class="modal fade" id="myModal" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="myModalLabel">CNAM Record</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
    
        <div class="modal-body">
        <table id="smsListTable" class="table table-hover table-striped">
                                <thead>
                                    <tr>
                                        <th>Number</th>
                                        <th>CNAM</th>
                                        <th>Date</th>
                                    </tr>
                                </thead>

                                <tbody id="hiddenAfterSms">
                                
                                </tbody>
                            </table>
          
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
</div>
        </div>
<!-- /.row -->
<div ng-app="myAppReport" ng-controller="myCtrlReport"></div>


</section>
<script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/imask"></script>
<script>
      var phoneInput = document.getElementById('phone_number');
    var phoneMask = new IMask(phoneInput, {
        mask: '(000) 000-0000'
    }); 
    </script>
<script>

    
        var app = angular.module('myAppReport', []);
        app.controller('myCtrlReport', function ($scope, $http, $interval)
        {
            phone_number = $("#phone_number").val();

            i=0;
            var interval;
            interval = $interval(function ()
            {
                $scope.displayDataReport();  
            }, 1000);

            $scope.displayDataReport = function()
            { 
                $http({ url: '/find-cli-report/'+phone_number, method: "get"})
                .success(function(response_data) {                 
                    var res_length = Object.keys(response_data.data).length
                    if (res_length > 0) {
                        $('#hiddenAfterSms').html("");
                        var elem = document.getElementById('hiddenAfterSms');
                        for (var i = 0; i < res_length; i++) {
                            var obj = response_data.data[i];
                            var localTime = obj.created_date;
                            var created_date = localTime;
                            elem.innerHTML = elem.innerHTML + '<tr><td class="mailbox-name"  >' + obj.cli + '</td><td class="mailbox-name"  >' + obj.cnam + '</td><td class="mailbox-date" style="width:180px;">' + created_date + '</td></tr>';
                        }
                    }
                });  
            }
        });
    
    
</script>

<script language="javascript">
    $(document).ready(function () {
        $("#search_lead").click(function() {
            var phone_input = $("#phone_number").val();
    
    // Remove any formatting characters (e.g., parentheses, hyphens, spaces) from the phone number
    var phone_number = phone_input.replace(/[\s()-]/g, '');
alert(phone_number);
            $.ajax({
                type: "get",
                url: "/cli-report-manually/"+phone_number,
                //data: postData,
                dataType: "json",
                success: function (data) {
                    $('#myModal').modal('show');
                }
            });
        });
    });

    // $(document).ready(function () {
    //     var oTable = $('#example').dataTable({
    //         "aoColumnDefs": [
    //         {"bSortable": false, "aTargets": [2, 3]}
    //         ]
    //     });
    // });

    function deleteSetting(id) {
        $("#delete-" + id).hide();
        postData = {
            "_token": "{{ csrf_token() }}"
        };

        $.ajax({
            type: "POST",
            url: "/smtp-delete/" + id,
            data: postData,
            dataType: "json",
            success: function (data) {
                console.log(data);
                if (data.success) {
                    $("#alert-success").html(data.message).show();
                    setTimeout(function() {
                        window.location.reload(1);
                    }, 2000);
                }
                else {
                    $("#alert-errors").html(data.message).show();
                }
            },
            error: function (xhr, status, error) {
                $("#alert-errors").html(error).show();
            }
        });
    }

</script>
@endsection


