@extends('layouts.app')
@section('title', 'Add New Client')

@section('content')
<style>
  .badge
{font-size: 1rem;
    font-style: normal;
    font-weight: 400;
    font-family: "IBM Plex Sans", sans-serif;
    line-height: 1.5;}
  </style>
   <style>
        .status-label-container {
            margin-top: 5px;
        }
        .status-label {
            font-size: 100%;
            padding: 6px;
        }
    </style>
<!-- Main content -->
        <section class="content">

      <div class="row">

        <div class="col-12">
          <div class="box">
              <div class="box-body">
             <h4 class="box-title text-info mb-0"><i class="fa fa-plus fa-sx"></i> Add New Client</h4>
                         <a href="{{ url('/clients') }}" type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-eye"></i>  Show Clients</a>


             <hr class="my-15">
            <div class="row">
                <div class="col-xs-12">
                    <div class="box">
                    <form method="POST" role="form" name="addForm" id="addForm" action="{{ url('client') }}">
                                @csrf
                                <div class="box-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label  class="form-label"for="company_name">Name  </label>
                                                <div class="input-group">
                                                    <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                                   <input type="text" class="form-control" name="company_name" id="company_name" value="{{ old('company_name') }}" required />
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="form-label" for="stage">Status </label><br>
                                                <div class="select2-container select2-container--default status-label-container">
                                                    <span class="label label-primary status-label"><i class="icon fa fa-plus"></i> NEW</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="form-label" for="address_1">Building/Street  </label>
                                                <div class="input-group">
                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                                <input type="text" class="form-control" name="address_1" id="address_1" value="{{ old("address_1") }}" />
                                            </div>
                                        </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="form-label"for="address_2">Area/State/Zipcode </label>
                                                <div class="input-group">
                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                                <input type="text" class="form-control" name="address_2" id="address_2" value="{{ old("address_2") }}" />
                                            </div>
                                        </div>
                                    </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="form-label"for="trunk">Trunk </label>
                                                <div class="input-group">
                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                                <input type="text" class="form-control" name="trunk" id="trunk" value="{{ old("trunk") }}" maxlength=30 />
                                            </div>
                                        </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <?php $oldServer = empty(old("asterisk_servers"))?[]:old("asterisk_servers") ?>
                                                <label class="form-label" for="asterisk_servers">Server Allotted </label>
                                                <div class="input-group">
                                                <select class="form-control select2" multiple name="asterisk_servers[]" id="asterisk_servers" data-placeholder="Asterisk Servers" style="width: 100%;">
                                                    @if(!empty($asteriskServers))
                                                        @foreach($asteriskServers as $server)
                                                            <option value={{$server["id"]}} @if(in_array($server["id"], $oldServer)) {{ "selected" }} @endif >{{$server["host"]}} - {{$server["location"]}} - {{$server["trunk"]}}</option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                    <div class="col-md-6">
                                    <div class="form-group">
                                                <label class="form-label">Enable 2FA </label>
                                                <div class="input-group">
                                                   <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                                    <select class="form-select" name="enable_2fa" id="enable_2fa" >
                                                        <option value="0">No</option>
                                                        <option value="1">Yes</option>
                                                    </select>
                                                </div>
                                            </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-label">API Token </label>
                                            <div class="input-group position-relative">
                                                <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                                <input type="text" class="form-control" style="padding-right: 3.5rem;" name="api_key" id="api_key" value="{{ old("api_key") }}" />
                                                <button class="btn btn-primary btn-sm position-absolute" type="button" id="generate-api-key" style="right: 0.1rem; top: 50%; transform: translateY(-50%); z-index: 10; border-top-right-radius: 0; border-bottom-right-radius: 0;" title="Generate new API key">
                                                    <i class="ti-plus" id="gen-icon"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                    </div>
                                    <div class="col-md-6">
                                    <div class="form-group">
                                                <label class="form-label">Enable MCA CRM</label>
                                                <div class="input-daterange input-group col-md-12">
                                                 <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                                    <select class="form-select" name="mca_crm" id="enable_mca_crm" >
                                                    <option value="0">No</option>
                                                        <option  value="1">Yes</option>
                                                    </select>
                                                </div>
                                            </div>
                                     </div>
                                    <?php /*?>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="trunk">SMS Plateform  <i data-toggle="tooltip" data-placement="right" title="Select Sms Plateform" class="fa fa-info-circle" aria-hidden="true"></i></label>
                                                <select class="form-control" required name="sms_plateform" id="sms_plateform">
                                                    <option value="">Select SMS Plateform</option>

                                                    <option value="didforsale">DID For Sale</option>
                                                    <option value="plivo">Plivo</option>
                                                </select>
                                            </div>
                                        </div>

                                    </div>

                                    <?php */ ?>


                                </div><!-- /.box-body -->

                                <div class="box-footer text-end">
                                    <button type="submit" name="submit" value="Save" class="btn btn btn-primary waves-effect waves-light">Save</button>
                                </div>
                            </form>

                    </div><!-- /.box -->
                </div><!-- /.col -->
            </div><!-- /.row -->

            </div>
          </div>
        </div>
      </div>
      <!-- /.row -->

      <!-- Button trigger modal -->




        </div>
    </section>





<script>
    document.addEventListener('DOMContentLoaded', function() {
        const apiKeyInput = document.getElementById('api_key');
        const generateBtn = document.getElementById('generate-api-key');
        const genIcon = document.getElementById('gen-icon');

        function updateButtonIcon() {
            if (apiKeyInput.value.trim() === '') {
                genIcon.className = 'ti-plus'; // Generate icon (plus)
                generateBtn.title = 'Generate new API key';
            } else {
                genIcon.className = 'ti-reload'; // Refresh icon
                generateBtn.title = 'Regenerate API key';
            }
        }

        function generateUUID() {
            return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
                const r = Math.random() * 16 | 0;
                const v = c === 'x' ? r : (r & 0x3 | 0x8);
                return v.toString(16);
            });
        }

        generateBtn.addEventListener('click', function() {
            const newKey = generateUUID();
            apiKeyInput.value = newKey;
            updateButtonIcon(); // Switch to refresh icon after generation
        });

        // Initial check
        updateButtonIcon();

        // Listen for input changes to update icon dynamically
        apiKeyInput.addEventListener('input', updateButtonIcon);
    });
</script>
@endsection
