@extends('layouts.app')
@section('title', 'Edit New Client')
@section('content')
<style>
  .badge
{font-size: 1rem;
    font-style: normal;
    font-weight: 400;
    font-family: "IBM Plex Sans", sans-serif;
    line-height: 1.5;}

  </style>
     <style>
        .status-label-container {
            margin-top: 5px;
        }

        .status-label {
            font-size: 100%;
            padding: 6px;
        }
    </style>
      <style>
        /* Chrome, Safari, Edge, Opera */
        input::-webkit-outer-spin-button,
        input::-webkit-inner-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }

        /* Firefox */
        input[type=number] {
            -moz-appearance: textfield;
        }

        .number-of-users input {
            width: 100px;
            text-align: center;
            font-size: 20px;
            border: 1px solid #ddd;
            border-radius: 4px;
            display: inline-block;
            vertical-align: middle;
        }

        .number-of-users .minus, .number-of-users .plus {
            width: 32px;
            background: #f2f2f2;
            border-radius: 4px;
            padding: 5px;
            border: 1px solid #ddd;
            display: inline-block;
            vertical-align: middle;
            text-align: center;
            cursor: pointer;
        }

        .number-of-users .title {
            text-align: left;
            font-weight: 700;
            padding: 5px 0px;
        }
        .nav-tabs-custom > .tab-content {
    background: #ffffff;
    padding: 1.25rem;
    border-radius: 0;
     min-height: 100px; */
}
    </style>
<!-- Main content -->
        <section class="content">

      <div class="row">

        <div class="col-12">
          <div class="box">
              <div class="box-body">
             <h4 class="box-title text-info mb-0"><i class="fa fa-edit fa-sx"></i> Client - {{$client["company_name"]}}</h4>

              <a href="{{ url('/clients') }}" type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-eye"></i>  Show Clients</a>


            <hr class="my-15">
            <div class="row">
                <div class="col-xs-12">
                    <div class="box">
                    <form method="post" role="form" name="editForm" id="editForm"
                              action="{{url('client')."/".$client["id"]}}">
                            @csrf
                            <input type="hidden" class="form-control" name="id" value="{{$client["id"]}}" id="id"
                                   required>
                                <div class="box-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label  class="form-label"for="company_name">Name  </label>
                                                <div class="input-group">
                                                    <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                                    <input type="text" class="form-control" name="company_name"
                                                    id="company_name" value="{{$client["company_name"]}}" required/>
                                                </div>
                                        </div>
                                        </div>
                                        <div class="col-md-6 d-flex gap-3">
                                            <div class="form-group">
                                                <label class="form-label" for="stage">Status </label><br>
                                                <div
                                                    class="select2-container select2-container--default status-label-container">
                                                    @if($client["stage"] < 5)
                                                        <span class="label label-warning status-label"><i
                                                                class="icon fa fa-ban"></i> Pending ({{$client["stage"]}}/5)</span>
                                                    @else
                                                        <span class="label label-success status-label"><i
                                                                class="icon fa fa-check"></i> Ready</span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group text-center">
                                                <label class="form-label" for="outbond_ai">Outbound AI</label>
                                                <select name="outbond_ai" id="outbond_ai" class="form-control text-center">
                                                    <option value="1" {{ $client['outbond_ai']===1 ? 'selected' : '' }}>ON</option>
                                                    <option value="0" {{ $client['outbond_ai']===0 ? 'selected' : '' }}>OFF</option>
                                                </select>
                                            </div>
                                            <!-- Currency Select -->
                                            <div class="form-group text-center">
                                                <label class="form-label" for="currency">Currency</label>
                                                @php $currency = $client['currency'] ?? ''; @endphp
                                                <select name="currency" id="currency" class="form-control text-center">
                                                    <option value="USD" {{ $currency === 'USD' ? 'selected' : '' }}>USD</option>
                                                    <option value="INR" {{ $currency === 'INR' ? 'selected' : '' }}>INR</option>
                                                </select>
                                            </div>

                                            <div class="form-group text-center">
                                                <label class="form-label" for="ai_call_rate">AI Call Rate</label>
                                                <input
                                                    type="number"
                                                    step="0.01"
                                                    name="ai_call_rate"
                                                    id="ai_call_rate"
                                                    class="form-control text-center"
                                                    value="{{ $client['ai_call_rate'] ?? '' }}"
                                                    required
                                                >
                                            </div>
                                        </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="form-label" for="address_1">Building/Street  </label>
                                                <div class="input-group">
                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                           <input type="text" class="form-control" name="address_1" id="address_1"
                                                   value="{{$client["address_1"]}}"/>                                          </div>
                                        </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="form-label"for="address_2">Area/State/Zipcode </label>
                                                <div class="input-group">
                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                                <input type="text" class="form-control" name="address_2" id="address_2"
                                                   value="{{$client["address_2"]}}"/>                                            </div>
                                        </div>
                                    </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="form-label"for="trunk">Trunk </label>
                                                <div class="input-group">
                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                                <input type="text" class="form-control" name="trunk" id="trunk"
                                                   value="{{$client["trunk"]}}" maxlength=30/>                                            </div>
                                        </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <?php $oldServer = empty(old("asterisk_servers"))?[]:old("asterisk_servers") ?>
                                                <label class="form-label" for="asterisk_servers">Server Allotted </label>
                                                <select class="form-select select2" multiple name="asterisk_servers[]"
                                                    id="asterisk_servers" data-placeholder="Asterisk Servers"
                                                    style="width: 100%;">
                                                @if(!empty($client["asteriskServerList"]))
                                                    @foreach($client["asteriskServerList"] as $server)
                                                        <option
                                                            value={{$server["id"]}} @if(isset($client["clientServers"][$server["id"]])) {{'selected="selected"'}} @endif >{{$server["host"]}}
                                                            - {{$server["location"]}} - {{$server["trunk"]}}</option>
                                                    @endforeach
                                                @endif
                                            </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                    <div class="col-md-6">
                                    <div class="form-group">
                                                <label class="form-label">Enable 2FA </label>
                                                <div class="input-daterange input-group col-md-12">
                                                 <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                                    <select class="form-select" name="enable_2fa" id="enable_2fa" >
                                                    <option @if($client["enable_2fa"] == '0') selected @endif value="0">No</option>
                                                        <option @if($client["enable_2fa"] == '1') selected @endif value="1">Yes</option>
                                                    </select>
                                                </div>
                                            </div>
                                     </div>
                                    <div class="col-md-6">
                                        <div class="form-group mt-25">

                                                <input name="sms"id="sms" @if($client['sms'] == 1) checked @endif value="1"  type="checkbox"><label for="sms">SMS Plugin</label>

                                                    <input name="fax"id="fax" @if($client['fax'] == 1) checked @endif value="1" type="checkbox"><label for="fax">Fax Plugin</label>
                                                <input name="chat"id="chat" @if($client['chat'] == 1) checked @endif value="1"  type="checkbox"><label for="chat">Chat Plugin</label>

                                                <input name="webphone"id="webphone" @if($client['webphone'] == 1) checked @endif value="1"  type="checkbox"><label for="webphone">Webphone Plugin</label>
                                        </div>
                                    </div>
                                    </div>
                                    <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-label">API Token</label>
                                            <div class="input-group position-relative">
                                                <span class="input-group-text @error('api_key') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                                <input type="text" class="form-control" style="padding-right: 3.5rem; border-top-right-radius: 1; border-bottom-right-radius: 1;" value="{{$client['api_key']}}" name="api_key" id="api_key">
                                                <button class="btn btn-primary btn-sm position-absolute" type="button" id="generate-api-key" style="right: 0.1rem; top: 50%; transform: translateY(-50%); z-index: 10; border-top-right-radius: 0; border-bottom-right-radius: 0" title="Generate new API key">
                                                    <i class="ti-plus" id="gen-icon"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                    <div class="form-group">
                                                <label class="form-label">Enable MCA CRM</label>
                                                <div class="input-daterange input-group col-md-12">
                                                 <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                                    <select class="form-select" name="mca_crm" id="enable_mca_crm" >
                                                    <option @if($client["mca_crm"] == '0') selected @endif value="0">No</option>
                                                        <option @if($client["mca_crm"] == '1') selected @endif value="1">Yes</option>
                                                    </select>
                                                </div>
                                            </div>
                                     </div>
                                    <div class="col-md-6">
                                           <div class="form-group">
                                                <label class="form-label">Enable Ringless</label>
                                                <div class="input-daterange input-group col-md-12">
                                                 <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                                    <select class="form-select" name="ringless" id="ringless" >
                                                    <option @if($client["ringless"] == '0') selected @endif value="0">No</option>
                                                        <option @if($client["ringless"] == '1') selected @endif value="1">Yes</option>
                                                    </select>
                                                </div>
                                            </div>
                                    </div>
                                    <div class="col-md-6">
                                           <div class="form-group">
                                                <label class="form-label"> Call Metrices</label>
                                                <div class="input-daterange input-group col-md-12">
                                                 <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                                    <select class="form-select" name="callchex" id="callchex" >
                                                    <option @if($client["callchex"] == '0') selected @endif value="0">No</option>
                                                        <option @if($client["callchex"] == '1') selected @endif value="1">Yes</option>
                                                    </select>
                                                </div>
                                            </div>
                                    </div>
                                    <div class="col-md-3">
                                           <div class="form-group">
                                                <label class="form-label">Enable Predictive Dial</label>
                                                <div class="input-daterange input-group col-md-12">
                                                 <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                                    <select class="form-select" name="predictive_dial" id="predictive_dial" >
                                                    <option @if($client["predictive_dial"] == '0') selected @endif value="0">No</option>
                                                        <option @if($client["predictive_dial"] == '1') selected @endif value="1">Yes</option>
                                                    </select>
                                                </div>
                                            </div>
                                    </div>

                                    @if($client["reserved"] == '1')
                                         <div class="col-md-3">
                                           <div class="form-group">
                                                <label class="form-label">Reserved</label>
                                                <div class="input-daterange input-group col-md-12">
                                                 <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                                    <select class="form-select" name="reserved" id="reserved" >
                                                    <option @if($client["reserved"] == '0') selected @endif value="0">No</option>
                                                        <option @if($client["reserved"] == '1') selected @endif value="1">Yes</option>
                                                    </select>
                                                </div>
                                            </div>
                                    </div>
                                    @endif
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="form-label">Sendgrid Key</label>
                                                <div class="input-group col-md-12">
                                                 <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                                 <input type="text" class="form-control" value="{{$client['sendgrid_key'] ?? '' }}" name="sendgrid_key" id="sendgrid_key">
                                                </div>
                                            </div>
                                        </div>
                                </div><!-- /.box-body -->
                                <div id="call_matrix" style="display:none;">
                                    <h3 class="box-title" style="font-weight: bold;">Call Matrix</h3>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="form-label">Call Matrix API Key</label>
                                                <div class="input-group col-md-12">
                                                 <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                                 <input type="text" class="form-control" value="{{$client['call_matrix_api_key'] ?? '' }}" name="call_matrix_api_key" id="call_matrix_api_key">
                                                </div>
                                            </div>
                                        </div>
                                        <!-- <div class="col-md-6">
                                            <div class="form-group">
                                                    <label class="form-label">Call Matrix API URL</label>
                                                    <div class="input-group col-md-12">
                                                    <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                                    <input type="url" class="form-control" value="{{$client['call_matrix_api_url'] ?? '' }}" name="call_matrix_api_url" id="call_matrix_api_url">
                                                    </div>
                                                </div>
                                            </div>
                                        </div> -->
                                         <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="form-label">Status</label>
                                                <div class="input-group col-md-12">
                                                 <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                                <select class="form-select" name="callchex_status" id="callchex_status" >
                                                    <option @if($client["call_matrix_status"] == '0') selected @endif value="0">Inactive</option>
                                                        <option @if($client["call_matrix_status"] == '1') selected @endif value="1">Active</option>
                                                </select>                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                                <div class="box-footer text-end">
                                    <button type="submit" name="submit" value="Save" class="btn btn btn-primary waves-effect waves-light">Save</button>
                                </div>
                            </form>

                    </div><!-- /.box -->
                </div><!-- /.col -->
            </div><!-- /.row -->
        <div class="row"><!-- /.row -->
            <div class="col-md-12">
                <div class="box box-default ">
                    <div class="box-header with-border">
                    <h3 class="box-title" style="font-weight: bold;">SMS Provider</h3>
                            <div class="box-tools pull-right">

                            </div>
                    </div>

                    <div class="box-body">
                                    <div class="row">
                                                <div class="col-md-12">

                                                                <div class="nav-tabs-custom">

                                                                                        <ul class="nav nav-tabs tabs-vertical" role="tablist">
                                                                                            <li class="nav-item"> <a class="nav-link active" data-bs-toggle="tab" href="#time" role="tab"><span class="hidden-sm-up"><i class="ion-home"></i></span> <span class="hidden-xs-down">DIDForSale</span> </a> </li>
                                                                                            <li class="nav-item"> <a class="nav-link" data-bs-toggle="tab" href="#settings" role="tab"><span class="hidden-sm-up"><i class="ion-person"></i></span> <span class="hidden-xs-down">PLIVO</span></a> </li>
                                                                                            <li class="nav-item"> <a class="nav-link" data-bs-toggle="tab" href="#tal" role="tab"><span class="hidden-sm-up"><i class="ion-person"></i></span> <span class="hidden-xs-down">TELNYX</span></a> </li>

                                                                                            <li class="nav-item"> <a class="nav-link" data-bs-toggle="tab" href="#twilio" role="tab"><span class="hidden-sm-up"><i class="ion-person"></i></span> <span class="hidden-xs-down">Twilio</span></a> </li>

                                                                                        </ul>
                                                                <div class="tab-content">
                                                                    <div class="tab-pane active" id="time">
                                                                        @if(!empty($sms_provider))
                                                                            @foreach($sms_provider as $provider)
                                                                            @if($provider->provider == 'didforsale')
                                                                            @php
                                                                            $didforsale_auth_id = $provider->auth_id;
                                                                            $didforsale_api_key = $provider->api_key;
                                                                            $didforsale_domain_name = $provider->domain_api_url;
                                                                            $didforsale_access_token = $provider->access_token;
                                                                            $didforsale_ai_url = $provider->sms_ai_url;


                                                                            $didforsale_label_name = $provider->label_name;
                                                                            $didforsale_host = $provider->host;
                                                                            $didforsale_sip_username = $provider->sip_username;
                                                                            $didforsale_sip_password = $provider->sip_password;

                                                                            @endphp
                                                                            @endif


                                                                            @if($provider->provider == 'plivo')
                                                                            @php
                                                                            $plivo_auth_id = $provider->auth_id;
                                                                            $plivo_api_key = $provider->api_key;
                                                                            $plivo_domain_name = $provider->domain_api_url;
                                                                            $plivo_access_token = $provider->access_token;
                                                                            $plivo_ai_url = $provider->sms_ai_url;


                                                                            $plivo_label_name = $provider->label_name;
                                                                            $plivo_host = $provider->host;
                                                                            $plivo_sip_username = $provider->sip_username;
                                                                            $plivo_sip_password = $provider->sip_password;


                                                                            @endphp
                                                                            @endif
                                                                            @if($provider->provider == 'telnyx')
                                                                            @php
                                                                            $telnyx_auth_id = $provider->auth_id;
                                                                            $telnyx_api_key = $provider->api_key;
                                                                            $telnyx_domain_name = $provider->domain_api_url;
                                                                            $telnyx_access_token = $provider->access_token;
                                                                            $telnyx_ai_url = $provider->sms_ai_url;

                                                                            $telnyx_label_name = $provider->label_name;
                                                                            $telnyx_host = $provider->host;
                                                                            $telnyx_sip_username = $provider->sip_username;
                                                                            $telnyx_sip_password = $provider->sip_password;
                                                                            @endphp
                                                                            @endif

                                                                            @if($provider->provider == 'twilio')
                                                                            @php
                                                                            $twilio_auth_id = $provider->auth_id;
                                                                            $twilio_api_key = $provider->api_key;
                                                                            $twilio_domain_name = $provider->domain_api_url;
                                                                            $twilio_access_token = $provider->access_token;
                                                                            $twilio_ai_url = $provider->sms_ai_url;

                                                                            $twilio_label_name = $provider->label_name;
                                                                            $twilio_host = $provider->host;
                                                                            $twilio_sip_username = $provider->sip_username;
                                                                            $twilio_sip_password = $provider->sip_password;

                                                                            @endphp
                                                                            @endif
                                                                            @endforeach
                                                                        @endif
                                                                            <form class="form-horizontal form-label-left" method="post" role="form" name="" id="">
                                                                                @csrf
                                                                            <input type="hidden" value="didforsale" name="provider">

                                                                            <div class="form-group row">
                                                                                <div class="col-sm-6">
                                                                                    <label for="inputPassword3" class="form-label">Auth ID</label>
                                                                                    <input type="text" required="" class="form-control" value="@if(!empty($didforsale_auth_id)){{$didforsale_auth_id}}@endif"  name="auth_id" id="inputEmail" autocomplete="off" placeholder="Enter Auth Id">
                                                                                </div>


                                                                                <div class="col-sm-6">
                                                                                    <label for="inputPassword3" class="form-label">Auth Token</label>
                                                                                    <input type="text" required="" class="form-control" value="@if(!empty($didforsale_api_key)){{$didforsale_api_key}}@endif" name="api_key" id="inputEmail" autocomplete="off" placeholder="Enter Key">
                                                                                </div>

                                                                            </div>

                                                                             <div class="form-group row">

                                                                                <div class="col-sm-3">
                                                                                    <label for="inputPassword3" class="form-label">Label</label>
                                                                                    <input type="text"  class="form-control" value="@if(!empty($didforsale_label_name)){{$didforsale_label_name}}@endif" name="label_name" id="inputEmail" autocomplete="off" placeholder="Enter Label Name">
                                                                                </div>

                                                                                <div class="col-sm-3">
                                                                                    <label for="inputPassword3" class="form-label">Host</label>
                                                                                    <input type="text"  class="form-control" value="@if(!empty($didforsale_host)){{$didforsale_host}}@endif" name="host" id="inputEmail" autocomplete="off" placeholder="Enter Host">
                                                                                </div>

                                                                                <div class="col-sm-3">
                                                                                    <label for="inputPassword3" class="form-label">SIP Username</label>
                                                                                    <input type="text"  class="form-control" value="@if(!empty($didforsale_sip_username)){{$didforsale_sip_username}}@endif" name="sip_username" id="inputEmail" autocomplete="off" placeholder="Enter SIP username">
                                                                                </div>

                                                                                <div class="col-sm-3">
                                                                                    <label for="inputPassword3" class="form-label">SIP Password</label>
                                                                                    <input type="text"  class="form-control" value="@if(!empty($didforsale_sip_password)){{$didforsale_sip_password}}@endif" name="sip_password" id="inputEmail" autocomplete="off" placeholder="Enter SIP Password">
                                                                                </div>
                                                                            </div>






                                                                            <div class="form-group row">
                                                                                <div class="col-sm-6">
                                                                                    <label for="inputPassword3" class="form-label">Access Token For SMS AI</label>
                                                                                    <input type="text"  class="form-control" value="@if(!empty($didforsale_access_token)){{$didforsale_access_token}}@endif" name="access_token" id="inputEmail" autocomplete="off" placeholder="Enter Access Token">
                                                                                </div>

                                                                                <div class="col-sm-6">
                                                                                    <label for="inputPassword3" class="form-label">SMS Url For SMS AI</label>
                                                                                    <input type="text"  class="form-control" value="@if(!empty($didforsale_ai_url)){{$didforsale_ai_url}}@endif" name="sms_ai_url" id="inputEmail" autocomplete="off" placeholder="Enter Sms Url">
                                                                                </div>

                                                                            </div>

                                                                            <div class="card-footer text-end">
                                                                                <button type="submit" class="btn btn-primary">Submit</button>
                                                                            </div>
                                                                        </form>
                                                                        <!-- The timeline -->

                                                                    </div><!-- /.tab-pane -->

                                                                    <div class="tab-pane" id="settings">
                                                                        <form class="form-horizontal form-label-left"  method="post">
                                                                            @csrf
                                                                            <input type="hidden" value="plivo" name="provider">
                                                                            <div class="form-group row">
                                                                                <div class="col-sm-6">
                                                                                    <label for="inputPassword3" class="form-label">Auth ID</label>

                                                                                    <input type="text" required="" class="form-control" value="@if(!empty($plivo_auth_id)){{$plivo_auth_id}}@endif" name="auth_id" id="inputEmail" autocomplete="off" placeholder="Enter Auth Id">
                                                                                </div>

                                                                                <div class="col-sm-6">
                                                                                    <label for="inputPassword3" class="form-label">Auth Token</label>

                                                                                    <input type="text" required="" class="form-control" value="@if(!empty($plivo_api_key)){{$plivo_api_key}}@endif" name="api_key" id="inputEmail" autocomplete="off" placeholder="Enter key">
                                                                                </div>
                                                                            </div>

                                                                             <div class="form-group row">

                                                                                <div class="col-sm-3">
                                                                                    <label for="inputPassword3" class="form-label">Label</label>
                                                                                    <input type="text"  class="form-control" value="@if(!empty($plivo_label_name)){{$plivo_label_name}}@endif" name="label_name" id="inputEmail" autocomplete="off" placeholder="Enter Label Name">
                                                                                </div>

                                                                                <div class="col-sm-3">
                                                                                    <label for="inputPassword3" class="form-label">Host</label>
                                                                                    <input type="text"  class="form-control" value="@if(!empty($plivo_host)){{$plivo_host}}@endif" name="host" id="inputEmail" autocomplete="off" placeholder="Enter Host">
                                                                                </div>

                                                                                <div class="col-sm-3">
                                                                                    <label for="inputPassword3" class="form-label">SIP Username</label>
                                                                                    <input type="text"  class="form-control" value="@if(!empty($plivo_sip_username)){{$plivo_sip_username}}@endif" name="sip_username" id="inputEmail" autocomplete="off" placeholder="Enter SIP username">
                                                                                </div>

                                                                                <div class="col-sm-3">
                                                                                    <label for="inputPassword3" class="form-label">SIP Password</label>
                                                                                    <input type="text"  class="form-control" value="@if(!empty($plivo_sip_password)){{$plivo_sip_password}}@endif" name="sip_password" id="inputEmail" autocomplete="off" placeholder="Enter SIP Password">
                                                                                </div>
                                                                            </div>






                                                                            <div class="form-group row">
                                                                                <div class="col-sm-6">
                                                                                    <label for="inputPassword3" class="form-label">Access Token For SMS AI</label>
                                                                                    <input type="text"  class="form-control" value="@if(!empty($plivo_access_token)){{$plivo_access_token}}@endif" name="access_token" id="inputEmail" autocomplete="off" placeholder="Enter Access Token">
                                                                                </div>

                                                                                <div class="col-sm-6">
                                                                                    <label for="inputPassword3" class="form-label">SMS Url For SMS AI</label>
                                                                                    <input type="text"  class="form-control" value="@if(!empty($plivo_ai_url)){{$plivo_ai_url}}@endif" name="sms_ai_url" id="inputEmail" autocomplete="off" placeholder="Enter Sms Url">
                                                                                </div>

                                                                            </div>

                                                                            <div class="card-footer text-end">
                                                                                <button type="submit" class="btn btn-primary waves-effect waves-light">Submit</button>
                                                                            </div>
                                                                        </form>
                                                                    </div><!-- /.tab-pane -->
                                                                    <div class="tab-pane" id="tal">

                                                                            <form class="form-horizontal form-label-left" method="post" role="form" name="" id="">
                                                                                @csrf
                                                                            <input type="hidden" value="telnyx" name="provider">


                                                                            <div class="form-group row">
                                                                                <div class="col-sm-6">
                                                                                    <label for="inputPassword3" class="form-label">Auth Token</label>
                                                                                    <input type="text" required="" class="form-control"  name="api_key"value="@if(!empty($telnyx_api_key)){{$telnyx_api_key}}@endif" id="inputEmail" autocomplete="off" placeholder="Enter Key">
                                                                                </div>

                                                                                  <div class="col-sm-6">
                                                                                    <label for="inputPassword3" class="form-label">Telnyx API Url</label>
                                                                                    <input type="text"  class="form-control" value="@if(!empty($telnyx_domain_name)){{$telnyx_domain_name}}@endif" name="domain_api_url" id="inputEmail" autocomplete="off" placeholder="Enter Domain Name">
                                                                                </div>
                                                                            </div>

                                                                                <div class="form-group row">

                                                                                <div class="col-sm-3">
                                                                                    <label for="inputPassword3" class="form-label">Label</label>
                                                                                    <input type="text"  class="form-control" value="@if(!empty($telnyx_label_name)){{$telnyx_label_name}}@endif" name="label_name" id="inputEmail" autocomplete="off" placeholder="Enter Domain Name">
                                                                                </div>

                                                                                <div class="col-sm-3">
                                                                                    <label for="inputPassword3" class="form-label">Host</label>
                                                                                    <input type="text"  class="form-control" value="@if(!empty($telnyx_host)){{$telnyx_host}}@endif" name="host" id="inputEmail" autocomplete="off" placeholder="Enter Domain Name">
                                                                                </div>

                                                                                <div class="col-sm-3">
                                                                                    <label for="inputPassword3" class="form-label">SIP Username</label>
                                                                                    <input type="text"  class="form-control" value="@if(!empty($telnyx_sip_username)){{$telnyx_sip_username}}@endif" name="sip_username" id="inputEmail" autocomplete="off" placeholder="Enter Domain Name">
                                                                                </div>

                                                                                <div class="col-sm-3">
                                                                                    <label for="inputPassword3" class="form-label">SIP Password</label>
                                                                                    <input type="text"  class="form-control" value="@if(!empty($telnyx_sip_password)){{$telnyx_sip_password}}@endif" name="sip_password" id="inputEmail" autocomplete="off" placeholder="Enter Domain Name">
                                                                                </div>
                                                                            </div>






                                                                            <div class="form-group row">
                                                                                <div class="col-sm-6">
                                                                                    <label for="inputPassword3" class="form-label">Access Token For SMS AI</label>
                                                                                    <input type="text"  class="form-control" value="@if(!empty($telnyx_access_token)){{$telnyx_access_token}}@endif" name="access_token" id="inputEmail" autocomplete="off" placeholder="Enter Access Token">
                                                                                </div>

                                                                                <div class="col-sm-6">
                                                                                    <label for="inputPassword3" class="form-label">SMS Url For SMS AI</label>
                                                                                    <input type="text"  class="form-control" value="@if(!empty($telnyx_ai_url)){{$telnyx_ai_url}}@endif" name="sms_ai_url" id="inputEmail" autocomplete="off" placeholder="Enter Sms Url">
                                                                                </div>

                                                                            </div>
                                                                            <div class="card-footer text-end">
                                                                                <button type="submit" class="btn btn-primary">Submit</button>
                                                                            </div>
                                                                        </form>
                                                                        <!-- The timeline -->

                                                                    </div><!-- /.tab-pane -->

                                                                    <div class="tab-pane" id="twilio">

                                                                            <form class="form-horizontal form-label-left" method="post" role="form" name="" id="">
                                                                                @csrf
                                                                            <input type="hidden" value="twilio" name="provider">

                                                                            <div class="form-group row">
                                                                                <div class="col-sm-6">
                                                                                    <label for="inputPassword3" class="form-label">Auth ID</label>
                                                                                    <input type="text" required="" class="form-control"  name="auth_id" id="inputEmail" value="@if(!empty($twilio_auth_id)){{$twilio_auth_id}}@endif"  autocomplete="off" placeholder="Enter Auth Id">
                                                                                </div>

                                                                                  <div class="col-sm-6">
                                                                                    <label for="inputPassword3" class="form-label">Auth Token</label>
                                                                                    <input type="text" required="" class="form-control"  name="api_key"value="@if(!empty($twilio_api_key)){{$twilio_api_key}}@endif" id="inputEmail" autocomplete="off" placeholder="Enter Key">
                                                                                </div>

                                                                            </div>


                                                                            <div class="form-group row">

                                                                                <div class="col-sm-3">
                                                                                    <label for="inputPassword3" class="form-label">Label</label>
                                                                                    <input type="text"  class="form-control" value="@if(!empty($twilio_label_name)){{$twilio_label_name}}@endif" name="label_name" id="inputEmail" autocomplete="off" placeholder="Enter Domain Name">
                                                                                </div>

                                                                                <div class="col-sm-3">
                                                                                    <label for="inputPassword3" class="form-label">Host</label>
                                                                                    <input type="text"  class="form-control" value="@if(!empty($twilio_host)){{$twilio_host}}@endif" name="host" id="inputEmail" autocomplete="off" placeholder="Enter Domain Name">
                                                                                </div>

                                                                                <div class="col-sm-3">
                                                                                    <label for="inputPassword3" class="form-label">SIP Username</label>
                                                                                    <input type="text"  class="form-control" value="@if(!empty($twilio_sip_username)){{$twilio_sip_username}}@endif" name="sip_username" id="inputEmail" autocomplete="off" placeholder="Enter Domain Name">
                                                                                </div>

                                                                                <div class="col-sm-3">
                                                                                    <label for="inputPassword3" class="form-label">SIP Password</label>
                                                                                    <input type="text"  class="form-control" value="@if(!empty($twilio_sip_password)){{$twilio_sip_password}}@endif" name="sip_password" id="inputEmail" autocomplete="off" placeholder="Enter Domain Name">
                                                                                </div>
                                                                            </div>




                                                                            <?php /*?>
                                                                                <div class="col-sm-3">
                                                                                    <label for="inputPassword3" class="form-label">API Url</label>
                                                                                    <input type="text"  class="form-control" value="@if(!empty($twilio_domain_name)){{$twilio_domain_name}}@endif" name="domain_api_url" id="inputEmail" autocomplete="off" placeholder="Enter Domain Name">
                                                                                </div>
                                                                                <?php */ ?>


                                                                            <div class="form-group row">
                                                                                <div class="col-sm-6">
                                                                                    <label for="inputPassword3" class="form-label">Access Token For SMS AI</label>
                                                                                    <input type="text"  class="form-control" value="@if(!empty($twilio_access_token)){{$twilio_access_token}}@endif" name="access_token" id="inputEmail" autocomplete="off" placeholder="Enter Access Token">
                                                                                </div>

                                                                                <div class="col-sm-6">
                                                                                    <label for="inputPassword3" class="form-label">SMS Url For SMS AI</label>
                                                                                    <input type="text"  class="form-control" value="@if(!empty($twilio_ai_url)){{$twilio_ai_url}}@endif" name="sms_ai_url" id="inputEmail" autocomplete="off" placeholder="Enter Sms Url">
                                                                                </div>

                                                                            </div>

                                                                            <div class="card-footer text-end">
                                                                                <button type="submit" class="btn btn-primary">Submit</button>
                                                                            </div>
                                                                        </form>
                                                                        <!-- The timeline -->

                                                                    </div><!-- /.tab-pane -->
                                                                </div><!-- /.tab-content -->
                                                                </div><!-- /.nav-tabs-custom -->
                                                </div>
                                    </div>
                    </div>
                </div>                  <!--  -->
            </div>
        </div>
<div class="row">
   <div class="col-xs-12">
       <div class="box">
           <div class="box-body">
               <h3 style="margin-bottom: 20px;">Manual Subscription Assignment</h3>
               <form method="post" role="form" name="manualSubscriptionForm" id="manualSubscriptionForm"
                     action="{{url('client/manual-subscription')}}">
                   @csrf
                   @if($client["stage"] >= 5)
                       <div class="row">
                           <div class="col-md-4">
                               <div class="form-group">
                                   <label for="package">Subscription</label>
                                   <div class="input-daterange input-group col-sm-12 col-xs-12">
                                       <select id="package" name="package"
                                               class="form-select" required>
                                           <option value="#">Select Subscription</option>
                                           @foreach($arrPackages as $package)
                                               <option value={{$package->key}}>{{$package->name}}</option>
                                           @endforeach
                                       </select>
                                   </div>
                               </div>
                           </div>
                           <div class="col-md-4">
                               <div class="form-group">
                                   <label>Billing</label>
                                   <div class="input-daterange input-group col-sm-12 col-xs-12">
                                       <select id="billing" name="billing" class="form-select">
                                           <option value="#">Select Billing Period</option>
                                           <option value="4">Yearly</option>
                                           <option value="3">Half Yearly</option>
                                           <option value="2">Quarterly</option>
                                           <option value="1">Monthly</option>
                                       </select>
                                   </div>
                               </div>
                           </div>
                           <div class="col-md-4">
                               <div class="form-group">
                                   <label>Quantity</label>
                                   <div class="input-daterange input-group col-sm-12 col-xs-12">
                                   <div class="number-of-users">
                                                        <span class="minus" data-page="cart"><span
                                                                class="glyphicon glyphicon-minus"></span></span>
                                                        <input type="text" class="quantity-field" name="quantity" value="0"/>
                                                        <span class="plus" data-page="cart"><span
                                                                class="glyphicon glyphicon-plus"></span></span>
                                                    </div>
                                   </div>
                               </div>
                           </div>
                       </div>
                       <hr>
                       <div class="box-footer text-end">
                                   <input type="hidden" class="form-control" name="parent"
                                          value="{{$client["id"]}}" required>
                                   <input type="submit" id="submitbtn" class="btn btn-primary"
                                          value="Submit">

                   @else
                       <div><h5>This section is available once client portal is ready</h5>
                       </div>
                   @endif
               </form>
           </div>
       </div>
   </div>
   <div class="col-xs-12" style="margin-bottom:40px;">
       <div class="box">
           <div class="box-body">
               <h3 style="margin-bottom: 20px;">Credit Wallet</h3>
               <form method="post" role="form" name="manualCreditWallet" id="manualCreditWallet"
                     action="{{url('client/credit-wallet')}}">
                   @csrf
                   @if($client["stage"] >= 5)
                       <div class="row">
                           <div class="col-md-4">
                               <div class="form-group">
                                   <label for="amount">Amount</label>
                                   <input type="text"  class="form-control" name="amount" id="amount" required="" placeholder="Enter Amount">
                               </div>
                           </div>
                       </div>
                       <hr>
                       <div class="box-footer text-end">

                                   <input type="hidden" class="form-control" name="parent"
                                          value="{{$client["id"]}}" required>
                                   <input type="submit" id="submitbtn" class="btn btn-primary"
                                          value="Submit">
                               </div>

                       </div>
                   @else
                       <div><h5>This section is available once client portal is ready</h5>
                       </div>
                   @endif
               </form>
           </div>
       </div>
   </div>
</div>
            </div>
          </div>
        </div>
      </div>
      <!-- /.row -->

      <!-- Button trigger modal -->




        </div>
    </section>


    <style>
        /* Chrome, Safari, Edge, Opera */
        input::-webkit-outer-spin-button,
        input::-webkit-inner-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }

        /* Firefox */
        input[type=number] {
            -moz-appearance: textfield;
        }

        .number-of-users input {
            width: 100px;
            text-align: center;
            font-size: 20px;
            border: 1px solid #ddd;
            border-radius: 4px;
            display: inline-block;
            vertical-align: middle;
        }

        .number-of-users .minus, .number-of-users .plus {
            width: 32px;
            background: #f2f2f2;
            border-radius: 4px;
            padding: 5px;
            border: 1px solid #ddd;
            display: inline-block;
            vertical-align: middle;
            text-align: center;
            cursor: pointer;
        }

        .number-of-users .title {
            text-align: left;
            font-weight: 700;
            padding: 5px 0px;
        }
    </style>
            <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>

    <script>
        $(document).ready(function () {
            $('.number-of-users .minus').click(function () {
                var input = $(this).parent().find('input');
                var count = parseInt(input.val()) - 1;

                count = count < 1 ? 1 : count;
                input.val(count);
                input.change();
            });

            $('.number-of-users .plus').click(function () {
                var input = $(this).parent().find('input');
                var page = $(this).data("page");
                input.val(parseInt(input.val()) + 1);
                input.change();
            });

            $('#package').change(function () {
                if ($(this).val() == "588703ba-e78a-430f-8872-bb088dc1abba") {
                    $("#billing").prop('disabled', true);
                } else {
                    $("#billing").prop('disabled', false);
                }
            });

            $('#submitbtn').click(function () {
                let validateSubscription = true;
                var subscriptionSelected = $("#package").val();
                var billingSelected = $("#billing").val();
                var quantitySelected = $(".number-of-users .quantity-field").val();

                if (subscriptionSelected == "#") {
                    toastr.error("Please select Subscription");
                    validateSubscription = false;
                }
                if (billingSelected == "#" && subscriptionSelected != "588703ba-e78a-430f-8872-bb088dc1abba") {
                    toastr.error("Please select Billing period");
                    validateSubscription = false;
                }
                if (quantitySelected == 0 && subscriptionSelected != "588703ba-e78a-430f-8872-bb088dc1abba") {
                    toastr.error("Please select Quantity");
                    validateSubscription = false;
                }

                if (validateSubscription == true) {
                    return true;
                } else {
                    return false;
                }
            });
        });
    </script>

<script>
    function toggleCallMatrix() {
        const callchex = document.getElementById('callchex').value;
        const callMatrixDiv = document.getElementById('call_matrix');

        if (callchex === '1') {
            callMatrixDiv.style.display = 'block';
        } else {
            callMatrixDiv.style.display = 'none';
        }
    }

    // Run on page load
    document.addEventListener('DOMContentLoaded', function () {
        toggleCallMatrix();
        document.getElementById('callchex').addEventListener('change', toggleCallMatrix);
    });

    document.addEventListener('DOMContentLoaded', function() {
        const apiKeyInput = document.getElementById('api_key');
        const generateBtn = document.getElementById('generate-api-key');
        const genIcon = document.getElementById('gen-icon');

        function updateButtonIcon() {
            if (apiKeyInput.value.trim() === '') {
                genIcon.className = 'ti-plus'; // Generate icon (plus)
                generateBtn.title = 'Generate new API key';
            } else {
                genIcon.className = 'ti-reload'; // Refresh icon
                generateBtn.title = 'Regenerate API key';
            }
        }

        function generateUUID() {
            return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
                const r = Math.random() * 16 | 0;
                const v = c === 'x' ? r : (r & 0x3 | 0x8);
                return v.toString(16);
            });
        }

        generateBtn.addEventListener('click', function() {
            const newKey = generateUUID();
            apiKeyInput.value = newKey;
            updateButtonIcon(); // Switch to refresh icon after generation
        });

        // Initial check
        updateButtonIcon();

        // Listen for input changes to update icon dynamically
        apiKeyInput.addEventListener('input', updateButtonIcon);
    });
</script>
@endsection
