@extends('layouts.app')
@section('title', 'Clients')

@section('content')
<style>

    div.dataTables_wrapper div.dataTables_paginate ul.pagination {
    /* margin: 0 0; */
    white-space: nowrap;
    justify-content: flex-end;
}  
    </style>
<!-- Main content -->
        <section class="content">

      <div class="row">
        
        <div class="col-12">
          <div class="box">
             <div class="box-body">   
              <h4 class="box-title text-info mb-0"><i class="fa fa-list fa-sx"></i> Clients</h4> 

              <form method="post">
                    @csrf
                    <a href="{{ url('/client') }}" type="button" style="float:right;margin-top:-20px;" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-plus"></i>  Add Clients</a>
                </form>
              

<hr class="my-15">
                     
              <div class="table-responsive">
                <table id="tickets"  class="table mt-0 table-hover no-wrap" >
                  <thead>
                    <tr>
                                    <th>Id</th>
                                    <th>Name</th>
                                    <th>Location</th>
                                    <th>API Key</th>
                                    <th>Status</th>
                                    <th>Reserved</th>
                                    <th>Actions</th>

                            </tr>
                  </thead>
                  <tbody>
                  @foreach($clients as $key => $client)
                                 @if(in_array($client->company_name, $mapping))
                                    <tr>
                                        <td>{{$client->id}}</td>
                                        <td>{{$client->company_name}}</td>
                                        <td>{{$client->address_2}}</td>
                                        <td>
                                        {{ $client->api_key ? $client->api_key : 'NA' }}
                                        </td>
                                        <td>
                                            @if($client->stage < 5)
                                                <span class="badge badge-warning status-label"><i class="icon fa fa-ban"></i> Pending ({{$client->stage}}/5)</span>
                                            @else
                                                <span class="badge badge-success status-label"><i class="icon fa fa-check"></i> Ready</span>
                                            @endif
                                            
                                            @if($client->is_deleted == 1)
                                                <span class="badge badge-danger status-label"><i class="icon fa fa-close"></i> Inactive</span>
                                            @else
                                                <span class="badge badge-success status-label"><i class="icon fa fa-check"></i> Active</span>
                                            @endif
                                        </td>
                                        <td>

                                            @if($client->reserved == 1)
                                                <span class="badge badge-danger status-label"><i class="icon fa fa-close"></i> Reserved</span>
                                            @else
                                                <span class="badge badge-success status-label"><i class="icon fa fa-check"></i> Used</span>
                                            @endif
                                            
                                        </td>
                                        <td>
                                            <a style="cursor:pointer;color:blue;" href="{{url('client')}}/{{ $client->id}}" class='editEG'><i class="fa fa-edit fa-lg"></i></a>
                                            @if ($client->id != Session::get('parentId'))
                                            <a href="#" class="user-clients" data-client-id="{{$client->id}}"><span class="badge badge-success">Switch To</span></a>
                                            @endif
                                        </td>
                                    </tr>
                                    @endif
                                @endforeach                   
                  </tbody>
                </table>
              
                    </div><!-- /.box-body -->
            

              </div>
     
            </div>
          </div>
        </div>
      </div>
      <!-- /.row -->
   
      <!-- Button trigger modal -->



 
        </div>
    </section>
 
    <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>
  
<script>
    $(".no-wrap").on("click", ".user-clients", function () {

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
            if (!window.switchingClient) {
                window.switchingClient = true;
                $.ajax({
                    url: 'switch-client/' + $(this).attr("data-client-id"),
                    type: 'post',
                    success: function (response) {
                        window.location = '/dashboard';
                    }
                });
            }
        });
</script>
@endsection
