<style>
.bm-modal-overlay{position:fixed;top:0;left:0;width:100%;height:100%;background:rgba(0,0,0,0.65);backdrop-filter:blur(8px);display:flex;justify-content:center;align-items:center;z-index:1000;opacity:1;transition:opacity .3s ease}.bm-modal-overlay.bm-hidden{opacity:0;pointer-events:none}.bm-modal{background:rgba(255,255,255,0.97);border-radius:16px;box-shadow:0 6px 24px rgba(0,0,0,0.3);width:90%;max-width:500px;padding:30px;position:relative;text-align:center;transform:scale(1);transition:transform .3s ease,opacity .3s ease}.bm-modal.bm-hidden{transform:scale(0.95);opacity:0}.bm-modal-close{position:absolute;top:15px;right:15px;background:none;border:none;font-size:28px;cursor:pointer;color:#444}.bm-modal-close:hover{color:#000}.bm-modal-title{font-size:28px;font-weight:700;margin-bottom:20px;color:#222}.bm-modal-body{font-size:18px;color:#555;margin-bottom:30px;line-height:1.5}.bm-modal-footer{display:flex;justify-content:center;gap:20px;flex-wrap:wrap}.bm-btn{padding:12px 30px;border-radius:10px;text-decoration:none;font-weight:600;font-size:18px;transition:background-color .3s;width:100%;max-width:200px}.bm-btn-primary{background:#007bff;color:#fff}.bm-btn-primary:hover{background:#0056b3}.bm-btn-danger{background:#dc3545;color:#fff}.bm-btn-danger:hover{background:#b02a37}@media (max-width:640px){.bm-modal{padding:20px;width:95%}.bm-modal-title{font-size:24px}.bm-modal-body{font-size:16px}.bm-btn{padding:10px 20px;font-size:16px;max-width:100%}.bm-modal-footer{gap:15px}}
</style>

<div class="bm-modal-overlay d-none" id="bmBalanceModal" @if(session('showBalanceModal', false)) style="display: flex;" @endif>
    <div class="bm-modal" id="bmModalContent">
        <button class="bm-modal-close" onclick="closeBalanceModal()">&times;</button>
        <h5 class="bm-modal-title">{{ session('modalTitle', 'Low Balance') }}</h5>
        <div class="bm-modal-body">{{ session('modalMessage','Your balance is insufficient. Please add funds to continue.') }}</div>
        <div class="bm-modal-footer">
            <a href="{{ url('recharge') }}" class="bm-btn bm-btn-primary">Add Funds</a>
            <a href="{{ url('packages') }}" class="bm-btn bm-btn-danger">Upgrade Plan</a>
        </div>
    </div>
</div>

<script>
function closeBalanceModal() {
    const modalOverlay = document.getElementById('bmBalanceModal');
    const modalContent = document.getElementById('bmModalContent');
    modalOverlay.classList.add('bm-hidden');
    modalContent.classList.add('bm-hidden');
    setTimeout(() => {
        modalOverlay.classList.add('d-none');
        modalOverlay.style.display = 'none';
        modalOverlay.classList.remove('bm-hidden');
        modalContent.classList.remove('bm-hidden');
        modalOverlay.innerHTML = '';
        document.body.style.overflow = 'auto';
        document.body.style.paddingRight = '0';
    }, 300);
}

document.addEventListener('DOMContentLoaded', function () {
    @if(session('showBalanceModal', false))
        setTimeout(() => {
            const modal = document.getElementById('bmBalanceModal');
            modal.classList.remove('d-none');
            modal.style.display = 'flex';
            document.body.style.overflow = 'hidden';
            document.body.style.paddingRight = '0';
        }, 2000);
    @endif
});
</script>
