@extends('layouts.app')
@section('title', 'Conferencing List')

@section('content')

<style>
  .badge
{font-size: 1rem;
    font-style: normal;
    font-weight: 400;
    font-family: "IBM Plex Sans", sans-serif;
    line-height: 1.5;}
    .table > tbody > tr > td, .table > tbody > tr > th {
     padding: 0.3rem; 
    vertical-align: middle;
}
</style>
<!-- Main content -->
        <section class="content">

      <div class="row">

       
        
        <div class="col-12">
          <div class="box">
             <div class="box-body">           
                       
              <h4 class="box-title text-info mb-0"><i class="fa fa-user fa-sx"></i> Conferencing List</h4>             
           <a id="openIpSettingForm" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"style="float:right;"><i class="fa fa-plus"></i> Add Conferencing List</a>
           <hr class="my-15">
              <div class="table-responsive">
                <table id="tickets" class="table mt-0 table-hover no-wrap" data-page-size="10">
                  <thead>
                    <tr>
                                    <th>#</th>
                                    <th>Title</th>
                                    <th>Conference Id</th>
                                    <th>Host Pin</th>
                                    <th>Participant Pin</th>
                                    <th>Max Participant</th>
                                    <th>Lock</th>
                                    <th>Mute</th>
                                    <th>Prompt File</th>
                                    <th>Action</th>

                            </tr>
                  </thead>
                  @if(!empty($conferencing_list))
                            <tbody>

                                @foreach($conferencing_list as $key => $conference)
                                <tr>
                                    <td>{{++$key}}</td>
                                    <td>{{$conference->title}}</td>
                                    <td>{{$conference->conference_id}}</td>
                                    <td>{{$conference->host_pin}}</td>
                                    <td>{{$conference->part_pin}}</td>
                                    <td>{{$conference->max_part}}</td>
                                    <td>
                                        @if ($conference->locked == '1')
                                            <span class="badge badge-success">YES</span>

                                        @else
                                            <span class="badge  badge-danger">NO</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if ($conference->mute == '1')
                                            <span class="badge badge-success">YES</span>

                                        @else
                                            <span class="badge  badge-danger">NO</span>
                                        @endif
                                    </td>
                                    <td><audio controls preload ='none'><source src="{{env('FILE_UPLOAD_URL')}}{{env('CONFERENCE_FILE_UPLOAD_FOLDER_NAME')}}/{{$conference->prompt_file}}.wav" type='audio/wav'></audio></td>
                                    <td>
                                        <a style="cursor:pointer;color:blue;margin-right:5px;" class='editConference' data-auto_id={{$conference->id}}  ><i class="fa fa-edit fa-lg"></i></a>
                                        <a style="cursor:pointer;" class='openConferenceDelete' data-id={{$conference->id}}><i class="fa fa-trash-o fa-lg"></i></a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                            @endif
                </table>
              </div>
            </div>
          </div>
        </div>
        <div class="modal fade" id="myModal" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="add-edit"></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form method="post" action="" enctype="multipart/form-data" id="conferencing">
       @csrf
      <div class="modal-body">
      <input type="hidden" class="form-control" name="auto_id" value="" id="id">
                        <div class="form-group">									
                            <label for="inputEmail3" class="form-label closed number">Title</label>
                            <div class="input-group mb-3">
                            <span class="input-group-text"><i class="ti-user"></i></span>

                            <input type="text" class="form-control closed" required name="title" id="title" placeholder="Enter title">
                            </div>
                        </div>
                        <div class="form-group">	
                            <label for="inputEmail3" class="form-label ">Conference Id </label>
                            <div class="input-group mb-3">
                               <span class="input-group-text"><i class="ti-user"></i></span>
                               <input type="text" readonly="" onkeypress="//return isNumberKey($(this));" class="form-control" required name="conference_id" id="conference_id" placeholder="">

                                <div class="input-group-btn">
                                        <button type="button" class="btn btn-primary" onclick="document.getElementById('conference_id').value = getConferenceId(1000,9999)">Generate</button>
                                </div>
                            </div>
                        </div>
                            <div class="form-group">                                
                                <label for="inputPassword3" id="" class="form-label">Host Pin  </label>
                                <div class="input-group mb-3">
                                    <span class="input-group-text"><i class="ti-user"></i></span>
                                    <input type="text" readonly="" onkeypress="//return isNumberKey($(this));" class="form-control" required name="host_pin" id="host_pin" placeholder="">
                                    <div class="input-group-btn">
                                        <button type="button" class="btn btn-primary" onclick="document.getElementById('host_pin').value = getHostId(1000,9999)">Generate</button>
                                    </div>
                                </div>
                            </div>
                                <div class="form-group">                                
                                    <label for="inputPassword3" id="" class="form-label">Participant Pin </label>
                                    <div class="input-group mb-3">
                                        <span class="input-group-text"><i class="ti-user"></i></span>
                                        <input type="text" readonly="" onkeypress="//return isNumberKey($(this));" class="form-control" required name="part_pin" id="part_pin" placeholder="">
                                    
                                    <div class="input-group-btn">
                                        <button type="button" class="btn btn-primary" onclick="document.getElementById('part_pin').value = getPartId(1000,9999)">Generate</button>
                                    </div>
                                </div>
                                </div> 
                                <div class="form-group">                                
                                    <label for="inputPassword3" id="" class="form-label">Maximum Participant</label>
                                    <div class="input-group mb-3">
                                    <span class="input-group-text"><i class="ti-user"></i></span>
                                    <input type="text" onkeypress="//return isNumberKey($(this));" class="form-control" required name="max_part" id="max_part" placeholder="Enter Part Pin">    
                                    </div> 
                                </div> 
                                <div class="form-group">                                
                                    <label for="inputPassword3" id="" class="form-label">Lock</label>
                                    <div class="input-group mb-3">
                                        <span class="input-group-text"><i class="ti-user"></i></span>
                                        <select class="form-select" name="locked" id="locked">
                                            <option value="1">Yes</option>
                                            <option value="0">No</option>
                                        </select>    
                                    </div> 
                                </div>
                                <div class="form-group">                                
                                    <label for="inputPassword3" id="" class="form-label">Mute</label>
                                    <div class="input-group mb-3">
                                        <span class="input-group-text"><i class="ti-user"></i></span>
                                        <select class="form-select" name="mute" id="mute">
                                            <option value="1">Yes</option>
                                            <option value="0">No</option>
                                        </select>   
                                    </div>
                                </div>  
                                <div class="form-group">                                
                                    <label for="inputPassword3" id="" class="form-label">Choose Prompt </label>
                                    <div class="input-group mb-3">
                                
                                        <input type="radio" checked="checked" id="prompt_upload_file_input" class="prompt_input" name="ivr_audio_option" value="upload" onclick="selectIPromptFileOption('prompt_upload_file');" />
                                        <label for="prompt_upload_file_input" class="form-label"> Upload File
                                        </label>                                     
                                        <input type="radio" id="prompt_text_to_speech_input" class="prompt_input" name="ivr_audio_option" value="text_to_speech" onclick="selectIPromptFileOption('prompt_text_to_speech');" />
                                        <label for="prompt_text_to_speech_input" class="form-label">  Convert Text to Audio
                                        </label>
                                    </div> 
                                </div>
                           
                            <div id="prompt_upload_file">
                                <input type="file"  class="form-control" name="prompt_file" id="prompt" placeholder="Enter Part Pin">
                            </div>

                            <div class="form-group-row" id="prompt_text_to_speech" style="display: none;">
                                <div class="row">
                                    <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="" class="form-label">Language</label>
                                        <div class="input-group mb-3">
                                            <span class="input-group-text"><i class="ti-user"></i></span>
                                            <select id="language_ddl" name="language" class="form-select" onchange="selectVoiceNameOnLanugageChange();">
                                                <option value="">--Select Language--</option>
                                                @foreach($arrLang as $key => $val)
                                                    <option {{isset($ivr_data->language) && $ivr_data->language == base64_decode($key) ? "selected='selected'" : ""}} value="{{$key}}">{{base64_decode($key)}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    </div>
                                    <div class="col-sm-6">
                                    <div class="form-group">
                                            <label for="inputPassword3" id="" class="form-label">Voice Name </label>
                                            <div class="input-group mb-3">
                                                    <span class="input-group-text"><i class="ti-user"></i></span>
                                                <select id="voice_name_ddl" name="voice_name" class="form-select">
                                                    <option value="">--Select Voice Name--</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">                               
                                    <label for="inputPassword3" id="" class="form-label">Text </label>
                                        <textarea id="speech_text" class="form-control" name="speech_text"
                                                placeholder="Type what you like your customers to hear and click on Listen button to listen">{{isset($ivr_data->speech_text) ? $ivr_data->speech_text : ""}}</textarea>
                                        <audio style="margin-top:10px; display:none;" id="test_audio" controls preload ='none'>
                                            <source src="" type='audio/mp3'>
                                        </audio>
                                        <div class="col-sm-2" style="padding-top: 30px;">
                                        <a class="btn btn-primary" href="javascript:void(0);" onclick="getAudioOnText();">Listen</a>
                                        </div>
                                </div>
                            </div>
                            <div class="form-group row" id="record_audio" style="display: none;">
                                <div class="col-sm-12">
                                    <button type="button" id="record" class="btn"><i class="fa fa-microphone"></i></button>
                                    <button type="button" id="stopRecord" class="btn" disabled><i class="fa fa-stop"></i></button>
                                    <span class="recording-status">Voice recording...</span>
                                    <audio id=recordedAudio></audio>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                <button type="submit"name="submit" class="btn btn-primary">Save</button>
                            </div>
        </form>
    </div>
  </div>
</div>

      </div>
      <div class="modal fade" id="delete" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="add-edit">Confirm Delete</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
     
      <div class="modal-body">
     
               
      <p>You are about to delete <b><i class="title"></i></b> conferencing.</p>
                        <p>Do you want to proceed?</p>
                        <input type="hidden" class="form-control" name="auto_id" value="" id="auto_id">
                        <div class="modal-footer">
                        <button type="button" class="btn btn-default btn-sm" data-dismiss="modal">Cancel</button>
                        <button type="button" class="btn btn-danger btn-ok btn-sm deleteConferencing">Delete</button>
                    </div>
    </div>
  </div>
</div>
      <!-- /.row -->

    </section>
        <!-- /.content -->

        <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>

        <script>
  

        $('#conferencing').submit(function (e) {
            if($("#prompt_upload_file_input").prop("checked")){
                if( document.getElementById("videoUploadFile").files.length == 0){
                    toastr.error("Please select prompt file");
                    return false;
                }
            }

            if($("#prompt_text_to_speech_input").prop("checked")){
                if(($('#speech_text').val().trim().length <= 0)){
                    toastr.error("Please enter text");
                    return false;
                }

                if(!$("#test_audio").attr("src")) {
                    toastr.info("Please listen to the audio before submitting");
                    return false;
                }
            }
        });

    $(".openConferenceDelete").click(function() {
        var auto_id = $(this).data('id');
        $("#delete").modal('show');
        $("#auto_id").val(auto_id);
    });

    $("#openIpSettingForm").click(function() {
        $("#myModal").modal('show');
        $("#title").val('');
        $("#conference_id").val('');
        $("#host_pin").val('');
        $("#part_pin").val('');
        $("#max_part").val('');
        $("#locked").val('1');
        $("#mute").val('1');
        $("#id").val('');
        $("#speech_text").val('');
        $(".closed").show();
        $("#add-edit").html('Add Conference Id');
    });

    $(document).on("click", ".editConference", function() {
        $("#myModal").modal('show');
        $("#add-edit").html('Edit Conference Id');
        var auto_id = $(this).data('auto_id');
       //alert(auto_id);

        $.ajax({
            url: 'editConferencing/' + auto_id,
            type: 'get',
            success: function(response) {
                $("#id").val(response[0].id);
                $("#title").val(response[0].title);
                $("#conference_id").val(response[0].conference_id);
                $("#host_pin").val(response[0].host_pin);
                $("#part_pin").val(response[0].part_pin);
                $("#max_part").val(response[0].max_part);
                $("#locked").val(response[0].locked);
                $("#mute").val(response[0].mute);
                $("#speech_text").val(response[0].speech_text);
                $("#language_ddl").val(response[0].language);

                if(response[0].prompt_option == 2){
                    $("#ivr_audio_option_audio_record").prop("checked", true);
                    $("#prompt_upload_file").hide();
                    $("#prompt_text_to_speech").hide();
                    $("#record_audio").show();
                } else if(response[0].prompt_option == 1){
                    selectVoiceNameOnLanugageChange(response[0].voice_name);
                    $("#prompt_text_to_speech_input").prop("checked", true);
                    $("#prompt_upload_file").hide();
                    $("#record_audio").hide();
                    $("#prompt_text_to_speech").show();
                } else{
                    $("#prompt_upload_file_input").prop("checked", true);
                    $("#record_audio").hide();
                    $("#prompt_upload_file").show();
                    $("#prompt_text_to_speech").hide();
                }
            }
        });
    });

    $(document).on("click", ".deleteConferencing", function() {
        // if(confirm("Are you sure you want to delete this?")){
        var auto_id = $("#auto_id").val();
        var el = this;
        $.ajax({
            url: 'deleteConferencing/' + auto_id,
            type: 'get',
            success: function(response) {
                toastr.success('Conferencing has been deleted successfully');
                window.location.reload(1);
            }
        });
        //}
        /*  else
          {
              return false;
          }*/
    });


    function selectIPromptFileOption(option) {
        if (option == 'prompt_text_to_speech') {
            $("#prompt_upload_file").hide();
            $("#record_audio").hide();
            $("#prompt_text_to_speech").show();
        } else if(option == 'audio_record'){
            getAudioRecordPermission();
            $("#prompt_upload_file").hide();
            $("#prompt_text_to_speech").hide();
            $("#record_audio").show();
        }else {
            $("#record_audio").hide();
            $("#prompt_upload_file").show();
            $("#prompt_text_to_speech").hide();
        }
    }

    function selectVoiceNameOnLanugageChange(defaultSelected = null) {
        $.ajax({
            url: '/get-voice-name-on-lanugage',
            type: 'post',
            data: {'language': $('#language_ddl').val(),
                '_token': $('meta[name="csrf-token"]').attr('content') // Add the CSRF token here
},
            success: function (response) {
                var html = '';
                $.each(response, function (index, value) {
                    var optionValue = value.language_code + " ## " + value.voice_name + " ## " + value.ssml_gender;
                    html += '<option value="'+ optionValue +'" ';
                    html += (defaultSelected == optionValue) ? 'selected >' : '>';
                    html += optionValue + '</option>';
                });

                $("#voice_name_ddl").html('');
                $("#voice_name_ddl").html(html);
            }
        });
    }

    function getAudioOnText() {
        if ($('#speech_text').val() == '') {
            toastr.error("Please Type Text");
            return;
        }
        if ($('#language_ddl').val() == '') {
            toastr.error("Please Select Language");
            return;
        }
        if ($('#voice_name_ddl').val() == '' || $('#voice_name_ddl').val() == null) {
            toastr.error("Please Select Voice Name");
            return;
        }

        $("#test_audio").attr('src', "");
        $.ajax({
            url: '/get-audio-on-text',
            type: 'post',
            data: {'language': $('#language_ddl').val(),
                'voice_name_ddl': $('#voice_name_ddl').val(),
                'speech_text': $('#speech_text').val(),
                'prompt_for' : 'conferencing',
                '_token': $('meta[name="csrf-token"]').attr('content') // Add the CSRF token here
},
            success: function (response) {
                console.log(response);
                if (typeof (response.file) != 'undefined') {
                    var file = "{{env('FILE_UPLOAD_URL')}}" + "{{env('CONFERENCE_FILE_UPLOAD_FOLDER_NAME')}}" + "/" + response.file;
                    var d = new Date();
                    $("#test_audio").attr('src', file+"?"+d.getTime());
                    var x = document.getElementById("test_audio");
                    x.play();
                } else {

                }
            }
        });
    }

    function getAudioRecordPermission(){
        navigator.mediaDevices.getUserMedia({audio:true})
            .then(stream => {handlerFunction(stream)});
    }

    function handlerFunction(stream) {
        rec = new MediaRecorder(stream);
        rec.ondataavailable = e => {
            audioChunks.push(e.data);
            if (rec.state == "inactive"){
                let blob = new Blob(audioChunks,{type:'audio/wav'});
                recordedAudio.src = URL.createObjectURL(blob);
                recordedAudio.controls=true;
                recordedAudio.autoplay=true;
                sendData(blob)
            }
        }
    }

    function sendData(data) {
        var fd = new FormData();
        fd.append('data', data);

        $.ajax({
            url: '/conferencing/save-recorded-audio',
            type: 'POST',
            data: fd,
            processData: false,
            contentType: false,
            success: function (response){
                // console.log(response);
            },
            error: function (response) {
                console.log(response);
            }
        });
    }

    record.onclick = e => {
        record.disabled = true;
        $(".recording-status").show();
        stopRecord.disabled=false;
        audioChunks = [];
        rec.start();
    }
    stopRecord.onclick = e => {
        record.disabled = false;
        stop.disabled=true;
        $(".recording-status").hide();
        rec.stop();
    }
</script>

<script>
function getConferenceId(min, max) {
  return Math.floor(Math.random() * (max - min)) + min;
}

function getHostId(min, max) {
  return Math.floor(Math.random() * (max - min)) + min;
}

function getPartId(min, max) {
  return Math.floor(Math.random() * (max - min)) + min;
}
</script>

<script src="{{ asset('asset/plugins/input-mask/jquery.inputmask.js') }}"></script>
<script src="{{ asset('asset/plugins/input-mask/jquery.inputmask.date.extensions.js') }}"></script>
<script src="{{ asset('asset/plugins/input-mask/jquery.inputmask.extensions.js') }}"></script>





@endsection
