@extends('layouts.app')
@section('title', 'Conferencing List')

@section('content')

<style>
  .badge
{font-size: 1rem;
    font-style: normal;
    font-weight: 400;
    font-family: "IBM Plex Sans", sans-serif;
    line-height: 1.5;}
  </style>
<!-- Main content -->
        <section class="content">

      <div class="row">

       
        
        <div class="col-12">
          <div class="box">
           <div class="box-body">           
              <h4 class="box-title text-info mb-0"><i class="fa fa-user fa-sx"></i> Live Conferencing</h4>             
           <hr class="my-15">
              <div class="table-responsive">
                <table id="tickets" class="table mt-0 table-hover no-wrap" data-page-size="10">
                  <thead>
                    <tr>
                                    <th>#</th>
                                    <th>Caller</th>
                                    <th>DID</th>
                                    <th>Channel</th>
                                    <th>Start Time</th>
                                    <th>Mute</th>
                                    <th>Conference Id</th>

                            </tr>
                  </thead>
                  @if(!empty($live_conference))
                            <tbody>

                                @foreach($live_conference as $key => $live)
                                <tr>
                                    <td>{{++$key}}</td>
                                    <td>{{$live->caller}}</td>

                                    <td>{{$live->did}}</td>
                                    <td>{{$live->channel}}</td>
                                    <td>{{$live->start_time}}</td>
                                    <td>{{$live->mute}}</td>
                                    <td>{{$live->conference_id}}</td>

                                </tr>

                                @endforeach
                            </tbody>
                            @endif
                </table>
              </div>
            </div>
          </div>
        </div>
 
      </div>
      <!-- /.row -->

    </section>
        <!-- /.content -->

        <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>

  

        <script>
    $(document).ready(function() {
        var oTable = $('#example').dataTable({
            "aoColumnDefs": [{
                "bSortable": false,
                "aTargets": [2, 3]
            }]
        });
    });

    $(".openConferenceDelete").click(function() {
        var auto_id = $(this).data('id');
        $("#delete").modal();
        $("#auto_id").val(auto_id);

    });


   

    $("#openIpSettingForm").click(function() {

        $("#myModal").modal();
        $("#name").val('');
        $("#status").val('1');
        $("#id").val('');
        $(".closed").show();
        $("#add-edit").html('Add Conference Id');
    });

    $(document).on("click", ".editConference", function() {
        $("#myModal").modal();
        $("#add-edit").html('Edit Conference Id');
        var auto_id = $(this).data('auto_id');
       //alert(auto_id);
        

        $.ajax({
            url: 'editConferencing/' + auto_id,
            type: 'get',
            success: function(response) {

                
                $("#id").val(response[0].id);
                $("#title").val(response[0].title);
                $("#conference_id").val(response[0].conference_id);
                $("#host_pin").val(response[0].host_pin);
                $("#part_pin").val(response[0].part_pin);
                $("#max_part").val(response[0].max_part);
                $("#locked").val(response[0].locked);
                $("#mute").val(response[0].mute);
                $("#prompt").val(response[0].prompt_file);





                
            }
        });
    });

    $(document).on("click", ".deleteConferencing", function() {
        // if(confirm("Are you sure you want to delete this?")){

        var auto_id = $("#auto_id").val();
       

        var el = this;
        $.ajax({
            url: 'deleteConferencing/' + auto_id,
            type: 'get',
            success: function(response) {
                window.location.reload(1);
            }
        });

        //}
        /*  else
          {
              return false;
          }*/
    });
</script>

<script>
function getConferenceId(min, max) {
  return Math.floor(Math.random() * (max - min)) + min;
}

function getHostId(min, max) {
  return Math.floor(Math.random() * (max - min)) + min;
}

function getPartId(min, max) {
  return Math.floor(Math.random() * (max - min)) + min;
}
</script>





@endsection
