@extends('layouts.app')
@section('title', 'Conference Overview')

@section('content')

<style>
  .badge
{font-size: 1rem;
    font-style: normal;
    font-weight: 400;
    font-family: "IBM Plex Sans", sans-serif;
    line-height: 1.5;}
  </style>
<!-- Main content -->
        <section class="content">

      <div class="row">

       
        
        <div class="col-12">
          <div class="box">
           <div class="box-body">           
                       
              <h4 class="box-title text-info mb-0"><i class="fa fa-user fa-sx"></i> Conference Overview</h4>             
            <hr class="my-15">
              <div class="table-responsive">
                <table id="tickets" class="table mt-0 table-hover no-wrap" data-page-size="10">
                  <thead>
                    <tr>
                                    <th>#</th>
                                    <th>Conference Id</th>
                                    <th>Total Participants</th>
                                    <th>Start Time</th>
                                    <th>End Time</th>
                                    <th>Recording</th>
                                    <th>Status</th>

                            </tr>
                  </thead>
                  @if(!empty($recording_conference))
                            <tbody>

                                @foreach($recording_conference as $key => $recording)
                                <tr>
                                    <td>{{++$key}}</td>

                                    <td>{{$recording->conference_id}}</td>
                                    <td>{{$recording->total_participants}}</td>
                                    <td>{{$recording->start_time}}</td>
                                    <td>{{$recording->end_time}}</td>
                                    <td><audio controls preload ='none'><source src="{{$recording->call_recording}}" type='audio/wav'></audio></td>
                                    <td>
                                        @if($recording->status == '0')
                                        OnGoing
                                        @elseif($recording->status == '1')
                                        Completed
                                        @endif

                                        </td>





                

                                </tr>

                                @endforeach
                            </tbody>
                            @endif
                </table>
              </div>
            </div>
          </div>
        </div>
 
      </div>
      <!-- /.row -->

    </section>
        <!-- /.content -->

        <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>

  
        <script>


    $(".openConferenceDelete").click(function() {
        var auto_id = $(this).data('id');
        $("#delete").modal();
        $("#auto_id").val(auto_id);

    });


   

    $("#openIpSettingForm").click(function() {

        $("#myModal").modal();
        $("#name").val('');
        $("#status").val('1');
        $("#id").val('');
        $(".closed").show();
        $("#add-edit").html('Add Conference Id');
    });

    $(document).on("click", ".editConference", function() {
        $("#myModal").modal();
        $("#add-edit").html('Edit Conference Id');
        var auto_id = $(this).data('auto_id');
       //alert(auto_id);
        

        $.ajax({
            url: 'editConferencing/' + auto_id,
            type: 'get',
            success: function(response) {

                
                $("#id").val(response[0].id);
                $("#title").val(response[0].title);
                $("#conference_id").val(response[0].conference_id);
                $("#host_pin").val(response[0].host_pin);
                $("#part_pin").val(response[0].part_pin);
                $("#max_part").val(response[0].max_part);
                $("#locked").val(response[0].locked);
                $("#mute").val(response[0].mute);
                $("#prompt").val(response[0].prompt_file);





                
            }
        });
    });

    $(document).on("click", ".deleteConferencing", function() {
        // if(confirm("Are you sure you want to delete this?")){

        var auto_id = $("#auto_id").val();
       

        var el = this;
        $.ajax({
            url: 'deleteConferencing/' + auto_id,
            type: 'get',
            success: function(response) {
                window.location.reload(1);
            }
        });

        //}
        /*  else
          {
              return false;
          }*/
    });
</script>

<script>
function getConferenceId(min, max) {
  return Math.floor(Math.random() * (max - min)) + min;
}

function getHostId(min, max) {
  return Math.floor(Math.random() * (max - min)) + min;
}

function getPartId(min, max) {
  return Math.floor(Math.random() * (max - min)) + min;
}
</script>

<script src="{{ asset('asset/plugins/input-mask/jquery.inputmask.js') }}"></script>
<script src="{{ asset('asset/plugins/input-mask/jquery.inputmask.date.extensions.js') }}"></script>
<script src="{{ asset('asset/plugins/input-mask/jquery.inputmask.extensions.js') }}"></script>





@endsection
