@extends('layouts.app')
@section('title', 'Add Api List')
@section('content')




    <!-- Main content -->
    <section class="content">
        <div class="row">
        <div class=" col-12">
        <div class="box">

            <form class="form-inline"  method="post">
                @csrf
                <div class="panel panel-primary">
                    <div class="box-body">
                        @php
                            $labelStr = "<tr><td><input type='text' class='form-select col-md-6' name='para_label[]' value='' class='param' required></td><td><select name='label[]' class='form-select' required='required'><option>Select Label</option>";

                                foreach($label_list  as $label)
                                {
                                    $labelStr .="<option value=".$label->id.">".$label->title."</option>";
                                }

                            $labelStr .="</select></td><td><button class='btn btn-danger btn-remove'><i class='fa fa-trash-o'></i></button></td></tr>";

                            $constantStr = "<tr><td><input type='text' class='form-control' name='para_constant[]' value='' class='param' required></td><td><input type='text' name='constant[]' class='form-control' value='' required='required'>";

                            $constantStr .="</td><td><button class='btn btn-danger btn-remove'><i class='fa fa-trash-o'></i></button></td></tr>";
                        @endphp
                        <h4 class="box-title text-info mb-0"><i class="fa fa-plus me-15"></i> Add API List </h4>
                                <a href="{{url('/api-data')}}" type="button" style="float:right;" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-eye fa-sx"></i> API List</a>

								<hr class="my-15">
                        <div class="row">
                            <div class="col-md-6">
                                <label class="form-label">Name </label>
                                    <div>
                                        <div class="input-group mb-3" id="date-range2">
                                           <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                            <input  type="text" class="form-control" name="title" value="{{ request()->input('title') }}" id="campaign_name" required="">
                                        </div>
                                    </div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">URL</label>
                                <div>
                                <div class="input-group mb-3" id="date-range2">
                                  <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>                                        <input type="text" class="form-control" name="url" value="" id="campaign_name" required="">
                                </div>
                                </div>
                            </div>
                            </div>
                       <div class="row">
                            <div class="col-md-6">
                                <label class="form-label">Method</label>
                                <div>
                                    <div class="input-group mb-3" id="date-range2">
                                        <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>                                        <select class="form-select" name='method'>
                                            <option value="get">GET</option>
                                            <option value="post">POST</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Campaign</label>
                                <div class="input-group mb-3" id="date-range2">
            
                                    <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                        <select class="js-example-basic-single select2"  name="campaign_id" autocomplete="off" data-placeholder="Select Group">
                                            @if($campaign_list)
                                        @foreach($campaign_list  as $camp)
                                            @if(!empty($camp->title) & ($camp->status==1))
                                                <option  value="{{$camp->id}}">{{$camp->title}}</option>
                                            @endif
                                        @endforeach
                                        @endif
                                        </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                        

                            <div class="col-md-6">
                                <label class="form-label">Disposition</label>
                                    <select class="select2" multiple="multiple" name="disposition_id[]" autocomplete="off" data-placeholder="Select Disposition" style="width: 100%;">

                                    @foreach($disposition_list as $dispo)
                                        <option  value="{{$dispo->id}}">{{$dispo->title}}</option>
                                    @endforeach;
                                    </select>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Set API Template</label>
                                <div class="input-group mb-3" id="date-range2">
                                <span class="input-group-text @error('caller_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                <select class="form-select"  name="is_default" autocomplete="off" data-placeholder="Select Group">
                                    <option value="0">No</option>
                                    <option value="1">Yes</option>
                                </select>
                            </div>
                            
                        </div>

                        <br>

                        <div class="box-footer text-end">
                            <button class="btn btn-primary btn-md" type="submit"><i class="fa fa-check-square-o"></i> 
                                Submit
                            </button>
                            &nbsp;
                            <a type="button" class="btn btn-warning btn-md" style="margin-right: 5px;" onclick="window.location.reload();">
                            <i class="fa fa-refresh fa-lg"></i> 
                            Reset
                            </a>
                            &nbsp;
                            <a type="button" class="btn btn-danger btn-md" style="margin-right: 5px;" href="{{url('/api-data')}}"><i class="fa fa-reply fa-lg"></i> 
                            Cancel
                            </a>
                        </div>
                    </div>
                </div>

                 <div class="col-xs-12" style="overflow-x: auto;">
                    <a href="#" class=" btn btn-primary  btn-sm pull-right add-list"style="margin-right:30px;" data-bs-toggle="modal" data-bs-target="#addRow"><i class="fa fa-plus"></i>Add Parameter
                    </a>
                    <table id="api_table" class="table mt-0 table-hover no-wrap" data-page-size="10">
                        <thead>
                            <tr>
                                <td>Parameter</td>
                                <td>Data</td>
                                <td>Remove</td>
                            </tr>
                        </thead>
                        <tbody id="param_label">
                        </tbody>
                    </table>
                </div>

                <div class="modal fade" id="addRow" tabindex="-1" aria-labelledby="addRowLabel" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title">Add Row</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                        
                                <div class="modal-body">
                                    <div class="form-group row">
                                        <div class="col-sm-6">
                                                    <label class="form-label">Type</label>
                                                    <div class="input-group">
                                                        <select name="row_type" class="form-select" id="row_type" required>
                                                            <option value="label">Parameter & Label</option>
                                                            <option value="constant">Parameter & constant</option>
                                                        </select>
                                        </div>
                                        </div>
                                            <div class="col-sm-6">
                                                    <label class="form-label">Number Of Rows</label>
                                                    <div class="input-group">
                                                                <select name="row_count" class="form-select" id="row-count" required>
                                                                    <option value="1">1</option>
                                                                    <option value="2">2</option>
                                                                    <option value="3">3</option>
                                                                    <option value="4">4</option>
                                                                    <option value="5">5</option>
                                                                    <option value="6">6</option>
                                                                    <option value="7">7</option>
                                                                    <option value="8">8</option>
                                                                    <option value="9">9</option>
                                                                    <option value="10">10</option>
                                                                </select>
                                            </div>
                                            </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                                    
                                                <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                                                <button type="button" class="btn btn-primary btn-sm" onclick="addRowAndHideModal();">Continue</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </section>
</div>
<!-- /.content-wrapper -->
<script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>
<!-- ... (your HTML code) ... -->
<!-- ... (your HTML code) ... -->
<script>
    $(document).ready(function () {
        displayTable();
    });

    function addRowAndHideModal() {
        var typ = $('#row_type').val();
        var num = $('#row-count').val();
        if (typ == "label") {
            for (var i = 0; i < num; i++) {
                $("#param_label").append("<?php echo $labelStr;?>");
            }
        } else if (typ == "constant") {
            for (var i = 0; i < num; i++) {
                $("#param_label").append("<?php echo $constantStr;?>");
            }
        }
        displayTable();
        $('#addRow').modal('hide'); // Hide the modal
        return false;
    }

    function displayTable() {
        var rowCount = $('#param_label tr').length;
        if (rowCount > 0) {
            $('#api_table').removeClass('hidden');
        } else {
            $('#api_table').addClass('hidden');
        }
    }

    $('#api_table').on('click', '#param_label .btn-remove', function () {
        $(this).closest("tr").remove();
        displayTable();
    });

    $('#addRow').on('hidden.bs.modal', function () {
        // Clear modal contents when it's hidden
        $('#row_type').val('label');
        $('#row-count').val('1');
    });
</script>

<script>
    
///////////////api //////////////


 



    $(document).on("click", ".deleteApi" , function() {
    if(confirm("Are you sure you want to delete this record?")){
        var api = $(this).data('api');
        // alert(api);
        //var account_no = $(this).data('account_no');
        //alert(account_no);
        var el = this;
        $.ajax({
            url: 'deleteApi/'+api,
            type: 'get',
            success: function(response){
                alert(response);
            }
        });
        window.location.reload(1);
    }
    else{
        return false;
    }
});


    $("#openLabelForm").click(function(){
        $("#myModal").modal();
        $("#name").val('');
        $("#status").val('1');
        $("#id").val('');
        $("#add-edit").html('Add Label');
    });


    $(document).on("click", ".editLabel" , function() {
    $("#myModal").modal();
    $("#add-edit").html('Edit Label');
    var edit_id = $(this).data('id');
    $.ajax({
        url: 'editLabel/'+edit_id,
        type: 'get',
        success: function(response){
            $("#name").val(response.name);
            $("#status").val(response.status);
            $("#id").val(response.id);
        }
    });
});


    $(document).on("click", ".deleteLabel" , function() {
    if(confirm("Are you sure you want to delete this?")){
        var delete_id = $(this).data('id');
        var el = this;
        $.ajax({
            url: 'deleteLabel/'+delete_id,
            type: 'get',
            success: function(response){
                $(el).closest( "tr" ).remove();
            }
        });
        window.location.reload(1);
    }
    else
    {
        return false;
    }
});


//////////////close api ///////////////


</script>

<script>
$(document).ready(function() {
    function initializeSelect2() {
        $('.js-example-basic-single.select2').select2({
            dropdownParent: $('#listModal')
        });

       
        $('.select2-container').css({
            'width': '93%',
            'display': 'block'
        });
        $('.select2-selection').css({
            'height': '38px',
            
            'border-radius': '1px'
        });
    }

    $('#listModal').on('shown.bs.modal', function() {
        initializeSelect2(); 
    });

    if ($('#listModal').hasClass('show')) {
        initializeSelect2();
    }
});
</script>

<style>
.select2-container {
    width: 93% !important;
}
.select2-selection--single {
    height: 38px !important; 
    display: flex;
    align-items: center;
}
.select2-selection__rendered {
    line-height: 36px !important;
}
.select2-selection__arrow {
    height: 36px !important;
}
</style>

@endsection
