@extends('layouts.app')
@section('title', 'API List')

@section('content')
<style>
  .badge
{font-size: 1rem;
    font-style: normal;
    font-weight: 400;
    font-family: "IBM Plex Sans", sans-serif;
    line-height: 1.5;}
    .table > tbody > tr > td, .table > tbody > tr > th {
     padding: 0.2rem; 
    vertical-align: middle;
}

  </style>
<!-- Main content -->
        <section class="content">

      <div class="row">

       
        
        <div class="col-12">
          <div class="box">
                     
           <div class="box-body">           
              <h4 class="box-title text-info mb-0"><i class="fa fa-user fa-sx"></i> API</h4>

              <a href="{{ url('/add-api') }}"  style="float:right"type="button" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-plus"></i>&nbsp; Add API </a>
<hr class="my-15">
              <div class="table-responsive">
                <table id="tickets1" class="table mt-0 table-hover no-wrap" data-page-size="10">
                  <thead>
                    <tr>
                              <th>#</th>
                              <th>Name</th>
                              <th>Campaign</th>
                              <th>URL</th>
                              <th>Method</th>
                              <th>Status</th>
                              <th>API Template</th>
                              <th>Created</th>                             
                              <th>Action</th>

                            </tr>
                  </thead>
                  <tbody>
                
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
        <div class="modal fade" id="myModal" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title"  id="upload-excel"></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form method="post" action="">
        @csrf
      <div class="modal-body">
      <div id="loader" style="display: none;">
                    <img src="{{ asset('assets/images/giphy.gif') }}" alt="Loading..."style="height:100px;width:100px;">
                </div>
                <input type="hidden" class="form-control" name="disposition" value="" id ="id" required>
                <input type="hidden" class="form-control" name="username" value="" id ="first-name" required>   
                <div class="form-group">             
                <label for="inputEmail3" class="form-label">Name</label>
                <input type="text" class="form-control" required  name="name" id="name" placeholder="Enter Name">
                </div>
                    <div class="form-group">
                        <label for="inputPassword3"  id="" class="form-label">Status</label>                   
                        <select class="form-select" required id="status" name="status" >                          
                          <option value="1">Active</option>
                          <option value="0">Inactive</option>
                        </select>                      
                    </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
        <button type="submit"name="submit" class="btn btn-info btn-sm ">Save</button>
      </div>
        </form>
    </div>
  </div>
</div>

<div class="modal fade" id="delete" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="myModalLabel">Confirm Delete</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <p>You are about to delete <b><i class="title"></i></b>List.</p>
         <p>Do you want to proceed?</p>
         <input type="hidden" class="form-control" name="api_id" value="" id ="api_id" >
       
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-danger btn-sm deleteApi">Delete</button>
      </div>
    </div>
  </div>
</div>
      </div>
      <!-- /.row -->

    </section>
        <!-- /.content -->
        <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>

<script>$(document).ready(function() {
    $('#tickets1').DataTable({
        processing: true,
        serverSide: true,
        ajax: "{{ url('api-data') }}",
        columns: [
            { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false },
            { data: 'title', name: 'title' },
            { data: 'campaign', name: 'campaign' },
            { data: 'url', name: 'url' },
            { data: 'method', name: 'method' },
            { data: 'is_deleted', name: 'is_deleted', orderable: false, searchable: false },
            { data: 'is_default', name: 'is_default', orderable: false, searchable: false },
            { data: 'updated_at', name: 'updated_at' },
            { data: 'action', name: 'action', orderable: false, searchable: false }
        ],
language: {
    processing: `
        <span style="display:flex; align-items:center; justify-content:center; gap:8px;">
            <img src="https://i.gifer.com/ZZ5H.gif"
                 alt="Loading..." style="width:20px; height:20px;">
            Processing...
        </span>
    `
}
    });
});
</script>
        <script>
 $(document).on("click", ".openApiDelete", function(){
        var delete_id = $(this).data('api');
        $("#delete").modal('show');
        $("#api_id").val(delete_id);
       
    });

     $(document).on("click", ".deleteApi" , function() {
    //if(confirm("Are you sure you want to delete this record?")){
        var api = $("#api_id").val();
        console.log(api);
        var el = this;
        $.ajax({
            url: 'deleteApi/'+api,
            type: 'get',
            success: function(response){
        window.location.reload(1);
               
            }
        });
    // }
    // else{
    //     return false;
    // }
});
</script>








@endsection
