@extends('layouts.app')
@section('title', 'CRM label')

@section('content')

<style>
.badge
{font-size: 1rem;
    font-style: normal;
    font-weight: 400;
    font-family: "IBM Plex Sans", sans-serif;
    line-height: 1.5;}
    .table > tbody > tr > td, .table > tbody > tr > th {
        padding: 0.8rem; 
        vertical-align: middle;
    }
    
    .disabled {
        opacity: 0.5; /* Adjust the opacity or add other styles as needed */
    }


    </style>
    <style>
        .btn-toggle.active {
            background-color: #2196f3; /* Set to the desired green color */
            color: white; /* Set to the desired text color */
            border-color: green; /* Set to the desired border color */
        }
        
        /* Style for the inactive state */
        .btn-toggle:not(.active) {
            background-color: red; /* Set to the desired red color */
            color: white; /* Set to the desired text color */
            border-color: red; /* Set to the desired border color */
}
	</style>
    <link href="{{asset('assets/css/bootstrap4-toggle.min.css')}}" rel="stylesheet">
    <section class="content">
  <div class="row">       
    <div class="col-lg-12 col-12">
      <div class="box">                  
          <div class="box-body"><!--bg-lightest-->
             <h4 class="box-title text-info mb-0"><i class="fa fa-plus"></i> CRM Labels</h4>
              <a id="openLabelForm"  type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-plus"></i> Add CRM Label</a>
                  <hr class="my-15">
                                                <div class="row">
                                                    <div class="col-md-9">
                                                        <div class="box">
                                                              <div class="box-body">
                                                                        <div class="row">
                                                                          <div class="table-responsive mailbox-messages ">
                                                                          <table id="tickets" class="table mt-0 table-hover no-wrap" data-page-size="10">								<thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Name</th>
                                            <th>Required By Merchant/Agent</th>
                                            <th>Data Type</th>
                                            <th>Edit Mode</th>
                                            <th>Status</th>                             
                                            <th>Action</th>

                                        </tr>
                                        </thead>
                                        <tbody>
                                                @php
                                                $title_order = $label_list;
                                                function compareByTitle($a, $b)
                                                { 
                                                    return strcmp($a->title, $b->title);
                                                }

                                                usort($title_order, 'compareByTitle');
                                                @endphp
                                                @foreach($label_list as $key => $label_data) 

                                                @if($label_data->label_title_url != 'unique_url')
                                                
                                                    <tr>
                                                                <th scope="row">{{$key+1}}</th>
                                                                <td>{{$label_data->title}}</td> 
                                                                <td>
                                                                @if($label_data->merchant_required == 1)
                                                                <span class="badge badge-success">Yes</span>
                                                                @else
                                                                <span class="badge badge-danger">No</span>
                                                                @endif /
                                                                @if($label_data->required == 1)
                                                                <span class="badge badge-success">Yes</span>
                                                                @else
                                                                <span class="badge badge-danger">No</span>
                                                                @endif
                                                                
                                                                </td>
                                                    
                                                                <td>@if($label_data->data_type == 'select_option')
                                                                        <span class="badge badge-info">Select Option</span>
                                                                        @elseif($label_data->data_type == 'currency')
                                                                        <span class="badge badge-info">Currency</span>
                                                                        @elseif($label_data->data_type == 'text')
                                                                        <span class="badge badge-info">Text</span>
                                                                        @elseif($label_data->data_type == 'phone_number')
                                                                        <span class="badge badge-info">Phone number</span>
                                                                        @elseif($label_data->data_type == 'number')
                                                                        <span class="badge badge-info">Number</span>
                                                                        @elseif($label_data->data_type == 'email')
                                                                        <span class="badge badge-info">Email</span>
                                                                        @elseif($label_data->data_type == 'datetime-local')
                                                                        <span class="badge badge-info">Datetime</span>
                                                                        @elseif($label_data->data_type == 'date')
                                                                        <span class="badge badge-info">Date</span>

                                                                    @endif

                                                                </td>
                                                                <td>@if($label_data->edit_mode == 0)
                                                                        <span class="badge badge-info">System</span>
                                                                    @endif

                                                                    @if($label_data->edit_mode == 1)
                                                                        <span class="badge badge-success">System & Merchant</span>
                                                                    @endif
                                                                </td>
                                                                    <td>  <button type="button"data-id="{{$label_data->id}}"  class="btn btn-sm btn-toggle  @if($label_data->status == '1') active @endif" data-bs-toggle="button" aria-pressed="true" autocomplete="off">
                                                                                                <div class="handle"></div>
                                                                                                </button>
                                                                    </td>
                                                                        
                                                                <td> 
                                                                {{--@if($label_data->label_type == 'open')  --}}
                                                                    <a style="cursor:pointer;margin-right:5px;color:#2f579a;" data-toggle="tooltip"
                                                                    data-id="{{$label_data->id}}" data-title="{{$label_data->title}}" data-datatype="{{$label_data->data_type}}" data-required="{{$label_data->required}}" data-merchantrequired="{{$label_data->merchant_required}}" data-editmode="{{$label_data->edit_mode}}" data-values="{{$label_data->values}}"data-nolength="{{$label_data->number_length}}"
                                                                    data-icons="{{$label_data->icons}}" data-heading_type="{{$label_data->heading_type}}"
                                                                    title="Edit" class="editLabel"><i
                                                                            class="fa fa-edit  fa-lg"></i></a>
                                                                            {{--@else--}}
                                                                            <!-- <a title="Can't Edit because it is system generated label" 
                                                                            style="cursor:pointer;margin-right:5px;color:#2f579a; opacity: 0.5;" 
                                                                            data-id="{{$label_data->id}}"
                                                                            onclick="return false;"
                                                                            >
                                                                            <i class="fa fa-edit fa-lg"></i>
                                                                            </a> -->
                                                                          {{--  @endif --}}
                                                                    <a style="cursor:pointer;margin-right:6px;color:#2f579a;" title="Delete" class='openLabelDelete'data-id="{{$label_data->id}}"><i class="fa fa-trash-o fa-lg"></i></a>
                                                              
                                                                    <a title="View On Lead"style="color:#2f579a;" href="javascript:void(0)" data-toggle="tooltip"
                                                                    data-id="{{$label_data->id}}" data-view="{{$label_data->view_on_lead}}" 
                                                                    data-original-title="Edit" class="view">

                                                                    @if($label_data->view_on_lead == 1)
                                                                    <i   class="fa fa-eye fa-lg"></i>
                                                                                @else
                                                                                <i style="opacity: 0.6;cursor: pointer;" class="fa fa-eye-slash fa-lg"></i>
                                                                    @endif  </a>
                                                    
                                                                                        
                                                                        
                                                                </td>
                                                                    
                                                    </tr>  
                                                    @endif
                                                @endforeach
                                            
                                        </tbody>
                                    </table>
                                                                          </div>
                                                                        </div>
                                                              </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="box">
                                                            <div class="box-body">
                                                                <div class="row">
                                                                  <div class="col-md-12">
                                                                        <h4 class="box-title">Display Order(Drag & Drop)</h4>
                                                                      <div class="box-body">
                                                                        <!-- the events -->
                                                                        <div id="external-events">
                                                                        <table class="table">
                                                                                    <tbody class="row_position">
                                                                                        @if(!empty($label_list))
                                                                                        @foreach($label_list as $key => $list)
                                                                                        @if($list->is_deleted == 0 && $list->status == 1)
                                                                                        <tr id="<?php echo $list->id; ?>">
                                                                                        <td style="cursor: pointer;width:100%;"class="waves-effect waves-light btn btn-primary mb-5"><?php echo $list->title ?></td>
                                                                                        </tr>
                                                                                        @endif
                                                                                        @endforeach
                                                                                        @endif
                                                                                    </tbody>
                                                                                    
                                                                                </table>
                                                                        </div>
                                                                      </div>                 
                                                                  </div>          
                                                                </div>
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>   
                                                <div class="modal fade" id="myModal" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
                                                        <div class="modal-dialog">
                                                                <div class="modal-content">
                                                                    <div class="modal-header">
                                                                    <h5 class="modal-title" id="add-edit"></h5>
                                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                    </div>
                                                                    <form method="post" id="addLabel">
                                                                        @csrf
                                                                        <div class="modal-body">
                                                                                                <div class="row">
                                                                                                    <div class="col-md-12 form-group">
                                                                                                        <label for="inputEmail3" class="form-label">Name</label>
                                                                                                        <input type="text" class="form-control" required name="title" id="title" placeholder="Enter Name">
                                                                                                    </div>
                                                                                                    <div class="col-6">
                                                                                                        <div class="form-group">
                                                                                                            <label for="exampleInputEmail1">Data Type</label>
                                                                                                            <select class="form-select data_type" name="data_type"id="data_type" required>
                                                                                                                <option value="select_option">Select Option</option>
                                                                                                                <option value="currency">Currency</option>
                                                                                                                <option value="date">Date</option>
                                                                                                                <option value="datetime-local">Datetime</option>
                                                                                                                <option value="email">Email</option>
                                                                                                                <option value="number">Number</option>
                                                                                                                <option value="phone_number">Phone number</option>
                                                                                                                <option selected value="text">Text</option>
                                                                                                                <option value="select_state">State Drop Down</option>

                                                                                                            </select>
                                                                                                        </div>
                                                                                                    </div>
                                                                                                    <div class="col-6"style="display: none;"  id="div_length">
                                                                                                        <div class="form-group">
                                                                                                            <label for="exampleInputEmail1">Number Length</label>
                                                                                                            <select class="form-select" name="number_length"id="number_length">
                                                                                                                <option value=""selected>Select</option>
                                                                                                                <option value="1">1</option>
                                                                                                                <option value="2">2</option>
                                                                                                                <option value="3">3</option>
                                                                                                                <option value="4">4</option>
                                                                                                                <option value="5">5</option>
                                                                                                                <option value="6">6</option>
                                                                                                                <option value="7">7</option>
                                                                                                                <option value="8">8</option>
                                                                                                                <option value="9">9</option>
                                                                                                                <option value="10">10</option>
                                                                                                            </select>
                                                                                                        </div>
                                                                                                    </div>
                                                                                                    <div class="col-6">
                                                                                                        <div class="form-group">
                                                                                                            <label for="exampleInputEmail1">Edit Mode</label>
                                                                                                            <select class="form-select" name="edit_mode" id="edit_mode_add">
                                                                                                                <option value="0"selected>System</option>
                                                                                                                <option value="1">System & Merchant</option>
                                                                                                            </select>
                                                                                                        </div>
                                                                                                    </div>
                                                                                                    <div class="col-6" style="display: none;" id="merchant_add">
                                                                                                        <div class="form-group">
                                                                                                            <label for="exampleInputEmail1">Required By Merchant</label>
                                                                                                            <select class="form-select" name="merchant_required"id="merchant_required">
                                                                                                                <option value="0"selected>No</option>
                                                                                                                <option value="1">Yes</option>
                                                                                                            </select>
                                                                                                        </div>
                                                                                                    </div>
                                                                                                    <div class="col-6">
                                                                                                        <div class="form-group">
                                                                                                            <label for="exampleInputEmail1">Required By Agent</label>
                                                                                                            <select class="form-select" name="required"id="required">
                                                                                                                <option value="0"selected>No</option>
                                                                                                                <option value="1">Yes</option>
                                                                                                            </select>
                                                                                                        </div>
                                                                                                    </div>     
                                                                                                    <div class="col-6">
                                                                                                        <div class="form-group">
                                                                                                            <label for="exampleInputEmail1">Icon</label>
                                                                                                            <select class="form-select" name="icons"id="icons">
                                                                                                            <option value="fa fa-user"selected>&#128100; User</option>
                                                                                                            <option value="fa fa-at"selected>&#128100; Email</option>
                                                                                                                <option value="fa fa-envelope">&#128235;Envelope</option>
                                                                                                                <option value="fa fa-phone">&#128222; Phone</option>
                                                                                                                <option value="fa fa-venus-mars">&#9792;&#9794; Gender</option>
                                                                                                                <option value="fa fa-calendar">&#128197; Calendar</option>
                                                                                                                <option value="fa fa-map-marker">&#128205; Location</option>
                                                                                                                <option value="fa fa-address-book">&#128214; Address Book</option>
                                                                                                                <option value="fa fa-building">    &#127961; Building</option>
                                                                                                                <option value="fa fa-usd">         &#36; USD</option>
                                                                                                                <option value="fa fa-adjust">     &#128295; Adjust</option>
                                                                              


                                                                                                            </select>
                                                                                                        </div>
                                                                                                    </div>     



                                                                      <div class="col-6">
                                                                <div class="form-group">
                                                                    <label for="exampleInputEmail1">Heading Type</label>
                                                                    <select class="form-select" name="heading_type" id="heading_type">
                                                                        <option value="owner">Owner Information</option>
                                                                        <option value="second_owner">Second Owner Information</option>
                                                                        <option value="business">Business Information</option>
                                                                    </select>
                                                                </div>
                                                            </div>                                                                                                                            
                                                                                                </div>
                                                                                                    <div class="col-md- 12 form-group">
                                                                                                        <div id="select_choices_container">
                                                                                                            <span>
                                                                                                                <i>Input comma-separated values</i>
                                                                                                            </span>
                                                                                                            <textarea class="form-control" id="select_choices" placeholder="Write your selection choices..."
                                                                                                                name="select_choices"></textarea>
                                                                                                                
                                                                                                        </div>
                                                                                                    </div>
                                                                                            
                                                                        </div>
                                                                        <div class="modal-footer">
                                                                            <button type="button" class="btn btn-secondary " data-bs-dismiss="modal">Close</button>
                                                                            <button type="submit" name="submit" class="btn btn-info btn-ok">Save</button>
                                                                        </div>
                                                                    </form>
                                                                </div>
                                                        </div>
                                                </div>
        <div class="modal fade" id="myModalEdit" tabindex="-1" aria-labelledby="myModalEditLabel" aria-hidden="true">
                <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                            <h5 class="modal-title" id="edit">Edit CRM Label</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <form method="post" action="{{ route('label.update') }}" id="updateLabel">
                                @csrf
                                <div class="modal-body">
                                    <input type="hidden" class="form-control" name="label_id" value="" id="id">
                                    <div class="row">
                                                        <div class="col-md-12 form-group">
                                                            <label for="inputEmail3" class="form-label">Name</label>
                                                            <input type="text" class="form-control" required name="title" id="titleEdit" placeholder="Enter Name">
                                                        </div>
                                                            <div class="col-6">
                                                                <div class="form-group">
                                                                    <label for="exampleInputEmail1">Data Type</label>
                                                                    <select class="form-select data_type" name="data_type"id="edit_data_type" required>
                                                                        <option value="select_option">Select Option</option>
                                                                        <option value="currency">Currency</option>
                                                                        <option value="date">Date</option>
                                                                        <option value="datetime-local">Datetime</option>
                                                                        <option value="email">Email</option>
                                                                        <option value="number">Number</option>
                                                                        <option value="phone_number">Phone number</option>
                                                                        <option selected value="text">Text</option>
                                                                        <option value="select_state">State Drop Down</option>

                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="col-6"style="display: none;"  id="div_length_edit">
                                                                <div class="form-group">
                                                                    <label for="exampleInputEmail1">Number Length</label>
                                                                    <select class="form-select" name="number_length"id="number_length_edit">
                                                                    <option value=""selected>Select</option>
                                                                        <option value="1">1</option>
                                                                        <option value="2">2</option>
                                                                        <option value="3">3</option>
                                                                        <option value="4">4</option>
                                                                        <option value="5">5</option>
                                                                        <option value="6">6</option>
                                                                        <option value="7">7</option>
                                                                        <option value="8">8</option>
                                                                        <option value="9">9</option>
                                                                        <option value="10">10</option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="col-6">
                                                                <div class="form-group">
                                                                    <label for="exampleInputEmail1">Edit Mode</label>
                                                                    <select class="form-select" name="edit_mode" id="edit_mode">
                                                                        <option value="0"selected>System</option>
                                                                        <option value="1">System & Merchant</option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                       

                                                     
                                                        <div class="col-6" style="display: none;" id="merchant_edit">
                                                                <div class="form-group">
                                                                    <label for="exampleInputEmail1">Required By Merchant</label>
                                                                    <select class="form-select" name="merchant_required"id="merchant_required_edit">
                                                                        <option value="0"selected>No</option>
                                                                        <option value="1">Yes</option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="col-6">
                                                                <div class="form-group">
                                                                    <label for="exampleInputEmail1">Required By Agent</label>
                                                                    <select class="form-select" name="required"id="requiredEdit">
                                                                        <option value="0"selected>No</option>
                                                                        <option value="1">Yes</option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                                                            <div class="col-6">
                                                                                                        <div class="form-group">
                                                                                                            <label for="exampleInputEmail1">Icon</label>
                                                                                                            <select class="form-select" name="icons"id="iconsEdit">
                                                                                                            <option value="fa fa-user"selected>&#128100; User</option>
                                                                                                                <option value="fa fa-envelope">&#128235;Envelope</option>
                                                                                                                <option value="fa fa-phone">&#128222; Phone</option>
                                                                                                                <option value="fa fa-venus-mars">&#9792;&#9794; Gender</option>
                                                                                                                <option value="fa fa-calendar">&#128197; Calendar</option>
                                                                                                                <option value="fa fa-map-marker">&#128205; Location</option>
                                                                                                                <option value="fa fa-address-book">&#128214; Address Book</option>
                                                                                                                <option value="fa fa-building">    &#127961; Building</option>
                                                                                                                <option value="fa fa-usd">         &#36; USD</option>
                                                                                                                <option value="fa fa-adjust">     &#128295; Adjust</option>
                                                                              



                                                                                                            </select>
                                                                                                        </div>
                                                                                                    </div>  

                                                                      <div class="col-6">
                                                                <div class="form-group">
                                                                    <label for="exampleInputEmail1">Heading Type</label>
                                                                    <select class="form-select" name="heading_type" id="headerTypeEdit">
                                                                        <option value="owner">Owner Information</option>
                                                                        <option value="second_owner">Second Owner Information</option>
                                                                        <option value="business">Business Information</option>

                                                                    </select>
                                                                </div>
                                                            </div>


                                                            <div class="form-group">
                                                            <div id="select_choices_container_edit"style="display:none;">
                                                                <span>
                                                                    <i>Input comma-separated values</i>
                                                                </span>
                                                                <textarea class="form-control" id="select_choices_edit" placeholder="Write your selection choices..."
                                                                    name="select_choices"></textarea>
                                                                    
                                                            </div>
                                                        </div>
                                                           
                                                        </div>

                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary " data-bs-dismiss="modal">Close</button>
                                    <button type="submit" name="submit" class="btn btn-info btn-ok">Save</button>
                                </div>
                            </form>
                        </div>
                </div>
        </div>

            <div class="modal fade" id="delete" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="myModalLabel">Confirm Delete</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    
                    <div class="modal-body">
                    <p>You are about to delete <b><i class="title"></i></b>Label.</p>
                        <p>Do you want to proceed?</p>
                        <input type="hidden" class="form-control" name="label_id" value="" id="label_id">
                    
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                        <button type="submit"name="submit" class="btn btn-danger btn-sm deleteLabel">Delete</button>
                    </div>
                    </div>
                </div>
            </div>
            </div>
              <!-- /.box-body -->
          
            <!-- /.box -->      
        </div>         
      </div>
  </section>

        <!-- /.content -->

        <script src="{{asset('assets/vendor_components/jquery-ui/jquery-ui.min.js')}}"></script>	
	<script src="{{asset('assets/js/pages/calendar.js')}}"></script>
        <script src="{{asset('assets/js/bootstrap4-toggle.min.js')}}"></script>
        <script>
              
    $(".openLabelDelete").click(function() {
        var delete_id = $(this).data('id');
        $("#delete").modal('show');
        $("#label_id").val(delete_id);

    });

    $("#openLabelForm").click(function() {
        $("#myModal").modal('show');
        $("#name").val('');
        $("#data_type").val('text');
        $("#required").val('1');
        $("#merchant_required").val('0');
        $("#edit_mode").val('0');
        $("#status").val('1');
        $("#id").val('');
        $("#add-edit").html('Add CRM Label');
    });
    
    $('.editLabel').click(function () {
        $('#myModalEdit').modal('show');
            var id = $(this).data('id');
            var title = $(this).data('title');
            var data_type = $(this).data('datatype');
            var required = $(this).data('required');
            var merchant_required = $(this).data('merchantrequired');
            var edit_mode = $(this).data('editmode'); 
            var icons = $(this).data('icons'); 
            var heading_type = $(this).data('heading_type'); 

            if(edit_mode == 1)
            {
                $("#merchant_edit").show();

            } 
            else{
                $("#merchant_edit").hide();

            }      
            var values = $(this).data('values');
            if(data_type == 'select_option')
            {
                $('#data_type').val(data_type);
                $("#select_choices_container_edit").show();
                $('#select_choices_edit').val(values);
            }
            else
            {
                $("#select_choices_container_edit").hide();
                $('#select_choices_edit').val("");
            }
            var no_length = $(this).data('nolength');
            if(data_type == 'number')
            {
                $('#data_type').val(data_type);
                $("#div_length_edit").show();
                $('#number_length_edit').val(no_length);
            }
            else
            {
                $("#div_length_edit").hide();
                $('#number_length_edit').val("");
            }
            $('#id').val(id);
            $('#titleEdit').val(title);
            $('#edit_data_type').val(data_type);
            $('#edit_mode').val(edit_mode);
            $('#requiredEdit').val(required);
            $('#merchant_required_edit').val(merchant_required);
            $('#iconsEdit').val(icons);
            $('#headerTypeEdit').val(heading_type);



        

        

        });
        

        $("#edit_mode").change(function(){
                $("#merchant_edit").hide();

            var mode = $("#edit_mode").val();
            if(mode == 1)
            {
                $("#merchant_edit").show();
            }
            else
            {
                $("#merchant_edit").hide();
            }

        });
        $("#edit_data_type").change(function(){
                $("#select_choices_container_edit").hide();

            var mode = $("#edit_data_type").val();
            if(mode == 'select_option')
            {
                $("#select_choices_container_edit").show();
            }
            else
            {
                $("#select_choices_container_edit").hide();
            }
            if(mode=="number"){
                    $("#div_length_edit").show();
                } else {
                    $("#div_length_edit").hide();

                }

        });
    $(document).on("click", ".deleteLabel", function() {

        //if(confirm("Are you sure you want to delete this?")){
        var delete_id = $("#label_id").val();
        var el = this;
        $.ajax({
            url: 'crm-labels/' + delete_id,
            type: 'get',
            success: function(response) {
                window.location.reload(1);
            }
        });

    });
            $("#select_choices_container").hide();
            $("#select_choices_container_edit").hide();


            $( ".data_type" ).change(function() {
                 var val = $(".data_type").val();
                if(val=="select_option"){
                $("#select_choices_container").show();
                } else {
                 $("#select_choices_container").hide();
                }
                if(val=="number"){
                $("#div_length").show();
                } else {
                    $("#div_length").hide();
                }
             });

            $( "#data_type" ).change(function() {
                var val = $("#data_type").val();
                if(val=="select_option"){
                    $("#select_choices_container_edit").show();
                } else {
                    $("#select_choices_container_edit").hide();
                }
                if(val=="number"){
                    $("#div_length_edit").show();
                } else {
                    $("#div_length_edit").hide();
                }
            });
            $(function () {
            $("#tickets").on("click", ".btn-toggle", function () {
              
                var button = $(this);
                var status = button.hasClass('active') ? 1 : 0;
                var label_id = button.data('id');
                $.ajax({
                    type: "GET",
                    dataType: "json",
                    url: '/crm-changeLabelStatus/' + label_id + '/' + status,
                    success: function (data) {
                        if (data.status == 'true') {
                            console.log(data.success);
                            window.location.reload(1);
                        } else {

                        }

                    }
                });
            })

             $("#tickets").on("click", ".view", function () {
                // $('#loading').show();
                var view_on_lead = $(this).data('view');
                if(view_on_lead == 1)
                    view_on_lead=0;
                else
                    view_on_lead=1;
                var label_id = $(this).data('id');

              

                $.ajax({
                    type: "GET",
                    dataType: "json",
                    url: '/crm-changeViewOnLead/' + label_id + '/' + view_on_lead,
                    success: function (data) {
                        if (data.status == 'true') {
                            console.log(data.success);
                            window.location.reload(1);
                        } else {

                            console.log(data.success);
                            window.location.reload(1);

                        }

                    }
                });
            })
        })
        
        $(".row_position").sortable({
            delay: 150,
            stop: function() {
                var selectedData = new Array();
                $('.row_position>tr').each(function() {
                    selectedData.push($(this).attr("id"));
                });
                updateOrder(selectedData);
            }
        });
        function updateOrder(data) {

            $.ajaxSetup({
            headers: 
            {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }});
            $.ajax({
                url: "{{ url('/crm-update/displayorder') }}",
                type:'post',
                data:{display_order:data},
                success:function(data){
                   toastr.success('Display Order is changed Successfully.');
                }
            })
        }
              $("#edit_mode_add").change(function(){
                $("#merchant_show").hide();

            var mode = $("#edit_mode_add").val();
            if(mode == 1)
            {
                $("#merchant_show").show();
            }
            else
            {
                $("#merchant_show").hide();
            }

        });

        $("#edit_mode_add").change(function(){
                $("#merchant_add").hide();

            var mode = $("#edit_mode_add").val();
            if(mode == 1)
            {
                $("#merchant_add").show();
            }
            else
            {
                $("#merchant_add").hide();
            }

        });

</script>




@endsection
