@extends('layouts.app')
@section('title', 'label')

@section('content')
    <style>
        .badge {
            font-size: 1rem;
            font-style: normal;
            font-weight: 400;
            font-family: "IBM Plex Sans", sans-serif;
            line-height: 1.5;
        }
        @media (max-width: 576px) {
    .d-flex {
        flex-direction: column;
        align-items: flex-start !important;
    }
    .d-flex a {
        margin-top: 10px;
    }
}

    </style>
    <!-- Main content -->
    <section class="content">

        <div class="row">



            <div class="col-12">
                <div class="box">
                    <div class="box-body">
<div class="d-flex justify-content-between align-items-center flex-wrap mb-3">
    <h4 class="box-title text-info mb-0">
        <i class="fa fa-user fa-sx"></i> Custom Field Labels
    </h4>
    <a id="openLabelForm" type="button"
       class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm">
        <i class="fa fa-plus"></i> Add Custom Field Label
    </a>
</div>

                        <!-- <h4 class="box-title text-info mb-0"><i class="fa fa-user fa-sx"></i> Custom Field Labels</h4>
                        <a id="openLabelForm" type="submit" style="float:right"
                            class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i
                                class="fa fa-plus"></i>Add Custom Field label</a> -->

                        <hr class="my-15">
                        <div class="table-responsive">
                            <table id="custom_field" class="table mt-0 table-hover no-wrap" data-page-size="10">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Name</th>
                                        <th>Status</th>
                                        <th>Action</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($custom_field_labels as $key => $label_data)
                                        <tr>
                                            <th scope="row">{{ $key + 1 }}</th>
                                            <td>{{ $label_data->title }}</td>
                                            <td>
                                                @if ($label_data->is_deleted == '0')
                                                    <span class="badge badge-sm badge-success">Active</span>
                                                @else
                                                    ($label_data->is_deleted == '1')
                                                    <span class="badge badge-sm badge-warning">Inactive</span>
                                                @endif
                                            </td>


                                            <td><a style="cursor:pointer;margin-right:5px;" title="Edit"class='editLabel'
                                                    data-id="{{ $label_data->id }}"><i class="fa fa-edit fa-lg"></i></a>
                                                <a style="cursor:pointer;" title="Delete" class='openLabelDelete'
                                                    data-id="{{ $label_data->id }}"><i class="fa fa-trash-o fa-lg"></i></a>
                                            </td>


                                        </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade" id="myModal" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="add-edit"></h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <form method="post" action="">
                            @csrf
                            <div class="modal-body">
                                <input type="hidden" class="form-control" name="label_id" value="" id="id">
                                <label for="inputEmail3" class="form-label">Name </label>
                                <input type="text" class="form-control" required name="title" id="title"
                                    placeholder="Enter Name">

                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                <button type="submit" name="submit" class="btn btn-info btn-ok">Save</button>
                            </div>
                        </form>

                    </div>
                </div>

            </div>

            <div class="modal fade" id="delete" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="myModalLabel">Confirm Delete</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <form method="post" action="" enctype="multipart/form-data">
                            @csrf
                            <div class="modal-body">
                                <p>You are about to delete <b><i class="title"></i></b>record.</p>
                                <p>Do you want to proceed?</p>
                                <input type="hidden" class="form-control" name="label_id" value="" id="label_id">

                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary btn-sm"
                                    data-bs-dismiss="modal">Close</button>
                                <button type="submit"name="submit"
                                    class="btn btn-danger btn-sm deleteLabel">Delete</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->

    </section>
    <!-- /.content -->

    <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM="
        crossorigin="anonymous"></script>


    <script>
        $(document).ready(function() {
            $('#custom_field').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ url('custom-field-labels') }}",
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'title',
                        name: 'title'

                    },
                    {
                        data: 'status',
                        name: 'status'

                    },


                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ],
language: {
    processing: `
        <span style="display:flex; align-items:center; justify-content:center; gap:8px;">
            <img src="https://i.gifer.com/ZZ5H.gif"
                 alt="Loading..." style="width:20px; height:20px;">
            Processing...
        </span>
    `
}

            });
        });
    </script>


    <script>
        $('#custom_field').on('click', '.openLabelDelete', function() {

            var delete_id = $(this).data('id');
            $("#delete").modal('show');
            $("#label_id").val(delete_id);
        });

        // $(".openLabelDelete").click(function() {

        //     var delete_id = $(this).data('id');
        //     $("#delete").modal('show');
        //     $("#label_id").val(delete_id);

        // });

        $("#openLabelForm").click(function() {
            $("#myModal").modal('show');
            $("#name").val('');
            $("#status").val('1');
            $("#id").val('');
            $("#add-edit").html('Add Custom Field Label');
        });

        $(document).on("click", ".editLabel", function() {
            $("#myModal").modal('show');
            $("#add-edit").html('Edit Custom Field Label');
            var edit_id = $(this).data('id');
            $.ajax({
                url: 'custom-field-label/' + edit_id,
                type: 'get',
                success: function(response) {
                    $("#title").val(response.title);

                    $("#id").val(response.id);
                }
            });
        });

        $(document).on("click", ".deleteLabel", function() {
            var delete_id = $("#label_id").val();
            var el = this;
            $.ajax({
                url: 'delete-custom-field-label/' + delete_id,
                type: 'get',
                success: function(response) {
                    window.location.reload(1);
                }
            });
        });
    </script>



@endsection
