@extends('layouts.app')
@section('title', 'Custom Field Values')

@section('content')
<style>
.badge
{font-size: 1rem;
    font-style: normal;
    font-weight: 400;
    font-family: "IBM Plex Sans", sans-serif;
    line-height: 1.5;}
    .custom-field-header {
    display: flex;
    flex-direction: column;     /* mobile: stack */
    align-items: flex-start;
    gap: 10px;
    margin-bottom: 15px;
}

.custom-field-header a {
    align-self: flex-start;     /* button mobile पर normal width */
}

/* Tablet & Desktop */
@media (min-width: 768px) {
    .custom-field-header {
        flex-direction: row;            /* row layout */
        justify-content: space-between; /* heading left, button right */
        align-items: center;
    }

    .custom-field-header a {
        align-self: center;
    }
}

    </style>
<!-- Main content -->
        <section class="content">

      <div class="row">

       
        
        <div class="col-12">
          <div class="box">
           <div class="box-body">           
            <div class="custom-field-header">
    <h4 class="box-title text-info mb-0">
        <i class="fa fa-user fa-sx"></i> Custom Field Values
    </h4>

    <a id="openLabelForm" type="button" 
       class="btn btn-primary btn-rounded btn-sm">
        <i class="fa fa-plus"></i> Add Custom Field Value
    </a>
</div>

            <hr class="my-15">
              <div class="table-responsive">
                <table id="tickets" class="table mt-0 table-hover no-wrap" data-page-size="10">
                  <thead>
                    <tr>
                              <th>#</th>
                              <th>Title</th>
                              <th>Title Links</th>                             
                              <th>Status</th>
                              <th>Action</th>

                            </tr>
                  </thead>
                  <tbody>
                  @foreach($custom_fields_values as $key => $label_data)

                                <tr>
                                  <th scope="row">{{$key+1}}</th>
                                  <td>{{$label_data->title_match}}</td>    
                                  <td>{{$label_data->title_links }}</td>                        
                                  <td>
                                        @if($label_data->is_deleted == '0')
                                        <span class="badge badge-sm badge-success">Active</span> 
                                        @else ($label_data->is_deleted == '1')
                                        <span class="badge badge-sm badge-warning">Inactive</span> 
                                        @endif
                                    </td>
                                 
                                  
                                  <td><a style="cursor:pointer;margin-right:5px;" title="Edit"class='editLabel' data-id="{{$label_data->id}}" ><i class="fa fa-edit fa-lg"></i></a> 
                                   <a style="cursor:pointer;" title="Delete" class='openLabelDelete' data-id="{{$label_data->id}}"><i class="fa fa-trash-o fa-lg"></i></a></td>
                                  
                             
                                </tr>

  
                            @endforeach
                         
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      <div class="modal fade" id="myModal" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title" id="add-edit"></h5>
              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="post" action="">
                @csrf
                <div class="modal-body">
                <input type="hidden" class="form-control" name="value_id" value="" id="value_id">
                            <input type="hidden" class="form-control" name="title_match" value="" id="title_match">

                            <input type="hidden" class="form-control" name="user_id" value="{{Session::get('id')}}" id="user_id">
                    <label for="inputEmail3" class="form-label">Custom Field Labels </label>
                    <select class="form-select"  required name="custom_id" id="custom_id" placeholder="Enter Name">
                                    <option value="">Select Custom Field Labels</option>
                                    @if(!empty($custom_field_labels))
                                @foreach($custom_field_labels as $key => $label_data_values)
                                <option value="{{$label_data_values->id}}">{{$label_data_values->title}}</option>
                                @endforeach
                                @endif
                                </select>
                                <label  class="form-label">Links</label>
                            <input type="text" required class="form-control" required name="title_links" id="title_links" placeholder="Enter Title Link ">
                </div>
                <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" name="submit" class="btn btn-info btn-ok">Save</button>
                </div>
            </form>
        
          </div>
        </div>

      </div>

<div class="modal fade" id="delete" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="myModalLabel">Confirm Delete</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form method="post" action="" enctype="multipart/form-data">
      @csrf
      <div class="modal-body">
      <p>You are about to delete <b><i class="title"></i></b>record.</p>
         <p>Do you want to proceed?</p>
         <input type="hidden" class="form-control" name="label_id" value="" id="label_id">
       
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
        <button type="submit"name="submit" class="btn btn-danger btn-sm deleteLabel">Delete</button>
      </div>
        </form>
    </div>
  </div>
</div>
      </div>
      <!-- /.row -->

    </section>
        <!-- /.content -->

        <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>

        <script>

    $(".openLabelDelete").click(function() {
        var delete_id = $(this).data('id');
        $("#delete").modal('show');
        $("#label_id").val(delete_id);

    });

    $("#openLabelForm").click(function() {
        $("#myModal").modal('show');
        $("#name").val('');
        $("#status").val('1');
        $("#id").val('');
        $("#add-edit").html('Add Custom Value');
    });

    $(document).on("click", ".editLabel", function() {
        $("#myModal").modal('show');
        $("#add-edit").html('Edit Custom Value');
        var edit_id = $(this).data('id');
        $.ajax({
            url: 'custom-field-value/' + edit_id,
            type: 'get',
            success: function(response) {
                $("#value_id").val(response.id);

                $('select[name^="custom_id"] option[value='+response.custom_id+']').attr("selected","selected");
                $("#title_links").val(response.title_links);
                $("#title_match").val(response.title_match);


            }
        });
    });

    $(document).on("click", ".deleteLabel", function() {

        //if(confirm("Are you sure you want to delete this?")){
        var delete_id = $("#label_id").val();
        //alert(delete_id);
        var el = this;
        $.ajax({
           url: 'delete-custom-field-value/' + delete_id,
            type: 'get',
            success: function(response) {
                window.location.reload(1);
            }
        });

    });

    $('#custom_id').change(function() {
  var title_match = $('#custom_id').find(":selected").text();
  $("#title_match").val(title_match);
})
</script>



@endsection
