@extends('layouts.app')
@section('title', 'IVR List')
@section('content')
<meta name="csrf-token" content="{{ csrf_token() }}"> 
<style>
    /* Increase the size of the sliders */
.slider {
    width: 100%;
    height: 10px;
}

    .ivr-input-types .ivr_type_txt_to_speech, .ivr-input-types .ivr_type_audio_record{
        margin-top: 10px;
    }
    .ivr-input-types {
        text-align: center;
    }
    .recording-status{
        display:none;
        padding-left: 10px;
        color: red;
        animation: blinker 1s linear infinite;
    }
    #record {
        border-radius: 50%;
        background-color: red;
        color: #fff;
        font-size: 20px;
        width: 60px;
        height: 60px;
        border: none;
    }
    #stopRecord{
        border-radius: 50%;
        background-color: #3c8dbc;
        color: #fff;
        font-size: 20px;
        width: 60px;
        height: 60px;
        border: none;
        margin-left: 5px;
    }
    #recordedAudio{
        vertical-align: middle;
        margin-left: 10px;
    }
    @keyframes blinker {
        50% {
            opacity: 0;
        }
    }
</style>


<section class="content">
			<div class="row">			  
				<div class="col-lg-12 col-12">
					  <div class="box">
						
						<!-- /.box-header -->
                        <form method="post" action="{{url('/ivr')}}" enctype="multipart/form-data" class="edit_ivr_form">
                            @csrf
                            <input type="hidden" class="form-control" name="id" value="{{isset($ivr_data->id) ? $ivr_data->id : "0"}}" id ="id" required>
                                <input type="hidden" class="form-control" name="old_ann_id" value="{{isset($ivr_data->ann_id) ? $ivr_data->ann_id : "0"}}" id="ann_id" required>
							<div class="box-body">
								<!-- <h4 class="box-title text-info mb-0"><i class="fa fa-edit me-15"></i> Edit Campaign</h4> -->
                                <!-- <a href="{{url('/ivr')}}" type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-eye fa-sx"></i> IVR</a> -->
                                <h4 class="box-title text-info mb-0"><i class="fa fa-edit me-15"></i> ADD IVR</h4>
                                <a href="{{url('/ivr')}}" type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-eye fa-sx"></i> IVR</a>
								<hr class="my-15">
								<div class="row">
								  <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-label">Audio File Description </label>
                                            <div class="input-group mb-3">
                                                <span class="input-group-text"><i class="ti-user"></i></span>
                                                <input value="{{isset($ivr_data->ivr_desc) ? $ivr_data->ivr_desc : ""}}" type="text" class="form-control" required  name="ivr_desc" id="ivr_desc" placeholder="IVR DESC">
                                            </div>
                                        </div>
								  </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="form-label"> Method :</label>
                                                <div class="c-inputs-stacked ">
                                                    <input  type="radio" id="ivr_audio_option_upload_file"name="ivr_audio_option" value="upload" checked onclick="selectIvrUploadFileOption('upload_file_div');"/>
                                                    <label for="ivr_audio_option_upload_file">Upload File</label>
                                                    <input type="radio" id="ivr_audio_option_audio" name="ivr_audio_option" value="text_to_speech" onclick="selectIvrUploadFileOption('text_to_speech_div');">
                                                    <label for="ivr_audio_option_audio">Convert Text to Audio</label>
                                                </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group row" id="upload_file_div">
                                    <div class="col-md-6">
                                        <label for="" class="col-form-label">Upload File<span style="color:red;">* &nbsp; (Only mp3 or wav file type is allowed)</span></label>
                                        <input type="file" accept="audio/*"  class="form-control"   name="ann_id"  placeholder="Please Upload file"  />
                                    </div>
                                </div>
                                <div  id="text_to_speech_div" style="display: none;">

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="" class="form-label">Language</label>
                                        <select id="language_ddl" name="language" class="form-select" onchange="selectVoiceNameOnLanugageChange();">
                                            <option value="">--Select Language--</option>
                                            @foreach($arrLang as $key => $val)
                                            <option {{isset($ivr_data->language) && $ivr_data->language == base64_decode($key) ? "selected='selected'" : ""}} value="{{$key}}">{{base64_decode($key)}}</option>
                                            @endforeach
                                        </select>
                                </div>
                            </div>
                                <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="" class="form-label">Voice Name</label>
                                            <select id="voice_name_ddl" name="voice_name" class="form-select">
                                                <option value="">--Select Voice Name--</option>
                                            </select>
                                        </div>
                                </div>
                        </div>
                                

                                <input type="hidden" value ="{{isset($ivr_data->pitch) ? $ivr_data->pitch : "0"}}" id="pitch_value" name="pitch_value">
                            <input type="hidden" value ="{{isset($ivr_data->speed) ? $ivr_data->speed : "1"}}" id="speed_value" name="speed_value">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Speed</label><span style="float:right;">Value: <span id="speed_id"></span></span>
                                    <div class="input-group">
                                        <input style="cursor: pointer;" type="range" min="0" max="4" value="{{isset($ivr_data->speed) ? $ivr_data->speed : "1"}}" class="slider" id="mySpeed">
                                        
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Pitch</label><span style="float:right">Value: <span id="pitch_id"></span></span>
                                    <div class="input-daterange input-group col-md-12">
                                        <input style="cursor: pointer;" type="range" min="-20" max="20" value="{{isset($ivr_data->pitch) ? $ivr_data->pitch : "0"}}" class="slider" id="myPitch">
                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">                           
                            <div class="col-sm-10" style="padding-top: 10px;">
                               <label for="" class="col-form-label">Text </label>
                               <textarea id="speech_text" class="form-control" name="speech_text"
                                   placeholder="Type what you like your customers to hear and click on Listen button to listen">{{isset($ivr_data->speech_text) ? $ivr_data->speech_text : ""}}</textarea>
                               <audio style="display:none;" id="test_audio" controls preload ='none'>
                                   <source src="" type='audio/mp3'>
                               </audio>
                            </div>
                           <div class="col-sm-2" style="padding-top: 30px;">
                               <a class="btn btn-primary" href="javascript:void(0);" onclick="getAudioOnText();"style="margin-top:22px;">Listen</a>
                           </div>
                       </div>
                       <div class="form-group row" id="record_audio" style="display: none;">
                                    <div class="col-sm-6">
                                        <button type="button" id="record" class="btn"><i class="fa fa-microphone"></i></button>
                                        <button type="button" id="stopRecord" class="btn" disabled><i class="fa fa-stop"></i></button>
                                        <span class="recording-status">Voice recording...</span>
                                        <audio id=recordedAudio></audio>
                                    </div>
                        </div>
                            </div>
                                  
                            </div>
                        

                          
                      
                          
                           
							<!-- /.box-body -->
							<div class="box-footer text-end">
								<a href="/campaign"><button type="button" class="btn btn-warning me-1">
								  <i class="ti-trash"></i></a> Cancel
								</button>
								<button type="submit" name="submit" value="add" class="btn btn-primary">
								  <i class="ti-save-alt"></i> Save
								</button>
							</div>  
						</form>
					  </div>
					  <!-- /.box -->			

                    </div>  
                    </div>
		
		  </div>
		  <!-- /.row -->

		</section>


<script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>

<script>
var slider1 = document.getElementById("mySpeed");
var output1 = document.getElementById("speed_id");
output1.innerHTML = slider1.value;

slider1.oninput = function() {
  output1.innerHTML = this.value;
document.getElementById("speed_value").value = this.value;


}

var slider2 = document.getElementById("myPitch");
var output2 = document.getElementById("pitch_id");
output2.innerHTML = slider2.value;

slider2.oninput = function() {
output2.innerHTML = this.value;
document.getElementById("pitch_value").value = this.value;

}
</script>
<script>

    $(document).ready(function () {
        setTimeout(function() {
            selectVoiceNameOnLanugageChange();
        }, 1000);

        $(".edit_ivr_form").submit(function () {
            if ($("#ivr_audio_option_audio").prop("checked") && !$("#test_audio").attr("src")) {
                toastr.info("Please listen to the audio before submitting");
                return false;
            }
        });

        var prompt_option = @if(isset($ivr_data->prompt_option)) @php echo $ivr_data->prompt_option @endphp @else"0"@endif;
        var voice_name = "@if(isset($ivr_data->voice_name))@php echo $ivr_data->voice_name @endphp@else 0 @endif";

        if(prompt_option == 2){
            $("#ivr_audio_option_audio_record").prop("checked", true);
            $("#upload_file_div").hide();
            $("#text_to_speech_div").hide();
            $("#record_audio").show();
        } else if(prompt_option == 1){
            $("#ivr_audio_option_audio").prop("checked", true);
            $("#upload_file_div").hide();
            $("#record_audio").hide();
            $("#text_to_speech_div").show();

            setTimeout(function() {
                selectVoiceNameOnLanugageChange(voice_name);
            }, 2000);
        } else{
            $("#ivr_audio_option_upload_file").prop("checked", true);
            $("#record_audio").hide();
            $("#upload_file_div").show();
            $("#text_to_speech_div").hide();
        }
    });

    function selectIvrUploadFileOption(option) {
        if (option == 'text_to_speech_div') {
            $("#text_to_speech_div").show();
            $("#upload_file_div").hide();
            $("#record_audio").hide();
        } else if(option == 'audio_record') {
            getAudioRecordPermission();
            $("#record_audio").show();
            $("#upload_file_div").hide();
            $("#text_to_speech_div").hide();
        } else {
            $("#upload_file_div").show();
            $("#text_to_speech_div").hide();
            $("#record_audio").hide();
        }
    }

    function selectVoiceNameOnLanugageChange(defaultSelected = null) {
        $.ajax({
            url:'/get-voice-name-on-lanugage',
            type: 'post',
            data: {
            'language': $('#language_ddl').val(),
            '_token': $('meta[name="csrf-token"]').attr('content') // Add the CSRF token here
        },
            success: function (response) {
                var html = '';
                $.each(response, function (index, value) {
                    var optionValue = value.language_code + " ## " + value.voice_name + " ## " + value.ssml_gender;
                    var optionView = value.voice_name + " (" + value.ssml_gender+") ";

                    html += '<option value="'+ optionValue +'" ';
                    html += (defaultSelected == optionValue) ? 'selected >' : '>';
                    html += optionView + '</option>';
                });
                $("#voice_name_ddl").html('');
                $("#voice_name_ddl").html(html);
            }
        });

    }

    function getAudioOnText() {
        if ($('#speech_text').val() == '') {
            toastr.error("Please Type Text");
            return;
        }
        if ($('#language_ddl').val() == '') {
            toastr.error("Please Select Language");
            return;
        }
        if ($('#voice_name_ddl').val() == '' || $('#voice_name_ddl').val() == null) {
            toastr.error("Please Select Voice Name");
            return;
        }

        $("#test_audio").attr('src', "");
        $.ajax({
            url:'/get-audio-on-text',
            type: 'post',
            data: {'language': $('#language_ddl').val(),
                'voice_name_ddl': $('#voice_name_ddl').val(),
                'speed': $('#speed_value').val(),
                'pitch': $('#pitch_value').val(),
                'speech_text': $('#speech_text').val(),
                '_token': $('meta[name="csrf-token"]').attr('content') // Add the CSRF token here
},
            
            success: function (response) {
                if (typeof (response.file) != 'undefined') {
                    var file = "{{env('FILE_UPLOAD_URL')}}" + "{{env('IVR_FILE_UPLOAD_FOLDER_NAME')}}" + "/" + response.file;
                     var d = new Date();
                    $("#test_audio").attr('src', file+"?"+d.getTime());
                    var x = document.getElementById("test_audio");
                    x.play();
                } else {

                }
            }
        });
    }

    function getAudioRecordPermission(){
        navigator.mediaDevices.getUserMedia({audio:true})
            .then(stream => {handlerFunction(stream)});
    }

    function handlerFunction(stream) {
        rec = new MediaRecorder(stream);
        rec.ondataavailable = e => {
            audioChunks.push(e.data);
            if (rec.state == "inactive"){
                let blob = new Blob(audioChunks,{type:'audio/wav'});
                recordedAudio.src = URL.createObjectURL(blob);
                recordedAudio.controls=true;
                recordedAudio.autoplay=true;
                sendData(blob)
            }
        }
    }

    function sendData(data) {
        var fd = new FormData();
        fd.append('data', data);

        $.ajax({
            url: '/save-recorded-audio',
            type: 'POST',
            data: fd,
            processData: false,
            contentType: false,
            success: function (response){
                // console.log(response);
            },
            error: function (response) {
                console.log(response);
            }
        });
    }

    record.onclick = e => {
        record.disabled = true;
        $(".recording-status").show();
        stopRecord.disabled=false;
        audioChunks = [];
        rec.start();
    }
    stopRecord.onclick = e => {
        record.disabled = false;
        stop.disabled=true;
        $(".recording-status").hide();
        rec.stop();
    }
</script>
@endsection
