@extends('layouts.app')
@section('title', 'Agent Status')

@section('content')
    <style>
        .extension-item {
            display: inline-block;
            margin-right: 5px;
            /* Adjust the margin as needed */
        }
    </style>
    <!-- Main content -->
    <section class="content">

        <div class="row">



            <div class="col-12">
                <div class="box">
                    <div class="box-body">

                        <h4 class="box-title text-info mb-0"><i class="fa fa-user fa-sx"></i> Agent Status</h4> ( <i
                            class="fa fa-refresh" aria-hidden="true"></i> refreshing in <span id="timer"></span> sec )
                        <hr class="my-15">
                        <div class="table-responsive">
                            {{-- <table id="tickets" class="table mt-0 table-hover no-wrap" data-page-size="10"> --}}
                            <table id="users-table" class="display table mt-0 table-hover" data-page-size="10""
                                style="width:100%">

                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Name</th>
                                        <th>Extension</th>
                                        <th>Campaign</th>
                                        <th>Lead Id</th>
                                        <th>Status</th>
                                        <th>Action</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($label_list as $key => $label_data)
                                        <tr>
                                            <th scope="row">{{ $key + 1 }}</th>
                                            <td>{{ $label_data->full_name }}</td>
                                            <td> {{ $label_data->extension }}</td>

                                            <td> {{ $label_data->title }}</td>
                                            <td>{{ $label_data->lead_id }}</td>
                                            <td>
                                                @if ($label_data->status == '0')
                                                    <span class="badge badge-sm badge-success">Ready For Calls</span>
                                                @elseif($label_data->status == '1')
                                                    <span class="badge badge-sm badge-success">In Call</span>
                                                @elseif($label_data->status == '2')
                                                    <span class="badge badge-sm badge-success">Hangup</span>
                                                @else
                                                    ($label_data->status == '3')
                                                    <span class="badge badge-sm badge-warning">Pause</span>
                                                @endif
                                            </td>


                                            <td>
                                                <a style="cursor:pointer;" title="Delete" class='openLabelDelete'
                                                    data-id="{{ $label_data->extension }}"><i class="fa fa-refresh"
                                                        title="Reset Extension"></i></a>
                                            </td>


                                        </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade" id="delete" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="myModalLabel">Confirm Delete</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>

                        <div class="modal-body">
                            <p>You are about to Reset <b><i class="title"></i></b> Extension.</p>
                            <p>Do you want to proceed?</p>
                            <input type="hidden" class="form-control" name="label_id" value="" id="label_id">

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                            <button type="submit"name="submit" class="btn btn-danger btn-sm deleteLabel">Delete</button>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->

    </section>
    <!-- /.content -->

    <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM="
        crossorigin="anonymous"></script>

    <script>
        $(".openLabelDelete").click(function() {
            var delete_id = $(this).data('id');
            $("#delete").modal('show');
            $("#label_id").val(delete_id);

        });




        $(document).on("click", ".deleteLabel", function() {

            //if(confirm("Are you sure you want to delete this?")){
            var delete_id = $("#label_id").val();
            //alert(delete_id);
            var el = this;
            $.ajax({
                url: 'deleteExtLiv/' + delete_id,
                type: 'get',
                //data:{'delete_id':delete_id},
                success: function(response) {
                    console.log(response);
                    window.location.reload(1);
                    toastr.success('Deleted Successfully.');
                }
            });

        });
    </script>

    <script>
        var counter = 16;
        var interval = setInterval(function() {
            counter--;
            $("#timer").html(counter);
            if (counter == 0) {
                clearInterval(interval);
                window.location.reload();
            }
        }, 1000);
    </script>

    <script>
        $(document).ready(function() {
            $('#users-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ url('extension_live') }}",
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex'
                    },
                    {
                        data: 'full_name',
                        name: 'full_name'
                    },
                    {
                        data: 'extension',
                        name: 'extension'
                    },
                    {
                        data: 'title',
                        name: 'title'
                    },
                    {
                        data: 'lead_id',
                        name: 'lead_id'
                    },
                    {
                        data: 'status',
                        name: 'status',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ],

language: {
    processing: `
        <span style="display:flex; align-items:center; justify-content:center; gap:8px;">
            <img src="https://i.gifer.com/ZZ5H.gif"
                 alt="Loading..." style="width:20px; height:20px;">
            Processing...
        </span>
    `
}
                
            });

            // Handle delete/reset button click
            $(document).on('click', '.openLabelDelete', function() {

                var delete_id = $(this).data('id');
                $("#delete").modal('show');
                $("#label_id").val(delete_id);

                // Show modal or perform AJAX call
            });
        });
    </script>
@endsection
