@extends('layouts.app')
@section('title', 'IP Setting')

@section('content')
<section class="content">
    <div class="row">       
        <div class="col-12">
        <div class="box">
                          
            <div class="box-body"><!--bg-lightest-->
                <h4 class="box-title text-info mb-0"><i class="fa fa-user fa-sx"></i> IP Approval List</h4>
                <a href="{{ url('/whitelist-ip') }}" type="submit" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-eye"></i>Whitelist IP</a>
                <hr class="my-15">



                <div class="row">
                <div class="col-md-2">
                    <div class="form-group @error('name') has-error @enderror">
                    <label class="form-label">IP</label> 
                        <div class="input-group mb-3">
                            <span class="input-group-text @error('name') text-danger border-danger @enderror"><i class="fa fa-laptop"></i></span>
                            <input type="text" name="whitelistIp" id="whitelistIp" class="form-control" data-inputmask="'alias': 'ip'" data-mask  value="" />
                        </div>
                    </div>
                </div>

            
                <div class="col-md-2">
                    <div class="form-group @error('list_id') has-error @enderror">
                    <label class="form-label">Server</label>
                        <div class="input-group mb-3">
                                            <select class="form-select" name="asteriskServer" id="asteriskServer" data-placeholder="Server">
                                                <option value="" >All</option>
                                                @if(!empty($asteriskServers))
                                                    @foreach($asteriskServers as $server)
                                                        <option value='{{$server->host}}' >{{$server->host}} - {{$server->location}} - {{$server->trunk}}</option>
                                                    @endforeach
                                                @endif
                                            </select>
                        </div>
                    </div>
                </div>
        
                <div class="col-md-2">
                    <div class="form-group @error('list_id') has-error @enderror">
                    <label class="form-label">Status</label>
                    <div class="input-group mb-3">
                                            <select class="form-select" name="status" id="status" data-placeholder="Status">
                                                <option value=0>Pending</option>
                                                <option value=1>Approved</option>
                                                <option value=-1>Rejected</option>
                                            </select>
                    </div>
                    </div>
                </div> 
        
        
                    <div class="col-md-2">
                        <div class="form-group @error('list_id') has-error @enderror">
                        <label class="form-label">From Web</label>
                            <div class="input-group mb-3">
                                                    <select class="form-select" name="fromWeb" id="fromWeb" data-placeholder="From Web">
                                                        <option value="">All</option>
                                                        <option value=1>Yes</option>
                                                        <option value=0>No</option>
                                                    </select>
                            </div>
                        </div>
                    </div> 
                    <div class="col-md-2">
                        <div class="form-group @error('list_id') has-error @enderror">
                        <label class="form-label"></label>
                        <div class="input-group mb-3"style="margin-top:8px;">
                        <input type="button" id="search" value="Search" class="btn btn-primary btn-md" />

                        </div>
                        </div>
                    </div> 
                </div> 
            </div>  
        </div>
    </div>

        <div class="row">    
            <div class="col-12">
            <div class="box">
               <div class="box-body">   
    <div class="d-flex justify-content-start align-items-center mb-2 gap-4">
    <div>
        <b>Total Rows: <span id="totalRows">0</span></b>
    </div>
    <div class="d-flex align-items-center">
        <label class="me-2" for="show">Show:</label>
        <select id="showEntries" class="form-select-sm me-2" onchange="updatePageSize(this.value)">
            <option value="10" selected>10</option>
            <option value="25">25</option>
            <option value="50">50</option>
            <option value="100">100</option>
        </select>
        <label for="entries">entries</label>
    </div>
</div>

        
                <div class="table-responsive">
                    <table  id="tickets1" class="table mt-0 table-hover no-wrap">
                    <thead>
                        <tr>
                                        <th>Time</th>
                                        <th>Server</th>
                                        <th>User</th>
                                        <th>IP Address</th>
                                        <th>Location</th>
                                        <th>From Web</th>
                                        <th>Actions</th>

                                </tr>
                    </thead>
                    <tbody id="result">
                    </tbody>
                    </table>
                    <!-- Your pagination controls -->
<div class="d-flex justify-content-between align-items-center mt-2">
    <div id="pageInfo">Showing 0 - 0 of 0 entries</div>
    <div>
        <button class="btn btn-primary btn-sm" id="prevPage">Previous</button>
        <button class="btn btn-primary btn-sm" id="nextPage">Next</button>
    </div>
</div>

                </div>
                </div>
            </div>
            </div>
    
            </div>
            <div class="modal fade" id="confirm" tabindex="-1" aria-labelledby="confirmLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="myModalLabel">Confirm</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <div class="modal-body">
                <p>Please confirm you want to <span id="confirm-action" class=""></span> ip <b><span id="confirm-ip"></span></b>.</p>
                                <div id="message">
                                </div>
                
                </div>
                <div class="modal-footer">
                <input type="hidden" id="server_ip" value="" />
                <input type="hidden" id="whitelist_ip" value="" />
                
                    <button type="button" class="btn btn-success btn-sm" data-bs-dismiss="modal"id="btn-approve">Approve</button>
                    <button type="button" class="btn btn-danger btn-sm" data-bs-dismiss="modal"id="btn-reject">Reject</button>
                    <button type="button" class="btn btn-info btn-sm" data-bs-dismiss="modal">Close</button>

                </div>
                </div>
            </div>
            </div>
        </div>
        <!-- /.row -->
        </form>
    </section>
        <!-- /.content -->

        <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>
        <script src="https://cdn.jsdelivr.net/npm/imask"></script>
<script>
      var phoneInput = document.getElementById('whitelistIp');
    var phoneMask = new IMask(phoneInput, {
        mask: '000.00.00.000'
    }); 
    </script>
    <script type="text/javascript">
        $(document).ready(function () {

            searchIpList(1, 0, null, null);
            $("#search").click(function (e) {
                searchIpList($("#fromWeb").val(), $("#status").val(), $("#asteriskServer").val(), $("#whitelistIp").val());
            });
            //Pass false to the callback function
            $(".btn-no").click(function () {
                handler(false);
                $("#confirm").modal("hide");
            });

            $('#btn-approve').click(function (e) {
                $("#confirm").modal("hide");
                $.ajax({
                    type: "POST",
                    url: "/ip-approve-whitelist",
                    data: {
                        "_token": "{{ csrf_token() }}",
                        "serverIp": $("#server_ip").val(),
                        "whitelistIp": $("#whitelist_ip").val(),
                    },
                    dataType: "json",
                    success: function (data) {
                        console.log(data);
                        if (data.success) {
                            $("#alert-success").html(data.message).show();
                            setTimeout(function(){
                                window.location.reload(1);
                            }, 3000);
                        } else {
                            $("#alert-errors").html(data.message).show();
                        }
                    },
                    error: function (xhr, status, error) {
                        $("#alert-errors").html(error).show();
                    }
                });
            });
            $('#btn-reject').click(function (e) {
                $("#confirm").modal("hide");
                $.ajax({
                    type: "POST",
                    url: "/ip-reject-whitelist",
                    data: {
                        "_token": "{{ csrf_token() }}",
                        "serverIp": $("#server_ip").val(),
                        "whitelistIp": $("#whitelist_ip").val(),
                    },
                    dataType: "json",
                    success: function (data) {
                        console.log(data);
                        if (data.success) {
                            $("#alert-success").html(data.message).show();
                            setTimeout(function(){
                                window.location.reload(1);
                            }, 3000);
                        } else {
                            $("#alert-errors").html(data.message).show();
                        }
                    },
                    error: function (xhr, status, error) {
                        $("#alert-errors").html(error).show();
                    }
                });

                $("#confirm").modal("hide");
            });
        });

        function approveIp(server_ip, whitelist_ip) {
            $('#confirm-action').html("approve");
            $('#confirm-action').removeClass('text-red').addClass('text-green');
            $('#confirm-ip').html(whitelist_ip);

            $('#btn-reject').hide();
            $('#btn-approve').show();
            $('#server_ip').val(server_ip);
            $('#whitelist_ip').val(whitelist_ip);
            $('#confirm').modal('show');
        }

        function rejectIp(server_ip, whitelist_ip) {
            $('#confirm-action').html("reject");
            $('#confirm-action').addClass('text-red').removeClass('text-green');
            $('#confirm-ip').html(whitelist_ip);

            $('#btn-approve').hide();
            $('#btn-reject').show();
            $('#server_ip').val(server_ip);
            $('#whitelist_ip').val(whitelist_ip);
            $('#confirm').modal('show');
        }

        function searchIpListold(fromWeb, approvalStatus, asteriskServer, whitelistIp)
        {
            console.log('hlo');
            $('#search').prop('disabled', true);
            $("#result").html("<td colspan='7' class='centered-body'><img src='{{ asset("assets/images/loader-30px.gif") }}' /></td>");

            var postdata = {
                "_token": "{{ csrf_token() }}",
                "fromWeb": fromWeb,
                "approvalStatus": approvalStatus
            };
            if (asteriskServer) postdata.asteriskServer = asteriskServer;
            if (whitelistIp) postdata.whitelistIp = whitelistIp;

            $.ajax({
                type: "POST",
                url: "/query-whitelist",
                data: postdata,
                dataType: "json",
                success: function (response) {
                    if (response.success) {
                        var list = "";
                        var count = 0;
                        $.each(response.data, function (index, row) {
                            console.log(row);
                            var datetime = new Date(row.created_at);
                            var created_at = datetime.toLocaleString();
                            list += "<tr>";
                            list += "<td>" + created_at + "</td>";
                            list += "<td>" + row.server_ip + "</td>";
                            list += "<td>" + row.user + "</td>";
                            list += "<td>" + row.whitelist_ip + "</td>";
                            list += "<td>" + (row.ip_location?row.ip_location:'-') + "</td>";
                            list += "<td>" + (row.from_web?'Yes':'No') + "</td>";
                            if (row.approval_status === 0) {
                                list += "<td>";
                                list += "<a style=\"cursor:pointer;color:green;\" href=\"javascript:approveIp('"+row.server_ip+"','"+row.whitelist_ip+"');\"><i class=\"fa fa-check fa-lg\"></i></a> <span style=\"padding: 0px 10px;\"></span>";
                                list += "<a style=\"cursor:pointer;color:red;\" href=\"javascript:rejectIp('"+row.server_ip+"','"+row.whitelist_ip+"');\"><i class=\"fa fa-remove fa-lg\"></i></a>";
                                list += "</td>";
                            } else if (row.approval_status === 1) {
                                list += "<td>Approved ("+row.approvedBy+")</td>";
                            } else if (row.approval_status === -1) {
                                list += "<td>Rejected ("+row.approvedBy+")</td>";
                            } else {
                                list += "<td></td>";
                            }
                            list += "</tr>";
                            count++;
                        });
                        if (count > 0) {
                            $("#result").html(list);
                        } else {
                            $("#result").html("<td colspan='7' class='centered-body'>No data available</td>");
                        }
                    } else {
                        var errors = response.message;
                        $.each(response.errors, function (index, row) {
                            errors += "<br/>" + row;
                        });
                        $("#result").html("<td colspan='7' class='centered-body'>"+errors+"</td>");
                    }
                    $('#search').prop('disabled', false);
                },
                error: function (xhr, status, error) {
                    $("#result").html("<td colspan='7' class='centered-body'>"+error+"</td>");
                    $('#search').prop('disabled', false);
                }
            });
        }

   let currentPage = 1;
let pageSize = 10;
let totalRecords = 0;

function searchIpList(fromWeb, approvalStatus, asteriskServer, whitelistIp) {
    $('#search').prop('disabled', true);
    $("#result").html("<td colspan='7' class='centered-body'><img src='{{ asset('assets/images/loader-30px.gif') }}' /></td>");

    const lower_limit = (currentPage - 1) * pageSize;
    const upper_limit = pageSize;

    const postData = {
        _token: "{{ csrf_token() }}",
        fromWeb: fromWeb,
        approvalStatus: approvalStatus,
        lower_limit: lower_limit,
        upper_limit: upper_limit
    };

    if (asteriskServer) postData.asteriskServer = asteriskServer;
    if (whitelistIp) postData.whitelistIp = whitelistIp;

    $.ajax({
        type: "POST",
        url: "/query-whitelist",
        data: postData,
        dataType: "json",
        success: function (response) {
            $('#search').prop('disabled', false);

            if (response.success) {
                totalRecords = response.total ?? response.data.length;
                $("#totalRows").text(totalRecords);

                const data = response.data || [];
                if (data.length === 0) {
                    $("#result").html("<td colspan='7' class='centered-body'>No data available</td>");
                    updatePageInfo();
                    return;
                }

                let list = "";
                $.each(data, function (index, row) {
                    const datetime = new Date(row.created_at).toLocaleString();
                    list += "<tr>";
                    list += "<td>" + datetime + "</td>";
                    list += "<td>" + row.server_ip + "</td>";
                    list += "<td>" + row.user + "</td>";
                    list += "<td>" + row.whitelist_ip + "</td>";
                    list += "<td>" + (row.ip_location ? row.ip_location : '-') + "</td>";
                    list += "<td>" + (row.from_web ? 'Yes' : 'No') + "</td>";

                    if (row.approval_status === 0) {
                        list += "<td>";
                        list += "<a style='cursor:pointer;color:green;' onclick=\"approveIp('" + row.server_ip + "','" + row.whitelist_ip + "')\"><i class='fa fa-check fa-lg'></i></a>";
                        list += " <span style='padding: 0px 10px;'></span>";
                        list += "<a style='cursor:pointer;color:red;' onclick=\"rejectIp('" + row.server_ip + "','" + row.whitelist_ip + "')\"><i class='fa fa-remove fa-lg'></i></a>";
                        list += "</td>";
                    } else if (row.approval_status === 1) {
                        list += "<td>Approved (" + row.approvedBy + ")</td>";
                    } else if (row.approval_status === -1) {
                        list += "<td>Rejected (" + row.approvedBy + ")</td>";
                    } else {
                        list += "<td></td>";
                    }

                    list += "</tr>";
                });

                $("#result").html(list);
                updatePageInfo();
            } else {
                $("#result").html("<td colspan='7' class='centered-body'>" + (response.message || "Error") + "</td>");
            }
        },
        error: function (xhr, status, error) {
            $('#search').prop('disabled', false);
            $("#result").html("<td colspan='7' class='centered-body'>" + error + "</td>");
        }
    });
}

function updatePageInfo() {
    const start = (currentPage - 1) * pageSize + 1;
    const end = Math.min(currentPage * pageSize, totalRecords);
    $("#pageInfo").text(`Showing ${start} - ${end} of ${totalRecords} entries`);
}

function triggerSearch() {
    const fromWeb = $("#fromWeb").val();
    const approvalStatus = $("#status").val();
    const asteriskServer = $("#asteriskServer").val();
    const whitelistIp = $("#whitelistIp").val();
    searchIpList(fromWeb, approvalStatus, asteriskServer, whitelistIp);
}


function updatePageSize(value) {
    pageSize = parseInt(value);
    currentPage = 1;
    triggerSearch();
}

// Pagination Buttons
$("#prevPage").click(function () {
    if (currentPage > 1) {
        currentPage--;
        triggerSearch();
    }
});

$("#nextPage").click(function () {
    if (currentPage * pageSize < totalRecords) {
        currentPage++;
        triggerSearch();
    }
});

// Initial Load
$(document).ready(function () {
    triggerSearch();

    $("#search").click(function () {
        currentPage = 1;
        triggerSearch();
    });
});

</script>

    </script>

@endsection
