@extends('layouts.app')
@section('title', ' Whitelist an IP')

@section('content')
<section class="content">
  <div class="row">       
    <div class="col-12">
      <div class="box">
       <div class="box-header with-border">            
              <h4 class="box-title"><i class="fa fa-user fa-sx"></i> Whitelist an IP</h4>
              <a href="{{ url('/ip-setting') }}" type="submit" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-eye"></i>IP Approval List</a>
             
            </div>



          <div class="box-body"><!--bg-lightest-->
          


          <form method="post" name="userform" id="userform" action="">
                                @csrf
            <div class="row">
              <div class="col-md-3">
                <div class="form-group @error('name') has-error @enderror">
                  <label class="form-label">IP Address</label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('name') text-danger border-danger @enderror"><i class="fa fa-laptop"></i></span>
                    <input type="text" name="whitelistIp" id="whitelistIp" class="form-control" pattern="[0-9]+(\.[0-9]+){3}" title="Please enter a valid IP address"  value="{{ old('whitelistIp') }}" />

                </div>
                </div>
              </div>

           
              <div class="col-md-3">
                <div class="form-group @error('list_id') has-error @enderror">
                <?php $oldServer = empty(old("asteriskServers"))?[]:old("asteriskServers") ?>
                  <label class="form-label">Server</label>
                  <div class="input-group mb-3">
                  <select class="form-control select2" multiple name="asteriskServers[]" id="asteriskServers" data-placeholder="Asterisk Servers" style="width: 100%;">
                                                        @if(!empty($asteriskServers))
                                                            @foreach($asteriskServers as $server)
                                                                <option value="{{$server['id']}}" @if(in_array($server["id"], $oldServer)) {{ "selected" }} @endif >{{$server["host"]}} - {{$server["location"]}} - {{$server["trunk"]}}</option>
                                                            @endforeach
                                                        @endif
                                                    </select>
                  </div>
                </div>
              </div>
      
         
    
      
      
              <div class="col-md-3">
                <div class="form-group @error('list_id') has-error @enderror">
                  <label class="form-label"></label>
                  <div class="input-group mb-3">
                  <button type="submit" name="submit" value="add" class="btn btn btn-primary waves-effect waves-light btn-md">Whitelist</button>

                  </div>
                </form>
                </div>
              </div> 
              </div> 
      <!-- /.row -->
     <!-- /.box-body -->
   
            <!-- /.box -->      
        </div>  

    </section>

        <!-- /.content -->

        <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>

   
@endsection
