@extends('layouts.app')
@section('title', 'Ivr Menu')

@section('content')

<!-- Main content -->
<section class="content">
<div class="col-md-12">
<!-- Default box -->
<div class="box">
<!--  <div class="box-header with-border">            
              <h4 class="box-title"><i class="fa fa-user fa-sx"></i> IVR Menu</h4>
              <a href="{{url('/ivr-menu/0')}}"   type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-plus"></i>Add IVR</a>

            </div> -->
            @if($ivr_id > -1)
<div class="row">
  <div class="box-header with-border" style="padding:2px 10px; box-sizing:border-box; width:100%; overflow:hidden;">
    <h4 class="box-title text-info mb-0"style="padding:10px;"  id="add_edit_box_header">Add / Edit IVR Menu of {{isset($ivr_menu_details[0]->ivr_desc) ? $ivr_menu_details[0]->ivr_desc : ""}}</h4>
    <ul class="box-controls pull-right">
      <li><a class="box-btn-slide" href="#"></a></li>	
    </ul>

  </div>

<style>
#add_edit_box_header {
  border-bottom: 1px solid #ddd;
  padding-bottom: 5px;
  display: block;
  width: 100%;
  margin: 0;
}

.with-border {
  border-bottom: none !important;
}
</style>


  
  <div class="box-body">
                <div class="table-responsive">
                    <form method='POST' action='{{url('/')}}/edit-ivr-menu'>
                                    <table class="table mt-0 table-hover no-wrap" {{count($ivr_menu_details) > 0 ? "style=display:none;": ""}}>
                                        <thead>
                                            <th>Select IVR</th>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <select id="ivr_select" class="form-select">
                                                        <!--show disabled only on add new ivr page-->
                                                        @if(count($ivr_menu_details) > 0)
                                                            @foreach($arrIvr as $key => $val)
                                                                <option {{$ivr_id > 0 && $ivr_id == $key ? "selected=selected" : ''}} value='{{$val['id']}}'>{{$val['desc']}}</option>
                                                            @endforeach
                                                        @else
                                                            @foreach($arrIvr as $key => $val)
                                                                <option {{$val['ivr_has_menu'] == 1 ? "disabled=disabled  style=background-color:lightgray;": ""}} {{$ivr_id > 0 && $ivr_id == $key ? "selected='selected'" : ''}} value='{{$val['id']}}'>{{$val['desc']}}</option>
                                                            @endforeach
                                                        @endif
                                                    </select>
                                                    <input type='hidden' name='ivr' id='ivr_input' value='{{$ivr_id > 0 ? $ivr_id : 0}}'/>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    @csrf
                            <table class="table mt-0 table-hover  no-wrap" >
                                <thead>
                                    <tr>
                                            <th>DTMF</th>
                                            <th>DTMF Title</th>

                                            <th>Destination Type</th>
                                            <th>Destination </th>
                                            <th>Action</th>
                                            </tr>
                                </thead>
                                <tbody id="ivr_level_body">
                                @if(count($ivr_menu_details) > 0)
                                                                @php
                                                                    $i = 0;
                                                                @endphp
                                                                @foreach($ivr_menu_details as $ivr_menu_detail)
                                
                                                <tr>
                                                                    <td>
                                                                        <input type="hidden" name="ivr_menu_id[]" value="{{isset($ivr_menu_detail->ivr_m_id) && $ivr_menu_detail->ivr_m_id > 0 ? $ivr_menu_detail->ivr_m_id : '0'}}" />
                                                                            <select class="form-select" name='dtmf[]'>
                                                                                @foreach($arrDtmf as $key => $val)
                                                                                    <option {{isset($ivr_menu_detail->dtmf) && $ivr_menu_detail->dtmf == $key ? "selected='selected'" : ''}} value='{{$key}}'>{{$val}}</option>
                                                                                @endforeach
                                                                            </select>
                                                                    </td>

                                                                    <td> <input value="{{$ivr_menu_detail->dtmf_title}}"  class="form-control" type="" name="dtmf_title[]" /></td>  
                                                <td> <select class="form-select dest_type" name='dest_type[]'>
                                                                                @foreach($arrDestType as $key => $val)
                                                                                    @php
                                                                                        $seletedDestination = '0';
                                                                                        if(isset($ivr_menu_detail->dest_type)) {
                                                                                            $seletedDestination = $ivr_menu_detail->dest_type;
                                                                                        }
                                                                                    @endphp
                                                                                    <option {{isset($ivr_menu_detail->dest_type) && $ivr_menu_detail->dest_type == $key ? "selected='selected'" : ''}} value='{{$key}}'>{{$val}}</option>
                                                                                @endforeach
                                                                            </select>
                                                                        </td>                        
                                                                            <td id="destinationTd" class="destTd">
                                                                            @if($seletedDestination == 0)
                                                                                <select class="form-select"  name='dest[]'>
                                                                                    @foreach($arrIvr as $key => $val)
                                                                                        <option {{isset($ivr_menu_detail->dest) && $ivr_menu_detail->dest == $key ? "selected='selected'" : ''}} value='{{$val['id']}}'>{{$val['desc']}}</option>
                                                                                    @endforeach
                                                                                </select>
                                                                            @elseif($seletedDestination == 1 || $seletedDestination == 2)
                                                                                <select class="form-select"  name='dest[]'>
                                                                                    @foreach($extensionOptions as $ext)
                                                                                        <option {{isset($ivr_menu_detail->dest) && $ivr_menu_detail->dest == $ext->extension ? "selected='selected'" : ''}} value='{{$ext->extension}}'>{{$ext->name}} - {{$ext->extension}}</option>
                                                                                    @endforeach
                                                                                </select>
                                                                            @elseif($seletedDestination == 4)
                                                                                <select class="form-select"  name='country_code[]'>
                                                                                    @foreach($countryCodeOptions as $code)
                                                                                        <option {{isset($ivr_menu_detail->dest) && $ivr_menu_detail->dest == $code->phonecode ? "selected='selected'" : ''}} value='{{$code->phonecode}}'>{{$code->phonecode}} - {{$code->name}}</option>
                                                                                    @endforeach
                                                                                </select>
                                                                            &nbsp;<input type="text" class="form-control" name="dest[]" value="{{isset($ivr_menu_detail->dest) ? $ivr_menu_detail->dest : ''}}" />
                                                                            @elseif($seletedDestination == 5)
                                                                                <select class="form-select"  name='dest[]'>
                                                                                    @foreach($conferenceOptions as $conf)
                                                                                        <option {{isset($ivr_menu_detail->dest) && $ivr_menu_detail->dest  == $conf->id ? "selected='selected'" : ''}} value='{{$conf->id}}'>{{$conf->title}}</option>
                                                                                    @endforeach
                                                                                </select>
                                                                            @elseif($seletedDestination == 8)
                                                                            <select class="form-select" name='dest[]'>
                                                                                @foreach($ringGroupOptions as $ring)
                                                                                    <option {{isset($ivr_menu_detail->dest) && $ivr_menu_detail->dest == $ring->id ? "selected='selected'" : ''}} value='{{$ring->id}}'>{{$ring->title}} - {{$ring->description}}</option>
                                                                                @endforeach
                                                                            </select>
                                                                            @else
                                                                            <select style="display:none" class="form-select" name="dest[]"><option value="0"></option></select>
                                                                            @endif
                                                                        </td>     
                                                                        @if($i == count($ivr_menu_details) - 1)
                                                                            <td>
                                                                                <button type="button" class="btn btn-success"onclick="addIvrRow();" title="Add More IVR Menu"><i class="fa fa-plus"></i></button>
                                                                            </td>
                                                                        @endif                           
                                                                    </tr>
                                                                    @php
                                                                        $i++;
                                                                    @endphp
                                                                @endforeach
                                                            @else
                                                            <tr>
                                                                    <td>
                                                                        <input type="hidden" name="ivr_menu_id[]" value="0" />
                                                                        <select class="form-select" name='dtmf[]'>
                                                                            @foreach($arrDtmf as $key => $val)
                                                                                <option value='{{$key}}'>{{$val}}</option>
                                                                            @endforeach
                                                                        </select>
                                                                    </td>

                                                                     <td> <input class="form-control" type="" name="dtmf_title[]" /></td>


                                                                    <td>
                                                                        <select class="form-select dest_type" name='dest_type[]'>
                                                                            @foreach($arrDestType as $key => $val)
                                                                                <option value='{{$key}}'>{{$val}}</option>
                                                                            @endforeach
                                                                        </select>
                                                                    </td>
                                                                    <td id="destinationTd" class="destTd">
                                                                        <select class="form-select"  name='dest[]'>
                                                                            @foreach($arrIvr as $key => $val)
                                                                                <option value='{{$val['id']}}'>{{$val['desc']}}</option>
                                                                            @endforeach
                                                                        </select>
                                                                    </td>
                                                                    <td>
                                                                        <button type="button" class="btn btn-success"onclick="addIvrRow();" title="Add More IVR Menu"><i class="fa fa-plus"></i></button>
                                                                    </td>
                                                                </tr>
                                                            @endif
                                        
                                </tbody>
                            </table>
                            <div class="box-footer text-end">
                            <button class="btn btn-primary btn-md" type="submit">
                                                                        <i class="fa fa-check-square-o"></i> 
                                                                        Submit
                                                                    </button>
                                                                    &nbsp;
                                                                    <a type="button" class="btn btn-warning btn-md"  onclick="window.location.reload();">
                                                                        <i class="fa fa-refresh"></i> 
                                                                        Reset
                                                                    </a>
                                                                    &nbsp;
                                                                    <a type="button" class="btn btn-danger btn-md" href="{{url('/ivr-menu')}}">
                                                                        <i class="fa fa-reply"></i> 
                                                                        Cancel
                                                                    </a>
                                                                                    </div>
                                                     
                    </form>
                </div>
  </div>
  <!-- /.box-body -->
</div>
@else
             <div class="box-header with-border mt-5">            
              <h4 class="box-title text-info mb-0"><i class="fa fa-user fa-sx"></i> IVR Menu</h4>
              <a href="{{url('/ivr-menu/0')}}"   type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-plus"></i>Add IVR</a>

            </div>
            </div>
            </div>
        @endif
             <!-- ivr parent div  -->
             @if(count($ivr_menu_details) == 0 && $ivr_id == -1)
            @foreach($arrIvrMenu as $key => $val)
                @if(isset($val[0]['dtmf']) && $val[0]['dtmf'] != '' 
                                            && isset($val[0]['is_deleted']) && $val[0]['is_deleted'] != 1)
                                            <div class="box collapsed-box">

                                            <div class="col-md-12">
                    <div class="box">
                        <div class="row">
                            <div class="col-xs-12">
                                <div class="box-header with-border"style="padding:10px;">
                                    <h4 class="box-title">{{isset($val[0]['ivr_desc']) ? $val[0]['ivr_desc'] : ''}}</h4>
                                    <ul class="box-controls pull-right">
                                    <li><a class="box-btn-slide" href="#"></a></li>	
                                    </ul>

                                </div>
                                <div class="box-body">
                                    <div class="table-responsive">
                                        <table class="table mt-0 table-hover table-striped no-wrap">
                                            <tbody>
                                            <tr>
                                                <th>DTMF</th>
                                                <th>Destination Type</th>
                                                <th>Destination</th>
                                                <th>Delete</th>
                                            </tr>
                                                @foreach($val as $arr)
                                                    <tr id='ivr_menu_row_{{$arr['ivr_m_id']}}'>
                                                 <td>{{$arr['dtmf_title']}} ({{$arr['dtmf']}})</td>

                                                        <td>{{isset($arrDestType[$arr['dest_type']]) ? $arrDestType[$arr['dest_type']] : '' }}</td>
                                                        <td>
                                                            @if(isset($arr['dest_type']) )
                                                                @if($arr['dest_type'] == 0 || $arr['dest_type'] == 4)
                                                                    {{$arr['dest']}}
                                                                @elseif($arr['dest_type'] == 1 || $arr['dest_type'] == 2)
                                                                    @foreach($extensionOptions as $ext)
                                                                        {{$ext->extension == $arr['dest'] ? $ext->name.' - '.$ext->extension : ""}}
                                                                    @endforeach
                                                                @elseif($arr['dest_type'] == 5)
                                                                    @foreach($conferenceOptions as $conf)
                                                                        {{$conf->id == $arr['dest'] ? $conf->title : ""}}
                                                                    @endforeach
                                                                @elseif($arr['dest_type'] == 8)
                                                                    @foreach($ringGroupOptions as $ring)
                                                                        {{$ring->id == $arr['dest']  ? $ring->description.' - '.$ring->title : ""}}
                                                                    @endforeach
                                                                @else
                                                                    {{$arr['dest']}}
                                                                @endif
                                                            @endif
                                                        </td>
                                                        <td>
                                                            <button onclick="deleteIvrMenu('{{$arr['ivr_m_id']}}');" class="btn btn-danger">
                                                            <i class="fa fa-trash-o"></i></button>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                    <td colspan="4">
                                                        <a type="button" href="{{url('/')}}/ivr-menu/{{$arr['ivr_id']}}" class="btn btn-primary btn-md" style="float:right;">
                                                            <i class="fa fa-edit "></i> 
                                                            Edit
                                                        </a>
                                                    </td>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        </div>
                    </div>
                    </div>
                @endif
            <!-- ivr parent div ends -->
            @endforeach
        @endif


<!-- /.box -->	
</section>
<script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>

<script language="javascript">
    
    var dtmf_options = '';
    var ivr_options = '';
    var dest_type_options = '';
    
    @foreach($arrDtmf as $key => $val)
        dtmf_options += "<option value='{{$key}}'>{{$val}}</option>";
    @endforeach
    
    @foreach($arrIvr as $key => $val)
        ivr_options += "<option value='{{$val['id']}}'>{{$val['desc']}}</option>";
    @endforeach                                                
    
    @foreach($arrDestType as $key => $val)
        dest_type_options += "<option value='{{$key}}'>{{$val}}</option>";
    @endforeach
    
    /*******conf options******/
    var conf_options = '';
    @foreach($conferenceOptions as $conf)
        conf_options += "<option value='{{$conf->id}}'>{{$conf->title}}</option>";
    @endforeach
    
    var ring_group_options = '';
    @foreach($ringGroupOptions as $ring)
        ring_group_options += "<option value='{{$ring->id}}'>{{$ring->title}} - {{$ring->description}}</option>";
    @endforeach
    
    var ext_options = '';
    @foreach($extensionOptions as $ext)
        ext_options += "<option value='{{$ext->extension}}'>{{$ext->name}} - {{$ext->extension}}</option>";
    @endforeach
    
    var country_code_options = '';
    @foreach($countryCodeOptions as $code)
        country_code_options += "<option value='{{$code->phonecode}}'>{{$code->phonecode}} - {{$code->name}}</option>";
    @endforeach
    /*******conf options******/
    
    $(document).ready(function() {
        
        $(document).on( 'change', '.dest_type', function(){
            var html = setDestInput($(this));
            $(this).parent().parent().find('.destTd').html(html);
        });
        
        //Set header box title on DDL change
        $("#ivr_select").on('change', function(){
            $("#add_edit_box_header").text("Add/Edit IVR menu : "+$('#ivr_select :selected').text());
            $("#ivr_input").val($("#ivr_select").val());
        });
        
        //Set header box title on page load
        $("#add_edit_box_header").text("Add/Edit IVR menu : "+$('#ivr_select :selected').text());
        $("#ivr_input").val($("#ivr_select").val());
    });
    
    /**
    * Function to add new row on add more
    */
    function addIvrRow() {
        var html ='<tr>\n\
<td><input type="hidden" name="ivr_menu_id[]" value="0" /><select class="form-select" name="dtmf[]">'+dtmf_options+'</select></td>\n\
<td><input type="text" class="form-control" name="dtmf_title[]"  /></td><td><select class="form-select dest_type" name="dest_type[]">'+dest_type_options+'</select></td>\n\
<td class="destTd"><select class="form-select" name="dest[]">'+ivr_options+'</select></td>\n\
<td><button onclick="$(this).parent().parent().remove();" class="btn btn-danger"><i class="fa fa-trash-o"></i></button></td></tr>';
        $('#ivr_level_body').append(html);
    }
    
    /**
     * Function to delete iver menu from list
     */
    function deleteIvrMenu(delete_id) {
        if(confirm("Are you sure want to delete this Ivr Menu?")) {
            $.ajax({
                url: 'deleteIvrMenu/' + delete_id,
                type: 'get',
                success: function(response) {
                    $("#ivr_menu_row_"+delete_id).hide();
                    toastr.success(response);
                    window.location.reload();
                },
                error: function(response) {
                    toastr.error(response);
                }
            });
        }
    }
    
    /**
    * Return destination input html
    */
    function setDestInput(inp) {
        var dest_type_id = inp.val();
        switch(dest_type_id) {
            case '0':
                return '<select class="form-select" name="dest[]">'+ivr_options+'</select>';
            break;
            case '1':
                return '<select class="form-select" name="dest[]">'+ext_options+'</select>';
            break;
            case '2':
                return '<select class="form-select" name="dest[]">'+ext_options+'</select>';
            break;
            case '3':
                return '<select style="display:none" class="form-select" name="dest[]"><option value="0"></option></select>';
            break;
            case '4':
                return '<select class="form-select" name="country_code[]">'+country_code_options+'</select>&nbsp;<input type="text" class="form-control" name="dest[]" />';
            break;
            case '5':
                return '<select class="form-select" name="dest[]">'+conf_options+'</select>';
            break;
            case '6':
                return '<select style="display:none" class="form-select" name="dest[]"><option value="0"></option></select>';
            break;
            case '7':
                return '<select style="display:none" class="form-select" name="dest[]"><option value="0"></option></select>';
            break;
            case '8':
                return '<select class="form-select" name="dest[]">'+ring_group_options+'</select>';
            break;
            case '9':
                return '<select style="display:none" class="form-select" name="dest[]"><option value="0"></option></select>';
            break;
            case '10':
                return '<select style="display:none" class="form-select" name="dest[]"><option value="0"></option></select>';
            break;
            case '11':
                return '<select style="display:none" class="form-select" name="dest[]"><option value="0"></option></select>';
            break;
            case '12':
                return '<select style="display:none" class="form-select" name="dest[]"><option value="0"></option></select>';
            break;
        }
    }
</script>
@endsection

