@extends('layouts.app')
@section('title', ' label')

@section('content')
    <style>
        .badge {
            font-size: 1rem;
            font-style: normal;
            font-weight: 400;
            font-family: "IBM Plex Sans", sans-serif;
            line-height: 1.5;
        }

        .table>tbody>tr>td,
        .table>tbody>tr>th {
            padding: 0.8rem;
            vertical-align: middle;
        }
    </style>
    <style>
        .btn-toggle.active {
            background-color: #2196f3;
            /* Set to the desired green color */
            color: white;
            /* Set to the desired text color */
            border-color: green;
            /* Set to the desired border color */
        }

        /* Style for the inactive state */
        .btn-toggle:not(.active) {
            background-color: red;
            /* Set to the desired red color */
            color: white;
            /* Set to the desired text color */
            border-color: red;
            /* Set to the desired border color */
        }
    </style>
    <link href="{{ asset('assets/css/bootstrap4-toggle.min.css') }}" rel="stylesheet">

    <section class="content">
        <!--Call tming div starts-->
        <div class="row">
            <div class="col-lg-12 col-12">
                <div class="box">
                    <div class="box-body">
                        <h4 class="box-title text-info mb-0"><i class="fa fa-user fa-sx"></i> Label</h4>
                        <a id="openLabelForm" type="button" style="float:right"
                            class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i
                                class="fa fa-plus"></i>Add Label</a>

                        <hr class="my-15">
                        <div class="row">
                            <div class="col-md-9">
                                <div class="box">
                                    <div class="box-body">
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <div class="table-responsive mailbox-messages ">
                                                    <table id="label" class="table mt-0 table-hover no-wrap"
                                                        data-page-size="10">
                                                        <thead>
                                                            <tr>
                                                                <th>#</th>
                                                                <th>Name</th>
                                                                <th>Status</th>
                                                                <th>Action</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            {{-- @foreach ($label_list as $key => $label_data)
                                                                <tr>
                                                                    <th scope="row">{{ $key + 1 }}</th>
                                                                    <td>{{ $label_data->title }}</td>
                                                                    <td>
                                                                        <!-- @if ($label_data->is_deleted == '0')
    <span class="badge badge-sm badge-success">Active</span>
@else
    ($label_data->is_deleted == '1')
    <span class="badge badge-sm badge-warning">Inactive</span>
    @endif -->
                                                                        <button
                                                                            type="button"data-listid="{{ $label_data->id }}"
                                                                            class="btn btn-sm btn-toggle  @if ($label_data->status == '1') active @endif"
                                                                            data-bs-toggle="button" aria-pressed="true"
                                                                            autocomplete="off">
                                                                            <div class="handle"></div>
                                                                    </td>
                                                                    <td><a style="cursor:pointer;margin-right:5px;"title="Edit"
                                                                            class='editLabel'
                                                                            data-id="{{ $label_data->id }}"><i
                                                                                class="fa fa-edit fa-lg"></i></a>
                                                                        <a style="cursor:pointer;" title="Delete"
                                                                            class='openLabelDelete'data-id="{{ $label_data->id }}"><i
                                                                                class="fa fa-trash-o fa-lg"></i></a>
                                                                    </td>
                                                                </tr>
                                                            @endforeach --}}
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="box">
                                    <div class="box-body">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <h4 class="box-title">Display Order(Drag & Drop)</h4>
                                                <div class="box-body">
                                                    <!-- the events -->
                                                    <div id="external-events">
                                                        <table class="table">
                                                            <tbody class="row_position">
                                                                @if (!empty($label_list))
                                                                    @foreach ($label_list as $key => $list)
                                                                        @if ($list->is_deleted == 0 && $list->status == 1)
                                                                            <tr id="<?php echo $list->id; ?>">
                                                                                <td
                                                                                    style="cursor: pointer;width:100%;"class="waves-effect waves-light btn btn-primary mb-5">
                                                                                    <?php echo $list->title; ?></td>
                                                                            </tr>
                                                                        @endif
                                                                    @endforeach
                                                                @endif
                                                            </tbody>

                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--Call tming div ends-->

    </section>



    <div class="modal fade" id="myModal" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="add-edit"></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form method="post" action="">
                    @csrf
                    <div class="modal-body">
                        <input type="hidden" class="form-control" name="label_id" value="" id="id">

                        <label for="inputEmail3" class="form-label">Name</label>
                        <input type="text" class="form-control" required name="title" id="title"
                            placeholder="Enter Name">

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary " data-bs-dismiss="modal">Close</button>
                        <button type="submit" name="submit" class="btn btn-info btn-ok">Save</button>
                    </div>
                </form>
            </div>
        </div>

    </div>

    <div class="modal fade" id="delete" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="myModalLabel">Confirm Delete</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <div class="modal-body">
                    <p>You are about to delete <b><i class="title"></i></b>Label.</p>
                    <p>Do you want to proceed?</p>
                    <input type="hidden" class="form-control" name="label_id" value="" id="label_id">

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                    <button type="submit"name="submit" class="btn btn-danger btn-sm deleteLabel">Delete</button>
                </div>
            </div>
        </div>
    </div>
    </div>
    <!-- /.row -->

    </section>
    <!-- /.content -->

    <script src="{{ asset('assets/vendor_components/jquery-ui/jquery-ui.min.js') }}"></script>
    <script src="{{ asset('assets/js/pages/calendar.js') }}"></script>
    <script src="{{ asset('assets/js/bootstrap4-toggle.min.js') }}"></script>
    <script>
        $('#label').on('click', '.openLabelDelete', function() {
            var delete_id = $(this).data('id');
            $("#delete").modal('show');
            $("#label_id").val(delete_id);
        });
        // $(".openLabelDelete").click(function() {
        //     var delete_id = $(this).data('id');
        //     $("#delete").modal('show');
        //     $("#label_id").val(delete_id);

        // });

        $("#openLabelForm").click(function() {
            $("#myModal").modal('show');
            $("#name").val('');
            $("#status").val('1');
            $("#id").val('');
            $("#add-edit").html('Add Label');
        });

        $(document).on("click", ".editLabel", function() {
            $("#myModal").modal('show');
            $("#add-edit").html('Edit Label');
            var edit_id = $(this).data('id');
            $.ajax({
                url: 'label/' + edit_id,
                type: 'get',
                success: function(response) {
                    $("#title").val(response[0].title);

                    $("#id").val(response[0].id);
                }
            });
        });

        $(document).on("click", ".deleteLabel", function() {

            //if(confirm("Are you sure you want to delete this?")){
            var delete_id = $("#label_id").val();
            //alert(delete_id);
            var el = this;
            $.ajax({
                url: 'deleteLabel/' + delete_id,
                type: 'get',
                success: function(response) {
                    window.location.reload(1);
                }
            });

        });

        $(".row_position").sortable({
            delay: 150,
            stop: function() {
                var selectedData = new Array();
                $('.row_position>tr').each(function() {
                    selectedData.push($(this).attr("id"));
                });
                updateOrder(selectedData);
            }
        });

        function updateOrder(data) {

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ url('/update/displayorder') }}",
                type: 'post',
                data: {
                    display_order: data
                },
                success: function(data) {
                    toastr.success('Display Order is changed Successfully.');
                }
            })
        }
    </script>

    <script>
        $(function() {
            $("#label").on("click", ".btn-toggle", function() {
                console.log('hi');
                var status = $(this).hasClass('active') ? 1 : 0;
                var listid = $(this).data('listid');


                $.ajax({
                    type: "GET",
                    dataType: "json",
                    url: '/updateLabelStatus/' + listid + '/' + status,

                    success: function(data) {
                        if (data.status == 'true') {
                            toastr.success(data.message);
                        } else {
                            toastr.error(data.message);

                        }

                        console.log(data.success);
                        window.location.reload(1);
                    }
                });
            })
        })
    </script>

    <script>
        $(document).ready(function() {
            $('#label').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ url('label') }}",
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'title',
                        name: 'title'

                    },
                    {
                        data: 'status',
                        name: 'status'

                    },


                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ],
 language: {
    processing: `
        <span style="display:flex; align-items:center; justify-content:center; gap:8px;">
            <img src="https://i.gifer.com/ZZ5H.gif"
                 alt="Loading..." style="width:20px; height:20px;">
            Processing...
        </span>
    `
}

            });


        });
    </script>





@endsection
