@extends('layouts.app')
@section('title', 'logo-setting')
@section('content')
<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <?php
    use App\Http\Controllers\InheritApiController;
    $userdetails = InheritApiController::headerUserDetails();
    ?>
    <!-- Content Wrapper. Contains page content -->
        <!-- Content Header (Page header) -->
        <style>
        #html_btn {
            display: none;
        }

        .container_css {
            position: relative;
            width: 100%;
            max-width: 358px;
            background-color: grey;
            min-height: 100px;
        }

        .image {
            display: block;
            padding:1px;
            height: auto;
        }

        .overlay {
            position: absolute;
            top: 0;
            bottom: 0;
            left: 0;
            right: 0;
            height: 100%;
            width: 100%;
            opacity: 0;
            transition: .3s ease;

        }

        .container_css:hover .overlay {
            opacity: 1;
        }

        .icon {
            color: black;
            font-size: 100px;
            position: absolute;
            top: 44%;
            left: 50%;
            transform: translate(-50%, -50%);
            -ms-transform: translate(-50%, -50%);
            text-align: center;
            cursor: pointer;
        }

        .fa-camera:hover {
            color: black;
        }

        .switch {
            position: relative;
            display: inline-block;
            width: 60px;
            height: 34px;
        }

        .switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }

        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            -webkit-transition: .4s;
            transition: .4s;
        }

        .slider:before {
            position: absolute;
            content: "";
            height: 26px;
            width: 26px;
            left: 4px;
            bottom: 4px;
            background-color: white;
            -webkit-transition: .4s;
            transition: .4s;
        }

        input:checked + .slider {
            background-color: #2196F3;
        }

        input:focus + .slider {
            box-shadow: 0 0 1px #2196F3;
        }

        input:checked + .slider:before {
            -webkit-transform: translateX(26px);
            -ms-transform: translateX(26px);
            transform: translateX(26px);
        }

        /* Rounded sliders */
        .slider.round {
            border-radius: 34px;
        }

        .slider.round:before {
            border-radius: 50%;
        }
    </style>
       
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-xs-12" >
                <div class="box-header with-border"style="padding:10px;">            
              <h4 class="box-title text-info mb-0"><i class="fa fa-user fa-sx"></i> Notification Setting</h4>
             
            </div>
                 <!-- Row wrapper -->
<div class="row">

    <!-- System Email Setting (Left Side) -->
    <div class="col-md-6">
        <div class="card shadow-sm rounded-3" style="border:1px solid #eee; padding:15px; background:#fff;">
     <div class="card-header bg-light border-bottom-0 d-flex align-items-center" 
     style="border:none; padding:8px 12px; gap:4px; justify-content:flex-start;">
    <i class="fa fa-envelope text-primary" style="font-size:18px; margin-right:4px;"></i>
    <h5 class="mb-0" style="font-size:16px; font-weight:500; margin:0;">System Email Setting</h5>
</div>

            <div class="card-body d-flex flex-column mt-2">
                @if($system_setting->success)
                    @if(count($system_setting->data) > 0)
                        <dl class="row">
                            <dt class="col-sm-4">Type</dt>
                            <dd class="col-sm-8">{{ $system_setting->data[0]->sender_type }}</dd>

                            <dt class="col-sm-4">Driver Name</dt>
                            <dd class="col-sm-8">{{ $system_setting->data[0]->mail_driver }}</dd>

                            <dt class="col-sm-4">Host Name</dt>
                            <dd class="col-sm-8">{{ $system_setting->data[0]->mail_host }}</dd>

                            <dt class="col-sm-4">Username</dt>
                            <dd class="col-sm-8">{{ $system_setting->data[0]->mail_username }}</dd>

                            <dt class="col-sm-4">Sender Email</dt>
                            <dd class="col-sm-8">{{ $system_setting->data[0]->from_email }}</dd>

                            <dt class="col-sm-4">Sender Name</dt>
                            <dd class="col-sm-8">{{ $system_setting->data[0]->from_name }}</dd>
                        </dl>
                          <div class="mt-auto d-flex justify-content-end">
                             <a href="/smtp/{{ $system_setting->data[0]->id }}" class="btn btn-info">
                              Update
                             </a>
                          </div>

                    @else
                        <div class="alert alert-warning">
                            <h5>No email setting present with type <u>system</u>!</h5>
                            <p>Define one by going in <a href="/smtps" style="color:#007bff;">SMTP settings</a></p>
                        </div>
                    @endif
                @else
                    <div class="alert alert-danger">
                        <h5>Failed to get system email setting!</h5>
                        <p>{{ $system_setting->message }}</p>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Company Logo (Right Side) -->
    <div class="col-md-6">
        <div class="card shadow-sm rounded-3" style="border:1px solid #eee; padding:15px; background:#fff;">
      <div class="card-header bg-light border-bottom-0 d-flex align-items-center" 
     style="border:none; padding:8px 12px; gap:4px; justify-content:flex-start;">
    <i class="fa fa-image text-primary" style="font-size:18px; margin-right:4px;"></i>
    <h5 class="mb-0" style="font-size:16px; font-weight:500; margin:0;">{{ $userdetails->data->company_name }} Logo</h5>
</div>

            <div class="card-body text-center mt-2">
                <div class="container_css position-relative d-inline-block">
                    <?php
                        if(!empty($userdetails->data->logo)){
                            if (file_exists(public_path() . '/logo/' . $userdetails->data->logo)) { ?>
                                <img src="{{ asset('logo') }}/{{$userdetails->data->logo}}" 
                                     alt="Avatar" 
                                     class="profile-user-img img-responsive image" 
                                     style="border:none; max-height:150px;">
                            <?php } else { ?>
                                <img src="{{ asset('logo/logo_white.png') }}" 
                                     alt="Avatar" 
                                     class="profile-user-img img-responsive image" 
                                     style="max-height:150px;">
                            <?php } 
                        } 
                    ?>

                    <div class="overlay">
                        <form id="form" action="{{ route('logo.upload.post') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="icon"><i class="fa fa-camera upload-button"></i></div>
                            <input type="hidden" id="old_logo" name="old_logo" value="{{$userdetails->data->logo}}"/>
                            <input id="html_btn" name="image" type="file" /><br>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

                    <!-- /.box Logo -->

                    <!-- Notification --->
                    <div class="box box-default  table-responsive">
                        <div class="box-header with-border">
                            <i class="fa fa-envelope"></i>
                            <h5 class="box-title">Notifications</h5>
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body">
                            <table class="table">
                                <form method="post">
                                    @csrf
                                    <?php
                                    foreach($notifications as $notification)
                                    {
                                    if ($notification["active"]) {
                                        $status = 'checked';
                                        $value = 1;
                                    } else {
                                        $status = '';
                                        $value = 0;
                                    }

                                    if ($notification["active_sms"]) {
                                        $active_sms = 'checked';
                                        $value = 1;
                                    } else {
                                        $active_sms = '';
                                        $value = 0;
                                    }
                                    ?>
                                    <tr>
                                        <td>
                                            <h5>{{$notification["name"]}}</h5>
                                            <input type="hidden" name="notification_id[{{$notification["id"]}}]" value="{{$notification["id"]}}">
                                        </td>
                                        <td>
                                            
                                                <input type="checkbox" {{$status}} value="1" id="basic_checkbox1_{{$notification["id"]}}" name="active[{{$notification["id"]}}]"> <label for="basic_checkbox1_{{$notification["id"]}}">Email</label>

                                                 {{-- @if($notification["id"] != 'send_fax_email' && $notification["id"] != 'daily_call_report') --}}
                                                &nbsp;&nbsp;<input type="checkbox" {{$active_sms}} id="basic_checkbox2_{{$notification["id"]}}" value="1" name="active_sms[{{$notification["id"]}}]"><label for="basic_checkbox2_{{$notification["id"]}}"> SMS</label>
                                                {{--@endif --}}
                                                
                                            
                                        </td>
                                        <td>
                                        @if($notification["id"] === 'send_fax_email' || ($notification["id"] === 'send_callback'))
                                        <input type="hidden" name="subscribers[{{$notification["id"]}}][]" value="0" />
                                        @else
                                        
                        <select class="select2" multiple="multiple" name="subscribers[{{$notification["id"]}}][]" placeholder="Select Emails">
                            @foreach($extension_list as $key => $extensions)
                                @if(($extensions->user_level != '9') || ($extensions->extension == request()->session()->get('extension')))
                                    <option @if(!empty($notification["subscribers"])) @if(in_array($extensions->id, $notification["subscribers"]))  selected @endif @endif  value={{$extensions->id}}>{{$extensions->first_name}} {{$extensions->last_name}}-{{$extensions->email}}-(+{{$extensions->country_code}} {{$extensions->mobile}})</option>
                                @endif
                            @endforeach
                        </select>
                                        
                                        @endif
                                        </td>

                                    </tr>
                                    <?php
                                    }
                                    ?>
                                    <tr>
                                        <td></td>
                                        <td></td>
                                        <td><input type="submit" class="btn btn-info" value="Submit"style="float:right;"></td>
                                    </tr>
                                </form>
                            </table>
                        </div>
                        <!-- /.box-body -->
                    </div>
                    <!-- /.box Notification -->
                </div>

            </div><!-- /.row -->
            <div style="clear: both; margin-bottom: 50px" class="row"></div>

        </section><!-- /.content -->
    </div>

    <!-- /.content-wrapper -->
@endsection
@push('styles')
  
@endpush
@push('scripts')
    <script type="text/javascript">
        document.getElementById("html_btn").onchange = function () {
            document.getElementById("form").submit();
        }
        $('.icon').on("click", function () {
            $('#html_btn').click();
        });
    </script>
@endpush
