@extends('layouts.app')
@section('title', 'Email Setting')
@section('content')

<section class="content">
    <div class="row">
        <div class="col-lg-12 col-12">
            <div class="box">
                <div class="box-body">
                    <h4 class="box-title text-info mb-0"><i class="fa fa-list"></i> Online Application</h4>
                    <hr class="my-15">
                    <div class="row">                              
                        <form  id="emailSettingsForm" method="post" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" value="online application" name="mail_type" id="mail_type">
                            <input type="hidden" @if(!empty($crm_system->online->id)) value="{{$crm_system->online->id}}"  @endif name="online_id" id="online_id">

                            <div class="row">
                                <div class="form-group col-md-3">
                                    <label for="exampleInputEmail1">Email Provider </label>
                                    <div class="input-group">
                                        <span class="input-group-text @error('mail_driver') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                        <select required class="form-select" name="mail_driver" id="mail_driver">
                                            <option value="">--Select--</option>
                                            <option @if(!empty($crm_system->online->mail_driver)) @if($crm_system->online->mail_driver == 'Sendgrid') selected @endif @endif value="Sendgrid">SendGrid</option>
                                            <option @if(!empty($crm_system->online->mail_driver)) @if($crm_system->online->mail_driver == 'Zoho') selected @endif @endif value="Zoho">Zoho</option>
                                            <option @if(!empty($crm_system->online->mail_driver)) @if($crm_system->online->mail_driver == 'Google') selected @endif @endif value="Google">Google</option>
                                        </select>                                            
                                    </div>
                                </div>
                                        
                                <div class="form-group col-md-3">
                                    <label for="exampleInputEmail1">User Name</label>
                                    <div class="input-group">
                                        <span class="input-group-text @error('mail_username') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                        <input required type="text" @if(!empty($crm_system->online->mail_username)) value="{{$crm_system->online->mail_username}}" @endif required class="form-control" autocomplete="off" name="mail_username"id="mail_username"placeholder="User Name">                                            
                                            
                                    </div>
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="exampleInputEmail1">Password</label>
                                    <div class="input-group">
                                        <span class="input-group-text @error('mail_password') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                        <input required type="password" @if(!empty($crm_system->online->mail_password)) value="{{$crm_system->online->mail_password}}" @endif required class="form-control" name="mail_password"id="mail_password"
                                                        placeholder="Password">   
                                                        <span class="input-group-text" onclick="togglePasswordVisibilityOnline()" style="cursor: pointer;">
                                                            <i id="eye-icon" class="ti-eye"></i>
                                                        </span>
                               
                                    </div>
                                </div>

                                <div class="form-group col-md-6">    
                                    <label for="exampleInputEmail1">Send Emails Via</label>
                                    <div class="input-group">
                                        <span class="input-group-text @error('send_email_via') text-danger border-danger @enderror"><i class="ti-email"></i></span>
                                        <select class="form-select" name="send_email_via" id="send_email_via"onchange="toggleCustomFields()">
                                            <option @if(!empty($crm_system->online->send_email_via))   @if($crm_system->online->send_email_via == 'user_email') selected @endif @endif  value="user_email">User Email</option>
                                            
                                            <option @if(!empty($crm_system->online->send_email_via))  @if($crm_system->online->send_email_via == 'custom') selected @endif @endif  value="custom">Custom</option>                                                                  
                                        </select>                                    
                                    </div>
                                </div>        

                                <div class="form-group col-md-3"id="customEmailGroup" @if(!empty($crm_system->online->send_email_via)) @if($crm_system->online->send_email_via == 'user_email') style="display:none;" @endif @else style="display:none;" @endif>
                                <label for="exampleInputEmail1">Sender Email</label>
                                    <div class="input-group">
                                        <span class="input-group-text @error('sender_email') text-danger border-danger @enderror"><i class="ti-email"></i></span>
                                        <input  type="email" @if(!empty($crm_system->online->sender_email)) value="{{$crm_system->online->sender_email}}" @endif  class="form-control" name="sender_email"id="sender_email"
                                                        placeholder="Sender Email">                                             
                                    </div>
                                </div>

                                <div class="form-group col-md-3"id="customNameGroup" @if(!empty($crm_system->online->send_email_via))  @if($crm_system->online->send_email_via == 'user_email') style="display:none;" @endif @else style="display:none;" @endif>
                                <label for="exampleInputEmail1">Sender Name</label>
                                    <div class="input-group">
                                        <span class="input-group-text @error('sender_name') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                        <input type="text"   @if(!empty($crm_system->online->sender_name)) value="{{$crm_system->online->sender_name}}" @endif class="form-control" name="sender_name"id="sender_name"
                                                        placeholder="Sender Name">                                              
                                    </div>
                                </div>     
                                        
                                            <div class="modal-footer text-end">
                                               <button type="button"  class="btn btn-info btn-warning "id="checkSetting"onclick="checkSMTPSettings('online application')">Verify</button>

                                               <a id="smtpResponce" style="display: none;"> <img style="width:30px;" src="{{ asset('assets/images/loader.gif') }}"/></a>
                                                
                                                @if(!empty($crm_system->online->id))
                                                <button type="submit" id="updateButton"   class="btn btn btn-primary waves-effect waves-light"><i class="ti-save-alt"></i> Update</button>
                                                @else
                                                <button type="submit" id="saveButton"  class="btn btn btn-primary waves-effect waves-light"><i class="ti-save-alt"></i> Submit</button> 
                                                @endif                                                 
                                               

                                            </div> 
                                            </div>  
                                </form>  
                            </div>
                    </div>    
                    <div class="box-body">
                        <h4 class="box-title text-info mb-0"><i class="fa fa-list"></i> Submissions</h4>
                        <hr class="my-15">
                            <div class="row">                              
                                <form  method="post" enctype="multipart/form-data"id="submissionForm">
                                        @csrf
                                        <input type="hidden" value="submission" name="mail_type" id="mail_type_submission">
                            <input type="hidden" @if(!empty($crm_system->submission->id)) value="{{$crm_system->submission->id}}"  @endif name="submission_id" id="submission_id">

                                        <div class="row">
                                    
                                            <div class="form-group col-md-3">
                                                <label for="exampleInputEmail1">Email Provider </label>
                                                <div class="input-group">
                                                        <span class="input-group-text @error('mail_driver') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                                                            <select class="form-select" name="mail_driver"id="mail_driver_submission">
                                                                            <option value="">--Select--</option>
                                                                                <option @if(!empty($crm_system->submission->mail_driver)) @if($crm_system->submission->mail_driver == 'Sendgrid') selected @endif @endif value="Sendgrid">SendGrid</option>
                                            <option @if(!empty($crm_system->submission->mail_driver)) @if($crm_system->submission->mail_driver == 'Zoho') selected @endif @endif value="Zoho">Zoho</option>
                                            <option @if(!empty($crm_system->submission->mail_driver)) @if($crm_system->submission->mail_driver == 'Google') selected @endif @endif value="Google">Google</option>
                                                                            
                                                                            </select>                                            
                                                </div>
                                            </div>
                                        
                                            <div class="form-group col-md-3">
                                                <label for="exampleInputEmail1">User Name</label>
                                                <div class="input-group">
                                                    <span class="input-group-text @error('mail_username') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                                    <input type="text" @if(!empty($crm_system->submission->mail_username)) value="{{$crm_system->submission->mail_username}}" @endif required class="form-control" name="mail_username"id="mail_username_submission"
                                                            placeholder="User Name">
                                                        
                                                </div>
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label for="exampleInputEmail1">Password</label>
                                                <div class="input-group">
                                                    <span class="input-group-text @error('mail_password') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                                    <input type="password" @if(!empty($crm_system->submission->mail_password)) value="{{$crm_system->submission->mail_password}}" @endif required class="form-control" name="mail_password"id="mail_password_submission"
                                                        placeholder="Password">    
                                                        <span class="input-group-text" onclick="togglePasswordVisibilitySubmission()" style="cursor: pointer;">
                                                            <i id="eye-icon-submission" class="ti-eye"></i>
                                                        </span>                              
                                                </div>
                                            </div>
                                            <div class="form-group col-md-6">    
                                    <label for="exampleInputEmail1">Send Emails Via</label>
                                    <div class="input-group">
                                        <span class="input-group-text @error('send_email_via') text-danger border-danger @enderror"><i class="ti-email"></i></span>
                                        <select class="form-select" name="send_email_via" id="send_email_via_submission"onchange="toggleCustomFieldsSub()">
                                            <option @if(!empty($crm_system->submission->send_email_via))   @if($crm_system->submission->send_email_via == 'user_email') selected @endif @endif  value="user_email">User Email</option>
                                            
                                            <option @if(!empty($crm_system->submission->send_email_via))  @if($crm_system->submission->send_email_via == 'custom') selected @endif @endif  value="custom">Custom</option>                                                                  
                                        </select>                                    
                                    </div>
                                </div>        

                                <div class="form-group col-md-3"id="senderEmail" @if(!empty($crm_system->submission->send_email_via)) @if($crm_system->submission->send_email_via == 'user_email') style="display:none;" @endif @else style="display:none;" @endif>
                                <label for="exampleInputEmail1">Sender Email</label>
                                    <div class="input-group">
                                        <span class="input-group-text @error('sender_email') text-danger border-danger @enderror"><i class="ti-email"></i></span>
                                        <input  type="email" @if(!empty($crm_system->submission->sender_email)) value="{{$crm_system->submission->sender_email}}" @endif  class="form-control" name="sender_email"id="sender_email_submission"
                                                        placeholder="Sender Email">                                             
                                    </div>
                                </div>

                                <div class="form-group col-md-3"id="senderName" @if(!empty($crm_system->submission->send_email_via))  @if($crm_system->submission->send_email_via == 'user_email') style="display:none;" @endif @else style="display:none;" @endif>
                                <label for="exampleInputEmail1">Sender Name</label>
                                    <div class="input-group">
                                        <span class="input-group-text @error('sender_name') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                        <input type="text"   @if(!empty($crm_system->submission->sender_name)) value="{{$crm_system->submission->sender_name}}" @endif class="form-control" name="sender_name"id="sender_name_submission"
                                                        placeholder="Sender Name">                                              
                                    </div>
                                </div>  


                                        
                                            <div class="modal-footer text-end">
                                            <button type="button"  class="btn btn-info btn-warning "id="checkSetting_submission" onclick="checkSMTPSettings('submission')">Verify</button>
                                            <a id="smtpResponce_submission" style="display: none;"> <img style="width:30px;" src="{{ asset('assets/images/loader.gif') }}"/></a>
                                             @if(!empty($crm_system->submission->id))
                                                <button type="submit" id="updateButton"   class="btn btn btn-primary waves-effect waves-light"><i class="ti-save-alt"></i> Update</button>
                                                @else
                                                <button type="submit" id="saveButton"  class="btn btn btn-primary waves-effect waves-light"><i class="ti-save-alt"></i> Submit</button> 
                                                @endif   

                                            </div> 
                                            </div>  
                                </form>  
                            </div>
                    </div>
                    
                    <div class="box-body">
                        <h4 class="box-title text-info mb-0"><i class="fa fa-list"></i> Notification</h4>
                            <hr class="my-15">
                            <div class="row">                              
                                <form  method="post" action="" enctype="multipart/form-data" id="notificationForm">
                                        @csrf
                                        <input type="hidden" value="notification" name="mail_type" id="mail_type_notification">
                            <input type="hidden" @if(!empty($crm_system->notification->id)) value="{{$crm_system->notification->id}}"  @endif name="notification_id" id="notification_id">
                                        <div class="row">                              
                                            <div class="form-group col-md-3">
                                            <label for="exampleInputEmail1">Email Provider </label>
                                                <div class="input-group">
                                                        <span class="input-group-text @error('mail_driver') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                                                            <select class="form-select" name="mail_driver" id="mail_driver_notification">
                                                                            <option value="">--Select--</option>
                                                                                <option @if(!empty($crm_system->notification->mail_driver)) @if($crm_system->notification->mail_driver == 'Sendgrid') selected @endif @endif value="Sendgrid">SendGrid</option>
                                            <option @if(!empty($crm_system->notification->mail_driver)) @if($crm_system->notification->mail_driver == 'Zoho') selected @endif @endif value="Zoho">Zoho</option>
                                            <option @if(!empty($crm_system->notification->mail_driver)) @if($crm_system->notification->mail_driver == 'Google') selected @endif @endif value="Google">Google</option>
                                                                            
                                                                            </select>
                                                        
                                                </div>
                                            </div>
                                            <div class="form-group col-md-3">
                                            <label for="exampleInputEmail1">User Name</label>
                                                <div class="input-group">
                                                <span class="input-group-text @error('mail_username') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                                    <input type="text" @if(!empty($crm_system->notification->mail_username)) value="{{$crm_system->notification->mail_username}}" @endif  required class="form-control" name="mail_username"id="mail_username_notification"
                                                        placeholder="User Name">                                            
                                                </div>
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label for="exampleInputEmail1">Password</label>
                                                <div class="input-group">
                                                    <span class="input-group-text @error('mail_password') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                                    <input type="password" @if(!empty($crm_system->notification->mail_password)) value="{{$crm_system->notification->mail_password}}" @endif required class="form-control" name="mail_password" id="mail_password_notification" 
                                                            placeholder="Password">   
                                                            <span class="input-group-text" onclick="togglePasswordVisibilityNotification()" style="cursor: pointer;">
                                                            <i id="eye-icon-notification" class="ti-eye"></i>
                                                        </span>                               
                                                </div>
                                            </div>                             
                                            <div class="form-group col-md-6">
                                            <label for="exampleInputEmail1">Sender Email</label>
                                                <div class="input-group">
                                                    <span class="input-group-text @error('sender_email') text-danger border-danger @enderror"><i class="ti-email"></i></span>
                                                        <input type="email" @if(!empty($crm_system->notification->sender_email)) value="{{$crm_system->notification->sender_email}}" @endif required class="form-control" name="sender_email"id="sender_email_notification"
                                                        placeholder="Sender Email">                                            
                                                </div>
                                            </div>
                                            <div class="form-group col-md-6">
                                            <label for="exampleInputEmail1">Sender Name</label>
                                                <div class="input-group">
                                                    <span class="input-group-text @error('sender_name') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                                    <input type="text" @if(!empty($crm_system->notification->sender_name)) value="{{$crm_system->notification->sender_name}}" @endif required class="form-control" name="sender_name"id="sender_name_notification"
                                                            placeholder="Sender Name">                                            
                                                </div>
                                            </div>                                                    
                                            <div class="modal-footer text-end">
                                                <button type="button"  class="btn btn-info btn-warning "id="checkSetting_notification"onclick="checkSMTPSettings('notification')">Verify</button>
                                                <a id="smtpResponce_notification" style="display: none;"> <img style="width:30px;" src="{{ asset('assets/images/loader.gif') }}"/></a>    

                                                
                                                @if(!empty($crm_system->notification->id))
                                                <button type="submit" id="updateButton"   class="btn btn btn-primary waves-effect waves-light"><i class="ti-save-alt"></i> Update</button>
                                                @else
                                                <button type="submit" id="saveButton"  class="btn btn btn-primary waves-effect waves-light"><i class="ti-save-alt"></i> Submit</button> 
                                                @endif   
                                         
                                            </div>
                                </form>
                            </div>                     
                    </div><!-- /.box-body -->
                     
                    <div class="box-body">
                        <h4 class="box-title text-info mb-0"><i class="fa fa-list"></i> Marketing Campaigns</h4>
                            <hr class="my-15">
                            <div class="row">                              
                                <form  method="post" action="" enctype="multipart/form-data" id="marketingCampaignsForm">
                                        @csrf
                                        <input type="hidden" value="marketing_campaigns" name="mail_type" id="mail_type_marketing_campaigns">
                            <input type="hidden" @if(!empty($crm_system->marketing_campaigns->id)) value="{{$crm_system->marketing_campaigns->id}}"  @endif name="marketing_campaigns_id" id="marketing_campaigns_id">
                                        <div class="row">                              
                                            <div class="form-group col-md-3">
                                            <label for="exampleInputEmail1">Email Provider </label>
                                                <div class="input-group">
                                                        <span class="input-group-text @error('mail_driver') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                                                            <select class="form-select" name="mail_driver" id="mail_driver_marketing_campaigns">
                                                                            <option value="">--Select--</option>
                                                                                <option @if(!empty($crm_system->marketing_campaigns->mail_driver)) @if($crm_system->marketing_campaigns->mail_driver == 'Sendgrid') selected @endif @endif value="Sendgrid">SendGrid</option>
                                            <option @if(!empty($crm_system->marketing_campaigns->mail_driver)) @if($crm_system->marketing_campaigns->mail_driver == 'Zoho') selected @endif @endif value="Zoho">Zoho</option>
                                            <option @if(!empty($crm_system->marketing_campaigns->mail_driver)) @if($crm_system->marketing_campaigns->mail_driver == 'Google') selected @endif @endif value="Google">Google</option>
                                                                            
                                                                            </select>
                                                        
                                                </div>
                                            </div>
                                            <div class="form-group col-md-3">
                                            <label for="exampleInputEmail1">User Name</label>
                                                <div class="input-group">
                                                <span class="input-group-text @error('mail_username') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                                    <input type="text" @if(!empty($crm_system->marketing_campaigns->mail_username)) value="{{$crm_system->marketing_campaigns->mail_username}}" @endif  required class="form-control" name="mail_username"id="mail_username_marketing_campaigns"
                                                        placeholder="User Name">                                            
                                                </div>
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label for="exampleInputEmail1">Password</label>
                                                <div class="input-group">
                                                    <span class="input-group-text @error('mail_password') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                                    <input type="password" @if(!empty($crm_system->marketing_campaigns->mail_password)) value="{{$crm_system->marketing_campaigns->mail_password}}" @endif required class="form-control" name="mail_password" id="mail_password_marketing_campaigns" 
                                                            placeholder="Password">  
                                                            <span class="input-group-text" onclick="togglePasswordVisibilityMarketing()" style="cursor: pointer;">
                                                            <i id="eye-icon-marketing" class="ti-eye"></i>
                                                        </span>                                 
                                                </div>
                                            </div>                             
                                            <div class="form-group col-md-6">
                                            <label for="exampleInputEmail1">Sender Email</label>
                                                <div class="input-group">
                                                    <span class="input-group-text @error('sender_email') text-danger border-danger @enderror"><i class="ti-email"></i></span>
                                                        <input type="email" @if(!empty($crm_system->marketing_campaigns->sender_email)) value="{{$crm_system->marketing_campaigns->sender_email}}" @endif required class="form-control" name="sender_email"id="sender_email_marketing_campaigns"
                                                        placeholder="Sender Email">                                            
                                                </div>
                                            </div>
                                            <div class="form-group col-md-6">
                                            <label for="exampleInputEmail1">Sender Name</label>
                                                <div class="input-group">
                                                    <span class="input-group-text @error('sender_name') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                                    <input type="text" @if(!empty($crm_system->marketing_campaigns->sender_name)) value="{{$crm_system->marketing_campaigns->sender_name}}" @endif required class="form-control" name="sender_name"id="sender_name_marketing_campaigns"
                                                            placeholder="Sender Name">                                            
                                                </div>
                                            </div>                                                    
                                            <div class="modal-footer text-end">
                                                <button type="button"  class="btn btn-info btn-warning "id="checkSetting_marketing_campaigns"onclick="checkSMTPSettings('marketing_campaigns')">Verify</button>
                                                <a id="smtpResponce_marketing_campaigns" style="display: none;"> <img style="width:30px;" src="{{ asset('assets/images/loader.gif') }}"/></a>    

                                                
                                                @if(!empty($crm_system->marketing_campaigns->id))
                                                <button type="submit" id="updateButton"   class="btn btn btn-primary waves-effect waves-light"><i class="ti-save-alt"></i> Update</button>
                                                @else
                                                <button type="submit" id="saveButton"  class="btn btn btn-primary waves-effect waves-light"><i class="ti-save-alt"></i> Submit</button> 
                                                @endif   
                                         
                                            </div>
                                </form>
                            </div>                     
                    </div><!-- /.box-body -->
                </div><!-- /.box -->
            </div><!-- /.col -->
        </div><!-- /.row -->
    </section><!-- /.content -->


<!-- /.content-wrapper -->



<script>
  
    function toggleCustomFields() {
        var senderEmail = document.getElementById('send_email_via');
        var customEmailGroup = document.getElementById('customEmailGroup');
        var customNameGroup = document.getElementById('customNameGroup');

        if (senderEmail.value === 'custom') {
            customEmailGroup.style.display = 'block';
            customNameGroup.style.display = 'block';

        } else {
            customEmailGroup.style.display = 'none';
            customNameGroup.style.display = 'none';

        }
    }

     function toggleCustomFieldsSub() {
        var senderEmail = document.getElementById('send_email_via_submission');
        var customEmailGroup = document.getElementById('senderEmail');
        var customNameGroup = document.getElementById('senderName');

        if (senderEmail.value === 'custom') {
            customEmailGroup.style.display = 'block';
            customNameGroup.style.display = 'block';

        } else {
            customEmailGroup.style.display = 'none';
            customNameGroup.style.display = 'none';

        }
    }
</script>

<script>
    function checkSMTPSettings(type) {

        /*alert(type);
        return true;*/

    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    if(type == 'online application')
    {

        var mail_type = $("#mail_type").val();
    var mail_driver = $("#mail_driver").val();
    var mail_username = $("#mail_username").val();
    var mail_password = $("#mail_password").val();
    var sender_email = $("#sender_email").val();
    var sender_name = $("#sender_name").val();
    var send_email_via = $("#send_email_via").val();
    var mail_host = $("#mail_host").val();
     $("#smtpResponce").show();
    $("#smtpResponce_submission").hide();
    $("#smtpResponce_notification").hide();



    }

    else
        if(type == 'submission')
    {

        var mail_type = $("#mail_type_submission").val();
    var mail_driver = $("#mail_driver_submission").val();
    var mail_username = $("#mail_username_submission").val();
    var mail_password = $("#mail_password_submission").val();
    var sender_email = $("#sender_email_submission").val();
    var sender_name = $("#sender_name_submission").val();
    var send_email_via = $("#send_email_via_submission").val();
    var mail_host = $("#mail_host_submission").val();
    $("#smtpResponce_submission").show();
     $("#smtpResponce").hide();
    $("#smtpResponce_notification").hide();




    }

    else
        if(type == 'notification')
    {

        var mail_type = $("#mail_type_notification").val();
    var mail_driver = $("#mail_driver_notification").val();
    var mail_username = $("#mail_username_notification").val();
    var mail_password = $("#mail_password_notification").val();
    var sender_email = $("#sender_email_notification").val();
    var sender_name = $("#sender_name_notification").val();
    var send_email_via = "custom";
    var mail_host = $("#mail_host_notification").val();
    $("#smtpResponce_notification").show();
    $("#smtpResponce_submission").hide();
     $("#smtpResponce").hide();


    }
    else
        if(type == 'marketing_campaigns')
    {

        var mail_type = $("#mail_type_marketing_campaigns").val();
    var mail_driver = $("#mail_driver_marketing_campaigns").val();
    var mail_username = $("#mail_username_marketing_campaigns").val();
    var mail_password = $("#mail_password_marketing_campaigns").val();
    var sender_email = $("#sender_email_marketing_campaigns").val();
    var sender_name = $("#sender_name_marketing_campaigns").val();
    var send_email_via = "custom";
    var mail_host = $("#mail_host_marketing_campaigns").val();
    $("#smtpResponce_marketing_campaigns").show();

    $("#smtpResponce_notification").hide();
    $("#smtpResponce_submission").hide();
     $("#smtpResponce").hide();


    }
    
    if (mail_driver == '') {
        $("#alert-errors").html("Please enter Driver");
        $("#alert-errors").show();
        $("#mail_driver").focus();
        return false;
    } else if (mail_username == '') {
        $("#alert-errors").html("Please enter Username");
        $("#alert-errors").show();
        $("#mail_username").focus();
        return false;
    } else if (mail_password == '') {
        $("#alert-errors").html("Please enter Password");
        $("#alert-errors").show();
        $("#mail_password").focus();
        return false;
    } /*else if (send_email_via == '') {
        $("#alert-errors").html("Please select For Sending");
        $("#alert-errors").show();
        $("#sender_type").focus();
        return false;
    }*/
    else if (mail_host == '') {
        $("#alert-errors").html("Please select For Sending");
        $("#alert-errors").show();
        $("#mail_host").focus();
        return false;
    }

   

    $.ajax({
        url: '/checkcrmSMTPSetting',
        data: {
            mail_driver: mail_driver,
            sender_email: sender_email, // Assuming from_email is correct, otherwise use sender_email
            sender_name: sender_name,   // Assuming from_name is correct, otherwise use sender_name
            send_email_via: send_email_via,
            mail_username:mail_username,
            mail_password:mail_password,
            mail_host:mail_host,
            mail_type:mail_type,

        },
        type: 'post',
        dataType: "json",
        success: function (response) {
            if (response.success) {
                $(".checkSetting").hide();
                $(".checkSetting_notification").hide();
                $(".checkSetting_submission").hide();

                if(type == 'online application')
                {
                    $("#smtpResponce").show();
                    $("#smtpResponce").html("<span class='btn btn-success btn-ok'>Configuration Setting Success</span>");
                }

                else
                if(type == 'submission')
                {
                    $("#smtpResponce_submission").show();
                    $("#smtpResponce_submission").html("<span class='btn btn-success btn-ok'>Configuration Setting Success</span>");
                    
                }

                else
                if(type == 'notification')
                {
                    $("#smtpResponce_notification").show();
                    $("#smtpResponce_notification").html("<span class='btn btn-success btn-ok'>Configuration Setting Success</span>");
                    
                }
                else
                if(type == 'marketing_campaigns')
                {
                    $("#smtpResponce_marketing_campaigns").show();
                    $("#smtpResponce_marketing_campaigns").html("<span class='btn btn-success btn-ok'>Configuration Setting Success</span>");
                    
                }


                //$("#saveButton").prop("disabled", false);
                //$("#updateButton").prop("disabled", false);
            } else {
                $(".checkSetting").show();
                $(".checkSetting_notification").show();
                $(".checkSetting_submission").show();

                if(type == 'online application')
                {
                    $("#smtpResponce").show();
                    $("#smtpResponce").html("<span class='btn btn-danger btn-ok'>Configuration Setting Failed</span>");
                }

                else
                if(type == 'submission')
                {
                    $("#smtpResponce_submission").show();
                    $("#smtpResponce_submission").html("<span class='btn btn-danger btn-ok'>Configuration Setting Failed</span>");
                    
                }

                else
                if(type == 'notification')
                {
                    $("#smtpResponce_notification").show();
                    $("#smtpResponce_notification").html("<span class='btn btn-danger btn-ok'>Configuration Setting Failed</span>");
                    
                }
                else
                if(type == 'marketing_campaigns')
                {
                    $("#smtpResponce_marketing_campaigns").show();
                    $("#smtpResponce_marketing_campaigns").html("<span class='btn btn-danger btn-ok'>Configuration Setting Failed</span>");
                    
                }
            }
            setTimeout(function () {
                $("#smtpResponce").html('<img style="width:30px;" src="{{ asset('assets/images/loader.gif') }}" />');
                $("#smtpResponce").hide();

                $("#smtpResponce_submission").html('<img style="width:30px;" src="{{ asset('assets/images/loader.gif') }}" />');
                $("#smtpResponce_submission").hide();

                $("#smtpResponce_notification").html('<img style="width:30px;" src="{{ asset('assets/images/loader.gif') }}" />');
                $("#smtpResponce_notification").hide();

                $("#smtpResponce_marketing_campaigns").html('<img style="width:30px;" src="{{ asset('assets/images/loader.gif') }}" />');
                $("#smtpResponce_marketing_campaigns").hide();
            }, 3000);
        }
    });
}


function togglePasswordVisibilityOnline() {
    const passwordField = document.getElementById('mail_password');
    const eyeIcon = document.getElementById('eye-icon');
    
    if (passwordField.type === 'password') {
        passwordField.type = 'text';
        eyeIcon.classList.remove('ti-eye');
        eyeIcon.classList.add('ti-eye-off');
    } else {
        passwordField.type = 'password';
        eyeIcon.classList.remove('ti-eye-off');
        eyeIcon.classList.add('ti-eye');
    }
}
function togglePasswordVisibilitySubmission() {
    const passwordField = document.getElementById('mail_password_submission');
    const eyeIcon = document.getElementById('eye-icon-submission');
    
    if (passwordField.type === 'password') {
        passwordField.type = 'text';
        eyeIcon.classList.remove('ti-eye');
        eyeIcon.classList.add('ti-eye-off');
    } else {
        passwordField.type = 'password';
        eyeIcon.classList.remove('ti-eye-off');
        eyeIcon.classList.add('ti-eye');
    }
}
function togglePasswordVisibilityNotification() {
    const passwordField = document.getElementById('mail_password_notification');
    const eyeIcon = document.getElementById('eye-icon-notification');
    
    if (passwordField.type === 'password') {
        passwordField.type = 'text';
        eyeIcon.classList.remove('ti-eye');
        eyeIcon.classList.add('ti-eye-off');
    } else {
        passwordField.type = 'password';
        eyeIcon.classList.remove('ti-eye-off');
        eyeIcon.classList.add('ti-eye');
    }
}
function togglePasswordVisibilityMarketing() {
    const passwordField = document.getElementById('mail_password_marketing_campaigns');
    const eyeIcon = document.getElementById('eye-icon-marketing');
    
    if (passwordField.type === 'password') {
        passwordField.type = 'text';
        eyeIcon.classList.remove('ti-eye');
        eyeIcon.classList.add('ti-eye-off');
    } else {
        passwordField.type = 'password';
        eyeIcon.classList.remove('ti-eye-off');
        eyeIcon.classList.add('ti-eye');
    }
}

    </script>
  @endsection  