@extends('layouts.app')
@section('title', 'Edit CRM Email Template')
@section('content')


<section class="content">
			<div class="row">			  
				<div class="col-lg-12 col-12">
					  <div class="box">
						
						<!-- /.box-header -->
                        <form method="post" name="userform" id="userform" action="">
                            @csrf

							<div class="box-body">
                                <h4 class="box-title text-info mb-0"><i class="fa fa-edit me-15"></i> Edit Email Template</h4>
                                <a href="{{url('/crm-email-templates')}}" type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-eye fa-sx"></i> See Email Template</a>
								<hr class="my-15">
								<div class="row">
								  <div class="col-md-3">
                                  <div class="form-group">
									<label class="form-label">Template Name </label>
									<div class="input-group mb-3">
										<span class="input-group-text"><i class="ti-user"></i></span>
                                        <input type="text" name="template_name" value="{{old('template_name', $email_template['template_name'])}}" class="form-control" id="template_name" required placeholder="Enter Template Name" />

                                    </div>
								 </div>
								  </div>
                                  <div class="col-md-3">
                                  <div class="form-group">
                                  <label class="form-label"> Lead Placeholders </label>
                                  <div class="input-group mb-3">
										<span class="input-group-text"><i class="ti-user"></i></span>
                                        <span id="setBoxValue" style="display:none;"></span>
                                        <select id="multiple_labels" class="form-select" autocomplete="off" >
                                                <option value="">Select to Insert</option>
                                                @foreach($label_list as $list)
                                                <option value="[[{{ $list->label_title_url }}]]">{{ $list->label_title_url }}</option>
                                                @endforeach;
                                                <option value="[[signature_image]]">signature_image</option>
                                            </select>
                                </div>
                                </div>
                                </div>
                                <div class="col-md-3 form-group">
                                        <label for="" class="form-label">Sender Placeholders</label>
                                        <div class="input-group mb-3">
										<span class="input-group-text"><i class="ti-user"></i></span>
                                        <select id="multiple_names" class="form-select" autocomplete="off" >
                                                <option value="">Select to Insert</option>
                                                @foreach($user_column as $user_list)
                                                <option value="[{{ $user_list }}]">{{$user_list}}</option>
                                                @endforeach;
                                            </select>                                   
                                        </div>
                                    </div>
                                    <div class="col-md-3 form-group">
                                        <label for="" class="form-label">Lead Status </label>
                                        <div class="input-group mb-3">
										<span class="input-group-text"><i class="ti-user"></i></span>
                                        <select id="lead_status" class="form-select" autocomplete="off" name="lead_status" >
                                                <option value="">Select to Insert</option>
                                                @foreach($lead_status as $list)
                                                <option @if($email_template['lead_status'] == $list->lead_title_url ) selected @endif value="{{ $list->lead_title_url }}">{{$list->title}}</option>
                                                @endforeach;
                                            </select>                              
                                         </div>
                                         </div>
                                         <div class="col-md-3 form-group" style="display: none;">
                                        <label for="" class="form-label">Send Bcc</label>
                                        <div class="input-group mb-3">
										<span class="input-group-text"><i class="ti-user"></i></span>
                                        <select id="send_bcc" class="form-select" autocomplete="off" name="send_bcc" >
                                                <option @if($email_template['send_bcc'] == '1' ) selected @endif value="1">Yes</option>
                                                <option @if($email_template['send_bcc'] == '0' ) selected @endif value="0">No</option>

                                            </select>                              
                                         </div>
                                         </div>
                                </div>
                                <div class="form-group row">
                             
                          
                               
                                         <div class="col-md-12">
                                        <label for="" class="form-label">Subject  </label>
                                        <div class="input-group mb-3">
										<span class="input-group-text"><i class="ti-user"></i></span>
                                        <input type="text" class="form-control" value="{{old('subject', $email_template['subject'])}}" name="subject" id="subject_box" />
                                 
                                         </div>
                                         </div>
                                </div>
                            
           

<div class="row">
                           
                           <div class="col-sm-12" style="padding-top: 10px;">
                               <label for="" class="form-label">Template Preview  </label>
                               <textarea type="text" class="form-control" name="template_html" value="" id="editor1" >{{$email_template['template_html']}}</textarea>

                           </div>
                       
                       </div>
                     
                            </div>
                                  
                            </div>
                        

                          
                      
                          
                           
							<!-- /.box-body -->
							<div class="box-footer text-end">
								<a href="/crm-email-templete"><button type="button" class="btn btn-warning me-1">
								  <i class="ti-trash"></i></a> Cancel
								</button>
								<button type="submit" name="submit" value="add" class="btn btn-primary">
								  <i class="ti-save-alt"></i> Save
								</button>
							</div>  
						</form>
					  </div>
					  <!-- /.box -->			

                    </div>  

		
		  </div>
		  <!-- /.row -->

		</section>

        <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>

    <script src="https://cdn.ckeditor.com/4.22.1/standard/ckeditor.js"></script>
        

<script language="javascript">
$(function () {
    CKEDITOR.config.autoParagraph = false;
    CKEDITOR.config.versionCheck = false;
    CKEDITOR.config.enterMode = CKEDITOR.ENTER_BR;
    CKEDITOR.config.shiftEnterMode = CKEDITOR.ENTER_P;
    CKEDITOR.replace('editor1', {
        enterMode: CKEDITOR.ENTER_BR,
        filebrowserUploadUrl: "{{route('start-dialing.upload', ['_token' => csrf_token() ])}}",
        filebrowserUploadMethod: 'form',
        allowedContent: true
        
    });

    $("#multiple_labels").on('change', function () {
        console.log($(this).val());
        var hidden_box = $('#setBoxValue').html();
        if (hidden_box == 'subject_box') {

            var cursorPos = $('#subject_box').prop('selectionStart');
            var v = $('#subject_box').val();
            var textBefore = v.substring(0, cursorPos);
            var textAfter = v.substring(cursorPos, v.length);
            $('#subject_box').val(textBefore + $(this).val() + textAfter);
        } else {
            for (var i in CKEDITOR.instances) {
                CKEDITOR.instances[i].insertHtml($(this).val());
            }
        }

    $("#multiple_labels").val('');
        
    });

    $("#multiple_names").on('change', function () {
        console.log($(this).val());
        var hidden_box = $('#setBoxValue').html();
        if (hidden_box == 'subject_box') {

            var cursorPos = $('#subject_box').prop('selectionStart');
            var v = $('#subject_box').val();
            var textBefore = v.substring(0, cursorPos);
            var textAfter = v.substring(cursorPos, v.length);
            $('#subject_box').val(textBefore + $(this).val() + textAfter);
        } else {

        for (var i in CKEDITOR.instances) {
            CKEDITOR.instances[i].insertHtml($(this).val());
        }
    }

    $("#multiple_names").val('');

    });

    $("#multiple_custom_names").on('change', function () {
        console.log($(this).val());
        var hidden_box = $('#setBoxValue').html();
        if (hidden_box == 'subject_box') {

            var cursorPos = $('#subject_box').prop('selectionStart');
            var v = $('#subject_box').val();
            var textBefore = v.substring(0, cursorPos);
            var textAfter = v.substring(cursorPos, v.length);
            $('#subject_box').val(textBefore + $(this).val() + textAfter);
        } else {

        for (var i in CKEDITOR.instances) {
            CKEDITOR.instances[i].insertHtml($(this).val());
        }

    }
    $("#multiple_custom_names").val('');

    });

    CKEDITOR.instances['editor1'].on('contentDom', function () {
        this.document.on('click', function (event) {
            $('#setBoxValue').html('');
        });
    });
});

$('#subject_box').on('click', function () {
    $('#setBoxValue').html('subject_box');
});


</script>
@endsection
