@extends('layouts.app')
@section('title', 'Dashboard')
@section('content')
<style>
:root {
    --card-bg: #ffffff;
    --text: #0f172a;
    --muted: #64748b;
    --ring-size: 50px;

    --r: 34;
    --c: 213.628;
}



.grid {
    display: grid;
    grid-template-columns: repeat(5, minmax(200px, 1fr));
    gap: 6px; /* Pehle 10px tha, ab kam kiya */
    padding: 10px 20px; /* Pehle 20px tha, ab vertical kam kiya */
}

.card {
    background: #fff;
    padding: 12px 16px;
    border-radius: 18px;
    box-shadow: 0 10px 25px rgba(2, 6, 23, .06), 0 2px 6px rgba(2, 6, 23, .04);
    display: flex;
    justify-content: center;
    gap: 14px;
    position: relative;
    overflow: hidden;
}

/* Common gradient border effect */
.card::before {
    content: "";
    position: absolute;
    inset: 0;
    padding: 2px; /* Border thickness */
    border-radius: inherit;
    background: var(--gradient, linear-gradient(135deg, #ccc, #999));
    -webkit-mask:
        linear-gradient(#fff 0 0) content-box,
        linear-gradient(#fff 0 0);
    -webkit-mask-composite: xor;
    mask-composite: exclude;
}

/* Gradients based on icon color */
.card:nth-child(1)::before {
    --gradient: linear-gradient(135deg, #22c55e, #16a34a); /* Green for Docs In */
}

.card:nth-child(2)::before {
    --gradient: linear-gradient(135deg, #ef4444, #dc2626); /* Red for Sales */
}

.card:nth-child(3)::before {
    --gradient: linear-gradient(135deg, #facc15, #eab308); /* Yellow/Orange for App Out */
}

.card:nth-child(4)::before {
    --gradient: linear-gradient(135deg, #8b5cf6, #7c3aed); /* Purple for Leads */
}

.card:nth-child(5)::before {
    --gradient: linear-gradient(135deg, #22c55e, #16a34a); /* Green for Lists */
}

.card:nth-child(6)::before {
    --gradient: linear-gradient(135deg, #ec4899, #db2777); /* Pink for Callback */
}

.card:nth-child(7)::before {
    --gradient: linear-gradient(135deg, #3b82f6, #2563eb); /* Blue for SMS Received */
}

.card:nth-child(8)::before {
    --gradient: linear-gradient(135deg, #9ca3af, #6b7280); /* Gray for SMS Sent */
}

.card:nth-child(9)::before {
    --gradient: linear-gradient(135deg, #3b82f6, #2563eb); /* Blue for Voicemail Received */
}

.card:nth-child(10)::before {
    --gradient: linear-gradient(135deg, #22c55e, #16a34a); /* Green for Unread Voicemail */
}

.card:hover::before {
    filter: brightness(1.2);
}


.card:hover {
    transform: translateY(-2px);
    box-shadow: 0 14px 32px rgba(2, 6, 23, .10), 0 4px 10px rgba(2, 6, 23, .06);
}

.row-layout {
    display: flex;
    align-items: center;
    gap: 15px;
}


.ring {
    width: var(--ring-size);
    height: var(--ring-size);
    display: grid;
    place-items: center;
    position: relative;
    flex-shrink: 0;
}

.ring svg {
    width: 100%;
    height: 100%;
    transform: rotate(-90deg);
}

.ring .bg {
    stroke: #eef2ff;
    stroke-width: 10;
    fill: none;
}

.ring .fg {
    stroke-linecap: round;
    stroke-width: 10;
    fill: none;
    stroke-dasharray: var(--c);
    stroke-dashoffset: calc((1 - var(--val) / 100) * var(--c));
    transition: stroke-dashoffset .9s cubic-bezier(.22, 1, .36, 1);
}

.ring .icon {
    position: absolute;
    font-size: 18px;
    color: #1f2937;
}

.meta {
    display: flex;
    flex-direction: column;
    gap: 5px;
}


.title {
    font-size: 14px;
    color: var(--muted);
    font-weight: 600;
}

.value {
    font-size: 18px;
    font-weight: 800;
}

/* Gradients */
.accent-green {
    stroke: #28a745;
}

.accent-red {
    stroke: #dc3545;
    /* Bright red color */
}

.accent-orange {
    stroke: url(#grad-orange);
}

.accent-purple {
    stroke: url(#grad-purple);
}

.accent-indigo {
    stroke: url(#grad-indigo);
}

.accent-pink {
    stroke: url(#grad-pink);
}

.accent-blue {
    stroke: url(#grad-blue);
}

.accent-gray {
    stroke: url(#grad-gray);
}

.accent-navy {
    stroke: url(#grad-navy);
}

.accent-lightgreen {
    stroke: url(#grad-lightgreen);
}

.custom-tab {
    border-radius: 20px;
    /* padding: 8px 18px; */
    font-weight: 500;
    color: #1e3a8a;
    background: #e0ecfa;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    gap: 6px;
}

.custom-tab:hover {
    background: #c2dff6;
    color: #0f172a;
}

.custom-tab.active {
    background: linear-gradient(135deg, #2563eb, #1e40af);
    color: #fff !important;
    box-shadow: 0 4px 8px rgba(37, 99, 235, 0.4);
}

.body-background {
    background-color: .bg-temple-white;
}
.entries-wrapper {
  display: flex;
  align-items: center;
  gap: 10px;
  font-family: 'Segoe UI', sans-serif;
  font-size: 14px;
  color: #333;
  margin-bottom: 15px;
}

.entries-label {
  font-weight: 500;
}

.custom-select {
  padding: 6px 12px;
  font-size: 14px;
  font-weight: 500;
  border-radius: 8px;
  border: 1px solid #ddd;
  background: linear-gradient(45deg, #f8f9fa, #ffffff);
  box-shadow: 0px 2px 6px rgba(0,0,0,0.08);
  cursor: pointer;
  transition: all 0.3s ease;
}

.custom-select:focus {
  outline: none;
  border-color: #007bff;
  box-shadow: 0px 0px 6px rgba(0,123,255,0.5);
}

.custom-select option {
  padding: 10px;
}

/* Responsive Layout */
@media (max-width: 1200px) {
  .grid {
    grid-template-columns: repeat(3, 1fr); 
  }
}

@media (max-width: 992px) {
  .grid {
    grid-template-columns: repeat(2, 1fr); 
  }
}

@media (max-width: 576px) {
  .grid {
    grid-template-columns: 1fr; 
  }
  
  .card {
    padding: 10px 12px;
    border-radius: 14px;
  }

  .row-layout {
    flex-direction: row; 
    gap: 10px;
  }

  .title {
    font-size: 13px;
  }

  .value {
    font-size: 16px;
  }

  .ring {
    --ring-size: 40px; 
  }
}

</style>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<body class="body-background">
    <div class="grid">


        <!-- Users -->
        <div class="card" style="--val:100">
            <div class="row-layout">
                <div class="ring">
                    <svg viewBox="0 0 100 100">
                        <defs>
                            <linearGradient id="grad-green" x1="0%" y1="0%" x2="100%" y2="100%">
                                <stop offset="0%" stop-color="#86efac" />
                                <stop offset="100%" stop-color="#22c55e" />
                            </linearGradient>
                        </defs>
                        <circle class="bg" cx="50" cy="50" r="34" />
                        <circle class="fg accent-green" cx="50" cy="50" r="34" />
                    </svg>
                    <i class="icon fa-solid fa-user-plus"></i>
                </div>

                <div class="meta">
                    <div class="title">Docs In</div>
                    <div class="value">34</div>
                </div>
            </div>
        </div>


        <!-- Phone Numbers -->
        <div class="card" style="--val:100">
            <div class="row-layout">
                <div class="ring">
                    <svg viewBox="0 0 100 100">
                        <defs>
                            <linearGradient id="grad-red" x1="0%" y1="0%" x2="100%" y2="100%">
                                <stop offset="0%" stop-color="#fca5a5" />
                                <stop offset="100%" stop-color="#ef4444" />
                            </linearGradient>
                        </defs>
                        <circle class="bg" cx="50" cy="50" r="34" />
                        <circle class="fg accent-red" cx="50" cy="50" r="34" />
                    </svg>
                    <i class="icon fa-solid fa-phone"></i>
                </div>
                <div class="meta">
                    <div class="title">Sales</div>
                    <div class="value">0</div>
                </div>
            </div>
        </div>

        <!-- Campaigns -->
        <div class="card" style="--val:100">
            <div class="row-layout">
                <div class="ring">
                    <svg viewBox="0 0 100 100">
                        <defs>
                            <linearGradient id="grad-orange" x1="0%" y1="0%" x2="100%" y2="100%">
                                <stop offset="0%" stop-color="#fde68a" />
                                <stop offset="100%" stop-color="#f59e0b" />
                            </linearGradient>
                        </defs>
                        <circle class="bg" cx="50" cy="50" r="34" />
                        <circle class="fg accent-orange" cx="50" cy="50" r="34" />
                    </svg>
                    <i class="icon fa-solid fa-bullhorn"></i>
                </div>
                <div class="meta">
                    <div class="title">App Out </div>
                    <div class="value">56</div>
                </div>
            </div>
        </div>

        <!-- Leads -->
        <div class="card" style="--val:100">
            <div class="row-layout">
                <div class="ring">
                    <svg viewBox="0 0 100 100">
                        <defs>
                            <linearGradient id="grad-purple" x1="0%" y1="0%" x2="100%" y2="100%">
                                <stop offset="0%" stop-color="#a78bfa" />
                                <stop offset="100%" stop-color="#7c3aed" />
                            </linearGradient>
                        </defs>
                        <circle class="bg" cx="50" cy="50" r="34" />
                        <circle class="fg accent-purple" cx="50" cy="50" r="34" />
                    </svg>
                    <i class="icon fa-solid fa-users"></i>
                </div>
                <div class="meta">
                    <div class="title">Leads</div>
                    <div class="value">32,474</div>
                </div>
            </div>
        </div>

        <!-- Lists -->
        <div class="card" style="--val:100">
            <div class="row-layout">
                <div class="ring">
                    <svg viewBox="0 0 100 100">
                        <defs>
                            <linearGradient id="grad-indigo" x1="0%" y1="0%" x2="100%" y2="100%">
                                <stop offset="0%" stop-color="#c4b5fd" />
                                <stop offset="100%" stop-color="#6d28d9" />
                            </linearGradient>
                        </defs>
                        <circle class="bg" cx="50" cy="50" r="34" />
                        <circle class="fg accent-indigo" cx="50" cy="50" r="34" />
                    </svg>
                    <i class="icon fa-solid fa-list"></i>
                </div>
                <div class="meta">
                    <div class="title">Lists</div>
                    <div class="value">17</div>
                </div>
            </div>
        </div>

        <!-- Callback -->
        <div class="card" style="--val:100">
            <div class="row-layout">
                <div class="ring">
                    <svg viewBox="0 0 100 100">
                        <defs>
                            <linearGradient id="grad-pink" x1="0%" y1="0%" x2="100%" y2="100%">
                                <stop offset="0%" stop-color="#fbcfe8" />
                                <stop offset="100%" stop-color="#ec4899" />
                            </linearGradient>
                        </defs>
                        <circle class="bg" cx="50" cy="50" r="34" />
                        <circle class="fg accent-pink" cx="50" cy="50" r="34" />
                    </svg>
                    <i class="icon fa-solid fa-phone-volume"></i>
                </div>
                <div class="meta">
                    <div class="title">Callback</div>
                    <div class="value">1</div>
                </div>
            </div>
        </div>

        <!-- SMS Received -->
        <div class="card" style="--val:100">
            <div class="row-layout">
                <div class="ring">
                    <svg viewBox="0 0 100 100">
                        <defs>
                            <linearGradient id="grad-blue" x1="0%" y1="0%" x2="100%" y2="100%">
                                <stop offset="0%" stop-color="#93c5fd" />
                                <stop offset="100%" stop-color="#3b82f6" />
                            </linearGradient>
                        </defs>
                        <circle class="bg" cx="50" cy="50" r="34" />
                        <circle class="fg accent-blue" cx="50" cy="50" r="34" />
                    </svg>
                    <i class="icon fa-solid fa-comment-dots"></i>
                </div>
                <div class="meta">
                    <div class="title">SMS Received</div>
                    <div class="value">0</div>
                </div>
            </div>
        </div>

        <!-- SMS Sent -->
        <div class="card" style="--val:100">
            <div class="row-layout">
                <div class="ring">
                    <svg viewBox="0 0 100 100">
                        <defs>
                            <linearGradient id="grad-gray" x1="0%" y1="0%" x2="100%" y2="100%">
                                <stop offset="0%" stop-color="#e5e7eb" />
                                <stop offset="100%" stop-color="#6b7280" />
                            </linearGradient>
                        </defs>
                        <circle class="bg" cx="50" cy="50" r="34" />
                        <circle class="fg accent-gray" cx="50" cy="50" r="34" />
                    </svg>
                    <i class="icon fa-solid fa-paper-plane"></i>
                </div>
                <div class="meta">
                    <div class="title">SMS Sent</div>
                    <div class="value">0</div>
                </div>
            </div>
        </div>

        <!-- Voicemail Received -->
        <div class="card" style="--val:100">
            <div class="row-layout">
                <div class="ring">
                    <svg viewBox="0 0 100 100">
                        <defs>
                            <linearGradient id="grad-navy" x1="0%" y1="0%" x2="100%" y2="100%">
                                <stop offset="0%" stop-color="#93c5fd" />
                                <stop offset="100%" stop-color="#1e3a8a" />
                            </linearGradient>
                        </defs>
                        <circle class="bg" cx="50" cy="50" r="34" />
                        <circle class="fg accent-navy" cx="50" cy="50" r="34" />
                    </svg>
                    <i class="icon fa-solid fa-envelope"></i>
                </div>
                <div class="meta">
                    <div class="title">Voicemail Received</div>
                    <div class="value">0</div>
                </div>
            </div>
        </div>

        <!-- Unread Voicemail -->
        <div class="card" style="--val:100">
            <div class="row-layout">
                <div class="ring">
                    <svg viewBox="0 0 100 100">
                        <defs>
                            <linearGradient id="grad-lightgreen" x1="0%" y1="0%" x2="100%" y2="100%">
                                <stop offset="0%" stop-color="#bbf7d0" />
                                <stop offset="100%" stop-color="#16a34a" />
                            </linearGradient>
                        </defs>
                        <circle class="bg" cx="50" cy="50" r="34" />
                        <circle class="fg accent-lightgreen" cx="50" cy="50" r="34" />
                    </svg>
                    <i class="icon fa-solid fa-bell"></i>
                </div>
                <div class="meta">
                    <div class="title">Unread Voicemail</div>
                    <div class="value">0</div>
                </div>
            </div>
        </div>

    </div>

    <!-- <div class="row mb-3">
        <div class="col-12 text-center">
           
            <button id="toggleFilter" class="btn btn-primary">
                <i class="fa fa-filter"></i> Filter
            </button>
        </div>
    </div> -->


  
<!-- Filter Form (Hidden by default) -->
<div id="filterBox" class="card shadow-sm p-3 mt-2 mx-3 stable-card" style="display:none; position:relative;">
    <!-- Close Button -->
    <button type="button" class="btn-close" aria-label="Close" 
            onclick="document.getElementById('filterBox').style.display='none'" 
            style="position:absolute; top:10px; right:10px;"></button>
    
    <div class="row g-3 mt-2">
        <!-- First Name -->
        <div class="col-md-3">
            <label>First Name</label>
            <div class="input-group">
                <span class="input-group-text"><i class="fa fa-user"></i></span>
                <input type="text" class="form-control" placeholder="First Name">
            </div>
        </div>

        <!-- Last Name -->
        <div class="col-md-3">
            <label>Last Name</label>
            <div class="input-group">
                <span class="input-group-text"><i class="fa fa-user"></i></span>
                <input type="text" class="form-control" placeholder="Last Name">
            </div>
        </div>

        <!-- DBA -->
        <div class="col-md-3">
            <label>DBA</label>
            <input type="text" class="form-control" placeholder="DBA">
        </div>

        <!-- Phone Number -->
        <div class="col-md-3">
            <label>Phone Number</label>
            <div class="input-group">
                <span class="input-group-text"><i class="fa fa-phone"></i></span>
                <input type="text" class="form-control" placeholder="Phone Number">
            </div>
        </div>

        <!-- Email -->
        <div class="col-md-3">
            <label>Email</label>
            <div class="input-group">
                <span class="input-group-text"><i class="fa fa-envelope"></i></span>
                <input type="email" class="form-control" placeholder="Email">
            </div>
        </div>

        <!-- Company Name -->
        <div class="col-md-3">
            <label>Company Name</label>
            <div class="input-group">
                <span class="input-group-text"><i class="fa fa-building"></i></span>
                <input type="text" class="form-control" placeholder="Company Name">
            </div>
        </div>

        <!-- Lead Status -->
        <div class="col-md-3">
            <label>Lead Status</label>
            <input type="text" class="form-control" placeholder="Lead Status">
        </div>

        <!-- Assigned To -->
        <div class="col-md-3">
            <label>Assigned To</label>
            <input type="text" class="form-control" placeholder="Assigned To">
        </div>

        <!-- Lead Type -->
        <div class="col-md-3">
            <label>Lead Type</label>
            <input type="text" class="form-control" placeholder="Lead Type">
        </div>

        <!-- Date Range -->
        <div class="col-md-3">
            <label>Date Range</label>
            <div class="input-group">
                <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                <input type="text" class="form-control" placeholder="Date Range">
            </div>
        </div>
    </div>

    <!-- Action Buttons -->
    <div class="mt-3 d-flex justify-content-end gap-2">
        <button class="btn btn-danger">Reset</button>
        <button class="btn btn-primary">Submit</button>
    </div>
</div>

<style>
.stable-card {
    margin-top: 8px !important;          
    transition: none !important;
    transform: none !important;
}


.stable-card:hover {
    box-shadow: 0 2px 6px rgba(0,0,0,0.08) !important; 
    transform: none !important;
}


@media (max-width: 991px) and (min-width: 768px) {
  #filterBox .row > div {
    flex: 0 0 50% !important;   
    max-width: 50% !important;
  }
}


@media (max-width: 767px) {
  #filterBox .row > div {
    flex: 0 0 100% !important;  
    max-width: 100% !important;
  }

 
  #filterBox .d-flex {
    flex-direction: column;
    align-items: stretch;
  }
  #filterBox .d-flex button {
    width: 100%;
  }
}

</style>


<style>
.status-toggle {
    position: relative;
    display: flex;
    justify-content: space-between;
    width: 260px; 
    margin: 0 auto;
    background: #f4f4f4;
    border-radius: 30px;
    padding: 4px;
    font-weight: 600;
    font-size: 14px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.08);
}

.status-toggle .toggle-option {
    flex: 1;
    text-align: center;
    padding: 8px 0;
    cursor: pointer;
    position: relative;
    z-index: 2;
    color: #333;
    transition: color 0.3s ease;
    border-radius: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 6px;
}

.status-toggle .toggle-option i {
    font-size: 14px;
}

.status-toggle .toggle-option.active {
    color: #fff;
}

.status-toggle .toggle-indicator {
    position: absolute;
    top: 4px;
    bottom: 4px;
    width: calc(33.33% - 8px);
    border-radius: 20px;
    transition: all 0.3s ease;
    z-index: 1;
}

/* Gradient Colors */
.status-toggle .toggle-option[data-status="Hot"].active ~ .toggle-indicator {
    left: 4px;
    background: linear-gradient(45deg, #ff4d4d, #ff0000);
}

.status-toggle .toggle-option[data-status="Warm"].active ~ .toggle-indicator {
    left: calc(33.33% + 4px);
    background: linear-gradient(45deg, #f39c12, #f1c40f);
}

.status-toggle .toggle-option[data-status="Cold"].active ~ .toggle-indicator {
    left: calc(66.66% + 4px);
    background: linear-gradient(45deg, #2980b9, #3498db);
}

/* ==== Card / Box ==== */
.box {
  margin: 0;
  border-radius: 10px;
  background: #fff;
  box-shadow: 0 2px 6px rgba(0,0,0,0.08);
  overflow: hidden;
}

.row {
  margin-left: 0;
  margin-right: 0;
  padding-left: 8px;
  padding-right: 8px; 
}

.box-body {
  padding: 0; 
}

.table-responsive {
  display: block;
  width: 100%;
  overflow-x: auto;           
  padding-bottom: 6px;         
}

.table {
  min-width: 1000px;            
  border-collapse: collapse;
  width: 100%;
  border: 1px solid #dee2e6;   
}

/* ==== Table Head ==== */
.custom-thead {
  background: linear-gradient(90deg, #6a11cb, #2575fc);
  color: #fff;
}

.table thead th {
  font-size: 13px;
  font-weight: 600;
  text-align: center;
  padding: 8px;
  line-height: 1.2;
  border: 1px solid #dee2e6;   
  border-bottom: none;        
  white-space: nowrap;
}

/* Remove extra border-radius */
.table thead tr:first-child th:first-child {
  border-top-left-radius: 0;
}
.table thead tr:first-child th:last-child {
  border-top-right-radius: 0;
}

/* ==== Table Body ==== */
.table tbody td {
  padding: 8px;
  border: 1px solid #dee2e6;
  vertical-align: middle;
  font-size: 13px;
}

.table tbody tr:nth-child(even) {
  background-color: #f9f9f9;
}

/* ==== Filter Button ==== */
#toggleFilter {
  padding: 4px 10px;
  font-size: 13px;
  border-radius: 4px;
}

/* ==== Entries Dropdown ==== */
.entries-wrapper {
  display: flex;
  align-items: center;
  gap: 5px;
  font-size: 13px;
}

.entries-wrapper .custom-select {
  padding: 2px 6px;
  font-size: 13px;
}


/* ===== Tablet View (768px – 991px) ===== */
@media (max-width: 991px) {
  /* Header layout */
  .box-header {
    flex-wrap: wrap;
    gap: 10px;
    justify-content: center !important;
  }

  /* Toggle center with full width */
  .status-toggle {
    width: 100%;
    max-width: 400px;
    margin: 0 auto;
    order: 2; /* search ke baad show ho */
  }

  /* Search input + filter */
  .box-header .d-flex {
    flex-wrap: wrap;
    gap: 8px;
    justify-content: center;
    width: 100%;
    order: 3;
  }

  .box-header input[type="text"] {
    width: 200px !important;
  }

  #toggleFilter {
    flex-shrink: 0;
  }

  /* Table width adjust */
  .table {
    min-width: 800px;
    font-size: 13px;
  }

  .table thead th,
  .table tbody td {
    padding: 6px 8px;
  }
}

/* ===== Mobile View (<576px) ===== */
@media (max-width: 576px) {
  .box-header {
    flex-direction: column;
    align-items: stretch !important;
    gap: 12px;
  }

  .status-toggle {
    width: 100%;
    max-width: 100%;
    font-size: 12px;
    padding: 4px;
    order: 1;
  }

  .status-toggle .toggle-option {
    font-size: 12px;
    padding: 6px 0;
  }

  .box-header input[type="text"],
  #toggleFilter {
    width: 100% !important;
  }

  .table {
    min-width: 650px;
    font-size: 12px;
  }

  .table thead th,
  .table tbody td {
    padding: 5px;
  }

  .entries-wrapper {
    flex-wrap: wrap;
    justify-content: center;
    gap: 6px;
  }
}


</style>



    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-header with-border d-flex justify-content-between align-items-center"
                    style="padding:15px">
                    <h4 class="box-title mb-0">
                        <i class="fa fa-user" style="margin-right:8px;color:blueviolet;"></i>
                        Agent Wise Call &nbsp;&nbsp;
                    </h4>

<div class="status-toggle" id="statusFilter">
    <div class="toggle-option active" data-status="Hot"><i class="fa fa-fire"></i> Hot</div>
    <div class="toggle-option" data-status="Warm"><i class="fa fa-sun"></i> Warm</div>
    <div class="toggle-option" data-status="Cold"><i class="fa fa-snowflake"></i> Cold</div>
    <div class="toggle-indicator"></div>
</div>





                    <div class="d-flex align-items-center" style="gap:10px;">
                       
                        <!-- Search Bar -->
                        <input type="text" id="agentSearch" class="form-control form-control-md "
                            placeholder="Search Agent..." style="width:180px;">

                        <!-- Dropdown -->
                        <!-- <select id="statusFilter" class="form-control form-control-md " style="width:150px;">

                            <option value="warm" style="background-color:Yellow">Warm </option>
                            <option value="Docs In" style="background-color:Red">Hot </option>
                            <option value="App Out" style="background-color:Blue">Cold </option>
                        </select> -->


                          <button id="toggleFilter" class="btn btn-primary">
                <i class="fa fa-filter"></i> Filter
            </button>
                    


                    </div>
                </div>


          
                <div class="box-body">
  <div class="table-responsive">
  <table class="table custom-table" style="min-width:1200px;">

     <thead class="bg-gradient-info text-white custom-thead">

        <tr>
          <th>#</th>
          <th>DBA</th>
          <th>Updated Label</th>
          <th>First Name</th>
          <th>Email</th>
          <th>Mobile</th>
          <th>Gender</th>
          <th>Status</th>
          <th>Created</th>
          <th>Modified</th>
          <th>Assigned To</th>
          <th>Created By</th>
          <th>Action</th>
        </tr>
      </thead>
         <tbody>
                                <tr>
                                    <td>182</td>
                                    <td></td>
                                    <td></td>
                                    <td>Himanshuu</td>
                                    <td>arorashikha1012955@gmail.com</td>
                                    <td>(510) 630-2725</td>
                                    <td>Female</td>
                                    <td><span class="badge bg-danger">Sales</span></td>
                                    <td>01/09/2025</td>
                                    <td>02/18/2025</td>
                                    <td>Andrew Gomez</td>
                                    <td>Shikha Chhabra</td>
                                    <td>
                                        <i class="fa fa-edit"></i>
                                        <i class="fa fa-eye"></i>
                                    </td>
                                </tr>

                            </tbody>
    </table>
  </div>
</div>

                <div class="box-footer">
                     <div class="entries-wrapper">
  <span class="entries-label">Show</span>
  <select class="custom-select">
    <option value="10">10</option>
    <option value="25">25</option>
    <option value="50">50</option>
    <option value="100">100</option>
  </select>
  <span class="entries-label">entries</span>
</div>
                </div>
            </div>

        </div>

    </div>
</body>
<script>
document.querySelectorAll('.card').forEach(card => {
    const target = parseFloat(getComputedStyle(card).getPropertyValue('--val'));
    card.style.setProperty('--val', 0);
    requestAnimationFrame(() => {
        requestAnimationFrame(() => card.style.setProperty('--val', target));
    });
});


document.getElementById("toggleFilter").addEventListener("click", function() {
    let box = document.getElementById("filterBox");
    box.style.display = (box.style.display === "none" || box.style.display === "") ? "block" : "none";
});
</script>

<script>
document.querySelectorAll('.toggle-option').forEach(option => {
    option.addEventListener('click', () => {
        document.querySelectorAll('.toggle-option').forEach(opt => opt.classList.remove('active'));
        option.classList.add('active');
    });
});
</script>

<!-- Vendor JS -->
<script src="js/vendors.min.js"></script>
<script src="js/pages/chat-popup.js"></script>
<script src="../assets/icons/feather-icons/feather.min.js"></script>
<script src="../assets/vendor_components/c3/d3.min.js"></script>
<script src="../assets/vendor_components/c3/c3.min.js"></script>


<!-- Joblly App -->
<script src="https://code.highcharts.com/dashboards/dashboards.js"></script>
<script src="js/template.js"></script>

<script src="https://code.highcharts.com/dashboards/dashboards.js"></script>


<!-- Joblly App -->
<script src="js/template.js"></script>

@endsection