@extends('layouts.app')
@section('title', 'Outbound AI Dashboard')
@section('content')

{{-- ============================================================
     OUTBOUND AI CALLS DASHBOARD
     - Chart.js for all visualisations
     - Dummy data embedded (replace with API calls later)
     - Minimal palette: white / #f8fafc / #3b82f6
     ============================================================ --}}

{{-- ===== Google Fonts – Inter ===== --}}
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">

<style>
/* ============================
   CSS CUSTOM PROPERTIES
   ============================ */
:root {
    --ob-font: 'Inter', system-ui, -apple-system, sans-serif;
    --ob-bg: #f8fafc;
    --ob-card: #ffffff;
    --ob-border: #e5e7eb;
    --ob-text: #111827;
    --ob-muted: #6b7280;
    --ob-blue: #3b82f6;
    --ob-blue-light: #eff6ff;
    --ob-green: #10b981;
    --ob-red: #ef4444;
    --ob-amber: #f59e0b;
    --ob-purple: #8b5cf6;
    --ob-radius: 10px;
    --ob-shadow: 0 1px 3px rgba(0,0,0,0.06), 0 1px 2px rgba(0,0,0,0.04);
}

/* ============================
   BASE RESET INSIDE DASHBOARD
   ============================ */
.ob-dashboard {
    font-family: var(--ob-font);
    background: var(--ob-bg);
    padding: 24px;
    min-height: 100vh;
    color: var(--ob-text);
}

.ob-dashboard *, .ob-dashboard *::before, .ob-dashboard *::after {
    box-sizing: border-box;
}

/* ============================
   PAGE HEADER
   ============================ */
.ob-page-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    flex-wrap: wrap;
    gap: 16px;
    margin-bottom: 24px;
}

.ob-page-header h1 {
    font-size: 22px;
    font-weight: 700;
    margin: 0;
    color: var(--ob-text);
}

.ob-page-header h1 span {
    font-weight: 400;
    color: var(--ob-muted);
    font-size: 14px;
    margin-left: 8px;
}

/* ============================
   FILTER BAR
   ============================ */
.ob-filters {
    display: flex;
    align-items: center;
    gap: 12px;
    flex-wrap: wrap;
}

.ob-filters select,
.ob-filters input[type="date"] {
    font-family: var(--ob-font);
    font-size: 13px;
    padding: 7px 12px;
    border: 1px solid var(--ob-border);
    border-radius: 6px;
    background: var(--ob-card);
    color: var(--ob-text);
    outline: none;
    transition: border-color 0.2s;
}

.ob-filters select:focus,
.ob-filters input[type="date"]:focus {
    border-color: var(--ob-blue);
}

.ob-filter-btn {
    font-family: var(--ob-font);
    font-size: 13px;
    font-weight: 600;
    padding: 7px 18px;
    border: none;
    border-radius: 6px;
    background: var(--ob-blue);
    color: #fff;
    cursor: pointer;
    transition: background 0.2s;
}

.ob-filter-btn:hover { background: #2563eb; }

/* ============================
   GRID HELPERS
   ============================ */
.ob-grid { display: grid; gap: 20px; }
.ob-grid-6 { grid-template-columns: repeat(6, 1fr); }
.ob-grid-3 { grid-template-columns: repeat(3, 1fr); }
.ob-grid-2 { grid-template-columns: repeat(2, 1fr); }
.ob-grid-2-1 { grid-template-columns: 2fr 1fr; }
.ob-grid-1-1 { grid-template-columns: 1fr 1fr; }

/* ============================
   CARD
   ============================ */
.ob-card {
    background: var(--ob-card);
    border: 1px solid var(--ob-border);
    border-radius: var(--ob-radius);
    box-shadow: var(--ob-shadow);
    padding: 20px;
}

.ob-card-title {
    font-size: 13px;
    font-weight: 600;
    color: var(--ob-muted);
    text-transform: uppercase;
    letter-spacing: 0.5px;
    margin: 0 0 16px;
}

/* ============================
   SUMMARY STAT CARDS (ROW 1)
   ============================ */
.ob-stat {
    display: flex;
    align-items: flex-start;
    gap: 14px;
    padding: 18px;
}

.ob-stat-icon {
    width: 42px;
    height: 42px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
    font-size: 18px;
}

.ob-stat-icon.blue   { background: var(--ob-blue-light); color: var(--ob-blue); }
.ob-stat-icon.green  { background: #ecfdf5; color: var(--ob-green); }
.ob-stat-icon.amber  { background: #fffbeb; color: var(--ob-amber); }
.ob-stat-icon.red    { background: #fef2f2; color: var(--ob-red); }
.ob-stat-icon.purple { background: #f5f3ff; color: var(--ob-purple); }

.ob-stat-body h3 {
    font-size: 24px;
    font-weight: 700;
    margin: 0 0 2px;
    line-height: 1.2;
    color: var(--ob-text);
}

.ob-stat-body p {
    font-size: 13px;
    color: var(--ob-muted);
    margin: 0;
}

/* ============================
   CHART CONTAINERS
   ============================ */
.ob-chart-wrap {
    position: relative;
    width: 100%;
}

.ob-chart-wrap.ob-h-280 { height: 280px; }
.ob-chart-wrap.ob-h-260 { height: 260px; }
.ob-chart-wrap.ob-h-220 { height: 220px; }

/* ============================
   AI METRIC MINI CARDS
   ============================ */
.ob-ai-metrics {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 12px;
    margin-top: 16px;
}

.ob-ai-metric {
    background: var(--ob-blue-light);
    border-radius: 8px;
    padding: 14px;
    text-align: center;
}

.ob-ai-metric h4 {
    font-size: 22px;
    font-weight: 700;
    color: var(--ob-blue);
    margin: 0 0 2px;
}

.ob-ai-metric p {
    font-size: 12px;
    color: var(--ob-muted);
    margin: 0;
}

/* ============================
   DATA TABLE
   ============================ */
.ob-table-wrap {
    overflow-x: auto;
}

.ob-table {
    width: 100%;
    border-collapse: collapse;
    font-size: 13.5px;
}

.ob-table thead th {
    text-align: left;
    font-weight: 600;
    color: var(--ob-muted);
    font-size: 12px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    padding: 10px 14px;
    border-bottom: 2px solid var(--ob-border);
    white-space: nowrap;
    cursor: pointer;
    user-select: none;
    position: relative;
}

.ob-table thead th:hover { color: var(--ob-blue); }

.ob-table thead th .ob-sort-icon {
    margin-left: 4px;
    font-size: 10px;
    opacity: 0.4;
}

.ob-table thead th.ob-sorted .ob-sort-icon { opacity: 1; color: var(--ob-blue); }

.ob-table tbody td {
    padding: 12px 14px;
    border-bottom: 1px solid #f3f4f6;
    color: var(--ob-text);
    white-space: nowrap;
}

.ob-table tbody tr:hover { background: #f9fafb; }

.ob-table tbody tr:last-child td { border-bottom: none; }

/* Status badges */
.ob-badge {
    display: inline-block;
    font-size: 11.5px;
    font-weight: 600;
    padding: 3px 10px;
    border-radius: 20px;
}

.ob-badge-active  { background: #ecfdf5; color: #065f46; }
.ob-badge-paused  { background: #fef3c7; color: #92400e; }

.ob-badge-connected  { background: #ecfdf5; color: #065f46; }
.ob-badge-noanswer   { background: #fef3c7; color: #92400e; }
.ob-badge-busy       { background: #fef2f2; color: #991b1b; }
.ob-badge-voicemail  { background: var(--ob-blue-light); color: #1e40af; }
.ob-badge-failed     { background: #fef2f2; color: #991b1b; }

/* ============================
   SECTION SPACING
   ============================ */
.ob-section { margin-bottom: 20px; }

/* ============================
   RESPONSIVE
   ============================ */
@media (max-width: 1400px) {
    .ob-grid-6 { grid-template-columns: repeat(3, 1fr); }
}

@media (max-width: 1100px) {
    .ob-grid-2, .ob-grid-2-1, .ob-grid-1-1 { grid-template-columns: 1fr; }
}

@media (max-width: 768px) {
    .ob-dashboard { padding: 16px; }
    .ob-grid-6 { grid-template-columns: repeat(2, 1fr); }
    .ob-grid-3 { grid-template-columns: 1fr; }
    .ob-page-header { flex-direction: column; align-items: flex-start; }
    .ob-stat-body h3 { font-size: 20px; }
}

@media (max-width: 480px) {
    .ob-grid-6 { grid-template-columns: 1fr; }
}
</style>


{{-- ===========================
     DASHBOARD HTML
     =========================== --}}
<div class="ob-dashboard">

    {{-- -------- PAGE HEADER + FILTERS -------- --}}
    <div class="ob-page-header">
        <h1>Outbound AI Dashboard <span>Real-time calling performance</span></h1>

        <div class="ob-filters">
            <input type="date" id="obFilterFrom" title="From date">
            <input type="date" id="obFilterTo" title="To date">
            <select id="obFilterCampaign">
                <option value="">All Campaigns</option>
                <option>Insurance Leads Q1</option>
                <option>Loan Reactivation</option>
                <option>Free Trial Follow-Up</option>
                <option>Renewal Reminder</option>
                <option>Feedback Collection</option>
            </select>
            <select id="obFilterStatus">
                <option value="">All Statuses</option>
                <option>Connected</option>
                <option>Not Answered</option>
                <option>Busy</option>
                <option>Voicemail</option>
                <option>Failed</option>
            </select>
            <button class="ob-filter-btn" onclick="applyFilters()">Apply</button>
        </div>
    </div>


    {{-- ======================================
         SECTION 1 – SUMMARY STAT CARDS
         ====================================== --}}
    <div class="ob-grid ob-grid-6 ob-section">

        {{-- Total Outbound Calls --}}
        <div class="ob-card ob-stat">
            <div class="ob-stat-icon blue"><i class="fa-solid fa-phone-arrow-up-right fa-phone"></i></div>
            <div class="ob-stat-body">
                <h3 id="statTotalCalls">12,482</h3>
                <p>Total Outbound Calls</p>
            </div>
        </div>

        {{-- Connected Calls --}}
        <div class="ob-card ob-stat">
            <div class="ob-stat-icon green"><i class="fa-solid fa-plug fa-phone-volume"></i></div>
            <div class="ob-stat-body">
                <h3 id="statConnected">8,736</h3>
                <p>Connected Calls</p>
            </div>
        </div>

        {{-- Answered by Human --}}
        <div class="ob-card ob-stat">
            <div class="ob-stat-icon purple"><i class="fa-solid fa-user-check"></i></div>
            <div class="ob-stat-body">
                <h3 id="statHuman">6,210</h3>
                <p>Answered by Human</p>
            </div>
        </div>

        {{-- Dropped / Failed --}}
        <div class="ob-card ob-stat">
            <div class="ob-stat-icon red"><i class="fa-solid fa-phone-slash"></i></div>
            <div class="ob-stat-body">
                <h3 id="statFailed">1,024</h3>
                <p>Dropped / Failed</p>
            </div>
        </div>

        {{-- Conversion Rate --}}
        <div class="ob-card ob-stat">
            <div class="ob-stat-icon amber"><i class="fa-solid fa-bullseye"></i></div>
            <div class="ob-stat-body">
                <h3 id="statConversion">18.4%</h3>
                <p>Conversion Rate</p>
            </div>
        </div>

        {{-- Avg Call Duration --}}
        <div class="ob-card ob-stat">
            <div class="ob-stat-icon blue"><i class="fa-solid fa-clock"></i></div>
            <div class="ob-stat-body">
                <h3 id="statAvgDuration">2m 38s</h3>
                <p>Avg Call Duration</p>
            </div>
        </div>
    </div>


    {{-- ======================================
         SECTION 2 – MAIN CHARTS
         Line (Calls/Day) + Bar (Campaign-wise)
         ====================================== --}}
    <div class="ob-grid ob-grid-1-1 ob-section">

        {{-- Calls Per Day – Line Chart --}}
        <div class="ob-card">
            <p class="ob-card-title">Calls Per Day <span style="font-weight:400; text-transform:none; letter-spacing:0;">(Last 30 Days)</span></p>
            <div class="ob-chart-wrap ob-h-280">
                <canvas id="chartCallsPerDay"></canvas>
            </div>
        </div>

        {{-- Campaign-wise Call Count – Bar Chart --}}
        <div class="ob-card">
            <p class="ob-card-title">Campaign-wise Call Count</p>
            <div class="ob-chart-wrap ob-h-280">
                <canvas id="chartCampaignBars"></canvas>
            </div>
        </div>
    </div>


    {{-- ======================================
         SECTION 3 – OUTCOMES PIE + AI PERF
         ====================================== --}}
    <div class="ob-grid ob-grid-3 ob-section">

        {{-- Call Outcome Distribution – Pie --}}
        <div class="ob-card">
            <p class="ob-card-title">Call Outcome Distribution</p>
            <div class="ob-chart-wrap ob-h-260">
                <canvas id="chartOutcomePie"></canvas>
            </div>
        </div>

        {{-- AI vs Human Handover – Doughnut --}}
        <div class="ob-card">
            <p class="ob-card-title">AI vs Human Handover</p>
            <div class="ob-chart-wrap ob-h-260">
                <canvas id="chartAiHuman"></canvas>
            </div>
        </div>

        {{-- AI Performance Metrics --}}
        <div class="ob-card">
            <p class="ob-card-title">AI Performance</p>
            <div class="ob-chart-wrap ob-h-220">
                <canvas id="chartAiSuccess"></canvas>
            </div>
            <div class="ob-ai-metrics">
                <div class="ob-ai-metric">
                    <h4>1.2s</h4>
                    <p>Avg AI Response Time</p>
                </div>
                <div class="ob-ai-metric">
                    <h4>87.3%</h4>
                    <p>AI Completion Rate</p>
                </div>
            </div>
        </div>
    </div>


    {{-- ======================================
         SECTION 4 – CAMPAIGN PERFORMANCE TABLE
         ====================================== --}}
    <div class="ob-card ob-section">
        <p class="ob-card-title">Campaign Performance</p>
        <div class="ob-table-wrap">
            <table class="ob-table" id="campaignTable">
                <thead>
                    <tr>
                        <th onclick="sortTable(0)">Campaign Name <span class="ob-sort-icon"><i class="fa-solid fa-sort"></i></span></th>
                        <th onclick="sortTable(1)">Total Calls <span class="ob-sort-icon"><i class="fa-solid fa-sort"></i></span></th>
                        <th onclick="sortTable(2)">Connected <span class="ob-sort-icon"><i class="fa-solid fa-sort"></i></span></th>
                        <th onclick="sortTable(3)">Conversion % <span class="ob-sort-icon"><i class="fa-solid fa-sort"></i></span></th>
                        <th onclick="sortTable(4)">Avg Duration <span class="ob-sort-icon"><i class="fa-solid fa-sort"></i></span></th>
                        <th onclick="sortTable(5)">Status <span class="ob-sort-icon"><i class="fa-solid fa-sort"></i></span></th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><strong>Insurance Leads Q1</strong></td>
                        <td>3,842</td>
                        <td>2,690</td>
                        <td>22.1%</td>
                        <td>3m 12s</td>
                        <td><span class="ob-badge ob-badge-active">Active</span></td>
                    </tr>
                    <tr>
                        <td><strong>Loan Reactivation</strong></td>
                        <td>2,916</td>
                        <td>1,987</td>
                        <td>16.8%</td>
                        <td>2m 45s</td>
                        <td><span class="ob-badge ob-badge-active">Active</span></td>
                    </tr>
                    <tr>
                        <td><strong>Free Trial Follow-Up</strong></td>
                        <td>2,480</td>
                        <td>1,860</td>
                        <td>19.5%</td>
                        <td>2m 10s</td>
                        <td><span class="ob-badge ob-badge-active">Active</span></td>
                    </tr>
                    <tr>
                        <td><strong>Renewal Reminder</strong></td>
                        <td>1,956</td>
                        <td>1,370</td>
                        <td>14.2%</td>
                        <td>1m 58s</td>
                        <td><span class="ob-badge ob-badge-paused">Paused</span></td>
                    </tr>
                    <tr>
                        <td><strong>Feedback Collection</strong></td>
                        <td>1,288</td>
                        <td>829</td>
                        <td>11.7%</td>
                        <td>2m 22s</td>
                        <td><span class="ob-badge ob-badge-active">Active</span></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>


    {{-- ======================================
         SECTION 5 – RECENT ACTIVITY
         ====================================== --}}
    <div class="ob-card ob-section">
        <p class="ob-card-title">Recent Outbound Calls</p>
        <div class="ob-table-wrap">
            <table class="ob-table" id="recentTable">
                <thead>
                    <tr>
                        <th>Phone Number</th>
                        <th>Campaign</th>
                        <th>Status</th>
                        <th>Duration</th>
                        <th>Time</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>+91 98XXX XX412</td>
                        <td>Insurance Leads Q1</td>
                        <td><span class="ob-badge ob-badge-connected">Connected</span></td>
                        <td>3m 42s</td>
                        <td>2 min ago</td>
                    </tr>
                    <tr>
                        <td>+91 87XXX XX089</td>
                        <td>Loan Reactivation</td>
                        <td><span class="ob-badge ob-badge-noanswer">Not Answered</span></td>
                        <td>0m 34s</td>
                        <td>5 min ago</td>
                    </tr>
                    <tr>
                        <td>+91 70XXX XX551</td>
                        <td>Free Trial Follow-Up</td>
                        <td><span class="ob-badge ob-badge-connected">Connected</span></td>
                        <td>2m 18s</td>
                        <td>8 min ago</td>
                    </tr>
                    <tr>
                        <td>+91 99XXX XX327</td>
                        <td>Insurance Leads Q1</td>
                        <td><span class="ob-badge ob-badge-voicemail">Voicemail</span></td>
                        <td>0m 52s</td>
                        <td>12 min ago</td>
                    </tr>
                    <tr>
                        <td>+91 88XXX XX764</td>
                        <td>Renewal Reminder</td>
                        <td><span class="ob-badge ob-badge-busy">Busy</span></td>
                        <td>0m 12s</td>
                        <td>14 min ago</td>
                    </tr>
                    <tr>
                        <td>+91 91XXX XX198</td>
                        <td>Loan Reactivation</td>
                        <td><span class="ob-badge ob-badge-connected">Connected</span></td>
                        <td>4m 05s</td>
                        <td>18 min ago</td>
                    </tr>
                    <tr>
                        <td>+91 73XXX XX446</td>
                        <td>Feedback Collection</td>
                        <td><span class="ob-badge ob-badge-failed">Failed</span></td>
                        <td>0m 00s</td>
                        <td>21 min ago</td>
                    </tr>
                    <tr>
                        <td>+91 96XXX XX830</td>
                        <td>Free Trial Follow-Up</td>
                        <td><span class="ob-badge ob-badge-connected">Connected</span></td>
                        <td>1m 56s</td>
                        <td>25 min ago</td>
                    </tr>
                    <tr>
                        <td>+91 85XXX XX672</td>
                        <td>Insurance Leads Q1</td>
                        <td><span class="ob-badge ob-badge-noanswer">Not Answered</span></td>
                        <td>0m 28s</td>
                        <td>30 min ago</td>
                    </tr>
                    <tr>
                        <td>+91 77XXX XX915</td>
                        <td>Renewal Reminder</td>
                        <td><span class="ob-badge ob-badge-connected">Connected</span></td>
                        <td>2m 44s</td>
                        <td>33 min ago</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

</div>
{{-- END .ob-dashboard --}}


{{-- ===========================
     CHART.JS + DASHBOARD SCRIPTS
     =========================== --}}
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.7/dist/chart.umd.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {

    /* ---------------------------------------------------
       SHARED CHART DEFAULTS
       --------------------------------------------------- */
    Chart.defaults.font.family = "'Inter', system-ui, sans-serif";
    Chart.defaults.font.size = 12;
    Chart.defaults.color = '#6b7280';
    Chart.defaults.plugins.legend.labels.usePointStyle = true;
    Chart.defaults.plugins.legend.labels.pointStyleWidth = 10;
    Chart.defaults.plugins.legend.labels.padding = 16;

    var BLUE    = '#3b82f6';
    var GREEN   = '#10b981';
    var RED     = '#ef4444';
    var AMBER   = '#f59e0b';
    var PURPLE  = '#8b5cf6';
    var GRAY    = '#9ca3af';
    var BLUELT  = 'rgba(59,130,246,0.08)';


    /* ---------------------------------------------------
       1. LINE CHART – Calls Per Day (30 days)
       --------------------------------------------------- */
    var daysLabels = [];
    var callsData = [];
    var connectedData = [];
    var today = new Date();
    for (var i = 29; i >= 0; i--) {
        var d = new Date(today);
        d.setDate(d.getDate() - i);
        daysLabels.push(d.toLocaleDateString('en-IN', { day: '2-digit', month: 'short' }));
        var total = Math.floor(Math.random() * 250) + 300;
        callsData.push(total);
        connectedData.push(Math.floor(total * (0.6 + Math.random() * 0.15)));
    }

    new Chart(document.getElementById('chartCallsPerDay'), {
        type: 'line',
        data: {
            labels: daysLabels,
            datasets: [
                {
                    label: 'Total Calls',
                    data: callsData,
                    borderColor: BLUE,
                    backgroundColor: BLUELT,
                    fill: true,
                    tension: 0.35,
                    pointRadius: 0,
                    pointHoverRadius: 5,
                    borderWidth: 2
                },
                {
                    label: 'Connected',
                    data: connectedData,
                    borderColor: GREEN,
                    backgroundColor: 'transparent',
                    fill: false,
                    tension: 0.35,
                    pointRadius: 0,
                    pointHoverRadius: 5,
                    borderWidth: 2,
                    borderDash: [5, 4]
                }
            ]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            interaction: { mode: 'index', intersect: false },
            scales: {
                x: { grid: { display: false }, ticks: { maxTicksLimit: 10 } },
                y: { beginAtZero: true, grid: { color: '#f3f4f6' }, ticks: { maxTicksLimit: 6 } }
            },
            plugins: { legend: { position: 'top', align: 'end' } }
        }
    });


    /* ---------------------------------------------------
       2. BAR CHART – Campaign-wise Call Count
       --------------------------------------------------- */
    new Chart(document.getElementById('chartCampaignBars'), {
        type: 'bar',
        data: {
            labels: ['Insurance Q1', 'Loan React.', 'Trial Follow', 'Renewal', 'Feedback'],
            datasets: [
                {
                    label: 'Total Calls',
                    data: [3842, 2916, 2480, 1956, 1288],
                    backgroundColor: BLUE,
                    borderRadius: 5,
                    barPercentage: 0.55
                },
                {
                    label: 'Connected',
                    data: [2690, 1987, 1860, 1370, 829],
                    backgroundColor: GREEN,
                    borderRadius: 5,
                    barPercentage: 0.55
                }
            ]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                x: { grid: { display: false } },
                y: { beginAtZero: true, grid: { color: '#f3f4f6' }, ticks: { maxTicksLimit: 6 } }
            },
            plugins: { legend: { position: 'top', align: 'end' } }
        }
    });


    /* ---------------------------------------------------
       3. PIE CHART – Call Outcome Distribution
       --------------------------------------------------- */
    new Chart(document.getElementById('chartOutcomePie'), {
        type: 'doughnut',
        data: {
            labels: ['Connected', 'Not Answered', 'Busy', 'Voicemail', 'Failed'],
            datasets: [{
                data: [8736, 1842, 924, 956, 1024],
                backgroundColor: [GREEN, AMBER, RED, PURPLE, GRAY],
                borderWidth: 0,
                hoverOffset: 6
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            cutout: '62%',
            plugins: {
                legend: { position: 'bottom', labels: { padding: 14, font: { size: 11.5 } } }
            }
        }
    });


    /* ---------------------------------------------------
       4. DOUGHNUT – AI vs Human Handover
       --------------------------------------------------- */
    new Chart(document.getElementById('chartAiHuman'), {
        type: 'doughnut',
        data: {
            labels: ['AI Handled Fully', 'Handed to Human', 'AI Partial + Drop'],
            datasets: [{
                data: [5480, 2526, 730],
                backgroundColor: [BLUE, AMBER, GRAY],
                borderWidth: 0,
                hoverOffset: 6
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            cutout: '62%',
            plugins: {
                legend: { position: 'bottom', labels: { padding: 14, font: { size: 11.5 } } }
            }
        }
    });


    /* ---------------------------------------------------
       5. BAR – AI Successful Conversations
       --------------------------------------------------- */
    new Chart(document.getElementById('chartAiSuccess'), {
        type: 'bar',
        data: {
            labels: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
            datasets: [
                {
                    label: 'AI Success',
                    data: [820, 790, 860, 910, 880, 420, 310],
                    backgroundColor: BLUE,
                    borderRadius: 4,
                    barPercentage: 0.5
                },
                {
                    label: 'Human Handover',
                    data: [310, 340, 290, 370, 350, 180, 120],
                    backgroundColor: '#e5e7eb',
                    borderRadius: 4,
                    barPercentage: 0.5
                }
            ]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                x: { grid: { display: false }, stacked: true },
                y: { beginAtZero: true, grid: { color: '#f3f4f6' }, stacked: true, ticks: { maxTicksLimit: 5 } }
            },
            plugins: { legend: { position: 'top', align: 'end', labels: { font: { size: 11 } } } }
        }
    });


    /* ---------------------------------------------------
       SET DEFAULT DATE RANGE (last 30 days)
       --------------------------------------------------- */
    var fromInput = document.getElementById('obFilterFrom');
    var toInput = document.getElementById('obFilterTo');
    var now = new Date();
    toInput.value = now.toISOString().split('T')[0];
    var from = new Date(now);
    from.setDate(from.getDate() - 30);
    fromInput.value = from.toISOString().split('T')[0];
});


/* ---------------------------------------------------
   TABLE SORTING (lightweight, no library needed)
   --------------------------------------------------- */
var sortDirections = {};

function sortTable(colIndex) {
    var table = document.getElementById('campaignTable');
    var tbody = table.querySelector('tbody');
    var rows = Array.from(tbody.querySelectorAll('tr'));
    var headers = table.querySelectorAll('thead th');

    /* Toggle direction */
    sortDirections[colIndex] = !sortDirections[colIndex];
    var asc = sortDirections[colIndex];

    /* Mark sorted column */
    headers.forEach(function (th, i) {
        th.classList.toggle('ob-sorted', i === colIndex);
    });

    rows.sort(function (a, b) {
        var aVal = a.cells[colIndex].textContent.trim();
        var bVal = b.cells[colIndex].textContent.trim();

        /* Attempt numeric comparison */
        var aNum = parseFloat(aVal.replace(/[^0-9.\-]/g, ''));
        var bNum = parseFloat(bVal.replace(/[^0-9.\-]/g, ''));

        if (!isNaN(aNum) && !isNaN(bNum)) {
            return asc ? aNum - bNum : bNum - aNum;
        }
        return asc ? aVal.localeCompare(bVal) : bVal.localeCompare(aVal);
    });

    rows.forEach(function (row) { tbody.appendChild(row); });
}


/* ---------------------------------------------------
   FILTER STUB (wire to real API later)
   --------------------------------------------------- */
function applyFilters() {
    var from     = document.getElementById('obFilterFrom').value;
    var to       = document.getElementById('obFilterTo').value;
    var campaign = document.getElementById('obFilterCampaign').value;
    var status   = document.getElementById('obFilterStatus').value;

    /* Replace this with an AJAX call to your API endpoint */
    console.log('Filters applied:', { from: from, to: to, campaign: campaign, status: status });
    alert('Filters applied (demo). Connect to API to fetch real data.');
}
</script>

@endsection
