@extends('layouts.app')
@section('title', 'Dashboard')
@section('content')
<!-- crm -->
<link href="{{asset('assets/css/bootstrap4-toggle.min.css')}}" rel="stylesheet">

<?php
use \App\Http\Controllers\InheritApiController;

$mca_crm = InheritApiController::mcaCRM();

$mca_crm_enable = $mca_crm['mca_crm'];

if($mca_crm_enable == 1)
{
?>

    <!-- <div style="text-align:center;">
        <label>Toggle Dashboard:</label>
     
        <input type="checkbox" id="dashboardToggle" data-toggle="toggle" data-on="Dialer" data-off="CRM" data-onstyle="success" data-offstyle="danger">

    </div> -->
    <?php 
}
?>
    <br>
    <!-- Spinner or Loading Text -->
<div id="dashboardLoader" class="text-center py-4" style="display: none;">
    <div class="spinner-border text-primary" role="status">
        <span class="sr-only">Loading...</span>
    </div>
    <p>Please wait, loading dashboard...</p>
</div>


    <!-- /crm -->
<div id="dashboard1" class="dashboard-content">
<?php
    $userdetails = InheritApiController::headerUserDetails();
?>

<script src="{{ asset('maps/highmaps.js?ver=0.0.1')}}"></script>
<script src="{{ asset('maps/data.js?ver=0.0.1')}}"></script>
<script src="{{ asset('maps/exporting.js?ver=0.0.1')}}"></script>
<script src="{{ asset('maps/offline-exporting.js?ver=0.0.1')}}"></script>
<script src="{{ asset('maps/us-all.js?ver=0.0.1')}}"></script>
<style>
    .highcharts-credits,
    .highcharts-title,
    .highcharts-button-symbol {
        display: none;
    }
 
    .box {}
 
 
.dashboard-box {
    width: auto !important;
    display: inline-block;
    vertical-align: top;
    margin-bottom: 15px;
}


@media (min-width: 992px) {
    .dashboard-box {
        width: 20% !important;
    }
}


@media (min-width: 768px) and (max-width: 991px) {
    .dashboard-box {
        width: 48% !important;
        margin-right: 4%;
    }
    .dashboard-box:nth-child(2n) {
        margin-right: 0;
    }
}


@media (max-width: 767px) {
    .dashboard-box {
        width: 100% !important;
        margin-right: 0;
    }
}

    
 
    @media (min-width: 992px) {
        .dashboard-box {
            width: 20%;
            display: inline-block;
            vertical-align: top;
        }
    }
 
     .top-space {
      margin-top: 0 !important;
      padding-top: 0 !important;
     }
 
    .spacing {
      margin-top: -2px !important;
      padding-top: -2px !important;
     }
 
    .dashboard-box {
     margin-top: -27px !important;  
    }

   
@media (max-width: 992px) {
  .live-calls-table .table-wrapper {
    overflow-x: auto;
    -webkit-overflow-scrolling: touch;
    display: block;
    border-radius: 8px;
  }

  .live-calls-table table {
    min-width: 750px; 
    width: 100%;
    border-collapse: collapse;
  }

  .live-calls-table th,
  .live-calls-table td {
    font-size: 12px;
    white-space: nowrap;
    padding: 6px 8px;
  }
}

@media (max-width: 576px) {
  .live-calls-table th,
  .live-calls-table td {
    font-size: 11px;
    padding: 5px;
  }
}

    </style>
 <style>
    .highcharts-credits,.highcharts-title,.highcharts-button-symbol
    {
        display: none;
    }
    /*#container
    {
        height: 500px;
        min-width: 500px;
        max-width: 800px;
        margin: 0 auto;
    }

    .loading
    {
        margin-top: 10em;
        text-align: center;
        color: gray;
    }
*/
</style> 

<p class="loading" style="display: none;"><img style="width:50px;" src="{{ asset('assets/images/loader.gif') }}"/></p>

@if(empty($availablePackages) && Session::get('level') < 7)
<div class="content-wrapper">
    <h1 class="no-package">No package is assigned!</h1>
</div>

@else

<!-- Main content -->

<section class="content">

    <div class="row">
        <div class="col-xl-12 col-12">
            <div class="row top-space">
    @if(Session::get('level') >=5)
    <div class="col-lg-3 col-12 dashboard-box">
                <a href="{{ url('/extension') }}"> 
                    <div class="box bg-success bg-hover-success" style="font-size:30px;color:white;">
                        <div class="box-body py-0">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h5 style="color:white;font-weight: 500;padding: 10px 0px 0px 0px;font-size: 13px;">USERS</h5>
                                    <h2 style="color:white;"  class="fw-500 mb-0">{{$userCount}}</h2>
                                </div>
                                <div>
                                    <i class="icon-Add-user"><span class="path1"></span><span class="path2"></span></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
                </div>

                <div class="col-lg-3 col-12 dashboard-box">
                <a href="{{ url('/did') }}">
                    <div class="box bg-danger bg-hover-danger" style="font-size:30px;color:white;">
                        <div class="box-body py-0">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h5 style="color:white;font-weight: 500;padding: 10px 0px 0px 0px;font-size: 13px;">PHONE NUMBERS</h5>
                                    <h2 style="color:white;"  class="fw-500 mb-0">{{$didCount}}</h2>
                                </div>
                                <div>
                                    <i class="icon-Layout-4-blocks"><span class="path1"></span><span class="path2"></span></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
                </div>

                <div class="col-lg-3 col-12 dashboard-box">
                <a href="{{ url('/campaign') }}">
                    <div class="box bg-warning bg-hover-warning" style="font-size:30px;color:white;">
                        <div class="box-body py-0">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h5 style="color:white;font-weight: 500;padding: 10px 0px 0px 0px;font-size: 13px;">CAMPAIGNS</h5>
                                    <h2 style="color:white;"  class="fw-500 mb-0">{{$campaignCount}}</h2>
                                </div>
                                <div>
                                    <i class="icon-Cardboard-vr"><span class="path1"></span><span class="path2"></span></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
                </div>

                <div class="col-lg-3 col-12 dashboard-box">
                <a href="{{ url('/lead') }}">
                    <div class="box bg-info bg-hover-info" style="font-size:30px;color:white;">
                        <div class="box-body py-0">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h5 style="color:white;font-weight: 500;padding: 10px 0px 0px 0px;font-size: 13px;">LEADS</h5>
                                    <h2 style="color:white;"  class="fw-500 mb-0">{{ number_format($leadCount) }}</h2>
                                </div>
                                <div>
                                    <i class="icon-File"><span class="path1"></span><span class="path2"></span></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
                </div>

                <div class="col-lg-3 col-12 dashboard-box">
                <a href="{{ url('/list') }}">
                    <div class="box bg-info bg-hover-info" style="font-size:30px;color:white;">
                        <div class="box-body py-0">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h5 style="color:white;font-weight: 500;padding: 10px 0px 0px 0px;font-size: 13px;">Lists</h5>
                                    <h2 style="color:white;"  class="fw-500 mb-0">{{$listCount}}</h2>
                                </div>
                                <div>
                                    <i class="icon-File"><span class="path1"></span><span class="path2"></span></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
                </div>

        

                <div class="col-lg-3 col-12 dashboard-box">
                <a href="{{ url('/callback') }}">
                    <div class="box bg-info bg-hover-info" style="font-size:30px;color:white;">
                        <div class="box-body py-0">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h5 style="color:white;font-weight: 500;padding: 10px 0px 0px 0px;font-size: 13px;">CallBack</h5>
                                    <h2 style="color:white;"  class="fw-500 mb-0">{{$callbackCount}}</h2>
                                </div>
                                <div>
                                    <i class="icon-File"><span class="path1"></span><span class="path2"></span></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
                </div>
                <div class="col-lg-3 col-12 dashboard-box">
                <a href="{{ url('/inbox') }}">
                    <div class="box bg-primary bg-hover-primary" style="font-size:30px;color:white;">
                        <div class="box-body py-0">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h5 style="color:white;font-weight: 500;padding: 10px 0px 0px 0px;font-size: 13px;">SMS Received</h5>
                                    <h2 style="color:white;" id="sms-received"  class="fw-500 mb-0"><img src="{{asset("assets/images/loader-30px.gif")}}"/></h2>
                                </div>
                                <div>
                                    <i class="icon-Chat"><span class="path1"></span><span class="path2"></span></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
                </div>

                <div class="col-lg-3 col-12 dashboard-box">
                <a href="{{ url('/inbox') }}">
                    <div class="box bg-secondary bg-hover-secondary" style="font-size:30px;color:white;">
                        <div class="box-body py-0">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h5 style="color:white;font-weight: 500;padding: 10px 0px 0px 0px;font-size: 13px;">SMS Sent</h5>
                                    <h2 style="color:white;" id="sms-sent"  class="fw-500 mb-0"><img src="{{asset("assets/images/loader-30px.gif")}}"/></h2>

                                </div>
                                <div>
                                    <i class="icon-Group-chat"><span class="path1"></span><span class="path2"></span></i>
                                </div>
                            </div>
                        </div>
                    </div>
                    </a>

                </div>

                <div class="col-lg-3 col-12 dashboard-box">
                <a href="{{ url('/profile') }}">
                    <div class="box bg-dark bg-hover-dark" style="font-size:30px;color:white;">
                        <div class="box-body py-0">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h5 style="color:white;font-weight: 500;padding: 10px 0px 0px 0px;font-size: 13px;">Voicemail Received</h5>
                                    <h2 style="color:white;" id="voicemail-received"  class="fw-500 mb-0"><img src="{{asset("assets/images/loader-30px.gif")}}"/></h2>

                                </div>
                                <div>
                                    <i class="icon-Incoming-mail"><span class="path1"></span><span class="path2"></span></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
                </div>

                <div class="col-lg-3 col-12 dashboard-box">
                <a href="{{ url('/profile') }}">
                    <div class="box bg-success bg-hover-success" style="font-size:30px;color:white;">
                        <div class="box-body py-0">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h5 style="color:white;font-weight: 500;padding: 10px 0px 0px 0px;font-size: 13px;">Unread Voicemail</h5>
                                    <h2 style="color:white;" id="voicemail-unread"  class="fw-500 mb-0"><img src="{{asset("assets/images/loader-30px.gif")}}"/></h2>
                                </div>
                                <div>
                                    <i class="icon-Notifications"><span class="path1"></span><span class="path2"></span></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
                </div>
                 @endif

             </div>

<style>
@media (max-width: 576px) {
    .box-header .col-md-3,
    .box-header .col-md-5,
    .box-header .col-md-4 {
        flex: 0 0 100% !important;
        max-width: 100% !important;
        margin-bottom: 10px; 
    }
}
</style>
              <div class="row">
        <div class="col-xl-12 col-12">

            <div class="box">
                <div class="box-header">
                    <div class="row">

                      
                    @if(Session::get('level') >=5)
                    <div class="col-md-3">
                        <div class="form-group">
                            <select class="form-select" style="width: 100%; background-color:#c2dff6; cursor: pointer;" name="extension" id="extension_user_check">
                                <option value="">All Users</option>
                                @foreach($extension_list as $key => $extension)
                                @if($extension->is_deleted=='0')
                                @if((request()->session()->get('level') > 9))
                                @if(($extension->user_level <= 9) || ($extension->extension == request()->session()->get('extension')))
                                    <option @if($extension->extension == request()->input('extension'))  selected @endif value="{{$extension->id}}">{{$extension->first_name}} {{$extension->last_name}} - {{$extension->extension}} @if($extension->is_deleted == 1) (Removed User) @endif
                                    </option>
                                @endif
                                @elseif(($extension->user_level < 9) || ($extension->extension == request()->session()->get('extension')))
                                    <option @if($extension->extension == request()->input('extension'))  selected @endif value="{{$extension->id}}">{{$extension->first_name}} {{$extension->last_name}} - {{$extension->extension}} @if($extension->is_deleted == 1) (Removed User) @endif
                                    </option>
                                @endif
                                @endif
                                @endforeach
                            </select>
                        </div>

                    </div> 
                    @endif

                    <div class="col-md-5">
                        <div class="box-controls pull-right" style="background: #c2dff6;">
                                <ul class="nav nav-pills nav-pills-sm" role="tablist">
                                    <li class="nav-item">
                                        <a onclick='populateChart("monthly")' class="nav-link py-2 px-4 b-0" data-bs-toggle="tab"  href="#">
                                            <span class="nav-text base-font">Month</span>
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a onclick='populateChart("daily-7")' class="nav-link py-2 px-4 b-0 active" data-bs-toggle="tab" href="#">
                                            <span class="nav-text base-font">Week</span>
                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a onclick='populateChart("today")' class="nav-link py-2 px-4 b-0 " data-bs-toggle="tab" href="#">
                                            <span class="nav-text base-font">Day</span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                            </div>
                           


 <div class="col-md-4"> 

                    <div class="box-tools pull-right">
                        <!-- Date and time range -->
                        <div class="form-group">
                            <div class="input-group">
                                <button type="button" class="btn btn-primary btn-sm pull-right" id="daterange-btn">
                                    <span>
                                        <i class="fa fa-calendar"></i> Date range picker
                                    </span>
                                    <i class="fa fa-caret-down"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                  
                </div>
                 </div>
                </div>


                


               

                 <div class="box-body">
                    <div class="row">
                        <div class="col-xl-8 col-12">
                                                                    <div class="chart">


                                <!-- <div id="area-chart"></div> -->
    <!-- <div id="line-chart" style="height: 360px;"></div> -->

  <canvas id="call-recap-canvas" style="height: 250px; width: 594px; display:none;" height="312" width="742"></canvas> 
   

                               <!--  <canvas id="line-chart1" height="150"></canvas> -->
                            </div>
                </div>

             
                        <div class="col-xl-4 col-12">
                            <ul style="position: relative;margin: 0 0px;padding-left: 25px;padding-right: 0px;border-radius: 0;border-left: 5px solid transparent;list-style: none;">
                                <li style="font-weight: 500;line-height: 40px; border-top: 2px solid #d2d6de;">
                                    <a href="#">Outbound Manual Calls<span class="pull-right" id="outbound-manual-count"><img src="{{asset("assets/images/loader-30px.gif")}}"/></span></a>
                                </li>
                                <li style="font-weight: 500;line-height: 40px; border-top: 2px solid #d2d6de;">
                                    <a href="#">Outbound Manual Avg Duration <span class="pull-right" id="outbound-manual-avg"><img src="{{asset("assets/images/loader-30px.gif")}}"/></span></a>
                                </li>
                                <li style="font-weight: 500;line-height: 40px; border-top: 2px solid #d2d6de;">
                                    <a href="#">Outbound(Dialer/Predictive/C2C)<span class="pull-right" id="outbound-dialer-count"><img src="{{asset("assets/images/loader-30px.gif")}}"/></span></a>
                                </li>
                                <li style="font-weight: 500;line-height: 40px; border-top: 2px solid #d2d6de;">
                                    <a href="#">Outbound Dialer Avg Duration <span class="pull-right" id="outbound-dialer-avg"><img src="{{asset("assets/images/loader-30px.gif")}}"/></span></a>
                                </li>
                                <li style="font-weight: 500;line-height: 40px; border-top: 2px solid #d2d6de;">
                                    <a href="#">Inbound Manual Calls <span class="pull-right" id="inbound-manual-count"><img src="{{asset("assets/images/loader-30px.gif")}}"/></span></a>
                                </li>
                                <li style="font-weight: 500;line-height: 40px; border-top: 2px solid #d2d6de;">
                                    <a href="#">Inbound Manual Avg Duration <span class="pull-right" id="inbound-manual-avg"><img src="{{asset("assets/images/loader-30px.gif")}}"/></span></a>
                                </li>
                                <li style="font-weight: 500;line-height: 40px; border-top: 2px solid #d2d6de;">
                                    <a href="#">Inbound Dialer Calls <span class="pull-right" id="inbound-dialer-count"><img src="{{asset("assets/images/loader-30px.gif")}}"/></span></a>
                                </li>
                                <li style="font-weight: 500;line-height: 40px; border-top: 2px solid #d2d6de;">
                                    <a href="#">Inbound Dialer Avg Duration <span class="pull-right" id="inbound-dialer-avg"><img src="{{asset("assets/images/loader-30px.gif")}}"/></span></a>
                                </li>

                                 <li style="font-weight: 500;line-height: 40px; border-top: 2px solid #d2d6de;">
                                    <a href="#">Total Agents Logged In <span class="pull-right" id="logged-in-agent"><img src="{{asset("assets/images/loader-30px.gif")}}"/></span></a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        
            

                <div class="col-md-12">
            <div class="row">

                <div class="col-md-8">
                            <div class="box box-default">
                                <div class="box-header with-border">
                                    <h4 class="">State Wise Call Report Map</h4>
                                </div>

                                <div class="box-body">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div id="container" style="height: 390px;"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                                 <div class="box">
                <div class="box-header with-border">
                    <h4 class="box-title">Agent Wise Call Count Summary &nbsp;&nbsp;</h4>
                    <span id="total_agent"></span>
                </div>

                <div class="box-body">
                    <div class="table-responsive">
                        <table id="checkAgents" class="table">
                                <thead class="bg-dark" style="font-size: 12px;">                               
                                    <tr>
                                    <th>#</th>
                                    <th>Agent Name</th>
                                    <th>Extension</th>
                                    <th>Call Count</th>
                                    <th>Total Duration</th>
                                    <th>Avg Duration</th>
                                    <th>SMS Sent</th>
                                    <th>SMS Received</th>
                                </tr>
                            </thead>

                            <tbody id="extListDashboard">
                                <tr>
                                    <td colspan='6' style='text-align: center'>
                                        
                                    </td>
                                </tr>
                            </tbody>

                            <tbody id="extListDashboard1" style="display: none;">
                                <tr>
                                    
                                </tr>
                            </tbody>
                        </table>

                                <div class="box-body" id="no_agents" style="font-size: 25px;text-align: center;font-weight: bold;">
                                    No Live Agents
                                </div>
                    </div>
                </div>

                <div class="box-footer clearfix">
                    <a style="display:none;"  id="show_all_agents" class="btn btn-sm btn-primary pull-left">View All</a>
                </div>
            </div>


              <div class="box">

                            @php
                            $count = 0;
                             $i=0;
                            @endphp
                            @if(!empty($liveCalls))
                            @php
                            $count = count($liveCalls);
                            @endphp
                            @endif
                            <div class="box-header with-border">
                                <h4 class="box-title">Live Call &nbsp;&nbsp;</h4>
                                <!-- <h3 class="box-title">Live Call </h3><small style="float: right;" class="label label-primary"><i class="fa fa-phone"></i>  Total Live calls :  {{$count}}</small> -->

                                 <span><small style="float: right;font-size: 15px;" class="badge badge-pill badge-primary"><i class="fa fa-phone"></i>  Total Live calls :  {{$count}}</small></span>
                            </div>

                            @if(!empty($liveCalls))
                            <div class="box-body">
                                @if (!empty($liveCalls))
                                  <div class="table-responsive">
                                <table class="table table-bordered">
                                         <thead class="bg-dark" style="font-size: 12px;">
                                        <tr>
                                            <th>#</th>
                                            <th>Agent Name (Extension)</th>
                                            <th>Campaign</th>
                                            <th>Number</th>
                                            <th>Route</th>
                                            <th>Call Type</th>
                                            <th>Start Time</th>
                                            <th>Duration</th>
                                        </tr>
                                        @php
                                        $i=0;
                                        @endphp


                                        @foreach($liveCalls as $key=>$value)

                                        @php
                                        $timezone = $userdetails->data->timezone;
                                        if(!empty($timezone))
                                        {
                                            $utc = $value->start_time;
                                            $dt = new DateTime($utc);
                                            $tz = new DateTimeZone($timezone); // or whatever zone you're after
                                            $dt->setTimezone($tz);   
                                            $start_time = $dt->format('Y-m-d H:i:s');
                                        }
                                        else
                                        {
                                            $start_time = $value->start_time;
                                        }

                                        @endphp

                                    </thead>
                                    <tbody>

                                        <?php if($i < 10){?>

                                        <tr>
                                            <td>{{++$key}}</td>
                                            <td>
                                                @foreach($extension_list as $extension)
                                                    @if($value->extension == $extension->extension)
                                                        {{$extension->first_name}} {{$extension->last_name}}  ({{$extension->extension}}) 
                                                    @elseif($value->extension == $extension->alt_extension)
                                                        {{$extension->first_name}} {{$extension->last_name}}  ({{$extension->extension}}) 
                                                    @endif
                                                @endforeach
                                            </td>
                                            
                                            <td>
                                                @if(empty($value->campaign_id))N/A
                                                @else
                                                @foreach($campaign_list as $campaign)
                                                    @if($campaign->id == $value->campaign_id)
                                                        {{$campaign->title}}
                                                    @endif
                                                @endforeach
                                                @endif
                                            </td>

                                            <td>{{$value->number}} </td>
                                            @if($value->route == 'IN')
                                                <td>Inbound</td>
                                                @elseif($value->route == 'OUT')
                                                <td>Outbound</td>
                                            @endif
                                                <td>{{$value->type}}</td>
                                                <td><?php echo $start_time; ?></td>
                                                <td><?php  echo substr($value->duration,1); ?></td>
                                        </tr>
                                    <?php }

                                    else
                                    {
                                        ?>
                                            <tr class= "hide_live_calls" style="display: none;">
                                            <td>{{++$key}}</td>
                                            <td>
                                                @foreach($extension_list as $extension)
                                                    @if($value->extension == $extension->extension)
                                                        {{$extension->first_name}} {{$extension->last_name}}  ({{$extension->extension}}) 
                                                    @elseif($value->extension == $extension->alt_extension)
                                                        {{$extension->first_name}} {{$extension->last_name}}  ({{$extension->extension}}) 
                                                    @endif
                                                @endforeach
                                            </td>
                                            
                                            <td>
                                                @if(empty($value->campaign_id))N/A
                                                @else
                                                @foreach($campaign_list as $campaign)
                                                    @if($campaign->id == $value->campaign_id)
                                                        {{$campaign->title}}
                                                    @endif
                                                @endforeach
                                                @endif
                                            </td>

                                            <td>{{$value->number}} </td>
                                            @if($value->route == 'IN')
                                                <td>Inbound</td>
                                                @elseif($value->route == 'OUT')
                                                <td>Outbound</td>
                                            @endif
                                                <td>{{$value->type}}</td>
                                                <td><?php echo $start_time; ?></td>
                                                <td><?php  echo substr($value->duration,1); ?></td>
                                        </tr>
                                        <?php
                                    }
                                    ?>


                                        @php
                                        $i++;
                                        @endphp
                                        @endforeach
                                        @else
                                        <tr>
                                            <td colspan="7" style="color:red;">No Live Call Found</td>
                                        </tr>
                                        @endif
                                    </tbody>
                                </table>
                            </div>
                                </div>
                            @else
                                <div class="box-body" style="font-size: 25px;text-align: center;font-weight: bold;">
                                    No Live Calls
                                </div>
                            @endif

                            <?php if($i > 9)
                            {?>
                            <div class="box-footer text-center">
                                <a id="live_calls" class="btn btn-sm btn-info btn-flat pull-right">View All</a>
                            </div>
                        <?php }?>
                        </div>

                      

                        </div>

                                <div class="col-md-4">
                    <div class="box">
                        <div class="box-body ">

                            <img id="pieChartLoader" src="{{asset("assets/images/loader-30px.gif")}}"/> 

                            <h4 style="font-weight: bold;" id="basic-pie2">Disposition Wise Report</h4>
                                                        <div id="basic-pie"  style="height:300px;display: none;"></div>
                                                        <div id="basic-pie1"  style="height:50px;"></div>


                                                        <div class="box-footer no-padding">
                                <ul class="list-inline" id="disposition-data">
                          
                        </ul>
                            </div>

                        </div>
                    </div>

                    <div class="box">
                <div class="box-body">                          
                    <div class="box no-shadow">
                        <div class="box-body px-0 pt-0">
                            <div id="calendar" class="dask evt-cal min-h-250"></div>
                        </div>
                    </div>

                    <h4 class="box-title mb-30">Scheduled Meeting</h4>
                                <div>

                                    @if(!empty($callback))
                                    @php

                                    $i=1;
                                    @endphp
                                        @foreach($callback as $value)

                                        @if($i < 11)
                                        <div class="d-flex align-items-center mb-30 justify-content-between">
                                            <div class="me-15 text-center rounded15 box-shadowed h-50 w-50 d-table">
                                                <!-- <p class="mt-5 mb-0 text-warning">Thu</p>
                                                <p class="mb-0">8</p> -->
                                                <i style="padding: 17px;font-size: 20px;" class="fa fa-phone"></i>
                                            </div>
                                            <div class="d-flex flex-column flex-grow-1 fw-500 min-w-p60">
                                                <a href="#" class="text-dark hover-primary mb-1 fs-16 overflow-hidden text-nowrap text-overflow">
                                                    
                                                    @php $intPhoneNumber = '-'; @endphp
                                                    @if($value->is_dialing_selected_column)
                                                        @php $isDialingSelectedColumn = $value->is_dialing_selected_column; @endphp
                                                        @php $intPhoneNumber = $value->$isDialingSelectedColumn; @endphp
                                                    @endif
                                                    {{$intPhoneNumber}}
                                                </a>
                                                <span class="fs-10 text-fade"><i class="fa fa-clock-o"></i> {{$value->callback_time}} </span>
                                            </div>
                                            <div class="dropdown">
                                                <a class="px-10 pt-5" href="#" data-bs-toggle="dropdown"><i class="ti-more-alt"></i></a>
                                                <div class="dropdown-menu">
                                                  <a class="dropdown-item" href="{{url('/callback')}}">View</a>
                                                  <!-- <a class="dropdown-item" href="#">Delete</a> -->
                                                </div>
                                            </div>
                                        </div>
                                        @php
                                        $i++;
                                        @endphp
                                        @endif
                                        @endforeach
                                    @endif
                                    
                                </div>
                    
                </div>
            </div>

@if(Session::get('level') >=5)


                       
{{--
                     <div class="box ">
                <div class="box-body ">                          
                   

                    <div class="box-header with-border">
                                    <h4 class="">Employee Directory</h4>
                                </div>
                                <div>

                                    <div class="box-body">

                                    @if (!empty($extensionList->user_data))
                                        @foreach ($extensionList->user_data as $key=>$user_list)

                                        @if( $key < 5)
                                    <div class="d-flex align-items-center mb-30">
                                        <div class="me-15">
                                            <img src="{{asset('assets/images/avatar/avatar-1.png')}}" class="avatar avatar-lg rounded100 bg-primary-light" alt="">
                                        </div>
                                        <div class="d-flex flex-column flex-grow-1 fw-500">
                                            <a href="{{ url('/extension') }}{{'/'.$user_list->id}}" class="text-dark hover-primary mb-1 fs-16">{{$user_list->first_name.' '.$user_list->last_name}}</a>
                                            <span class="fs-12"><span class="text-fade">{{$user_list->date_show}}</span>
                                        </div>
                                        
                                    </div>
                                    @endif

                                     @endforeach
                                    @endif
                                    
                                   
                                </div>
                                    
                                </div>
                    
                </div>
            </div> --}}

                        @endif
            



            

           
        </div> 

                        
                    </div>
                    </div>

                




           
        </div>  



         

        
   
   </div>

     <br>
                        <br>
                        

    <input type="hidden" id="start_date_open" value="{{date('Y-m-d 00:00:00')}}" />
    <input type="hidden" id="end_date_open" value="{{date('Y-m-d 23:59:59')}}" />

   

                    <?php /* ?>


                <!-- Main row -->
                   <div class="row">
        <div class="col-md-12">
            @if(Session::get('level') >=5)
            <div class="box">
                <div class="box-header with-border">
                    <h4 class="box-title">Agent Wise Call Count Summary &nbsp;&nbsp;</h4>
                    <span id="total_agent"></span>
                </div>

                <div class="box-body">
                    <div class="table-responsive">
                        <table id="" class="table">
                            <thead class="bg-dark">
                                <tr>
                                    <th>#</th>
                                    <th>Agent Name</th>
                                    <th>Extension</th>
                                    <th>Call Count</th>
                                    <th>Total Duration</th>
                                    <th>Avg Duration</th>
                                    <th>SMS Sent</th>
                                    <th>SMS Received</th>
                                </tr>
                            </thead>

                            <tbody id="extListDashboard">
                                <tr>
                                    <td colspan='6' style='text-align: center'>
                                        
                                    </td>
                                </tr>
                            </tbody>

                            <tbody id="extListDashboard1" style="display: none;">
                                <tr>
                                    
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="box-footer clearfix">
                    <a style="display:none;"  id="show_all_agents" class="btn btn-sm btn-primary pull-left">View All</a>
                </div>
            </div>



            <div class="box box-primary">
                            @php
                            $count = 0;
                             $i=0;
                            @endphp
                            @if(!empty($liveCalls))
                            @php
                            $count = count($liveCalls);
                            @endphp
                            @endif
                            <div class="box-header with-border">
                                <h3 class="box-title">Live Call </h3><small style="float: right;
    font-size: 15px;" class="label label-primary"><i class="fa fa-phone"></i>  Total Live calls :  {{$count}}</small>
                            </div>

                            @if(!empty($liveCalls))
                            <div class="box-body">
                                @if (!empty($liveCalls))
                                <table class="table table-bordered">
                                    <tbody>
                                        <tr>
                                            <th>#</th>
                                            <th>Agent Name (Extension)</th>
                                            <th>Campaign</th>
                                            <th>Number</th>
                                            <th>Route</th>
                                            <th>Call Type</th>
                                            <th>Start Time</th>
                                            <th>Duration</th>
                                        </tr>
                                        @php
                                        $i=0;
                                        @endphp


                                        @foreach($liveCalls as $key=>$value)

                                        @php
                                        $timezone = $userdetails->data->timezone;
                                        if(!empty($timezone))
                                        {
                                            $utc = $value->start_time;
                                            $dt = new DateTime($utc);
                                            $tz = new DateTimeZone($timezone); // or whatever zone you're after
                                            $dt->setTimezone($tz);   
                                            $start_time = $dt->format('Y-m-d H:i:s');
                                        }
                                        else
                                        {
                                            $start_time = $value->start_time;
                                        }

                                        @endphp

                                        <?php if($i < 10){?>

                                        <tr>
                                            <td>{{++$key}}</td>
                                            <td>
                                                @foreach($extension_list as $extension)
                                                    @if($value->extension == $extension->extension)
                                                        {{$extension->first_name}} {{$extension->last_name}}  ({{$extension->extension}}) 
                                                    @elseif($value->extension == $extension->alt_extension)
                                                        {{$extension->first_name}} {{$extension->last_name}}  ({{$extension->extension}}) 
                                                    @endif
                                                @endforeach
                                            </td>
                                            
                                            <td>
                                                @if(empty($value->campaign_id))N/A
                                                @else
                                                @foreach($campaign_list as $campaign)
                                                    @if($campaign->id == $value->campaign_id)
                                                        {{$campaign->title}}
                                                    @endif
                                                @endforeach
                                                @endif
                                            </td>

                                            <td>{{$value->number}} </td>
                                            @if($value->route == 'IN')
                                                <td>Inbound</td>
                                                @elseif($value->route == 'OUT')
                                                <td>Outbound</td>
                                            @endif
                                                <td>{{$value->type}}</td>
                                                <td><?php echo $start_time; ?></td>
                                                <td><?php  echo substr($value->duration,1); ?></td>
                                        </tr>
                                    <?php }

                                    else
                                    {
                                        ?>
                                            <tr class= "hide_live_calls" style="display: none;">
                                            <td>{{++$key}}</td>
                                            <td>
                                                @foreach($extension_list as $extension)
                                                    @if($value->extension == $extension->extension)
                                                        {{$extension->first_name}} {{$extension->last_name}}  ({{$extension->extension}}) 
                                                    @elseif($value->extension == $extension->alt_extension)
                                                        {{$extension->first_name}} {{$extension->last_name}}  ({{$extension->extension}}) 
                                                    @endif
                                                @endforeach
                                            </td>
                                            
                                            <td>
                                                @if(empty($value->campaign_id))N/A
                                                @else
                                                @foreach($campaign_list as $campaign)
                                                    @if($campaign->id == $value->campaign_id)
                                                        {{$campaign->title}}
                                                    @endif
                                                @endforeach
                                                @endif
                                            </td>

                                            <td>{{$value->number}} </td>
                                            @if($value->route == 'IN')
                                                <td>Inbound</td>
                                                @elseif($value->route == 'OUT')
                                                <td>Outbound</td>
                                            @endif
                                                <td>{{$value->type}}</td>
                                                <td><?php echo $start_time; ?></td>
                                                <td><?php  echo substr($value->duration,1); ?></td>
                                        </tr>
                                        <?php
                                    }
                                    ?>


                                        @php
                                        $i++;
                                        @endphp
                                        @endforeach
                                        @else
                                        <tr>
                                            <td colspan="7" style="color:red;">No Live Call Found</td>
                                        </tr>
                                        @endif
                                    </tbody>
                                </table>
                            </div>
                            @else
                                <div class="box-body" style="font-size: 25px;text-align: center;font-weight: 500;">
                                    No Live Calls
                                </div>
                            @endif

                            <?php if($i > 9)
                            {?>
                            <div class="box-footer text-center">
                                <a id="live_calls" class="btn btn-sm btn-info btn-flat pull-right">View All</a>
                            </div>
                        <?php }?>
                        </div>
                    @endif

                </div>
                </div>
                    <?php */ ?>

                

                      

                        <!-- TABLE: LATEST ORDERS -->

                    </div><!-- /.col -->
                   

                   
                  
                  
                </div><!-- /.row -->
                            </div>
            </section><!-- /.content -->


    @endif

    @if(empty($userdetails->data->timezone))
    @if(Session::get('timezone_session') == 0)

    <script type="text/javascript">
        $(document).ready(function()
        {
            $('#closemodal').click(function()
            {
                $('#timezone_model').modal('hide');
                $.ajax({
                    type: "POST",
                    url: "change-session-value-for-timezone",
                });
            });
        });

        $(window).on('load', function()
        {
            $('#timezone_model').modal('show');
        });

    </script>

 

        <div class="modal custom-modal fade" id="timezone_model" role="dialog">
               <div class="modal-dialog">
                <div class="modal-content" style="border-radius: 1rem; padding: 0;">
                 <div class="modal-header px-4 pt-4 pb-2">
                   
                    <h4 class="modal-title">Please Select Your Timezone</h4>
                       <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                            <i class="ti ti-x"></i>
                        </button>
                </div>

                <form enctype="multipart/form-data" class="form-horizontal" method="post" action="{{url('updateTimezone')}}">
                    @csrf
                    

                        <div class="modal-body">
                            <div class="row">
                                <div class="col-sm-12">
                                    <label for="inputPassword3" class="col-form-label">Timezone</label>
                                    <select class="form-select" name="timezone" required>
                                        <option value="">Select Timezone </option>
                                        <option  value="Pacific/Midway">(GMT-11:00) Midway Island, Samoa</option>
                                        <option  value="America/Adak">(GMT-10:00) Hawaii-Aleutian</option>
                                        <option  value="Etc/GMT+10">(GMT-10:00) Hawaii</option>
                                        <option  value="Pacific/Marquesas">(GMT-09:30) Marquesas Islands</option>
                                        <option  value="Pacific/Gambier">(GMT-09:00) Gambier Islands</option>
                                        <option  value="America/Anchorage">(GMT-09:00) Alaska</option>
                                        <option  value="America/Ensenada">(GMT-08:00) Tijuana, Baja California</option>
                                        <option  value="Etc/GMT+8">(GMT-08:00) Pitcairn Islands</option>
                                        <option  value="America/Los_Angeles">(GMT-08:00) Pacific Time (US & Canada)</option>
                                        <option  value="America/Denver">(GMT-07:00) Mountain Time (US & Canada)</option>
                                        <option  value="America/Chihuahua">(GMT-07:00) Chihuahua, La Paz, Mazatlan</option>
                                        <option  value="America/Dawson_Creek">(GMT-07:00) Arizona</option>
                                        <option  value="America/Belize">(GMT-06:00) Saskatchewan, Central America</option>
                                        <option  value="America/Cancun">(GMT-06:00) Guadalajara, Mexico City, Monterrey</option>
                                        <option  value="Chile/EasterIsland">(GMT-06:00) Easter Island</option>
                                        <option  value="America/Chicago">(GMT-06:00) Central Time (US & Canada)</option>
                                        <option  value="America/New_York">(GMT-05:00) Eastern Time (US & Canada)</option>
                                        <option  value="America/Havana">(GMT-05:00) Cuba</option>
                                        <option  value="America/Bogota">(GMT-05:00) Bogota, Lima, Quito, Rio Branco</option>
                                        <option   value="America/Caracas">(GMT-04:30) Caracas</option>
                                        <option   value="America/Santiago">(GMT-04:00) Santiago</option>
                                        <option   value="America/La_Paz">(GMT-04:00) La Paz</option>
                                        <option   value="Atlantic/Stanley">(GMT-04:00) Faukland Islands</option>
                                        <option   value="America/Campo_Grande">(GMT-04:00) Brazil</option>
                                        <option   value="America/Goose_Bay">(GMT-04:00) Atlantic Time (Goose Bay)</option>
                                        <option   value="America/Glace_Bay">(GMT-04:00) Atlantic Time (Canada)</option>
                                        <option   value="America/St_Johns">(GMT-03:30) Newfoundland</option>
                                        <option   value="America/Araguaina">(GMT-03:00) UTC-3</option>
                                        <option   value="America/Montevideo">(GMT-03:00) Montevideo</option>
                                        <option   value="America/Miquelon">(GMT-03:00) Miquelon, St. Pierre</option>
                                        <option   value="America/Godthab">(GMT-03:00) Greenland</option>
                                        <option   value="America/Argentina/Buenos_Aires">(GMT-03:00) Buenos Aires</option>
                                        <option   value="America/Sao_Paulo">(GMT-03:00) Brasilia</option>
                                        <option   value="America/Noronha">(GMT-02:00) Mid-Atlantic</option>
                                        <option   value="Atlantic/Cape_Verde">(GMT-01:00) Cape Verde Is.</option>
                                        <option   value="Atlantic/Azores">(GMT-01:00) Azores</option>
                                        <option  value="Europe/Belfast">(GMT) Greenwich Mean Time : Belfast</option>
                                        <option  value="Europe/Dublin">(GMT) Greenwich Mean Time : Dublin</option>
                                        <option  value="Europe/Lisbon">(GMT) Greenwich Mean Time : Lisbon</option>
                                        <option  value="Europe/London">(GMT) Greenwich Mean Time : London</option>
                                        <option  value="Africa/Abidjan">(GMT) Monrovia, Reykjavik</option>
                                        <option  value="Europe/Amsterdam">(GMT+01:00) Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna</option>
                                        <option  value="Europe/Belgrade">(GMT+01:00) Belgrade, Bratislava, Budapest, Ljubljana, Prague</option>
                                        <option  value="Europe/Brussels">(GMT+01:00) Brussels, Copenhagen, Madrid, Paris</option>
                                        <option  value="Africa/Algiers">(GMT+01:00) West Central Africa</option>
                                        <option  value="Africa/Windhoek">(GMT+01:00) Windhoek</option>
                                        <option  value="Asia/Beirut">(GMT+02:00) Beirut</option>
                                        <option  value="Africa/Cairo">(GMT+02:00) Cairo</option>
                                        <option   value="Asia/Gaza">(GMT+02:00) Gaza</option>
                                        <option   value="Africa/Blantyre">(GMT+02:00) Harare, Pretoria</option>
                                        <option   value="Asia/Jerusalem">(GMT+02:00) Jerusalem</option>
                                        <option   value="Europe/Minsk">(GMT+02:00) Minsk</option>
                                        <option   value="Asia/Damascus">(GMT+02:00) Syria</option>
                                        <option   value="Europe/Moscow">(GMT+03:00) Moscow, St. Petersburg, Volgograd</option>
                                        <option  value="Africa/Addis_Ababa">(GMT+03:00) Nairobi</option>
                                        <option  value="Asia/Tehran">(GMT+03:30) Tehran</option>
                                        <option  value="Asia/Dubai">(GMT+04:00) Abu Dhabi, Muscat</option>
                                        <option  value="Asia/Yerevan">(GMT+04:00) Yerevan</option>
                                        <option  value="Asia/Kabul">(GMT+04:30) Kabul</option>
                                        <option  value="Asia/Yekaterinburg">(GMT+05:00) Ekaterinburg</option>
                                        <option  value="Asia/Tashkent">(GMT+05:00) Tashkent</option>
                                        <option  value="Asia/Kolkata">(GMT+05:30) Chennai, Kolkata, Mumbai, New Delhi</option>
                                        <option  value="Asia/Katmandu">(GMT+05:45) Kathmandu</option>
                                        <option  value="Asia/Dhaka">(GMT+06:00) Astana, Dhaka</option>
                                        <option  value="Asia/Novosibirsk">(GMT+06:00) Novosibirsk</option>
                                        <option  value="Asia/Rangoon">(GMT+06:30) Yangon (Rangoon)</option>
                                        <option  value="Asia/Bangkok">(GMT+07:00) Bangkok, Hanoi, Jakarta</option>
                                        <option  value="Asia/Krasnoyarsk">(GMT+07:00) Krasnoyarsk</option>
                                        <option  value="Asia/Hong_Kong">(GMT+08:00) Beijing, Chongqing, Hong Kong, Urumqi
                                        </option>
                                        <option   value="Asia/Irkutsk">(GMT+08:00) Irkutsk, Ulaan Bataar</option>
                                        <option   value="Australia/Perth">(GMT+08:00) Perth</option>
                                        <option   value="Australia/Eucla">(GMT+08:45) Eucla</option>
                                        <option   value="Asia/Tokyo">(GMT+09:00) Osaka, Sapporo, Tokyo</option>
                                        <option   value="Asia/Seoul">(GMT+09:00) Seoul</option>
                                        <option   value="Asia/Yakutsk">(GMT+09:00) Yakutsk</option>
                                        <option   value="Australia/Adelaide">(GMT+09:30) Adelaide</option>
                                        <option   value="Australia/Darwin">(GMT+09:30) Darwin</option>
                                        <option   value="Australia/Brisbane">(GMT+10:00) Brisbane</option>
                                        <option   value="Australia/Hobart">(GMT+10:00) Hobart</option>
                                        <option   value="Asia/Vladivostok">(GMT+10:00) Vladivostok</option>
                                        <option   value="Australia/Lord_Howe">(GMT+10:30) Lord Howe Island</option>
                                        <option   value="Etc/GMT-11">(GMT+11:00) Solomon Is., New Caledonia</option>
                                        <option   value="Asia/Magadan">(GMT+11:00) Magadan</option>
                                        <option  value="Pacific/Norfolk">(GMT+11:30) Norfolk Island</option>
                                        <option  value="Asia/Anadyr">(GMT+12:00) Anadyr, Kamchatka</option>
                                        <option  value="Pacific/Auckland">(GMT+12:00) Auckland, Wellington</option>
                                        <option  value="Etc/GMT-12">(GMT+12:00) Fiji, Kamchatka, Marshall Is.</option>
                                        <option  value="Pacific/Chatham">(GMT+12:45) Chatham Islands</option>
                                        <option  value="Pacific/Tongatapu">(GMT+13:00) Nuku'alofa</option>
                                        <option  value="Pacific/Kiritimati">(GMT+14:00) Kiritimati</option>
                                    </select>
                                </div>
                            </div>
                        </div>

        <div class="modal-footer">
            <button type="submit" style="background-color: #3c8dbc;color:white;" class="btn btn-sm btn-default" >Submit</button>
        </div>
    </div>

</form>

    </div>
</div>
@endif
@endif
    <br/>
    <!-- /.content-wrapper -->
    @push('styles')
        <!-- daterange picker -->
        <link rel="stylesheet" href="{{asset('assets/plugins/daterangepicker/daterangepicker-bs3.css') }}">
        <!-- <link rel="stylesheet" href="{{asset('assets/plugins/dashboard_date/daterangepicker.css') }}"> -->

        <!-- bootstrap datetimepicker -->
        <link rel="stylesheet" href="{{asset('assets/plugins/bootstrap-datetimepicker/css/bootstrap-datetimepicker.min.css') }}">
        <!-- <link rel="stylesheet" href="{{asset('assets/plugins/dashboard_date/bootstrap-datepicker.min.css') }}"> -->
        <link rel="stylesheet" href="{{asset('assets/plugins/datatables/dataTables.bootstrap.min.css') }}">
        <style>
            .no-dispositions 
            {
                font-size: 25px;
                text-align: center;
                font-weight: 500;
            }
            .loading {
                position: absolute;
                color: White;
                top: 50%;
                left: 45%;
            }

            .info-box {
                min-height: 60px;
                border-radius: 5px;
            }

            .info-box-icon {
                height: 60px;
                width: 60px;
                line-height: 60px;
                border-radius: 5px;
            }

            .info-box-content {
                margin-left: 60px;
            }

            .ext_img {
                text-transform: uppercase;
                width: 75px;
                height: 75px;
                background: #4b5568;
                -moz-border-radius: 50px;
                -webkit-border-radius: 50px;
                border-radius: 50px;
                color: #c9cece;
                font-size: 35px;
                font-weight: 600;
                padding-top: 13%;
            }

            .incomingcss {
                float: left;
            }

            .outgoingcss {
                float: right;
            }

            .user_img {
                text-transform: uppercase;
                width: 42px;
                height: 42px;
                background: #4b5568;
                -moz-border-radius: 50px;
                -webkit-border-radius: 50px;
                border-radius: 50px;
                color: #c9cece;
                font-size: 24px;
                font-weight: 600;
                padding-left: 4%;
            }
            #call-recap-message {
                width: 100%;
                text-align: center;
            }
            h1.no-package{
                text-align: center;
                padding-top: 10%;
                margin:0;
            }
        </style>
    @endpush

    @push('scripts')


        <!-- SlimScroll 1.3.0 -->
        <script src="{{ asset('assets/plugins/slimScroll/jquery.slimscroll.min.js?ver=0.0.1') }}"></script>

        <!-- ChartJS 1.0.1 -->
       <!--  <script src="{{asset('assets/js/Chart.min.js?ver=0.0.1')}}"></script> -->

        <!-- date-range-picker -->
        <script src="{{asset('assets/plugins/dashboard_date/moment.min.js?ver=0.0.1') }}"></script>
        <script src="{{asset('assets/plugins/dashboard_date/daterangepicker.js?ver=0.0.1') }}"></script>

        <!-- bootstrap datepicker -->
        <script src="{{asset('assets/plugins/dashboard_date/bootstrap-datepicker.min.js?ver=0.0.1') }}"></script>

        <script src="{{asset('assets/plugins/datatables/jquery.dataTables.min.js?ver=0.0.1') }}"></script>
        <script src="{{asset('assets/plugins/datatables/dataTables.bootstrap.min.js?ver=0.0.1') }}"></script>
    @endpush
   <script>
                   

                </script>

<script src="{{asset('assets/vendor_components/chart.js-master/Chart.min.js?ver=0.0.1')}}"></script>

    <script type="text/javascript">
        var userIdArray = new Array();
        var chartRange = "";

        function autoSub(start_date, end_date, diff, label,userId) {
            $("#extListDashboard").show();
            $("#extListDashboard").html("<tr><td colspan='8' style='text-align: center'><img src=\"{{asset('assets/images/loader-30px.gif')}}\"></td></tr>");

            $("#smsListDashboard").html("<tr><td colspan='6' style='text-align: center'><img src=\"{{asset('assets/images/loader-30px.gif')}}\"></td></tr>");
            $('#outbound-manual-count').html($("<img>", {src: "{{asset("assets/images/loader-30px.gif")}}"}));
            $('#outbound-manual-avg').html($("<img>", {src: "{{asset("assets/images/loader-30px.gif")}}"}));
            $('#outbound-dialer-count').html($("<img>", {src: "{{asset("assets/images/loader-30px.gif")}}"}));
            $('#outbound-dialer-avg').html($("<img>", {src: "{{asset("assets/images/loader-30px.gif")}}"}));
            $('#inbound-manual-count').html($("<img>", {src: "{{asset("assets/images/loader-30px.gif")}}"}));
            $('#inbound-manual-avg').html($("<img>", {src: "{{asset("assets/images/loader-30px.gif")}}"}));
            $('#inbound-dialer-count').html($("<img>", {src: "{{asset("assets/images/loader-30px.gif")}}"}));
            $('#inbound-dialer-avg').html($("<img>", {src: "{{asset("assets/images/loader-30px.gif")}}"}));
            $('#logged-in-agent').html($("<img>", {src: "{{asset("assets/images/loader-30px.gif")}}"}));

            // $('#voicemail-received').html($("<img>", {src: "{{asset("assets/images/loader-30px.gif")}}"}));
            // $('#voicemail-unread').html($("<img>", {src: "{{asset("assets/images/loader-30px.gif")}}"}));
            $("#disposition-data").html("");
            $("#pieChart").hide();
            $("#pieChartLoader").show();

            $.ajax({
                url: "ajax_call_report",
                data: {
                    "_token": "{{ csrf_token() }}",
                    "start_date": start_date,
                    "end_date": end_date,
                    "label": label,
                    "extension_user_check":userId
                },
                type: 'post',
                dataType: 'json',
                success: function (userObj) {
                    // console.log(userObj);
                    objectDispositionLenght = Object.keys(userObj.getDispositionWiseCalls).length;

                    var totalCalls = 0
                    $.each(userObj.getDispositionWiseCalls, function (index, row) {
                        totalCalls += parseInt(row.rowCount);
                    });

                    
                    if (objectDispositionLenght > 0)
                {
                    var $ul_disposition = $('<ul class="chart-legend clearfix">');
                    var labels = "";
                    var color_array = ['#f56954', '#00a65a', '#f39c12', '#00c0ef', '#3c8dbc', '#ebac23', '#b80058', '#008cf9', '#006e00', '#00bbad', '#d163e6', '#b24502', '#ff9287', '#5954d6', '#00c6f8', '#878500', '#00a76c', '#00a76c', '#00a65a', '#f39c12', '#00B3E6', '#E6B333', '#3366E6', '#999966', '#99FF99', '#B34D4D', '#80B300', '#809900', '#E6B3B3', '#6680B3', '#66991A', '#FF99E6', '#CCFF1A', '#FF1A66', '#E6331A', '#33FFCC', '#66994D', '#B366CC', '#4D8000', '#B33300', '#CC80CC', '#66664D', '#991AFF', '#E666FF', '#4DB3FF', '#1AB399', '#E666B3', '#33991A', '#CC9999', '#B3B31A', '#00E680', '#4D8066', '#809980', '#E6FF80', '#1AFF33', '#999933', '#FF3380', '#CCCC00', '#66E64D', '#4D80CC', '#9900B3', '#E64D66', '#4DB380', '#FF4D4D', '#99E6E6', '#6666FF'];

                    var jsonArr = [];
                    var total_count=0;
                    for (var i = 0; i < objectDispositionLenght; i++) {
                        var $line = $("<li>");
                        //alert(userObj.getDispositionWiseCalls[i].rowCount);
                        var legend = userObj.getDispositionWiseCalls[i].title;
                        if (legend == null) legend = "Disposition Missing";
                        //var style = "style='color:" + color_array[i] + "'";
                        var style = "style='color:" + color_array[i] + "'";
                        var style1 = "style='background-color:" + color_array[i] + "'";

                        
                        var percent = ((userObj.getDispositionWiseCalls[i].rowCount / totalCalls) * 100).toFixed(2);
                        //$line.append($("<i "+style+" class='fa fa-circle-o'></i>").html(' ' + legend + ' (' + percent + '%)'));
                        //labels += "<li><a href='#' " + style + ">" + legend + "<span class='pull-right'>" + userObj.getDispositionWiseCalls[i].rowCount + " (" + percent + "%)</span></a></li>";

                        labels +='<li '+style+' class="flexbox mb-5"><div><span class="badge badge-dot badge-lg me-1" '+style1+' ></span><span>' + legend + '</span></div><div>' + userObj.getDispositionWiseCalls[i].rowCount + ' (' + percent + '%)</div></li>';

                        //$line.append("</li>");
                        //$ul_disposition.append($line);

                        jsonArr.push({
                            labels: legend,
                            values: userObj.getDispositionWiseCalls[i].rowCount,
                            color_val: color_array[i]
                        });

                        total_count = total_count + userObj.getDispositionWiseCalls[i].rowCount;
                    }

                    $("#disposition-data").html(labels);
                    //$("#pi_count").html(" Total : "+total_count);
                    /*$("#pi_count").html('<small class="label label-primary"><i class="fa fa-list"></i> Total Dispositions : '+total_count+'</small>');*/

                    $("#basic-pie").show();
                    $("#basic-pie1").hide();
                    $("#basic-pie2").show();


                    drawPieChart(jsonArr);
                }else
                {
                    $("#basic-pie1").show();
                    $("#basic-pie2").hide();


                    $("#basic-pie").hide();
                    $("#basic-pie1").html("<p style='text-align:center;padding:10px 70px 70px 70px;font-weight:bold;font-size:18px' class='no-dispositions'>No Dispositions</p>"); 
                    $("#pieChart").hide();
                    $("#pieChartLoader").hide();


                }
                    console.log(userObj);

                   // alert(userObj.outBoundManual.calls);

                $('#outbound-manual-count').text(userObj.outBoundManual.calls);
                $('#outbound-manual-avg').text(new Date(userObj.outBoundManual.avgDuration * 1000).toISOString().substr(11, 8));
                $('#outbound-dialer-count').text(userObj.outBoundDialer.calls+' / '+userObj.outBoundPredictive.calls+' / '+userObj.outBoundDialerC2C.calls);
                $('#outbound-dialer-avg').text(new Date(userObj.outBoundDialer.avgDuration * 1000).toISOString().substr(11, 8));
                $('#inbound-manual-count').text(userObj.inBoundManual.calls);
                $('#inbound-manual-avg').text(new Date(userObj.inBoundManual.avgDuration * 1000).toISOString().substr(11, 8));
                $('#inbound-dialer-count').text(userObj.inBoundDailer.calls);
                $('#inbound-dialer-avg').text(new Date(userObj.inBoundDailer.avgDuration * 1000).toISOString().substr(11, 8));
                $('#logged-in-agent').text(userObj.loggedInAgent.totalAgent);



                // $('#voicemail-received').text(userObj.voicemails.read + userObj.voicemails.unread);
                // $('#voicemail-unread').text(userObj.voicemails.unread);
                objectMappingLenght = Object.keys(userObj.getStatewiseCalls).length;
                    var jsonArrMap = [];
                    for (var i = 0; i < objectMappingLenght; i++)
                    {
                        jsonArrMap.push({
                            value: userObj.getStatewiseCalls[i].rowCount,
                            code:  userObj.getStatewiseCalls[i].state_code,
                        });
                    }

                var holder = {};

                jsonArrMap.forEach(function(d)
                {
                    if (holder.hasOwnProperty(d.code))
                    {
                        holder[d.code] = holder[d.code] + d.value;
                    }
                    else
                    {
                        holder[d.code] = d.value;
                    }
                });

                var obj2 = [];
                for (var prop in holder)
                {
                    obj2.push({ code: prop, value: holder[prop] });
                }

                countryStateMap(obj2);
                //end mapping chart






                    
                    var extlistBody = "";
                    var extlistBody1 = "";
                    var total_calls=0;
                    var total_agent=0;

                    $.each(userObj.extListDashboard, function (index, row) {

                        if(index < 10)
                        {
                        extlistBody += "<tr>";
                        extlistBody += "<td>" + (index + 1) + "</td>";
                        extlistBody += "<td>" + row.first_name + ' ' + row.last_name + "</td>";
                        extlistBody += "<td>" + row.extension + "</td>";
                        extlistBody += "<td>" + row.calls + "</td>";
                        extlistBody += "<td>" + new Date(row.totalDuration * 1000).toISOString().substr(11, 8) + "</td>";
                        extlistBody += "<td>" + new Date(row.avgDuration * 1000).toISOString().substr(11, 8) + "</td>";
                        extlistBody += "<td>" + row.outgoing + "</td>";
                        extlistBody += "<td>" + row.incoming + "</td>";


                        extlistBody += "</tr>";
                    }
                    else
                    {
                        extlistBody1 += "<tr>";
                        extlistBody1 += "<td>" + (index + 1) + "</td>";
                        extlistBody1 += "<td>" + row.first_name + ' ' + row.last_name + "</td>";
                        extlistBody1 += "<td>" + row.extension + "</td>";
                        extlistBody1 += "<td>" + row.calls + "</td>";
                        extlistBody1 += "<td>" + new Date(row.totalDuration * 1000).toISOString().substr(11, 8) + "</td>";
                        extlistBody1 += "<td>" + new Date(row.avgDuration * 1000).toISOString().substr(11, 8) + "</td>";
                        extlistBody1 += "<td>" + row.outgoing + "</td>";
                        extlistBody1 += "<td>" + row.incoming + "</td>";


                        extlistBody += "</tr>";

                    $("#show_all_agents").show();
                    }

                    total_calls = total_calls + row.calls;
                    $("#extListDashboard").html(extlistBody);
                    $("#extListDashboard1").html(extlistBody1);
                    total_agent = index+1;


                    });

                    if(total_agent == '0')
                    {
                        $("#extListDashboard").hide();
                        $("#no_agents").show();
                        $("#checkAgents").hide();
                    }
                    else
                    {
                        $("#no_agents").hide();
                        $("#checkAgents").show();
                    }

                    $("#total_agent").html('<small style="float: right;font-size: 15px;" class="badge badge-pill badge-primary"><i class="icon-Add-user"><span class="path1"></span><span class="path2"></span></i>  Total Agents Logged In :  '+total_agent+'</small>');

                    if(userObj.loggedInAgent.totalAgent == 0)
                    {
                        $('#logged-in-agent').text(total_agent);
                    }
                }
            });
            updateSmsCounts(start_date, end_date, userId);
                        updateVoiceCounts(start_date, end_date, userId);

        }
    
        function populateChart(type) {

            console.log(type);
            if (type === chartRange) return false;
            console.log("hello");


            chartRange = type;
            var ranges = [];
            var labels = [];
            var title = "";
            var extension_user_check = userIdArray;


            if (type === "today") {
                console.log(extension_user_check);
                for (var i = 0; i >= 0; i--) {
                    ranges.push({
                        "startTime": moment().subtract(i, 'days').format('YYYY-MM-DD 00:00:00'),
                        "endTime": moment().subtract(i, 'days').format('YYYY-MM-DD 23:59:59'),
                        "extension_user_check":extension_user_check
                    });
                    labels.push(moment().subtract(i, 'days').format('ddd'));
                }
                title = "Daily Calls Recap (<a href='javascript:populateChart(\"daily-30\")'>Switch to 30 day view</a> | <a href='javascript:populateChart(\"monthly\")'>Switch to 6 month view</a>)";
            }

            else
                if (type === "daily-7") {
                console.log(extension_user_check);
                for (var i = 6; i >= 0; i--) {
                    ranges.push({
                        "startTime": moment().subtract(i, 'days').format('YYYY-MM-DD 00:00:00'),
                        "endTime": moment().subtract(i, 'days').format('YYYY-MM-DD 23:59:59'),
                        "extension_user_check":extension_user_check
                    });
                    labels.push(moment().subtract(i, 'days').format('ddd'));
                }
                title = "Daily Calls Recap (<a href='javascript:populateChart(\"daily-30\")'>Switch to 30 day view</a> | <a href='javascript:populateChart(\"monthly\")'>Switch to 6 month view</a>)";
            } else if (type === "daily-30") {
                for (var i = 29; i >= 0; i--) {
                    ranges.push({
                        "startTime": moment().subtract(i, 'days').format('YYYY-MM-DD 00:00:00'),
                        "endTime": moment().subtract(i, 'days').format('YYYY-MM-DD 23:59:59'),
                        "extension_user_check":extension_user_check
                    });
                    labels.push(moment().subtract(i, 'days').format('DD MMM'));
                }
                title = "Daily Calls Recap (<a href='javascript:populateChart(\"daily-7\")'>Switch to 7 day view</a> | <a href='javascript:populateChart(\"monthly\")'>Switch to 6 month view</a>)";
            } else if (type === "monthly") {
                for (var i = 5; i >= 0; i--) {
                    ranges.push({
                        "startTime": moment().subtract(i, 'month').startOf('month').format('YYYY-MM-DD 00:00:00'),
                        "endTime": moment().subtract(i, 'month').endOf('month').format('YYYY-MM-DD 23:59:59'),
                        "extension_user_check":extension_user_check
                    });
                    labels.push(moment().subtract(i, 'month').format('MMMM'));
                }
                title = "Monthly Calls Recap (<a href='javascript:populateChart(\"daily-7\")'>Switch to 7 day view</a> | <a href='javascript:populateChart(\"daily-30\")'>Switch to 30 day view</a>)";
            }
            getCallsData(ranges, labels, title);
        }

        /*

        function getCallsData(ranges, labels, title) {

            $("#call-chart-title").html(title);
            $('#call-recap-message').html($("<img>", {src: "{{asset("assets/images/loader-30px.gif")}}"}));
            $("#call-recap-message").show();
            $("#call-recap-canvas").hide();
            $("#line-chart1").hide();


            $.ajax({
                type: "POST",
                url: "get-call-chart-data",
                data: {
                    "_token": "{{ csrf_token() }}",
                    "range": ranges
                },
                dataType: 'json',
                success: function (data) {


                    var inData = [];
                    var outData = [];

                    //create PieData dynamically
                    data.forEach(function (e) {
                        inData.push(e.IN);
                        outData.push(e.OUT);
                    });

                    

                    if (window.callRecapChart)
                        window.callRecapChart.destroy();



                    $("#call-recap-canvas").show();
                    $("#line-chart1").show();

                    "use strict";

                    var inData = [];
                    var outData = [];


                    inData.push('Inbound');

                        outData.push('Outbound');




                    //create PieData dynamically
                    data.forEach(function (e) {
                        inData.push(e.IN);
                        outData.push(e.OUT);
                    });

                    

                    if (window.callRecapChart)
                        window.callRecapChart.destroy();



var ans = Array.isArray(outData);
var ansss = Array.isArray(inData);




    console.log("Output for String: " + ans);




    var a = c3.generate({
        bindto: "#area-chart",
        size: { height: 350 },
        point: { r: 4 },
        color: { pattern: ["#ff4c52","#3e8ef7"] },
        data: {
            columns: [
                outData,inData

            ],
             type: 'bar'
        },
        axis: {
    x: {
      type: 'category',
      categories: labels
    }
  },
        grid: { y: { show: !0 } }


    });
    


                    
                    $("#call-recap-message").hide();
                },
                error: function (request, status, error) {
                    $("#call-recap-canvas").hide();
                    $("#line-chart1").show();

                    $("#call-recap-message").html(request.responseText);
                    $("#call-recap-message").show();
                }
            });
        }  

        */


         function getCallsData(ranges, labels, title) {

            $("#call-chart-title").html(title);
            $('#call-recap-message').html($("<img>", {src: "{{asset("asset/img/loader-30px.gif")}}"}));
            $("#call-recap-message").show();
            $("#call-recap-canvas").hide();

            $.ajax({
                type: "POST",
                url: "get-call-chart-data",
                data: {
                    "_token": "{{ csrf_token() }}",
                    "range": ranges
                },
                dataType: 'json',
                success: function (data) {
                    $("#call-recap-canvas").show();

                    var inData = [];
                    var outData = [];

                    //create PieData dynamically
                    data.forEach(function (e) {
                        inData.push(e.IN);
                        outData.push(e.OUT);
                    });

                    var lineChartData = {
                        labels: labels,
                        datasets: [{
                            label: 'Outbound',
                            borderColor: '#f39c12',
                            backgroundColor: '#f39c12',
                            fill: false,
                            data: outData,
                            yAxisID: 'y-axis-1',
                        },
                        {
                            label: 'Inbound',
                            borderColor: '#008cf9',
                            backgroundColor: '#008cf9',
                            fill: false,
                            data: inData,
                            yAxisID: 'y-axis-2'
                        }]
                    };

                    if (window.callRecapChart)
                        window.callRecapChart.destroy();

                    var context = document.getElementById('call-recap-canvas').getContext('2d');
                    window.callRecapChart = Chart.Line(context, {
                        data: lineChartData,
                        options: {
                            responsive: true,
                            hoverMode: 'index',
                            stacked: false,
                            title: {
                                display: false,
                                text: 'Chart.js Line Chart - Multi Axis'
                            },
                            scales: {
                                yAxes: [{
                                    type: 'linear', // only linear but allow scale type registration. This allows extensions to exist solely for log scale for instance
                                    display: true,
                                    position: 'left',
                                    id: 'y-axis-1',
                                    gridLines: {
                                        color: "#f39c12",
                                        drawOnChartArea: false, // only want the grid lines for one axis to show up
                                    },
                                    ticks: {
                                        fontColor: "#f39c12"
                                    }
                                }, {
                                    type: 'linear', // only linear but allow scale type registration. This allows extensions to exist solely for log scale for instance
                                    display: true,
                                    position: 'right',
                                    id: 'y-axis-2',
                                    gridLines: {
                                        color: "#008cf9",
                                        drawOnChartArea: false, // only want the grid lines for one axis to show up
                                    },
                                    ticks: {
                                        fontColor: "#008cf9"
                                    }
                                }]
                            }
                        }
                    });
                    $("#call-recap-message").hide();
                },
                error: function (request, status, error) {
                    $("#call-recap-canvas").hide();
                    $("#call-recap-message").html(request.responseText);
                    $("#call-recap-message").show();
                }
            });
        }

    /*  function updateSmsCounts(start_date, end_date, userId) {
    $('#sms-received').html($("<img>", {src: "{{ asset('assets/images/loader-30px.gif') }}"}));
    $('#sms-sent').html($("<img>", {src: "{{ asset('assets/images/loader-30px.gif') }}"}));

    $.ajax({
        type: "POST", // or "POST" based on your route
        url: "{{ url('dashboard') }}", // or "/dashboard"
        data: {
            "_token": "{{ csrf_token() }}", // only required for POST
            "startTime": start_date,
            "endTime": end_date,
            "userId": userId
        },
        success: function (response) {
            console.log(response);
            if (response) {
                $('#sms-received').html(response.incomingSms ?? 0);
                $('#sms-sent').html(response.outgoingSms ?? 0);
            } else {
                $('#sms-received').html('<i class="fa fa-frown-o" style="color:red"></i>');
                $('#sms-sent').html('<i class="fa fa-frown-o" style="color:red"></i>');
            }
        },
        error: function (error) {
            console.log(error.responseJSON);
            $('#sms-received').html('<i class="fa fa-frown-o" style="color:red"></i>');
            $('#sms-sent').html('<i class="fa fa-frown-o" style="color:red"></i>');
        }
    });
}*/


function updateSmsCounts(start_date, end_date, userId) {
    // Show loader while "fetching"
    $('#sms-received').html($("<img>", { src: "{{ asset('assets/images/loader-30px.gif') }}" }));
    $('#sms-sent').html($("<img>", { src: "{{ asset('assets/images/loader-30px.gif') }}" }));

    // Immediately return 0 for both counts
    setTimeout(function() {
        $('#sms-received').html(0);
        $('#sms-sent').html(0);
    }, 500); // optional delay to mimic loading
}

 function updateVoiceCounts(start_date, end_date, userId) {
    $('#voicemail-received').html($("<img>", {src: "{{ asset('assets/images/loader-30px.gif') }}"}));
    $('#voicemail-unread').html($("<img>", {src: "{{ asset('assets/images/loader-30px.gif') }}"}));

    $.ajax({
        type: "POST", // or "POST" based on your route
        url: "{{ url('dashboard') }}", // or "/dashboard"
        data: {
            "_token": "{{ csrf_token() }}", // only required for POST
            "startTime": start_date,
            "endTime": end_date,
            "userId": userId
        },
        success: function (response) {
            console.log(response);
            if (response) {
                $('#voicemail-received').html(response.receivedVoicemail ?? 0);
                $('#voicemail-unread').html(response.unreadVoicemail ?? 0);
            } else {
                $('#voicemail-received').html('<i class="fa fa-frown-o" style="color:red"></i>');
                $('#voicemail-unread').html('<i class="fa fa-frown-o" style="color:red"></i>');
            }
        },
        error: function (error) {
            console.log(error.responseJSON);
            $('#voicemail-received').html('<i class="fa fa-frown-o" style="color:red"></i>');
            $('#voicemail-unread').html('<i class="fa fa-frown-o" style="color:red"></i>');
        }
    });
}


        function countryStateMap(data)
        {

             var data = data;
        data.forEach(function (p)
        {
            p.code = p.code.toUpperCase();
        });

        Highcharts.mapChart('container', {
            chart: {
            map: 'countries/us/us-all',
            //borderWidth: 1
        },

        title: {
            text: 'Call Report density (/call)'
        },

        exporting: {
            sourceWidth: 600,
            sourceHeight: 500
        },

        legend: {
            layout: 'horizontal',
            borderWidth: 0,
            backgroundColor: 'rgba(255,255,255,0.85)',
            floating: true,
            verticalAlign: 'top',
            y: 25
        },

        mapNavigation: {
            enabled: true
        },

        colorAxis: {
            min: 1,
            type: 'logarithmic',
            minColor: '#EEEEFF',
            maxColor: '#000022',
            stops: [
                [0, '#EFEFFF'],
                [0.67, '#4444FF'],
                [1, '#000022']
            ]
        },

        series: [{
            animation: {
                duration: 1000
            },
            data: data,
            joinBy: ['postal-code', 'code'],
            dataLabels: {
                enabled: true,
                color: '#FFFFFF',
                format: '{point.code}'
            },
            name: 'No of Calls',
            tooltip: {
                pointFormat: '{point.code}: {point.value}'
            }
        }]
    });



        }

    //     function drawPieChart(data) {
          
    //                 $("#pieChartLoader").hide();

    //       var pieValues = [];
    //         var pieColors = [];
    //         var pieLabels = [];

    //         // create PieData dynamically
    //         data.forEach(function (e) {
    //             pieValues.push(e.values);
    //             pieColors.push(e.color_val);
    //             pieLabels.push(e.labels);
    //         });

    //         var r = [],i,keys = pieValues,values = pieLabels;

    //         for (i = 0; i < keys.length; i++) {

    //             r.push({ 
    //                 value:keys[i],
    //                 name:values[i],
    //             });
    //         }

    //         console.log(r);


    //     var basicpieChart = echarts.init(document.getElementById('basic-pie'));
    //     var option = {
    //         // Add title
    //             title: {
    //                 //text: 'Disposition Wise Report',
    //                 //subtext: 'Disposition Report Overview',
    //                 x: 'left'
    //             },

    //             // Add tooltip
    //             tooltip: {
    //                 trigger: 'item',
    //                 formatter: "{a} <br/>{b}: {c} ({d}%)"
    //             },

    //             // Add legend
    //             /*legend: {
    //                 orient: 'vertical',
    //                 x: 'left',
    //                 data: ['Direct Access', 'Mail Marketing', 'Union ad', 'Video ad', 'Search Engine']
    //             },*/

    //             // Add custom colors
    //             color: pieColors,//['#689f38', '#38649f', '#389f99', '#ee1044', '#ff8f00'],

    //             // Display toolbox
    //             toolbox: {
    //                 show: true,
    //                 orient: 'vertical',
    //                 feature: {
    //                     mark: {
    //                         show: true,
    //                         title: {
    //                             mark: 'Markline switch',
    //                             markUndo: 'Undo markline',
    //                             markClear: 'Clear markline'
    //                         }
    //                     },
    //                     /*dataView: {
    //                         show: true,
    //                         readOnly: false,
    //                         title: 'View data',
    //                         lang: ['View chart data', 'Close', 'Update']
    //                     },*/
    //                     magicType: {
    //                         show: true,
    //                         title: {
    //                             pie: 'Switch to pies',
    //                             funnel: 'Switch to funnel',
    //                         },
    //                         type: ['pie', 'funnel'],
    //                         option: {
    //                             funnel: {
    //                                 x: '25%',
    //                                 y: '20%',
    //                                 width: '50%',
    //                                 height: '70%',
    //                                 funnelAlign: 'left',
    //                                 max: 1000
    //                             }
    //                         }
    //                     },
    //                     /*restore: {
    //                         show: true,
    //                         title: 'Restore'
    //                     },
    //                     saveAsImage: {
    //                         show: true,
    //                         title: 'Same as image',
    //                         lang: ['Save']
    //                     }*/
    //                 }
    //             },

    //             // Enable drag recalculate
    //             calculable: true,

    //             // Add series
    //             series: [{
    //                 name: 'Dispositions',
    //                 type: 'pie',
    //                 radius: '70%',
    //                 center: ['50%', '57.5%'],
    //                 data:  r /*[
    //                     {value: 335, name: 'Direct Access'},
    //                     {value: 310, name: 'Mail Marketing'},
    //                     {value: 234, name: 'Union ad'},
    //                     {value: 135, name: 'Video ad'},
    //                     {value: 1548, name: 'Search Engine'}
    //                 ]*/
    //             }]
    //     };
    
    //     basicpieChart.setOption(option);
    // // ------------------------------
    // // Basic pie chart
    //     }
function drawPieChart(data) {
    $("#pieChartLoader").hide();

    var pieValues = [];
    var pieColors = [];
    var pieLabels = [];

    data.forEach(function (e) {
        pieValues.push(e.values);
        pieColors.push(e.color_val);
        pieLabels.push(e.labels);
    });

    var r = [];
    for (var i = 0; i < pieValues.length; i++) {
        r.push({
            value: pieValues[i],
            name: pieLabels[i]
        });
    }

    var totalCalls = pieValues.reduce((a, b) => a + b, 0);

    var basicpieChart = echarts.init(document.getElementById('basic-pie'));
    var option = {
        tooltip: {
            trigger: 'item',
            formatter: "{b}: {c} ({d}%)"
        },
            color: ['#7E57C2', '#42A5F5', '#66BB6A'],  // fixed colors
        series: [{
            name: 'Dispositions',
            type: 'pie',
            radius: ['50%', '70%'],   // donut style
            center: ['50%', '50%'],
            data: r,
            label: {
                formatter: '{d}%',   // show percentage only
                fontSize: 14
            },
            labelLine: {
                show: true
            }
        }],
        graphic: {
            type: 'text',
            left: 'center',
            top: 'center',
            style: {
                text: 'Total Calls\n' + totalCalls,
                textAlign: 'center',
                fill: '#333',
                fontSize: 16,
                fontWeight: 'bold'
            }
        }
    };

    basicpieChart.setOption(option);
}

        $(function () {
            $('#daterange-btn').daterangepicker({
                    ranges: {
                        'Today': [moment(), moment()],
                        'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                        'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                        'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                        'This Month': [moment().startOf('month'), moment().endOf('month')],
                        'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                    },
                    startDate: moment(),
                    endDate: moment()
                },
                function (start, end, label) {
                    //$("#show_all_agents").show();
                    $("#extListDashboard1").hide();
                    $('#daterange-btn span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
                    var start_date = start.format('YYYY-MM-DD HH:mm:ss');
                    $("#start_date_open").val(start_date);
                    var end_date = end.format('YYYY-MM-DD HH:mm:ss');
                    $("#end_date_open").val(end_date);

                    var diff = end.diff(start, 'days') + 1;
                    var extension_user_check = userIdArray;
                    autoSub(start_date, end_date, diff, label,extension_user_check);
                });


            $("#sendSms").click(function ()
            {
                message = $("#div_message").val();
                if (message == "")
                {
                    $("#errorMsg").html("Please write message");
                    return false;
                }

                $(".loading").show();
                to = $("#div_number").val();
                from = $("#div_did").val();

                $.ajax({
                    url: 'sendSms/' + from + '/' + to + '/' + message,
                    type: 'get',
                    success: function (response)
                    {
                        $('#show').animate({
                            scrollTop: $('#show')[0].scrollHeight
                        }, 1000);

                        $.ajax({
                            url: 'openSmsDetails/' + to,
                            type: 'get',
                            success: function (response)
                            {
                                $("#show").html('');
                                for (var i = 0; i < response.length; i++)
                                {
                                    var obj = response[i];
                                    var ele = document.getElementById('show');
                                    if (obj.type == 'incoming')
                                    {
                                        ele.innerHTML = ele.innerHTML + '<div class="direct-chat-msg"><div class="direct-chat-info clearfix"><span class="direct-chat-name pull-left"><i style="color:green;" class="fa fa-arrow-down" aria-hidden="true"></i>' + obj.number + '</span><span class="direct-chat-timestamp pull-right">' + obj.date + '</span></div> <div class="user_img incomingcss">C</div> <div class="direct-chat-text">' + obj.message + '</div></div>';
                                    }
                                    if (obj.type == 'outgoing')
                                    {
                                        ele.innerHTML = ele.innerHTML + '<div class="direct-chat-msg right"><div class="direct-chat-info clearfix"><span class="direct-chat-name pull-right"><i style="color:green;" class="fa fa-arrow-up" aria-hidden="true"></i>' + obj.number + '</span><span class="direct-chat-timestamp pull-left">' + obj.date + '</span></div> <div class="user_img outgoingcss">A</div> <div class="direct-chat-text">' + obj.message + '</div></div>';
                                    }
                                }
                            }
                        });
                        $("#div_message").val("");
                    }
                });
            });

            var start_date = '<?php echo date('Y-m-d 00:00:00'); ?>';
            var end_date = '<?php echo date('Y-m-d 23:59:59'); ?>';
            var extension_user_check = $("#extension_user_check").val();
            autoSub(start_date, end_date, 1, "Today",extension_user_check);
            populateChart("daily-7");
        });

        $("#show_all_agents").click(function(){
            $("#extListDashboard1").show();
            $("#show_all_agents").hide();
        });

         $("#live_calls").click(function(){
            $(".hide_live_calls").show();
            $("#live_calls").hide();
        });

        $("#extension_user_check").change(function()
        {
            userIdArray = new Array();
            var start_date = $("#start_date_open").val();
            var end_date = $("#end_date_open").val();
            var extension_user_check = $("#extension_user_check").val();
            userIdArray.push(extension_user_check);
            autoSub(start_date, end_date, 1, "Today",userIdArray);
            populateChart("daily-7");
        });

        
        /*$('ul li').on('change','.cbCheck',function()
        {
            var extension_user_check = $(this).attr('id');
            var start_date = $("#start_date_open").val();
            var end_date = $("#end_date_open").val();

            if ($(this).is(':checked'))
            {
                userIdArray.push(extension_user_check);
                autoSub(start_date, end_date, 1, "Today",userIdArray);
                populateChart("daily-7");
            }    
            else
            {
                var index = userIdArray.indexOf(extension_user_check);
                if (index > -1)
                { 
                    userIdArray.splice(index, 1);
                    autoSub(start_date, end_date, 1, "Today",userIdArray);
                    populateChart("daily-7");
                }
            }
            //alert(userIdArray);
        });*/

        function openDiv(number, did) {

            $(".ulsms").hide();


            $("#send_msg").show();

            $("#show").show();
            $("#hide_new_message_div").hide();
            $("#openNewMessage").show();


            $('#show').animate({
                scrollTop: $('#show')[0].scrollHeight
            }, 1000);

            $("#div_number").val(number);
            $("#div_did").val(did);

            $(".loading").show();


            $("#show").html('');

            $.ajax({
                url: 'openSmsDetails',
                data: {'did': did, 'number': number},
                type: 'get',
                success: function (response) {
                    for (var i = 0; i < response.length; i++) {
                        var obj = response[i];

                        var ele = document.getElementById('show');
                        if (obj.type == 'incoming') {
                            ele.innerHTML = ele.innerHTML + '<div class="direct-chat-msg"><div class="direct-chat-info clearfix"><span class="direct-chat-name pull-left"><i style="color:green;" class="fa fa-arrow-down" aria-hidden="true"></i>' + obj.number + '</span><span class="direct-chat-timestamp pull-right">' + obj.date + '</span></div> <div class="user_img incomingcss">C</div> <div class="direct-chat-text">' + obj.message + '</div></div>';
                        }
                        if (obj.type == 'outgoing') {
                            ele.innerHTML = ele.innerHTML + '<div class="direct-chat-msg right"><div class="direct-chat-info clearfix"><span class="direct-chat-name pull-right"><i style="color:green;" class="fa fa-arrow-up" aria-hidden="true"></i>' + obj.number + '</span><span class="direct-chat-timestamp pull-left">' + obj.date + '</span></div> <div class="user_img outgoingcss">A</div> <div class="direct-chat-text">' + obj.message + '</div></div>';
                        }
                    }
                }
            });
        }
        
    </script>


 @push('scripts')


<!-- 
<script src="{{asset('assets/vendor_components/chart.js-master/Chart.min.js')}}"></script> -->

 <!--  <script src="{{ asset('assets/vendor_components/Flot/jquery.flot.js?ver=0.0.1')}}"></script>
    <script src="{{ asset('assets/vendor_components/Flot/jquery.flot.resize.js?ver=0.0.1')}}"></script>
    <script src="{{ asset('assets/vendor_components/Flot/jquery.flot.pie.js?ver=0.0.1')}}"></script>
    <script src="{{ asset('assets/vendor_components/Flot/jquery.flot.categories.js?ver=0.0.1')}}"></script>
    
  
    
    <script src="{{ asset('assets/js/pages/widget-flot-charts.js?ver=0.0.1')}}"></script>
 -->

<script src="{{ asset('assets/vendor_components/c3/d3.min.js')}}"></script>
    <script src="{{ asset('assets/vendor_components/c3/c3.min.js')}}"></script>
   <!--  <script src="{{ asset('assets/js/pages/c3-line.js')}}"></script> -->
  

    
    <!-- Joblly App -->
    

    <script src="{{ asset('assets/vendor_components/echarts/dist/echarts-en.min.js?ver=0.0.1')}}"></script>
    <script src="{{asset('assets/js/bootstrap4-toggle.min.js')}}"></script>
    <!-- <script>
        $(document).ready(function () {
            $('#dashboardToggle').click(function () {
                var isPressed = $(this).attr('aria-pressed') === 'true';

                // Hide all dashboard content
                $('.dashboard-content').hide();

                // Show the selected dashboard content
                if (isPressed) {
                    $('#dashboard1').show();
                } else {
                    $('#dashboard2').show();
                }
            });
        });
    </script> -->

 

    
    <!-- <script src="{{ asset('assets/js/pages/echart-pie-doghnut.js?ver=0.0.1')}}"></script> -->
    @endpush

  
    
 
    
  
    
  

@endsection
