@extends('layouts.app')
@section('title', 'Start Dialing')
@section('content')

<!-- Add Font Awesome (if not already in layout) -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">


<style>
      
      #preloader {
            background-color: black;
            bottom: 0;
            left: 0;
            position: fixed;
            right: 0;
            top: 0;
            z-index: 2147483647;
        }
        #preloader-status {
            background: center center no-repeat;
            height: 80px;
            left: 50%;
            top: 50%;
            position: absolute;
            width: 80px;
            margin: -40px 0 0 -40px;
        }
    </style>
<?php

use \App\Http\Controllers\InheritApiController;
$userdetails = InheritApiController::headerUserDetails();
?>

<style>
    .custom {
        width: 100px !important;
    }

    fieldset.scheduler-border
    {
        /*border: 1px groove #ddd !important;*/
        /*padding: 0px 3.4em 2.4em 7.4em !important;*/
        margin: 5px 4px 1.5em 6px !important;
        box-shadow: 0px 0px 0px 0px #000;
    }

    legend.scheduler-border
    {
        font-size: 1.2em !important;
        font-weight: bold !important;
        text-align: left !important;
        width:auto;
        padding:0 10px;
        /*border-bottom:none;*/
    }

    /* Container bar */
.campaign-bar {
    background: #fff;
    padding: 12px 18px !important;
    border-radius: 2px !important; 
    box-shadow: 0 2px 8px rgba(0,0,0,0.06);
    margin-bottom: 15px;
    width: 100% !important; 
    display: flex;
    justify-content: space-between;
    align-items: center;
}

/* Labels */
.campaign-bar .form-label {
    font-weight: 600;
    font-size: 14px;
    color: #333;
}

/* Dropdown */
.custom-select {
    border: 1px solid #ccc !important;
    border-radius: 2px !important;
    padding: 6px 12px !important;
    font-size: 14px;
    min-width: 180px;
    height: 38px !important; /* Uniform height */
}

/* Submit Button */
.btn-submit {
    background: #d32f2f !important;
    color: #fff !important;
    border: none !important;
    padding: 6px 18px !important;
    border-radius: 2px !important;
    font-weight: 600 !important;
    font-size: 14px !important;
    transition: 0.3s;
    height: 38px !important; /* Matches select height */
}
.btn-submit:hover {
    background: #b71c1c !important;
}


    
</style>

<div ng-app="myApp" ng-controller="myCtrl"></div>

<section class="content">

   <div class="row mb-0" style="margin:-15px;">
    <div class="col-lg-12" style="padding:0;">
        <div class="box" style="height:45px; width:100%; border-radius:6px;">
          <div id="preloader"style="display:none;">
                      <div id="preloader-status">
                        <img  src="{{asset('assets/images/loader-30px.gif')}}">
                        </div>  
                        </div>
                <div class="box-header with-border">
                    <!-- <h4 class="">Campaign Lists</h4> -->

                    <div class="row">
                        <div class="col-sm-4">

                            <form class="form-inline form-dialer" method="post">
                                <input type="hidden" id="popup_value">
                                @csrf

                                <div class="row-fluid">

                                    <div class="form-group row">
                                  <label for="example-text-input" class="col-sm-4"  style="padding: 7px;">Campaign List</label>
                                  <div class="col-sm-8" style="padding: 0px;">
                                    <div class="input-group" style="flex-wrap: inherit !important;">
                                            <select name="campaign" class="form-select" required="" id="campaign">
                                                <option value="">Select Campaign</option>
                                                @if (!empty($campaign->data))
                                                    @foreach($campaign->data as $key => $value)
                                                        <option value="{{$value->id}}">{{$value->title}}</option>
                                                    @endforeach
                                                @endif
                                            </select>

                                            <button type="submit" id="start_dialing" name="submit" class="btn btn-success btn-sm" value="Search">Submit</button>
                                        </div>
                                  </div>
                                </div>
                                    

                                    <div class="form-group" style="margin-left: 15%;">
                                        <div class="row text-danger text-center" id="form_error">
                                            @if(!empty($message))
                                                {{ $message }}
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-sm-4">
                            <div id="detail-message" style="padding:6px 6px 0px 6px;" class=""></div>
                            <div class="row text-center" style="padding:6px 6px 0px 6px;" id="disposition_error"></div>

                        </div>

                         <!-- <div class="col-sm-4">
                             <div class="form-group row">
                                  <label for="example-text-input" class="col-sm-5"  style="padding: 7px 0px 0px 30px">Dialing Mode</label>
                                  <div class="col-sm-7" style="padding: 0px 5px 5px 5px;">
                                    <div class="input-group" style="flex-wrap: inherit !important;">
                                            <select name="dialer_mode" onchange="updateDialerModeStatus(this.value)" class="form-select" required="" id="dialer_mode">
                                               <option @if($userdetails->data->dialer_mode == '1') selected @endif value="1">Desk Phone</option>    
                                        <option @if($userdetails->data->dialer_mode == '2') selected @endif value="2">Web Phone</option>    
                                        <option @if($userdetails->data->dialer_mode == '3') selected @endif value="3">Mobile App</option>  
                                            </select>

                                            
                                        </div>
                                  </div>
                                </div>

                        </div>  -->



                    </div>
                </div>
            </div>
        </div>
    </div>
     <div class="row" >
        <div class="col-lg-12" >
            <div class="box" >
                <div class="">

                    @if (!empty($campaignDetail) )
                    @if($campaignDetail['dial_mode'] == 'super_power_dial')

                    <!-- <div class="nav-tabs-custom HiddenAfterPause" style="margin:-15px; overflow-y: auto;">
                        <ul class="nav nav-tabs" role="tablist" >
                            <li class="nav-item"> <a  class="nav-link active" data-bs-toggle="tab" href="#leads" role="tab"><i class="icon-Home me-1"></i>Lead Details</a> </li>
                            <li class="nav-item"> <a onclick="ShowSmsPopUpTab()"  class="nav-link" data-bs-toggle="tab" href="#sms" role="tab"><span> <i class="icon-Chat"><span class="path1"></span><span class="path2"></span></i> Send SMS</span></a> </li>
                            <li class="nav-item"> <a id="btn_send_email"  class="nav-link" data-bs-toggle="tab" href="#email" role="tab"><i class="icon-Incoming-mail"><span class="path1"></span><span class="path2"></span></i> Send Email</span></a> </li>
                            <li class="nav-item"> <a  class="nav-link" data-bs-toggle="tab" href="#agent" role="tab"><span><i class="icon-file-excel me-1"><span class="path1"></span><span class="path2"></span></i>Agent Script</span></a> </li>
                            <li class="nav-item"> <a id="notes"  class="nav-link" data-bs-toggle="tab" href="#comments" role="tab"><span><i class="icon-file-excel me-1"><span class="path1"></span><span class="path2"></span></i>Notes</span></a> </li>
                            <li class="nav-item"> <a  class="nav-link" data-bs-toggle="tab" href="#events" role="tab"><span><i class="icon-file-excel me-1"><span class="path1"></span><span class="path2"></span></i>Events</span></a> </li>
                            

                        </ul> -->

  
<style>
.action-buttons {
    margin: 0 !important;
    padding: 0 !important;
    height: 100% !important;
    display: flex !important;
    align-items: stretch !important;
}

/* Common buttons (Hangup ke alawa) */
.action-buttons .btn:not(.btn-danger) {
   background: #2196f3 !important; 
    color: #fff !important;
    display: flex !important;
    align-items: center !important;
    justify-content: center !important;
    padding: 6px 12px !important;
    height: 32px !important;
    line-height: 1.2 !important;
    margin: 0 !important;
    border-radius: 0 !important; 
    border: 1px solid #11707f !important;
    box-shadow: none !important;

    /* Top-left & Top-right slope */
    border-top-left-radius: 6px !important;
    border-top-right-radius: 6px !important;

    /* Bottom flat */
    border-bottom-left-radius: 0 !important;
    border-bottom-right-radius: 0 !important;
}


.action-buttons .btn + .btn {
    margin-left: -8px !important;
}

.action-buttons .btn:not(.btn-danger):hover {
    filter: brightness(92%);
}

#reload-lead {
    margin-left: -8px !important; 
}

.action-buttons .btn-danger,
#btn-hangup {
    background: linear-gradient(90deg, #dc3545, #b02a37) !important;
    color: #fff !important;
    border-radius: 6px !important; 
    margin-left: 6px !important;    
    height: 32px !important;
    line-height: 1.2 !important;
    display: flex !important;
    align-items: center !important;
    justify-content: center !important;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1) !important;
    border: none !important;
}


.action-buttons .btn:first-child {
    margin-left: 2px !important; 
}
 
@media (max-width: 992px) {
    .form-inline.form-dialer .form-group.row {
        display: flex !important;
        flex-wrap: nowrap !important;   
        align-items: center !important;
        width: 100% !important;
    }

  
    .form-inline.form-dialer label {
        flex: 0 0 auto !important;      
        margin-right: 8px !important;
        white-space: nowrap !important;
        font-weight: 600 !important;
    }

  
    .form-inline.form-dialer .col-sm-8 {
        flex: 1 1 auto !important;      
        display: flex !important;
        flex-wrap: nowrap !important;
        align-items: center !important;
        gap: 6px !important;
        width: auto !important;
        padding: 0 !important;
    }


    .form-inline.form-dialer select {
        flex: 0 0 140px !important;     
        margin: 0 !important;
    }


    .form-inline.form-dialer button {
        flex: 0 0 80px !important;      
        margin: 0 !important;
    }

    .action-buttons {
        display: flex !important;
        flex-wrap: nowrap !important;
        overflow-x: auto !important;
        margin-top: 12px !important;
    }

    .action-buttons .btn {
        flex: 0 0 auto !important;
        margin: 4px 6px !important;
    }
}

</style>


<div class="nav-tabs-custom HiddenAfterPause" style="margin:-15px; overflow-y:auto;">
    <div class="d-flex justify-content-between align-items-center flex-wrap" style="border-bottom: 1px solid #dee2e6;">

        <!-- LEFT SIDE: NAVIGATION + BUTTONS -->
        <div class="d-flex gap-2 p-2 flex-wrap align-items-center action-buttons">
            <!-- Lead Details -->
 <a class="btn btn-primary btn-sm" id="tab-leads" data-bs-toggle="tab" href="#leads" role="tab" aria-controls="leads" aria-selected="true">
    <i class="icon-Home me-1"></i> Lead Details
</a>

            <!-- Send SMS -->
            <button type="button" onclick="ShowSmsPopUpTab()" class="btn btn-success btn-sm" data-bs-toggle="offcanvas" href="#modal-right" role="button">
                <i class="fa fa-comment"></i> Send SMS
            </button>

            <!-- Send Email -->
            <button type="button" id="btn_send_email" class="btn btn-primary btn-sm" data-bs-toggle="offcanvas" href="#modal-email" role="button" aria-controls="modal-email">
                <i class="fa fa-envelope"></i> Send Email
            </button>

        <!-- Agent Script -->
<a class="btn btn-purple btn-sm" id="tab-agent" data-bs-toggle="tab" href="#agent" role="tab" aria-controls="agent" aria-selected="false">
    <i class="fa fa-file-text"></i> Agent Script
</a>

<a class="btn btn-success btn-sm" id="tab-comments" data-bs-toggle="tab" href="#comments" role="tab" aria-controls="comments" aria-selected="false">
    <i class="fa fa-sticky-note"></i> Notes
</a>

<a class="btn btn-warning1 btn-sm" id="tab-events" data-bs-toggle="tab" href="#events" role="tab" aria-controls="events" aria-selected="false">
    <i class="fa fa-calendar"></i> Events
</a>

            <button type="button" id="dialPad" class="btn btn-info btn-sm">
                <i class="fa-solid fa-th"></i> Dialpad
            </button>

            @if($campaignDetail['send_crm'] == 1)
            <button type="button" class="btn btn-export btn-sm">
                <i class="fa-solid fa-share-from-square"></i> Export Lead
            </button>
            @endif

            @if($campaignDetail['call_transfer'] == 1)
            <button type="button" onclick="openCallTransfer()" id="call_transfer_id" class="btn btn-warning btn-sm">
                <i class="fa-solid fa-shuffle"></i> Transfer
            </button>
            @endif

        <span class="start-dial-action-btn" id="block-reload-lead" style="display: none;">
        <button type="button" id="reload-lead" class="btn btn-primary btn-sm">
            <i class="fa-solid fa-rotate-right"></i> Retry
        </button>
        </span>

        
<!-- 
            <button type="button" id="btn-hangup" class="btn btn-danger btn-sm hang-up" data-bs-toggle="offcanvas" data-bs-target="#dispositionOffcanvas">
                <i class="fa-solid fa-phone-slash"></i> Hang Up
            </button> -->
        </div>

        <!-- RIGHT SIDE: ONLY Hang Up and Dialpad -->
        <div class="d-flex p-2 align-items-center me-2">
            <button type="button" id="btn-hangup" class="btn btn-danger btn-sm hang-up" data-bs-toggle="offcanvas" data-bs-target="#dispositionOffcanvas">
                <i class="fa-solid fa-phone-slash"></i> Hang Up
            </button>

      
        </div>
    </div>

 <!-- TAB CONTENT -->
<div class="tab-content tabcontent-border">
    <div class="tab-pane active" id="leads" role="tabpanel">
        <div class="row">
            <!-- Comment Card -->
            <div class="full-width showDiv" style="display: none; padding: 0px; margin: -10px 0px -15px 0px;">
                <div class="box box-widget widget-user-2">
                    <div class="widget-user-header bg-gradient-info d-flex align-items-center text-white" style="padding: 5px 10px;">
                 <i class="fas fa-user-circle" style="font-size: 24px;"></i>


                        <h4 class="widgetUserUsername widget-user-username" style="margin-left: 10px; padding: 0px;"></h4>
                        
                    </div>
                    
                    <div class="box">
                        <div class="box-body box-profile" style="padding-top: 0.5rem;">
                            <div class="table-responsive">
                                <table id="tickets" class="table table-hover">
                                    <tbody class="leadBoxUser"></tbody>
                                </table>
                                <input type="hidden" name="lead_id" id="lead_id" value=""/>
                                <input type="hidden" name="list_id" id="list_id" value=""/>
                                <!-- <textarea class="form-control comment" rows="3" placeholder="Enter comment"></textarea> -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>


                                    <!-- <div class="col-12 col-lg-6 col-xl-7">
                                        <div class="row  hiddeNDispose">
                                            <div class="col-lg-12">

                                                
                                                <span class="start-dial-action-btn" id="block-reload-lead" style="display: none;">
                                                    <button type="button" name="reload-lead" id="reload-lead" style="margin: 5px;" class="btn btn-primary btn-sm" value="retry">Retry</button>
                                                </span>

                                                <button type="button" name="hangup" id="btn-hangup" class= "btn btn-danger custom  btn-sm mb-1 hang-up">Hang Up</button>

                                                <button type="button" name="dialPad" id="dialPad" class="btn btn-primary  custom  btn-sm mb-1" value="dialPad">Dialpad</button>

                                                @if($campaignDetail['send_crm'] == 1)

                                                <button type="button" class="btn btn-success  custom  btn-sm mb-1 send-to-crm">Export Lead</button>
                                                @endif

                                                @if (Session::get('vm_drop')==0)

                                                <button name="voicemail-drop"   value="voicemail-drop"  type="button" data-bs-toggle="modal" data-bs-target="#myModal"  class="btn btn-warning  custom  btn-sm mb-1 voicemail-drop-empty">Voice Drop</button>

                                                @else

                                                <button  type="button" name="voicemail-drop" class="btn btn-warning  custom  btn-sm mb-1 voicemail-drop"  value="voicemail-drop" >Voice Drop</button>



                                                @endif



                                                @if($campaignDetail['call_transfer'] == 1)

                                                <button type="button" onclick="openCallTransfer()" id="call_transfer_id" class="btn btn-success  custom  btn-sm mb-1 ">Transfer</button>
                                                @endif
                                            </div>
                                        </div> -->

                              
   <!-- Disposition Card --> 
<div class="offcanvas offcanvas-end" tabindex="-1" id="dispositionOffcanvas" aria-labelledby="dispositionLabel">
  <div class="offcanvas-header">
    <h5 id="dispositionLabel">Select Disposition</h5>
    <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
  </div>


        
        <div class="offcanvas-body">

            <div class="row">
                @if(!empty($dispositionDetail))
                    @foreach($dispositionDetail as $item=>$value)
                           <div class="col-12 px-0"> 
                            <div class="form-check">
                                <input type="radio" class="form-check-input disposition-radio" 
                                    id="disposition-radio-{{$value->id}}" 
                                    name="disposition" value="{{$value->title}}"
                                    @if($value->enable_sms == 1) onchange="ShowSmsPopUp()" @endif
                                    @if($value->d_type== 3) onchange="ShowSmsPopUpCallBack()" @endif
                                >
                                <label for="disposition-radio-{{$value->id}}" class="form-check-label">
                                    {{$value->title}}
                                </label>
                            </div>
                        </div>
                    @endforeach
                @endif
            </div>

            <!-- Callback fields (hidden by default) -->
            <div class="row mt-3" id="callback-section" style="display:none;">
                <div class="col-md-12 mb-3">


<div class="icon-form" style="position:relative; display:inline-block; width:230px;">
    <input type="text" name="callback_time" id="callback-time" class="form-control" placeholder="mm/dd/yyyy" style="width:100%; padding-right:40px; height:38px; font-size:14px;">
    <span class="form-icon" style="position:absolute; right:12px; top:45%; transform:translateY(-50%); cursor:pointer; font-size:14px; color:#666;">
        <i class="fa fa-calendar"></i>
    </span>
</div>


                </div>
                <div class="col-md-12">
                    <textarea class="form-control" name="callback_notes" id="callback-notes" rows="3" placeholder="Enter notes..."></textarea>
                </div>
            </div>

            <!-- Pause Calling -->
            <div class="form-group mt-3">
                <div class="form-check form-switch">
                    <input class="form-check-input" type="checkbox" id="pause_calling">
                    <label class="form-check-label" for="pause_calling">Pause Calling</label>
                </div>
            </div>

            <!-- Buttons -->
<div class="d-flex mt-4">
    <button type="button" name="submit" id="redial" 
        class="btn btn-success me-2" disabled>
        Redial
    </button>
    <button type="button" name="submit" id="save-disposition" 
        class="btn btn-danger" disabled>
        Save
    </button>
</div>


        </div>
    </div>
</div>

<script>
document.addEventListener("DOMContentLoaded", function(){
    const radios = document.querySelectorAll(".disposition-radio");
    const callbackSection = document.getElementById("callback-section");

    radios.forEach(radio => {
        radio.addEventListener("change", function(){
            let selectedValue = this.value.toLowerCase().trim();

           
            selectedValue = selectedValue.replace(/\s+/g, "");

            if(selectedValue.includes("callback")) {   
                callbackSection.style.display = "flex"; 
            } else {
                callbackSection.style.display = "none";
            }
        });
    });
});



</script>



<style>
#dispositionOffcanvas {
    width: 280px;   
    padding: 12px;
}

#dispositionOffcanvas .offcanvas-header {
    border-bottom: 1px solid #ddd; 
    padding-bottom: 8px;
    margin-bottom: 10px;
}

#dispositionOffcanvas .form-check {
    display: flex;
    align-items: center;
    margin-bottom: 8px;
    padding-left: 0 !important;  
}

#dispositionOffcanvas .form-check-input {
    margin-left: 0 !important;   
    margin-right: 6px;
}

#dispositionOffcanvas .form-check-label {
    margin-left: 0 !important;
}


#dispositionOffcanvas input[type="text"],
#dispositionOffcanvas input[type="date"],
#dispositionOffcanvas input[type="datetime-local"],
#dispositionOffcanvas textarea {
    width: 100% !important;
    display: block;
    margin-bottom: 10px;
}

#dispositionOffcanvas .d-flex {
    display: flex;
    width: 100%;      
    gap: 10px;          
}


#dispositionOffcanvas .d-flex button {
    flex: 1;           
    width: 100%;        
}


.showDiv.full-width {
    width: 110%; 
    margin: 0 auto;
    transition: width 0.4s ease;
    background: #fff;
    border-radius: 8px; 
    box-shadow: 0 4px 10px rgba(0, 0, 0, 0.08);
    overflow: hidden;
    padding: 15px;
}

.showDiv.half-width {
    width: 58%;
    margin: 0 auto;
}


.leadBoxUser {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    font-family: 'Poppins', sans-serif;
    font-size: 14px;
    border-top: 1px solid #ddd;
    background: #fff;
}

/* Each row (item) */
.leadBoxUser .item {
    padding: 10px 15px;
    display: flex;
    flex-direction: column; 
    border-bottom: 1px solid #f0f0f0; 
}

/* Label styling */
.leadBoxUser .label {
    font-weight: 600;
    color: #666; 
    font-size: 12px;
    text-transform: uppercase;
    margin-bottom: 4px;
    letter-spacing: 0.5px;
}

/* Value styling */
.leadBoxUser .value {
    color: #666;
    font-weight: 500;
    font-size: 14px;
    word-break: break-word;
}

.leadBoxUser .value,
.leadBoxUser td {
    text-transform: none !important; 

}


.leadBoxUser .value,
.leadBoxUser td {
    text-transform: lowercase !important;
}


.leadBoxUser .value::first-letter,
.leadBoxUser td::first-letter {
    text-transform: uppercase;
}


/* Responsive */
@media (max-width: 992px) {
    .leadBoxUser {
        grid-template-columns: repeat(2, 1fr);
    }
}
.leadBoxUser {
    width: 100%;
    border-collapse: collapse; 
    font-family: 'Poppins', sans-serif;
    font-size: 14px;
    background: #fff;
}



.leadBoxUser th {
    font-weight: 600;
    color: #444;
    text-transform: uppercase;
    font-size: 12px;
    letter-spacing: 0.5px;
    padding: 8px 12px;
    text-align: left;
    white-space: nowrap;
    font-family: 'Poppins', sans-serif;
}


.leadBoxUser th::before {
    content: "•";
    color: #003366; 
    font-size: 16px;
    display: inline-block;
    margin-right: 6px; 
    vertical-align: middle; 
}



/* Value cell */
.leadBoxUser td {
    color: #1a4ed8; 
    font-weight: 500;
    font-size: 14px;
    padding: 8px 12px;
    word-break: break-word;
}

.leadBoxUser tr {
    border-bottom: 1px solid #e0e0e0;
}


@media (max-width: 768px) {
    .leadBoxUser, 
    .leadBoxUser tr, 
    .leadBoxUser th, 
    .leadBoxUser td {
        display: block;
        width: 100%;
    }
    .leadBoxUser th {
        margin-bottom: 2px;
    }
}




</style>



</div>

    <!-- Other Tabs -->
    <div class="tab-pane" id="agent" role="tabpanel">Agent Script</div>
    <div class="tab-pane" id="comments" role="tabpanel">@include('sms.notes')</div>
    <div class="tab-pane" id="events" role="tabpanel">Events</div>
</div>


     
<style>
#modal-right .form .row,
#modal-right .form .form-group {
    display: block !important;
    width: 100% !important;
    max-width: 100%;
    margin: 0 0 15px 0; 
    padding: 0;
}


#modal-right .form .input-group,
#modal-right .form input,
#modal-right .form select,
#modal-right .form textarea {
    width: 100% !important;
    border-radius: 6px;
}


#modal-right .form .form-label {
    display: block;
    margin-bottom: 6px;
    font-size: 14px;
    font-weight: 500;
}


#modal-right .count_sms_len {
    text-align: right;
    font-size: 12px;
    margin-bottom: 10px;
}


#modal-right #previewVideo,
#modal-right #previewImage,
#modal-right #previewPDF {
    display: block;
    margin-top: 10px;
    max-width: 100%;
}


#modal-right .input-group {
    position: relative;
}


#modal-right .input-group-text {
    background: transparent;
    border: none;
    position: absolute;
    left: 12px;
    top: 50%;
    transform: translateY(-50%);
    z-index: 2;
    padding: 0;
}


#modal-right .input-group-text i {
    font-size: 16px;
    color: #666;
}


#modal-right .input-group input,
#modal-right .input-group select,
#modal-right .input-group textarea {
    padding-left: 40px !important;
}


</style>
                      

<div class="offcanvas offcanvas-end" tabindex="-1" id="modal-right" aria-labelledby="modalRightLabel">
  <div class="offcanvas-header">
    <h5 id="modalRightLabel">SMS</h5>
    <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
  </div>
  <div class="offcanvas-body">
    @include('sms.send_message_tab')
  </div>
</div>


<!-- Email Offcanvas -->
<div class="offcanvas offcanvas-end" tabindex="-1" id="modal-email" aria-labelledby="modalEmailLabel">
  <div class="offcanvas-header">
    <h5 id="modalEmailLabel">Email</h5>
    <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
  </div>
  <div class="offcanvas-body">
    @include('sms.send_mail_tab')
  </div>
</div>

<!-- Custom CSS -->
<style>
.offcanvas-header {
    border-bottom: 1px solid #ddd; 
    padding: 0.4rem 0.75rem;  
    margin-bottom: 8px;        
    height: auto;

    display: flex;
    justify-content: space-between; 
    align-items: center;           
}

.offcanvas-header h5, 
.offcanvas-header .offcanvas-title {
    margin: 0;
    font-size: 1.15rem;   
    font-weight: 400;   
    line-height: 1.3;     
    padding-top: 3px;   
}



/* cross button */
.offcanvas-header .btn-close {
    width: 1.6rem;
    height: 1.6rem;
    margin: 0; 

    background-color: #007bff;
    border-radius: 4px;
    opacity: 1;

    background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' fill='%23ffffff' viewBox='0 0 16 16'%3E%3Cpath d='M2.146 2.146a.5.5 0 0 1 .708 0L8 7.293l5.146-5.147a.5.5 0 1 1 .708.708L8.707 8l5.147 5.146a.5.5 0 0 1-.708.708L8 8.707l-5.146 5.147a.5.5 0 0 1-.708-.708L7.293 8 2.146 2.854a.5.5 0 0 1 0-.708z'/%3E%3C/svg%3E");
    background-repeat: no-repeat;
    background-position: center;
    background-size: 1rem;
}

/* hover effect */
.offcanvas-header .btn-close:hover {
    background-color: #0056b3;
}

#modal-right .offcanvas-body {
    padding-top: 5px !important;  
}




/* Offcanvas width */
#modal-email {
    width: auto !important;
    max-width: 700px;
    overflow-x: hidden;
}

/* Form container */
.sendMailModel form {
    display: flex;
    flex-direction: column;
    gap: 5px; 
}

/* Flex rows */
.flex-row {
    display: flex;
    gap: 8px; 
    flex-wrap: wrap;
    box-sizing: border-box;
    margin-bottom: 3px; 
}

/* Row 1: To + From */
.flex-row.row-1 .form-group {
    flex: 1 1 48%;
    min-width: 0;
}
.flex-row.row-1 {
    margin-top: -10px;
}

/* Row 2: 3 placeholders */
.flex-row.row-2 .form-group {
    flex: 1 1 32%;
    min-width: 0;
}

/* Row 3: Subject full width */
.flex-row.row-3 .form-group {
    flex: 1 1 100%;
    min-width: 0;
}

/* Row 4: Editor full width */
.flex-row.row-4 .form-group {
    flex: 1 1 100%;
    min-width: 0;
}

/* Input group and icons inside input */
.sendMailModel .form-group .input-group {
    display: flex;
    width: 100%;
    align-items: center;
    box-sizing: border-box;
    margin-bottom: 3px !important;
}

.sendMailModel .form-group input,
.sendMailModel .form-group select,
.sendMailModel .form-group textarea {
    flex: 1 1 auto;
    min-width: 0;
}

/* Slightly smaller than input box */
.sendMailModel .form-group .input-group-text {
    height: 32px; 
    min-height: 32px;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 0 8px;
    box-sizing: border-box;
    font-size: 15px;
}

/* Label adjustment */
.sendMailModel .form-group label {
    margin-bottom: 2px !important; 
    font-size: 13px;
    font-weight: 500;
}

/* Buttons */
.text-end {
    width: 100%;
    text-align: right;
    margin-top: 5px;
}

/* Responsive */
@media (max-width: 768px) {
    .flex-row.row-1 .form-group,
    .flex-row.row-2 .form-group {
        flex: 1 1 100%;
    }
    #modal-email {
        width: 95% !important;
    }
}


</style>


                        </div>
                    </div>

                    @endif

                 @if($campaignDetail['dial_mode'] == 'predictive_dial')


<style>
.action-buttons {
    margin: 0 !important;
    padding: 0 !important;
    height: 100% !important;
    display: flex !important;
    align-items: stretch !important;
}

/* Common buttons (Hangup ke alawa) */
.action-buttons .btn:not(.btn-danger) {
   background: #2196f3 !important; 
    color: #fff !important;
    display: flex !important;
    align-items: center !important;
    justify-content: center !important;
    padding: 6px 12px !important;
    height: 32px !important;
    line-height: 1.2 !important;
    margin: 0 !important;
    border-radius: 0 !important; 
    border: 1px solid #11707f !important;
    box-shadow: none !important;

    /* Top-left & Top-right slope */
    border-top-left-radius: 6px !important;
    border-top-right-radius: 6px !important;

    /* Bottom flat */
    border-bottom-left-radius: 0 !important;
    border-bottom-right-radius: 0 !important;
}


.action-buttons .btn + .btn {
    margin-left: -8px !important;
}

.action-buttons .btn:not(.btn-danger):hover {
    filter: brightness(92%);
}

#reload-lead {
    margin-left: -8px !important; 
}

.action-buttons .btn-danger,
#btn-hangup {
    background: linear-gradient(90deg, #dc3545, #b02a37) !important;
    color: #fff !important;
    border-radius: 6px !important; 
    margin-left: 6px !important;    
    height: 32px !important;
    line-height: 1.2 !important;
    display: flex !important;
    align-items: center !important;
    justify-content: center !important;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1) !important;
    border: none !important;
}


.action-buttons .btn:first-child {
    margin-left: 2px !important; 
}
 
@media (max-width: 992px) {
    .form-inline.form-dialer .form-group.row {
        display: flex !important;
        flex-wrap: nowrap !important;   
        align-items: center !important;
        width: 100% !important;
    }

  
    .form-inline.form-dialer label {
        flex: 0 0 auto !important;      
        margin-right: 8px !important;
        white-space: nowrap !important;
        font-weight: 600 !important;
    }

  
    .form-inline.form-dialer .col-sm-8 {
        flex: 1 1 auto !important;      
        display: flex !important;
        flex-wrap: nowrap !important;
        align-items: center !important;
        gap: 6px !important;
        width: auto !important;
        padding: 0 !important;
    }


    .form-inline.form-dialer select {
        flex: 0 0 140px !important;     
        margin: 0 !important;
    }


    .form-inline.form-dialer button {
        flex: 0 0 80px !important;      
        margin: 0 !important;
    }

    .action-buttons {
        display: flex !important;
        flex-wrap: nowrap !important;
        overflow-x: auto !important;
        margin-top: 12px !important;
    }

    .action-buttons .btn {
        flex: 0 0 auto !important;
        margin: 4px 6px !important;
    }
}

</style>

<div class="nav-tabs-custom HiddenAfterPause" style="margin:-15px; overflow-y:auto;">
    <div class="d-flex justify-content-between align-items-center flex-wrap" style="border-bottom: 1px solid #dee2e6;">

        <!-- LEFT SIDE: NAVIGATION + BUTTONS -->
        <div class="d-flex gap-2 p-2 flex-wrap align-items-center action-buttons">
            <!-- Lead Details -->
 <a class="btn btn-primary btn-sm" id="tab-leads" data-bs-toggle="tab" href="#leads" role="tab" aria-controls="leads" aria-selected="true">
    <i class="icon-Home"></i>Lead Details
</a>

            <!-- Send SMS -->
            <button type="button"  class="btn btn-success btn-sm" data-bs-toggle="offcanvas" href="#modal-right" role="button">
                <i class="fa fa-comment"></i> Send SMS
            </button>

            <!-- Send Email -->
            <button type="button" id="btn_send_email" class="btn btn-primary btn-sm" data-bs-toggle="offcanvas" href="#modal-email" role="button" aria-controls="modal-email">
                <i class="fa fa-envelope"></i> Send Email
            </button>

        <!-- Agent Script -->
<a class="btn btn-purple btn-sm" id="tab-agent" data-bs-toggle="tab" href="#agent" role="tab" aria-controls="agent" aria-selected="false">
    <i class="fa fa-file-text"></i> Agent Script
</a>

<a class="btn btn-success btn-sm" id="tab-comments" data-bs-toggle="tab" href="#comments" role="tab" aria-controls="comments" aria-selected="false">
    <i class="fa fa-sticky-note"></i> Notes
</a>

<a class="btn btn-warning1 btn-sm" id="tab-events" data-bs-toggle="tab" href="#events" role="tab" aria-controls="events" aria-selected="false">
    <i class="fa fa-calendar"></i> Events
</a>

            <button type="button" id="dialPad" class="btn btn-info btn-sm">
                <i class="fa-solid fa-th"></i> Dialpad
            </button>

            @if($campaignDetail['send_crm'] == 1)
            <button type="button" class="btn btn-export btn-sm">
                <i class="fa-solid fa-share-from-square"></i> Export Lead
            </button>
            @endif

            @if($campaignDetail['call_transfer'] == 1)
            <button type="button" onclick="openCallTransfer()" id="call_transfer_id" class="btn btn-warning btn-sm">
                <i class="fa-solid fa-shuffle"></i> Transfer
            </button>
            @endif

        <span class="start-dial-action-btn" id="block-reload-lead" style="display: none;">
        <button type="button" id="reload-lead" class="btn btn-primary btn-sm">
            <i class="fa-solid fa-rotate-right"></i> Retry
        </button>
        </span>

            <!-- <button type="button" id="btn-hangup" class="btn btn-danger btn-sm hang-up" data-bs-toggle="offcanvas" data-bs-target="#dispositionOffcanvas">
                <i class="fa-solid fa-phone-slash"></i> Hang Up
            </button> -->
        </div>

        <!-- RIGHT SIDE: ONLY Hang Up and Dialpad -->
        <div class="d-flex p-1 align-items-center">
            <button type="button" id="btn-hangup" class="btn btn-danger btn-sm hang-up" data-bs-toggle="offcanvas" data-bs-target="#dispositionOffcanvas">
                <i class="fa-solid fa-phone-slash"></i> Hang Up
            </button>

      
        </div>
    </div>


 <!-- TAB CONTENT -->
<div class="tab-content tabcontent-border">
    <div class="tab-pane active" id="leads" role="tabpanel">
        <div class="row">
            <!-- Comment Card -->
            <div class="full-width showDiv" style="display: none; padding: 0px; margin: -10px 0px -15px 0px;">
                <div class="box box-widget widget-user-2">
                    <div class="widget-user-header bg-primary d-flex align-items-center text-white" style="padding: 5px 10px;">
                 <i class="fas fa-user-circle" style="font-size: 24px;"></i>


                        <h4 class="widgetUserUsername widget-user-username" style="margin-left: 10px; padding: 0px;"></h4>
                        
                    </div>
                    
                    <div class="box">
                        <div class="box-body box-profile" style="padding-top: 0.5rem;">
                            <div class="table-responsive">
                                <table id="tickets" class="table table-hover">
                                    <tbody class="leadBoxUser"></tbody>
                                </table>
                                <input type="hidden" name="lead_id" id="lead_id" value=""/>
                                <input type="hidden" name="list_id" id="list_id" value=""/>
                                <!-- <textarea class="form-control comment" rows="3" placeholder="Enter comment"></textarea> -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>


   <!-- Disposition Card --> 
<div class="offcanvas offcanvas-end" tabindex="-1" id="dispositionOffcanvas" aria-labelledby="dispositionLabel">
  <div class="offcanvas-header">
    <h5 id="dispositionLabel">Select Disposition</h5>
    <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
  </div>


        
        <div class="offcanvas-body">

            <div class="row">
                @if(!empty($dispositionDetail))
                    @foreach($dispositionDetail as $item=>$value)
                           <div class="col-12 px-0"> 
                            <div class="form-check">
                                <input type="radio" class="form-check-input disposition-radio" 
                                    id="disposition-radio-{{$value->id}}" 
                                    name="disposition" value="{{$value->title}}"
                                    @if($value->enable_sms == 1) onchange="ShowSmsPopUp()" @endif
                                    @if($value->d_type== 3) onchange="ShowSmsPopUpCallBack()" @endif
                                >
                                <label for="disposition-radio-{{$value->id}}" class="form-check-label">
                                    {{$value->title}}
                                </label>
                            </div>
                        </div>
                    @endforeach
                @endif
            </div>

            <!-- Callback fields (hidden by default) -->
            <div class="row mt-3" id="callback-section" style="display:none;">
                <div class="col-md-12 mb-3">


<div class="icon-form" style="position:relative; display:inline-block; width:230px;">
    <input type="text" name="callback_time" id="callback-time" class="form-control" placeholder="mm/dd/yyyy" style="width:100%; padding-right:40px; height:38px; font-size:14px;">
    <span class="form-icon" style="position:absolute; right:12px; top:45%; transform:translateY(-50%); cursor:pointer; font-size:14px; color:#666;">
        <i class="fa fa-calendar"></i>
    </span>
</div>


                </div>
                <div class="col-md-12">
                    <textarea class="form-control" name="callback_notes" id="callback-notes" rows="3" placeholder="Enter notes..."></textarea>
                </div>
            </div>

            <!-- Pause Calling -->
            <div class="form-group mt-3">
                <div class="form-check form-switch">
                    <input class="form-check-input" type="checkbox" id="pause_calling">
                    <label class="form-check-label" for="pause_calling">Pause Calling</label>
                </div>
            </div>

            <!-- Buttons -->
<div class="d-flex mt-4">
    <button type="button" name="submit" id="redial" 
        class="btn btn-success me-2" disabled>
        Redial
    </button>
    <button type="button" name="submit" id="save-disposition" 
        class="btn btn-danger" disabled>
        Save
    </button>
</div>


        </div>
    </div>
</div>

<script>
document.addEventListener("DOMContentLoaded", function(){
    const radios = document.querySelectorAll(".disposition-radio");
    const callbackSection = document.getElementById("callback-section");

    radios.forEach(radio => {
        radio.addEventListener("change", function(){
            let selectedValue = this.value.toLowerCase().trim();

           
            selectedValue = selectedValue.replace(/\s+/g, "");

            if(selectedValue.includes("callback")) {   
                callbackSection.style.display = "flex"; 
            } else {
                callbackSection.style.display = "none";
            }
        });
    });
});



</script>



<style>
#dispositionOffcanvas {
    width: 280px;   
    padding: 12px;
}

#dispositionOffcanvas .offcanvas-header {
    border-bottom: 1px solid #ddd; 
    padding-bottom: 8px;
    margin-bottom: 10px;
}

#dispositionOffcanvas .form-check {
    display: flex;
    align-items: center;
    margin-bottom: 8px;
    padding-left: 0 !important;  
}

#dispositionOffcanvas .form-check-input {
    margin-left: 0 !important;   
    margin-right: 6px;
}

#dispositionOffcanvas .form-check-label {
    margin-left: 0 !important;
}


#dispositionOffcanvas input[type="text"],
#dispositionOffcanvas input[type="date"],
#dispositionOffcanvas input[type="datetime-local"],
#dispositionOffcanvas textarea {
    width: 100% !important;
    display: block;
    margin-bottom: 10px;
}

#dispositionOffcanvas .d-flex {
    display: flex;
    width: 100%;      
    gap: 10px;          
}


#dispositionOffcanvas .d-flex button {
    flex: 1;           
    width: 100%;        
}


.showDiv.full-width {
    width: 110%; 
    margin: 0 auto;
    transition: width 0.4s ease;
    background: #fff;
    border-radius: 8px; 
    box-shadow: 0 4px 10px rgba(0, 0, 0, 0.08);
    overflow: hidden;
    padding: 15px;
}

.showDiv.half-width {
    width: 58%;
    margin: 0 auto;
}


.leadBoxUser {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    font-family: 'Poppins', sans-serif;
    font-size: 14px;
    border-top: 1px solid #ddd;
    background: #fff;
}

/* Each row (item) */
.leadBoxUser .item {
    padding: 10px 15px;
    display: flex;
    flex-direction: column; 
    border-bottom: 1px solid #f0f0f0; 
}

/* Label styling */
.leadBoxUser .label {
    font-weight: 600;
    color: #666; 
    font-size: 12px;
    text-transform: uppercase;
    margin-bottom: 4px;
    letter-spacing: 0.5px;
}

/* Value styling */
.leadBoxUser .value {
    color: #666; 
    font-weight: 500;
    font-size: 14px;
    word-break: break-word;
}

.leadBoxUser .value,
.leadBoxUser td {
    text-transform: none !important; 

}


.leadBoxUser .value,
.leadBoxUser td {
    text-transform: lowercase !important;
}


.leadBoxUser .value::first-letter,
.leadBoxUser td::first-letter {
    text-transform: uppercase;
}


/* Responsive */
@media (max-width: 992px) {
    .leadBoxUser {
        grid-template-columns: repeat(2, 1fr);
    }
}
.leadBoxUser {
    width: 100%;
    border-collapse: collapse; 
    font-family: 'Poppins', sans-serif;
    font-size: 14px;
    background: #fff;
}



.leadBoxUser th {
    font-weight: 600;
    color: #444;
    text-transform: uppercase;
    font-size: 12px;
    letter-spacing: 0.5px;
    padding: 8px 12px;
    text-align: left;
    white-space: nowrap;
    font-family: 'Poppins', sans-serif;
}


.leadBoxUser th::before {
    content: "•";
    color: #003366; 
    font-size: 16px;
    display: inline-block;
    margin-right: 6px; 
    vertical-align: middle; 
}



/* Value cell */
.leadBoxUser td {
    color: #1a4ed8; 
    font-weight: 500;
    font-size: 14px;
    padding: 8px 12px;
    word-break: break-word;
}

.leadBoxUser tr {
    border-bottom: 1px solid #e0e0e0;
}


@media (max-width: 768px) {
    .leadBoxUser, 
    .leadBoxUser tr, 
    .leadBoxUser th, 
    .leadBoxUser td {
        display: block;
        width: 100%;
    }
    .leadBoxUser th {
        margin-bottom: 2px;
    }
}




</style>



</div>

    <!-- Other Tabs -->
    <div class="tab-pane" id="agent" role="tabpanel">Agent Script</div>
    <div class="tab-pane" id="comments" role="tabpanel">@include('sms.notes')</div>
    <div class="tab-pane" id="events" role="tabpanel">Events</div>
</div>


     
<style>
#modal-right .form .row,
#modal-right .form .form-group {
    display: block !important;
    width: 100% !important;
    max-width: 100%;
    margin: 0 0 15px 0; 
    padding: 0;
}


#modal-right .form .input-group,
#modal-right .form input,
#modal-right .form select,
#modal-right .form textarea {
    width: 100% !important;
    border-radius: 6px;
}

/* Label styling */
#modal-right .form .form-label {
    display: block;
    margin-bottom: 6px;
    font-size: 14px;
    font-weight: 500;
}

/* Character count styling */
#modal-right .count_sms_len {
    text-align: right;
    font-size: 12px;
    margin-bottom: 10px;
}

/* File input preview adjustments */
#modal-right #previewVideo,
#modal-right #previewImage,
#modal-right #previewPDF {
    display: block;
    margin-top: 10px;
    max-width: 100%;
}


#modal-right .input-group {
    position: relative;
}


#modal-right .input-group-text {
    background: transparent;
    border: none;
    position: absolute;
    left: 12px;
    top: 50%;
    transform: translateY(-50%);
    z-index: 2;
    padding: 0;
}


#modal-right .input-group-text i {
    font-size: 16px;
    color: #666;
}


#modal-right .input-group input,
#modal-right .input-group select,
#modal-right .input-group textarea {
    padding-left: 40px !important;
}


</style>
                      

<div class="offcanvas offcanvas-end" tabindex="-1" id="modal-right" aria-labelledby="modalRightLabel">
  <div class="offcanvas-header">
    <h5 id="modalRightLabel">SMS</h5>
    <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
  </div>
  <div class="offcanvas-body">
    @include('sms.send_message_tab')
  </div>
</div>


<!-- Email Offcanvas -->
<div class="offcanvas offcanvas-end" tabindex="-1" id="modal-email" aria-labelledby="modalEmailLabel">
  <div class="offcanvas-header">
    <h5 id="modalEmailLabel">Email</h5>
    <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
  </div>
  <div class="offcanvas-body">
    @include('sms.send_mail_tab')
  </div>
</div>

<!-- Custom CSS -->
<style>
.offcanvas-header {
    border-bottom: 1px solid #ddd; 
    padding: 0.4rem 0.75rem;  
    margin-bottom: 8px;        
    height: auto;

    display: flex;
    justify-content: space-between; 
    align-items: center;           
}

.offcanvas-header h5, 
.offcanvas-header .offcanvas-title {
    margin: 0;
    font-size: 1.15rem;   
    font-weight: 400;   
    line-height: 1.3;     
    padding-top: 3px;   
}



/* cross button */
.offcanvas-header .btn-close {
    width: 1.6rem;
    height: 1.6rem;
    margin: 0; 

    background-color: #007bff;
    border-radius: 4px;
    opacity: 1;

    background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' fill='%23ffffff' viewBox='0 0 16 16'%3E%3Cpath d='M2.146 2.146a.5.5 0 0 1 .708 0L8 7.293l5.146-5.147a.5.5 0 1 1 .708.708L8.707 8l5.147 5.146a.5.5 0 0 1-.708.708L8 8.707l-5.146 5.147a.5.5 0 0 1-.708-.708L7.293 8 2.146 2.854a.5.5 0 0 1 0-.708z'/%3E%3C/svg%3E");
    background-repeat: no-repeat;
    background-position: center;
    background-size: 1rem;
}

/* hover effect */
.offcanvas-header .btn-close:hover {
    background-color: #0056b3;
}

#modal-right .offcanvas-body {
    padding-top: 5px !important;  /* default 1rem hoti hai */
}




/* Offcanvas width */
#modal-email {
    width: auto !important;
    max-width: 700px;
    overflow-x: hidden;
}

/* Form container */
.sendMailModel form {
    display: flex;
    flex-direction: column;
    gap: 5px; 
}

/* Flex rows */
.flex-row {
    display: flex;
    gap: 8px; 
    flex-wrap: wrap;
    box-sizing: border-box;
    margin-bottom: 3px; 
}

/* Row 1: To + From */
.flex-row.row-1 .form-group {
    flex: 1 1 48%;
    min-width: 0;
}
.flex-row.row-1 {
    margin-top: -10px;
}

/* Row 2: 3 placeholders */
.flex-row.row-2 .form-group {
    flex: 1 1 32%;
    min-width: 0;
}

/* Row 3: Subject full width */
.flex-row.row-3 .form-group {
    flex: 1 1 100%;
    min-width: 0;
}

/* Row 4: Editor full width */
.flex-row.row-4 .form-group {
    flex: 1 1 100%;
    min-width: 0;
}

/* Input group and icons inside input */
.sendMailModel .form-group .input-group {
    display: flex;
    width: 100%;
    align-items: center;
    box-sizing: border-box;
    margin-bottom: 3px !important;
}

.sendMailModel .form-group input,
.sendMailModel .form-group select,
.sendMailModel .form-group textarea {
    flex: 1 1 auto;
    min-width: 0;
}

/* Slightly smaller than input box */
.sendMailModel .form-group .input-group-text {
    height: 32px; 
    min-height: 32px;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 0 8px;
    box-sizing: border-box;
    font-size: 15px;
}

/* Label adjustment */
.sendMailModel .form-group label {
    margin-bottom: 2px !important; 
    font-size: 13px;
    font-weight: 500;
}

/* Buttons */
.text-end {
    width: 100%;
    text-align: right;
    margin-top: 5px;
}

/* Responsive */
@media (max-width: 768px) {
    .flex-row.row-1 .form-group,
    .flex-row.row-2 .form-group {
        flex: 1 1 100%;
    }
    #modal-email {
        width: 95% !important;
    }
}


</style>


                        </div>
                    </div>

                   
                @endif

                @endif



<style>
.dialpad-card {
    border-radius: 20px;
    box-shadow: 0px 8px 25px rgba(0,0,0,0.15);
    border: none;
    background: white;
    font-family: 'Exo', sans-serif;
    max-width: 280px;
    margin: auto;
    overflow: hidden;
}

.dialpad-header {
    background: linear-gradient(135deg, #007bff, #0056b3);
    color: white;
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 10px 12px;
}

.dialpad-header .title {
    font-size: 16px;
    font-weight: bold;
}

.close-btn {
    background: transparent;
    border: none;
    color: white;
    font-size: 22px;
    cursor: pointer;
    line-height: 1;
}

.dialpad-display {
    background: #f8f9fa;
    border-radius: 12px;
    margin: 10px;
    padding: 8px;
    text-align: center;
    font-size: 20px;
    font-weight: bold;
    min-height: 38px;
    box-shadow: inset 0 2px 4px rgba(0,0,0,0.05);
}

/* Compact number buttons layout */
.dialpad-grid {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 10px;
    padding: 0 20px 15px 20px;
}

.digit {
    background: white;
    border-radius: 50%;
    height: 55px;
    width: 55px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 22px;
    font-weight: bold;
    color: #333;
    box-shadow: 0px 3px 8px rgba(0,0,0,0.08);
    cursor: pointer;
    transition: all 0.15s ease-in-out;
    margin: auto;
}

.digit:hover {
    background: #007bff;
    color: white;
    transform: scale(1.05);
}

/* Call & Back buttons compact */
.dialpad-actions {
    display: flex;
    justify-content: space-around;
    align-items: center;
    margin-bottom: 15px;
}

.call-btn, .back-btn {
    display: flex;
    align-items: center;
    justify-content: center;
    height: 45px;
    width: 45px;
    border-radius: 50%;
    font-size: 18px;
    color: white;
    cursor: pointer;
    box-shadow: 0px 3px 8px rgba(0,0,0,0.15);
}

.call-btn {
    background: #28a745;
}

.back-btn {
    background: #6c757d;
}

</style>

<div class="modal fade" id="dialPadModal" role="dialog">
    <div class="modal-dialog modal-xs">
        <link href="https://fonts.googleapis.com/css?family=Exo" rel="stylesheet">
        <link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.6.3/css/font-awesome.min.css" rel="stylesheet">

        <div class="modal-content dialpad-card">
            <div class="dialpad-header">
                <span class="title">Dialpad</span>
                <button type="button" class="close-btn" data-bs-dismiss="modal">&times;</button>
            </div>

            <div class="dialpad-display" id="output"></div>

            <div class="dialpad-grid">
                <div class="digit">1</div>
                <div class="digit">2</div>
                <div class="digit">3</div>
                <div class="digit">4</div>
                <div class="digit">5</div>
                <div class="digit">6</div>
                <div class="digit">7</div>
                <div class="digit">8</div>
                <div class="digit">9</div>
                <div class="digit">*</div>
                <div class="digit">0</div>
                <div class="digit">#</div>
            </div>

            <!-- <div class="dialpad-actions">
                <div class="call-btn"><i class="fa fa-phone"></i></div>
                <div class="back-btn"><i class="fa fa-long-arrow-left"></i></div>
            </div> -->
        </div>
    </div>
</div>


                      
                        </div>

                    </div>
                </div>
            </div><!-- /.row -->

          







            <div class="modal fade" id="sendtocrmselection" role="dialog">
                <div class="modal-dialog modal-xs">
                    

                        <div class="modal-content">
                        <div class="box-body">
                            <div class="modal-header">
                                <h4> Click Url to Send to CRM<button style="padding: 5px 9px 5px 9px;margin: -25px 400px;" type="button" class="btn btn-danger float-end" data-bs-dismiss="modal">X</button></h4>
                            </div>

                            <div class="modal-body">
                                <p>Please click to url which u want to send to crm<b><i class="title"></i></b></p>
                                <div id="showUrls" style="color:white;"></div>
                            </div>
                        </div>
                    </div>
                    </div>
                </div>
            @include('sms.send_message')
            @push('scripts')
                <script>
                    var base_url = "<?php echo URL::to('/'); ?>";
                </script>
                <script type="text/javascript" src="{{ URL::asset ('asset/js/send_sms_component.js') }}"></script>
            @endpush



            <div id="myModalsss" class="modal fade in" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg"style="width:1200px;">
                    <div class="modal-content">
                        <div class="box-body">
                            <div class="modal-header">
                                <h4> Warning Header<button style="padding: 5px 11px 5px 11px;margin: 0px 675px;" type="button" class="btn btn-danger float-end" data-bs-dismiss="modal">X</button></h4>
                            </div>

                            <div class="modal-body">
                                <p>You have not recorded voicemail drop message for your extension. Please call *88 from your extension to record your personalized voicemail drop message and relogin.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div id="myModal" class="modal fade in" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg"style="width:1200px;">
                    <div class="modal-content">
                        <div class="box-body">
                            <div class="modal-header">
                                <h4> Warning Header<button style="padding: 5px 11px 5px 11px;margin: 0px 675px;" type="button" class="btn btn-danger float-end" data-bs-dismiss="modal">X</button></h4>
                            </div>

                            <div class="modal-body">
                                <p>You have not recorded voicemail drop message for your extension. Please call *88 from your extension to record your personalized voicemail drop message and relogin.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </section>
 

    <!-- /.content-wrapper -->
@endsection
@push('styles')
    <style>
        /*Custom CSS*/
        .save-disposition-block {
            display: inline-block;
            margin: 15px 0px 10px 30px;
        }

        .start-dial-btn {
            display: flex;
            margin: 15px 0px;
        }

        .disposition .start-dial-btn .btn {
            margin-left: 20px;
        }

        .disposition {
            display: none;
        }

        .disposition .box-body .col-md-12 {
            padding-left: 0px;
        }

        #dialPadModal .modal-content {
            width: 330px;
        }

        #dialPadModal .modal-header,
        #dialPadModal .modal-footer {
            text-align: center;
            border: none;
        }

        .dialer .fa-phone {
            cursor: pointer;
        }

        .p-r-0 {
            padding-right: 0 !important;
        }

        .save-disposition-block .btn {
            margin-left: 30px;
        }

        #detail-message {
            display: block;
            width: 100%;
            padding: 5px;
            font-size: 120%;
        }

        .callback-dis {
            xwidth: 90px;
            padding-right: 0px;
        }

        .dpicker {
            position: relative;
            left: 132px;
            height: 40px;
        }

        .dpicker input[type="text"] {
            position: relative;
            bottom: 42px;
            height: 40px;
            width: 155px;
        }
        .datepicker.datepicker-inline{
            display:none !important;
        }
        .disposition span {
            margin-left: 5px;
            position: relative;
            bottom: 2px;
        }

        .bootstrap-datetimepicker-widget.dropdown-menu {
            display: none;
            background-color: #eee;
            width: 200px;
        }

        .start-dial-action-btn {
            width: auto;
            padding: 0 10px;
        }

        #start_dialing {
            margin-left: 15px;
        }

        .bold {
            font-weight: bold;
        }

        .mr-l {
            margin-right: 1% !important;
        }

        .mr-6 {
            margin-right: 6% !important;
        }

        .bg-yellow, .callout.callout-warning {
            background-color: #293f51 !important;
        }

        .webrtc-setup label{
            float: right;
        }

        @if( !empty($campaignDetail) && ($campaignDetail['dial_mode']=='predictive_dial'|| $campaignDetail['dial_mode']=='super_power_dial')) #call-btn {
            display: none;
        }

        .disposition-label {
            width: 100%;
            height: 100%;
            padding: 10px 15px;
            margin-bottom: 0px;
        }

        .lead-save-status {
            font-size: 120%;
        }
        @endif
    </style>
    <link rel="stylesheet" type="text/css" media="screen" href="{{ asset('asset/plugins/bootstrap-datetimepicker/css/bootstrap-datetimepicker.min.css') }}">
@endpush
@push('scripts')
    <script src="{{ asset('asset/plugins/bootstrap-datetimepicker/js/bootstrap-datetimepicker.min.js') }}"></script>
    <script src="https://cdn.ckeditor.com/4.22.1/standard/ckeditor.js"></script>


<!-- call transfer -->

@if(!empty($campaignDetail))

    <script>


           $("#leave_conference").click(function(){
            var leadId = $("#lead_id").val();

            var customer_phone_number = $('#lead-detail').attr('data-number');

            campaign_id = {{ $campaignDetail['id'] }};


           
                var alt_extension_call_transfer = $("#alt_extension_call_transfer").val();
               

                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },

                    type: 'POST',
                    url: 'leave-conference',
                    dataType: "json",
                    data: {
                        lead_id: leadId,
                        forward_extension: alt_extension_call_transfer,
                        customer_phone_number: customer_phone_number,
                        campaign_id: {{ $campaignDetail['id'] }},
                    },

                    success: function (response) {
                        console.log(response);
                        $(".call_transfer_message").show();
                        $("#checkResponce").hide();
                        if (response.status) {
                            $(".call_transfer_message").html("<div class='alert-success' style='padding: 5px 25px;'>" + response.message + "</div>");
                            $("#connecting_transfer_call").hide();
                             $('#myModal_open_call').modal('hide');
                             $('#leave_conference').modal('hide');

                            //checkExtensionLiveForAgentB(alt_extension_call_transfer,campaign_id);

                            /*setInterval(function () {
                                
                            }, 1000);*/
                        } else {
                            $(".call_transfer_message").html("<div class='alert-danger' style='padding: 5px 25px;'>" + response.message + "</div>");
                        }
                        setTimeout(function () {
                            $(".call_transfer_message").hide();
                        }, 3000);
                    }
                });

                });

        $("#connecting_transfer_call").click(function(){
            var call_transfer_type =  $('input[name="call_transfer"]:checked').val();
            var leadId = $("#lead_id").val();

            var customer_phone_number = $('#lead-detail').attr('data-number');

            campaign_id = {{ $campaignDetail['id'] }};

              var call_transfer = $(".call_transfer").val();

            if(call_transfer_type == 'extension')
            {
                var alt_extension_call_transfer = $("#alt_extension_call_transfer").val();
                if(alt_extension_call_transfer == '')
                {
                    $(".call_transfer_message").show();

                    $(".call_transfer_message").html("<div class='alert-danger' style='padding: 5px 25px;'>Please select any one extension from drop down</div>");
                    setTimeout(function () {
                            $(".call_transfer_message").hide();
                        }, 3000);
                    return false;
                }

                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },

                    type: 'POST',
                    url: 'merge-call-with-transfer',
                    dataType: "json",
                    data: {
                        lead_id: leadId,
                        forward_extension: alt_extension_call_transfer,
                        customer_phone_number: customer_phone_number,
                        campaign_id: {{ $campaignDetail['id'] }},
                        call_transfer:call_transfer_type
                    },

                    success: function (response) {
                        console.log(response);
                        $(".call_transfer_message").show();
                        $("#checkResponce").hide();
                        if (response.status) {
                            $(".call_transfer_message").html("<div class='alert-success' style='padding: 5px 25px;'>" + response.message + "</div>");
                            $("#connecting_transfer_call").hide();
                            $("#leave_conference").show();

                            //checkExtensionLiveForAgentB(alt_extension_call_transfer,campaign_id);

                            /*setInterval(function () {
                                
                            }, 1000);*/
                        } else {
                            $(".call_transfer_message").html("<div class='alert-danger' style='padding: 5px 25px;'>" + response.message + "</div>");
                        }
                        setTimeout(function () {
                            $(".call_transfer_message").hide();
                        }, 3000);
                    }
                });
            }

            else
                  if(call_transfer_type == 'did')
            {
                var did_call_transfer = $("#did_call_transfer").val();
                if(did_call_transfer == '')
                {
                    $(".call_transfer_message").show();

                    $(".call_transfer_message").html("<div class='alert-danger' style='padding: 5px 25px;'>Please enter 10 digit mobile number</div>");
                    setTimeout(function () {
                            $(".call_transfer_message").hide();
                        }, 3000);
                    return false;
                }

                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },

                    type: 'POST',
                    url: 'merge-call-with-transfer',
                    dataType: "json",
                    data: {
                        lead_id: leadId,
                        forward_extension: did_call_transfer,
                        customer_phone_number: customer_phone_number,
                        campaign_id: {{ $campaignDetail['id'] }},
                        call_transfer:call_transfer_type
                    },

                    success: function (response) {
                        console.log(response);
                        $(".call_transfer_message").show();
                        $("#checkResponce").hide();
                        if (response.status) {
                            $(".call_transfer_message").html("<div class='alert-success' style='padding: 5px 25px;'>" + response.message + "</div>");
                            $("#connecting_transfer_call").hide();
                            $("#leave_conference").show();

                            //checkExtensionLiveForAgentB(alt_extension_call_transfer,campaign_id);

                            /*setInterval(function () {
                                
                            }, 1000);*/
                        } else {
                            $(".call_transfer_message").html("<div class='alert-danger' style='padding: 5px 25px;'>" + response.message + "</div>");
                        }
                        setTimeout(function () {
                            $(".call_transfer_message").hide();
                        }, 3000);
                    }
                });
            }

                });




$("#warm_transfer_call").click(function(){
    
    var call_transfer_type =  $('input[name="call_transfer"]:checked').val();
    if (!$("input[name='call_transfer']:checked").val()) {
        $(".call_transfer_message").show();
                $(".call_transfer_message").html("<div class='alert-danger' style='padding: 5px 25px;'>Please select any one point</div>");
                setTimeout(function () {
                    $(".call_transfer_message").hide();
                }, 3000);
                return false;
    }
    else {

        //alert('One of the radio buttons is checked!');
        var leadId = $("#lead_id").val();
        var customer_phone_number = $('#lead-detail').attr('data-number');
        var campaign_id = {{ $campaignDetail['id'] }};

        if(call_transfer_type == 'extension')
        {
            var alt_extension_call_transfer = $("#alt_extension_call_transfer").val();

            var alt_extension_call_transfer_name= $('#alt_extension_call_transfer').find(":selected").text();

            if(alt_extension_call_transfer == '')
            {
                $(".call_transfer_message").show();
                $(".call_transfer_message").html("<div class='alert-danger' style='padding: 5px 25px;'>Please select any one extension from drop down</div>");
                setTimeout(function () {
                    $(".call_transfer_message").hide();
                }, 3000);
                return false;
            }
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },

                    type: 'POST',
                    url: 'warm-call-transfer',
                    dataType: "json",
                    data: {
                        lead_id: leadId,
                        forward_extension: alt_extension_call_transfer,
                        ring_group_call_transfer: '',
                        did_call_transfer: '',
                        

                        customer_phone_number: customer_phone_number,
                        campaign_id: {{ $campaignDetail['id'] }},
                        call_transfer:call_transfer_type
                    },

                    success: function (response) {
                        console.log(response);
                        $(".call_transfer_message").show();
                        $("#checkResponce").hide();
                        if (response.status) {
                            $(".call_transfer_message").html("<div class='alert-success' style='padding: 5px 25px;'>" + response.message + "</div>");

                           /*   alert(leadId);
        alert(customer_phone_number);*/

                           checkExtensionLiveForAgentB(alt_extension_call_transfer,campaign_id,alt_extension_call_transfer_name,leadId,customer_phone_number,call_transfer_type);

                            /*setInterval(function () {
                                
                            }, 1000);*/
                        } else {
                            $(".call_transfer_message").html("<div class='alert-danger' style='padding: 5px 25px;'>" + response.message + "</div>");
                        }
                        setTimeout(function () {
                            $(".call_transfer_message").hide();
                        }, 3000);
                    }
                });
            }
            else
            if(call_transfer_type == 'ring_group')
            {
                var ring_group_call_transfer = $("#ring_group_call_transfer").val();
                if(ring_group_call_transfer == '')
                {

                    $(".call_transfer_message").html("<div class='alert-danger' style='padding: 5px 25px;'>Please select any one ring group from drop down</div>");
                    $(".call_transfer_message").show();
                    setTimeout(function () {
                            $(".call_transfer_message").hide();
                        }, 3000);
                    return false;
                }
                //alert(alt_extension_call_transfer);

                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },

                    type: 'POST',
                    url: 'warm-call-transfer',
                    dataType: "json",
                    data: {
                        lead_id: leadId,
                        forward_extension: '',

                        ring_group_call_transfer: ring_group_call_transfer,
                        did_call_transfer: '',

                        customer_phone_number: customer_phone_number,
                        campaign_id: {{ $campaignDetail['id'] }},
                        call_transfer:call_transfer_type
                    },

                    success: function (response) {
                        console.log(response);
                        $("#checkResponce").hide();
                        if (response.status) {
                            $(".call_transfer_message").html("<div class='alert-success' style='padding: 5px 25px;'>" + response.message + "</div>");
                        $(".call_transfer_message").show();
                        } else {
                            $(".call_transfer_message").html("<div class='alert-danger' style='padding: 5px 25px;'>" + response.message + "</div>");
                        $(".call_transfer_message").show();
                            
                        }
                        setTimeout(function () {
                            $(".call_transfer_message").hide();
                        }, 3000);
                    }
                });
            }

            else
                if(call_transfer_type == 'did')
            {
                var did_call_transfer = $("#did_call_transfer").val();
                if(did_call_transfer == '')
                {
                    $(".call_transfer_message").show();

                    $(".call_transfer_message").html("<div class='alert-danger' style='padding: 5px 25px;'>Please enter 10 digit mobile number</div>");
                    setTimeout(function () {
                            $(".call_transfer_message").hide();
                        }, 3000);
                    return false;
                }
                //alert(alt_extension_call_transfer);

                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },

                    type: 'POST',
                    url: 'warm-call-transfer',
                    dataType: "json",
                    data: {
                        lead_id: leadId,
                        forward_extension: '',

                        ring_group_call_transfer: "",
                        did_call_transfer: did_call_transfer,

                        customer_phone_number: customer_phone_number,
                        campaign_id: {{ $campaignDetail['id'] }},
                        call_transfer:call_transfer_type
                    },

                    success: function (response) {
                        console.log(response);
                        $(".call_transfer_message").show();
                        $("#checkResponce").hide();
                        if (response.status) {
                            $(".call_transfer_message").html("<div class='alert-success' style='padding: 5px 25px;'>" + response.message + "</div>");

                             checkExtensionLiveForAgentB(did_call_transfer,campaign_id,'',leadId,customer_phone_number,call_transfer_type);

                        } else {
                            $(".call_transfer_message").html("<div class='alert-danger' style='padding: 5px 25px;'>" + response.message + "</div>");
                        }
                        setTimeout(function () {
                            $(".call_transfer_message").hide();
                        }, 3000);
                    }
                });
            }
        }

    });


    function checkExtensionLiveForAgentB(alt_extension_call_transfer,campaign_id,alt_extension_call_transfer_name,leadId,customer_phone_number,call_transfer_type)
    {
       // alert(leadId);
        //alert(customer_phone_number);

        //alert(alt_extension_call_transfer,campaign_id);

         $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },

                    type: 'POST',
                    url: 'check-extension-live',
                    dataType: "json",
                    data: {
                        campaign_id: campaign_id,
                        forward_extension: alt_extension_call_transfer,
                        lead_id:leadId,
                        customer_phone_number:customer_phone_number,
                        call_transfer_type:call_transfer_type

                        
                    },

                    success: function (response) {
                        console.log(response);
                        $(".call_transfer_message").show();
                        $("#checkResponce").hide();
                        if (response.status) {
                            $(".call_transfer_message").html("<div class='alert-success' style='padding: 5px 25px;'>Call connected to " +alt_extension_call_transfer_name +"</div>");

                           // $(".call_transfer_message").html("<div class='alert-success' style='padding: 5px 25px;'>" + response.message + "</div>");
                            $("#warm_transfer_call").hide();
                            $("#connecting_transfer_call").show();

                        } else {

                            checkExtensionLiveForAgentB(alt_extension_call_transfer,campaign_id,alt_extension_call_transfer_name,leadId,customer_phone_number,call_transfer_type);
                           // alert("loop");
                            //$(".call_transfer_message").html("<div class='alert-danger' style='padding: 5px 25px;'>" + response.message + "</div>");
                            $(".call_transfer_message").html("<div class='alert-danger' style='padding: 5px 25px;'>Please wait connecting to "+alt_extension_call_transfer_name +"</div>");

                        }
                      /*  setTimeout(function () {
                            $(".call_transfer_message").hide();
                        }, 3000);*/
                    }
                });
      
    }
</script>

@endif

<!--end call transfer -->

   

    <script type="text/javascript">

        $('#notes').click(function () {

            var leadId = $("#lead_id").val();


            postData = {
                "_token": $("#csrf-token").val(),
            };
            console.log(postData);

            $.ajax({
                type: "POST",
                url: "/notes/" + leadId,
                data: postData,
                dataType: "json",
                success: function (data) {
                    if (data.success) {

                leadBoxData="";
                        $("#multiple_notes").html(leadBoxData);


                        $.each(data.data, function (key, entry) {

                             leadBoxData += '<div class="media"><a class="avatar" href="#"><img src="{{asset("assets/images/avatar/6.jpg")}}" alt="..."></a><div class="media-body"><p><a href="#"><strong>'+entry.first_name+' '+entry.last_name+'</strong></a><time class="float-end text-fade" datetime="'+entry.created_at+'">'+entry.created_at+'</time></p><p>'+entry.comment+'</p></div></div>';
                        })
                        
                        $("#multiple_notes").html(leadBoxData);
                        
                    } else {

                        $("#" + input.name + "-save-status").addClass('text-danger').removeClass('text-success').html("<i class='icon fa fa-close'></i> ");
                    }
                }
                
            });



            $('#sendNotesModel').show();


        });

        function ShowSmsPopUp() {

            $('#preview_sms_id').val("");
            $("#sms_template_list").prop('selectedIndex','');
            let cont_number_sms = $(this).attr('data-contact');
            $('#send_phone').val(cont_number_sms)

            var popup = $("#popup_value").val();

            $("#send_phone").val(popup);

            $('#myModal_open').modal('show');
        }

        function ShowSmsPopUpCallBack() {

            $(".notes_callback").show();

            /*$('#preview_sms_id').val("");
            $("#sms_template_list").prop('selectedIndex','');
            let cont_number_sms = $(this).attr('data-contact');
            $('#send_phone').val(cont_number_sms)

            var popup = $("#popup_value").val();

            $("#send_phone").val(popup);

            $('#myModal_open_callback').modal('show');*/
        }

@if(!empty($campaignDetail))


        function openCallTransfer()
        {
            $("#warm_transfer_call").show();
            $("#alt_extension_call_transfer").val('');
            $("#did_call_transfer").val('');

            

            var leadId = $("#lead_id").val();
            //alert(leadId);

            var customer_phone_number = $('#lead-detail').attr('data-number');
          //alert(customer_phone_number);

            campaign_id = {{ $campaignDetail['id'] }};
           //alert(campaign_id);

            var alt_extension='<?php echo Session::get('private_identity');?>';
           //alert(alt_extension);

           var call_transfer = $(".call_transfer").val();


             $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },

                    type: 'POST',
                    url: 'check-line-details',
                    dataType: "json",
                    data: {
                        lead_id: leadId,
                        alt_extension: alt_extension,
                        customer_phone_number: customer_phone_number,
                        campaign_id: campaign_id,
                        call_transfer:call_transfer
                    },

                    success: function (response) {
                        console.log(response);
                        //$(".call_transfer_message").show();
                        $("#checkResponce").hide();
                        if (response.status) {
                            //$(".call_transfer_message").html("<div class='alert-success' style='padding: 5px 25px;'>" + response.message + "</div>");
                             $('#myModal_open_call').modal('show');
                             $("#warm_call_show").show();
                            $(".call_transfer_message").hide();

                         } else {
                            $(".call_transfer_message").show();

                            $(".call_transfer_message").html("<div class='alert-danger' style='padding: 5px 25px;'>" + response.message + "</div>");
                            $("#warm_call_show").hide();
                            
                             $('#myModal_open_call').modal('show');
                             setTimeout(function () {
                            $(".call_transfer_message").hide();
                             $('#myModal_open_call').modal('hide');

                        }, 3000);
                        }
                        setTimeout(function () {
                            $(".call_transfer_message").hide();
                        }, 3000);
                    }
                });





        }
        @endif

        function ShowSmsPopUpTab() {

            $('#preview_sms_id').val("");
            $("#sms_template_list_tab").prop('selectedIndex','');
            let cont_number_sms = $(this).attr('data-contact');
            alert(cont_number_sms);
            $('#send_phone_tab').val(cont_number_sms)

            var popup = $("#popup_value").val();

            $("#send_phone_tab").val(popup);

            //$('#myModal_open').modal('show');
        }
        
    
    </script>

    <script language="javascript">
        $(function () {
            CKEDITOR.config.autoParagraph = false;
            CKEDITOR.config.versionCheck = false;
            CKEDITOR.config.width = 1000;

            CKEDITOR.config.enterMode = CKEDITOR.ENTER_BR;
            CKEDITOR.config.shiftEnterMode = CKEDITOR.ENTER_P;
            CKEDITOR.replace('editor1', {
                enterMode: CKEDITOR.ENTER_BR,
                filebrowserUploadUrl: "{{route('start-dialing.upload', ['_token' => csrf_token() ])}}",
                filebrowserUploadMethod: 'form',
                allowedContent: true
                
            });

            CKEDITOR.instances['editor1'].on('contentDom', function () {
                this.document.on('click', function (event) {
                    console.log('abh');
                    $('#setBoxValue').html('');
                });
            });

            $("#multiple_labels").on('change', function () {
                //console.log($(this).val());
                var label_name = $(this).val();
                var lead_id = $("#lead_id").val();
                var list_id = $("#list_id").val();


                $.ajax({
                    url: 'getLabelValue/' + label_name + '/' + list_id + '/' + lead_id,
                    type: 'get',
                    success: function (response) {

                        //console.log($(this).val());
                        var hidden_box = $('#setBoxValue').html();
                        if (hidden_box == 'subject_box')
                        {
                            var cursorPos = $('#subject').prop('selectionStart');
                            var v = $('#subject').val();
                            console.log(v);

                            var textBefore = v.substring(0, cursorPos);
                            var textAfter = v.substring(cursorPos, v.length);
                            $('#subject').val(textBefore + response + textAfter);
                        }
                        else
                        {
                            for (var i in CKEDITOR.instances) {

                                console.log(response);
                                CKEDITOR.instances[i].insertHtml(response);
                            }
                        }
                    }
                });
            });

            $("#multiple_names").on('change', function () {
                console.log($(this).val());
                var sender_id = $(this).val();
                $.ajax({
                    url: 'getSenderValue/' + sender_id,
                    type: 'get',
                    success: function (response) {
                        var hidden_box = $('#setBoxValue').html();
                        if (hidden_box == 'subject_box')
                        {
                            var cursorPos = $('#subject').prop('selectionStart');
                            var v = $('#subject').val();
                            console.log(v);

                            var textBefore = v.substring(0, cursorPos);
                            var textAfter = v.substring(cursorPos, v.length);
                            $('#subject').val(textBefore + response + textAfter);
                        }
                        else
                        {
                            for (var i in CKEDITOR.instances) {
                                CKEDITOR.instances[i].insertHtml(response);
                            }
                        }
                    }
                });
            });

            $("#multiple_custom_names").on('change', function () {
                console.log($(this).val());
                var custom_id = $(this).val();
               $.ajax({
                    url: 'getCustomFieldValue/' + custom_id,
                    type: 'get',
                    success: function (response) {
                        var hidden_box = $('#setBoxValue').html();
                        if (hidden_box == 'subject_box')
                        {
                            var cursorPos = $('#subject').prop('selectionStart');
                            var v = $('#subject').val();
                            console.log(v);

                            var textBefore = v.substring(0, cursorPos);
                            var textAfter = v.substring(cursorPos, v.length);
                            $('#subject').val(textBefore + response + textAfter);
                        }
                        else
                        {
                            for (var i in CKEDITOR.instances) {
                                CKEDITOR.instances[i].insertHtml(response);
                            }
                        }
                    }
                });
            });

            $("#templates").on('change', function () {
                console.log("Template change called");
                var output = '';
                CKEDITOR.instances['editor1'].setData(output);

                var template_id = this.value;
                var lead_id = $("#lead_id").val();
                var list_id = $("#list_id").val();

                $.ajax({
                    url: 'getTemplate/' + template_id + '/' + list_id + '/' + lead_id,
                    type: 'get',
                    success: function(response){
                        $("#subject").val(response['subject']);
                        for (var i in CKEDITOR.instances) {
                            CKEDITOR.instances[i].insertHtml(response['template_html']);
                            var editor = CKEDITOR.instances[i];
                            editor.on('contentDom', function () {
                                var editable = editor.editable();
                                editable.attachListener(editable, 'click', function () {
                                    console.log("click event");
                                    $('#setBoxValue').html('');
                                });
                            });
                        }
                    }
                });
            });

            $('#subject').on('click', function () {
                $('#setBoxValue').html('subject_box');
            });
        });

        @if(!empty($campaignDetail))

        $('#btn_send_email').click(function () {
            var lead_id = $(this).attr('data-leadid');
            var list_id = $(this).attr('data-listid');
            var toEmailId = $("#toEmailId").val();

            $("#lead_id").val(lead_id);
            $("#list_id").val(list_id);
            $("#responseMessage").html('');

            //Rest the template selection
            $('#templates option[value=""]').attr('selected','selected');
            $('#subject').val('');
            $('#multiple_labels').val('');
            $('#multiple_names').val('');
            $('#multiple_custom_names').val('');
            CKEDITOR.instances['editor1'].setData('');

            console.log("btn_send_email: " + toEmailId);
            $.ajax({
                headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
                url: '/openMailModal',
                type: 'post',
                data: {
                    lead_id: lead_id,
                    smtpType: {{ intval($campaignDetail['email']) }},
                    campaign_id: {{ $campaignDetail['id'] }},
                    list_id: list_id,
                    toEmailId: toEmailId
                },
                success: function (response) {

                    templates_line = "<option value=''>Compose New</option>";
                    for (var i = 0; i < response['email_templates'].length; i++) {
                        if(response['email_templates'][i]['status'] == 1)
                        {
                            var email_template = response['email_templates'][i];
                            //alert(email_template);
                            templates_line += "<option value='" + response['email_templates'][i]['id'] + "'>";
                            templates_line += response['email_templates'][i]['template_name'];
                            templates_line += "</option>";
                            
                        }

                    }

                    @if($campaignDetail['email'] == 1)
                        $("#fromEmail").val("{{ session("emailId") }}");
                    @else
                        $("#fromEmail").val(response['smtpSetting']['from_email']);
                    @endif

                    $('#templates').html(templates_line);
                    label_line = "<option value=''>Select to Insert</option>";
                    for (var i = 0; i < response['labels'].length; i++) {
                        var labels = response['labels'][i];
                        label_line += "<option value='" + response['labels'][i]['id'] + "'>";
                        //label_line += "<option value='[["+response['labels'][i]['title']+"]]'>";
                        label_line += response['labels'][i]['title'];
                        label_line += "</option>";
                    }

                    $('#multiple_labels').html(label_line);
                    user_line = "<option value=''>Select to Insert</option>";
                    for (var i = 0; i < response['user_column'].length; i++) {
                        var user_column = response['user_column'][i];
                        //alert(user_column);
                        user_line += "<option value='[[" + user_column + "]]'>";
                        user_line += user_column;
                        user_line += "</option>";
                    }
                    $('#multiple_names').html(user_line);
                    custom_label_labels = "<option value=''>Select to Insert</option>";
                    for (var i = 0; i < response['custom_label_labels'].length; i++) {
                        var custom_field_values = response['custom_label_labels'][i];
                        custom_label_labels += "<option value='" + response['custom_label_labels'][i]['id'] + "'>";
                        custom_label_labels += response['custom_label_labels'][i]['title'];
                        custom_label_labels += "</option>";
                    }
                    $('#multiple_custom_names').html(custom_label_labels);
                    //window.location.reload(1);
                },
                error: function (xhr, status, error) {
                    $("#responseMessage").html('<p style="font-size: 14px;font-weight: 500;background: red;padding: 0px 0px 0px 10px;color: white;" id="alert-errors">'+xhr.responseText+'</p>');
                }
            });
            $('#sendMailModel').show();
        });

        $('#send-email').bind('click', function (event) {
            event.preventDefault();
            from = $("#fromEmail").val();
            if (from == '' || from == undefined) {
                $('#from').css('border', '1px solid red');
                $("#from").focus();
                return false;
            }
            to = $("#toEmailId").val();
            if (to == '' || to == undefined) {
                $('#to').css('border', '1px solid red');
                $("#to").focus();
                return false;
            }
            subject = $("#subject").val();
            if (subject == '' || subject == undefined) {
                $('#subject').css('border', '1px solid red');
                $("#subject").focus();
                return false;
            }
            message = CKEDITOR.instances['editor1'].getData();

            if (message == '' || message == undefined) {
                $('#message').css('border', '1px solid red');
                $("#message").focus();
                return false;
            }

            $("#checkResponce").show();

            $.ajax({
                headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
                type: 'POST',
                url: 'send-email/generic',
                dataType: "json",
                data: {
                    from: from,
                    to: to,
                    subject: subject,
                    message: message,
                    smtpType: {{ intval($campaignDetail['email']) }},
                    campaign_id: {{ $campaignDetail['id'] }}
                },
                success: function (response) {
                    console.log(response);
                    $("#responseMessage").show();
                    $("#checkResponce").hide();
                    if (response.success) {
                        $("#responseMessage").html("<div class='alert alert-success alert-block'>Mail Send Successfully</div>");
                    } else {
                        $("#responseMessage").html("<div class='alert alert-danger alert-block'>" + response.message + "</div>");
                    }
                    setTimeout(function () {
                        $("#responseMessage").hide();
                    }, 3000);
                }
            });
        });

        $('.dpicker').datetimepicker({
            format: 'MM/dd/yyyy hh:mm:ss',
            language: 'en'
        });
        var campaign_id = "{{$campaignDetail['id']}}";
        var dial_mode = "{{$campaignDetail['dial_mode']}}";
        var group_id = "{{$campaignDetail['group_id']}}";
        var api = "{{$campaignDetail['api']}}";
        var user_id = "{{$campaignDetail['user_id']}}";
        var user_token = "{{$campaignDetail['user_token']}}";
        var extension = "{{$campaignDetail['extension']}}";
        var getLeadAttempt = 0;
        $('#campaign').val(campaign_id);
        $(".showDiv").show();
        $("#start_dialing").prop('disabled', true);

        getLead();
        $('#lead-detail').on('click', '#call-btn', function () {
            event.preventDefault();
            event.stopPropagation();
            var num = $(this).attr('data-number');
            $.ajax({
                type: 'POST',
                url: '/call-number',
                data: {
                    number: num,
                    campaign: campaign_id,
                    lead: '1',
                    "_token": "{{ csrf_token() }}",
                    user_id: user_id,
                    user_token: user_token,
                    extension: extension
                },
                success: function (data) {
                    var res = $.parseJSON(data);
                    if (res.status == 'success') {
                        $("#detail-message").addClass('text-success').removeClass('text-danger').html(res.message);
                        $('#detail-message').fadeOut(6000);
                    } else {
                        $("#detail-message").addClass('text-danger').removeClass('text-success').html(res.message);
                        $('#detail-message').fadeOut(6000);

                    }
                }
            });
        });
        $('.hang-up').on('click', function (event) {
            event.preventDefault();
            event.stopPropagation();
            $('.hang-up').prop('disabled', true);
            $.ajax({
                type: 'POST',
                url: '/hang-up',
                data: {
                    "_token": "{{ csrf_token() }}",
                    user_id: user_id,
                    user_token: user_token,
                },
                success: function (data) {
                    var res = $.parseJSON(data);
                    if (res.status == 'true') {
                        $("#detail-message").addClass('text-success').removeClass('text-danger').html(res.message);
                        $('#detail-message').fadeOut(6000);

                        $(".start-dial-btn :input").attr("disabled", true);

                    } else {
                        $("#detail-message").addClass('text-danger').removeClass('text-success').html(res.message);
                        $('#detail-message').fadeOut(6000);

                    }
                }
            });
        });


        var count = 0;
        $(".digit").on('click', function() {
            var num = ($(this).clone().children().remove().end().text());
            if (count < 13) {
                $("#output").append('<span>' + num.trim() + '</span>');
                count++
            }

            $.ajax({
                type: 'POST',
                url: '/dtmf',
                data: {
                    digit: num,
                    user_id: user_id,
                    user_token: user_token,
                    extension: extension,
                    "_token": "{{ csrf_token() }}"
                },
                success: function (data) {
                    var res = $.parseJSON(data);
                    if (res.status != "true") {
                        $("#detail-message").addClass('text-danger').removeClass('text-success').html(res.message);
                        $('#detail-message').fadeOut(6000);

                    }
                }
            });


        });

        $('.fa-long-arrow-left').on('click', function() {
            $('#output span:last-child').remove();
            count--;
        });

       /* $('.digits').click(function () {
            var digit = $(this).attr('data-number');
            $('.digit-number').append(digit);
            $.ajax({
                type: 'POST',
                url: '/dtmf',
                data: {
                    digit: digit,
                    user_id: user_id,
                    user_token: user_token,
                    extension: extension,
                    "_token": "{{ csrf_token() }}"
                },
                success: function (data) {
                    var res = $.parseJSON(data);
                    if (res.status != "true") {
                        $("#detail-message").addClass('text-danger').removeClass('text-success').html(res.message);
                        $('#detail-message').fadeOut(6000);

                    }
                }
            });
        });*/
        $('.voicemail-drop').click(function () {
            $.ajax({
                type: 'POST',
                url: '/voicemail-drop',
                data: {
                    user_id: user_id,
                    user_token: user_token,
                    extension: extension,
                    "_token": "{{ csrf_token() }}"
                },
                success: function (data) {
                    var res = $.parseJSON(data);
                    if (res.status == "true") {
                        $("#detail-message").addClass('text-success').removeClass('text-danger').html(res.message);
                        $('#detail-message').fadeOut(6000);

                        $(".hang-up").trigger("click");
                    }
                }
            });
        });
        $('.send-to-crm').click(function () {
            var num = $('#lead-detail').attr('data-number');
            var lead_id_1 = $('.lead-detail-class-box').attr('value');
            //$('#lead-detail').html(lead_id);
            $.ajax({
                type: 'POST',
                url: '/sendToCrm',
                data: {
                    id: user_id,
                    user_id: user_id,
                    user_token: user_token,
                    campaign: campaign_id,
                    lead: lead_id_1,
                    number: num,
                    "_token": "{{ csrf_token() }}"
                },
                /*success: function (data) {
                    var res = $.parseJSON(data);
                    if (res.status == "success") {
                        window.open(res.url, '_blank');
                    } else {
                        $("#detail-message").addClass('text-success').removeClass('text-danger').html(res.message);
                    }
                }*/

                success: function (data)
                {
                    var res = $.parseJSON(data);
                    //alert(res.status);
                    if (res.status == "false")
                    {
                        //$("#detail-message").addClass('text-success').removeClass('text-danger').html(res.message);
                        alert(res.message);
                    }
                    count = Object.keys(res.url).length;
                    if (res.status == "success")
                    {
                        if(count == 1)
                        {
                            window.open(res.url, '_blank');
                        }
                        else
                        {
                            console.log("hello");
                            $("#sendtocrmselection").modal('show');

                            var html='';
                            for(i=0;i<count;i++)
                            {
                                html+='<p><a target="_blank" style="color:white;background: yellowgreen;" href="'+res.url[i]+'">'+res.main_url[i]+'</a></p>';
                            }

                            //alert(html);
                            $("#showUrls").html(html);
                        }
                    }
                    else
                    {
                        $("#detail-message").addClass('text-success').removeClass('text-danger').html(res.message);
                        $('#detail-message').fadeOut(6000);

                    }
                }
            });
        });

        function getLead() {
            $(".widgetUserDesc").html("");
            $(".widgetUserUsername").html("");
            $(".widget-user-image").hide();
            $("#block-reload-lead").hide();
            $("#reload-lead").attr("disabled", true);
            getLeadAttempt++;
            $.ajax({
                type: 'POST',
                url: '/get-lead',
                data: {
                    "_token": "{{ csrf_token() }}"
                },
                dataType: "json",
                success: function (res) {
                    console.log(res);
                    if (res.success) {
                        getLeadAttempt = 0;

                        var callBtn = '&nbsp;<button type="button" name="call" id="call-btn" class="btn btn-success" value="' + res.number + '" data-number="' + res.number + '">Call</button>';
                        $("#detail-message").html('');
                        $(".start-dial-btn :input").attr("disabled", false);

                        $(".lead-detail-class").removeData("number");
                        $(".lead-detail-class").attr('data-number', res.number);

                        $(".lead-detail-class").removeData("lead");
                        $(".lead-detail-class").attr('data-lead', res.lead_id);

                        $(".lead-detail-class-box").attr('value', res.lead_id);
                        $("#lead-img").attr('title', "Lead id " + res.lead_id);
                        $("#lead-detail").html(res.lead_id);
                        $("#lead_id").val(res.lead_id);
                        $("#list_id").val(res.list_id);


                        $('#btn_send_email').removeData("leadid");
                        $('#btn_send_email').attr('data-leadid', res.lead_id);

                        $('#btn_send_email').removeData("listid");
                        $('#btn_send_email').attr('data-listid', res.list_id);

                        //reset the email and sms values
                        $('#btn_send_email').removeData("emailid");
                        $('#btn_send_email').attr('data-emailid', '');

                        $('#btn_send_sms').removeData("contact");
                        $('#btn_send_sms').attr('data-contact', '');

                        $("#toEmailId").val('');

                        mobile_txt = '';
                        $val_1 = '';
                        $val_2 = '';

                        leadBoxData = '';


                        $.each(res.data, function (columnName, columnData) {
                            console.log(res.lead_id, columnName, columnData);
                            if (columnData.is_dialing) {
                                mobile_val = columnData.value;
                                mobile_txt = '<span class="pull-left ml-1" style="width: 19%;"><i class="fa fa-phone mr-6"></i>' + columnData.value + '</span>';
                                $('#btn_send_sms').attr('data-contact', columnData.value);
                                $("#popup_value").val(columnData.value);
                            } else if (/email/i.test(columnData.label)) {
                                $('#btn_send_email').attr('data-emailid', columnData.value);
                                $("#toEmailId").val(columnData.value);

                                email_txt = '<i class="fa fa-envelope mr-l"></i>';
                                $(".widgetUserDesc").html(email_txt + columnData.value + mobile_txt);
                            } else if (/first name/i.test(columnData.label)) {
                                $(".widgetUserUsername").html(columnData.value);
                                $val_1 = columnData.value;
                            } else if (/last name/i.test(columnData.label)) {
                                $val_2 = columnData.value;
                            }

                            if (columnData.is_visible) {
                                var columnHtml = columnData.value;
                                if (columnData.is_editable) {

                                    data_col = " <input class='form-control' type='text' name='" + columnName + "' id='" + columnName + "' onchange='updateLeadData(this, " + res.lead_id + ")' value='" + columnData.value + "' /><span style='float: right;margin: -24px 5px;' id='" + columnName + "-save-status' class='lead-save-status'></span>";
                                }
                                else
                                {
                                    data_col = "<span id='" + columnName + "-save-status' class='lead-save-status'></span>" + columnData.value;
                                    // data_col = "<span id='" + columnName + "-save-status' class='lead-save-status'></span> <input class='form-control' disabled type='text' name='" + columnName + "' id='" + columnName + "' onchange='updateLeadData(this, " + res.lead_id + ")' value='" + columnData.value + "' />";

                                }
                                //leadBoxData += '<li><a href="javascript:return false;"> <b>' + columnData.label + '</b> <span class="pull-right">' + columnHtml + '</span></a></li>';

                                // leadBoxData += '<div class="form-group row"><label for="example-text-input" class="col-sm-5 col-form-label">' + columnData.label + '</label><div class="col-sm-7">'+data_col+'</div></div>';

                                leadBoxData += '<tr><th style="white-space: nowrap; padding: 0.5rem;">' + columnData.label + '</th><td style="padding: 0.5rem;">'+data_col+'</td></tr>';

                            }
                        });

                        $(".widgetUserUsername").html($val_1 + ' ' + $val_2);
                        $(".leadBoxUser").html(leadBoxData);
                        $(".widget-user-image").show();
                    } else {
                        $('#lead-detail').html('');
                        if (getLeadAttempt < 3) {
                            $("#detail-message").html("Please wait, populating lead information");
                            $('#detail-message').fadeOut(6000);

                            setTimeout(function () {
                                getLead();
                            }, 3000);
                        } else {
                            $.when($.ajax({type: "GET", url: "/hopper-count/" + campaign_id, dataType: "json"})).then(function (data, textStatus, jqXHR) {
                                console.log(data);
                                if (data.success) {
                                    if (data.count === 0) {
                                        $(".leadBoxUser").html('<div class="alert alert-warning"><h5><i class="icon fa fa-warning"></i> No leads in hopper</h5></div>');
                                    }
                                }
                                $("#detail-message").html("Click on Retry button after leads are loaded and call is connected.");
                                $('#detail-message').fadeOut(6000);

                                $("#block-reload-lead").show();
                                $("#reload-lead").attr("disabled", false);
                            });
                        }
                    }
                    console.log("toEmailId: " + $("#toEmailId").val());
                }
            });
        }

        function updateLeadData(input, leadId) {

            var values = {};
            values[input.name] = input.value;

            var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
            if(regex.test(input.value))
            {
                $("#toEmailId").val(input.value);
            }
           

            postData = {
                "_token": $("#csrf-token").val(),
                "values": values
            };
            console.log(postData);

            $.ajax({
                type: "POST",
                url: "/lead/" + leadId,
                data: postData,
                dataType: "json",
                success: function (data) {
                    if (data.success) {
                        $("#" + input.name + "-save-status").addClass('text-success').removeClass('text-danger').html("<i class='icon fa fa-check'></i> ");
                        //window.location.reload(1);
                        
                    } else {
                        $("#" + input.name + "-save-status").addClass('text-danger').removeClass('text-success').html("<i class='icon fa fa-close'></i> ");
                    }
                },
                error: function (xhr, status, error) {
                    //expired csrf or session
                    if (xhr.status === 419) {
                        //request new csrf from server and try again
                        if (upadteCsrfToken()) {
                            updateLeadData(input, leadId);
                            return;
                        }
                    }
                    $("#" + input.name + "-save-status").addClass('text-danger').removeClass('text-success').html("<i class='icon fa fa-close'></i> ");
                }
            });
        }

        function upadteCsrfToken() {
            $.ajax({
                async: false,
                type: "GET",
                url: "/get-csrf-token",
                dataType: "json",
                success: function (data) {
                    $("#csrf-token").val(data.token);
                    return true;
                },
                error: function (xhr, status, error) {
                    return false;
                }
            });
        }

        $('#redial').click(function (event) {
            //alert();
            $(this).attr("disabled", true);
            $('.hang-up').prop('disabled', false);

            event.preventDefault();
            event.stopPropagation();

            var disposition = $(".call-disposition input:radio:checked").val();
            var callBack = $('#callback-time').val();
            $('#lead-detail').html('');
            if (disposition === undefined || disposition === null) {
                $("#disposition_error").removeClass('text-success').addClass('text-danger').html("Please select disposition");
                $("#disposition_error").fadeOut(6000);
            } else {
                $("#disposition_error").html("");
                if (disposition == 4 && (callBack === undefined || callBack === null)) {
                    $("#disposition_error").removeClass('text-success').addClass('text-danger').html("Please add call back time");
                    $("#disposition_error").fadeOut(6000);

                }
            }

            var comment = $('.comment').val();
            var pause_calling = ($('#pause_calling').is(":checked")) ? 1 : 0;
            var lead_id = $("#lead_id").val();
            //alert(lead_id);
            var list_id = $("#list_id").val();
            //alert(list_id);

            /*var disposition = 0;
            var callBack =0;*/




            $.ajax({
                method: "POST",
                url: "/redial-call",
                dataType: "json",
                data: {
                    "_token": "{{ csrf_token() }}",
                    user_id: user_id,
                    user_token: user_token,
                    disposition: disposition,
                    campaign: campaign_id,
                    lead: lead_id,
                    listId: list_id,
                    api: '{{$campaignDetail['api']}}',
                    comment: comment,
                    pause_calling: pause_calling,
                    call_back_time: callBack
                }
            }).done(function (response) {
                if (response.status) {
                    $("#disposition-panel").toggle();
                    if (pause_calling == 1) {
                        $('#lead-detail').html('');
                        $("#detail-message").addClass('text-success').removeClass('text-danger').html(response.message + ". Calling Paused");
                        $('#detail-message').fadeOut(6000);

                        $('.start-dial-btn').addClass("hide");
                        $('.showDiv').hide();
                        $('#start_dialing').attr('disabled', false);
                    } else {
                        $(".leadBoxUser").html('<div class="alert alert-primary"><h5><i class="icon fa fa-info"></i> Call Redial. Please wait...</h5></div>');
                        $("#detail-message").addClass('text-success').removeClass('text-danger').html(response.message);
                        $('#detail-message').fadeOut(6000);

                        getLead();
                    }
                    $('.comment').val('');
                    $(this).attr("disabled", false);
                } else {
                    $("#disposition_error").addClass('text-danger').removeClass('text-success').html("Unable to save disposition");
                    $("#disposition_error").fadeOut(6000);

                }
            }).fail(function () {
                $("#disposition_error").addClass('text-danger').removeClass('text-success').html("Unable to save disposition");
                $("#disposition_error").fadeOut(6000);

            });
        });

        $("#pause_calling").change(function()
        {
            if (!$("#pause_calling").is(":checked"))
            {
                $("#redial").attr("disabled", false);
            }
            else
            {
                $("#redial").attr("disabled", true);
            }
        });

        $('#save-disposition').click(function (event) {
            $(this).attr("disabled", true);
            $('.hang-up').prop('disabled', false);

            event.preventDefault();
            event.stopPropagation();

            var disposition = $(".call-disposition input:radio:checked").val();
            var callBack = $('#callback-time').val();
            $('#lead-detail').html('');
            if (disposition === undefined || disposition === null) {
                $("#disposition_error").removeClass('text-success').addClass('text-danger').html("Please select disposition");
                $("#disposition_error").fadeOut(6000);

            } else {
                $("#disposition_error").html("");
                if (disposition == 4 && (callBack === undefined || callBack === null)) {
                    $("#disposition_error").removeClass('text-success').addClass('text-danger').html("Please add call back time");
                    $("#disposition_error").fadeOut(6000);

                }
            }

            var comment = $('.comment').val();
            var comment_callback = $('.comment_callback').val();

            var full_name = $(".widgetUserUsername").html();

            //alert(full_name);

            let cont_number_sms_phone = mobile_val;



            var pause_calling = ($('#pause_calling').is(":checked")) ? 1 : 0;
            var lead_id = $("#lead_id").val();

            $.ajax({
                method: "POST",
                url: "/save-disposition",
                dataType: "json",
                data: {
                    "_token": "{{ csrf_token() }}",
                    user_id: user_id,
                    user_token: user_token,
                    disposition: disposition,
                    campaign: campaign_id,
                    lead: lead_id,
                    api: '{{$campaignDetail['api']}}',
                    comment: comment,
                    comment_callback: comment_callback,
                    pause_calling: pause_calling,
                    call_back_time: callBack,
                    full_name:full_name+' ( '+cont_number_sms_phone+' )'
                }
            }).done(function (response) {
                if (response.status) {
                    $("#disposition-panel").toggle();
                    if (pause_calling == 1) {
                        $('#lead-detail').html('');
                        $("#detail-message").addClass('text-success').removeClass('text-danger').html(response.message + ". Calling Paused");
                        $('#detail-message').fadeOut(6000);

                        $('.start-dial-btn').addClass("hide");
                        $('.showDiv').hide();
                        $('#start_dialing').attr('disabled', false);
                        $(".HiddenAfterPause").hide();

                    } else {
                        $(".leadBoxUser").html('<div class="alert alert-primary"><h5><i class="icon fa fa-info"></i> Looking for next lead. Please wait...</h5></div>');
                        $("#detail-message").addClass('text-success').removeClass('text-danger').html(response.message);
                        $('#detail-message').fadeOut(6000);

                        getLead();
                    }
                    $('.comment').val('');
                    $(this).attr("disabled", false);
                } else {
                    $("#disposition_error").addClass('text-danger').removeClass('text-success').html("Unable to save disposition");
                    $("#disposition_error").fadeOut(6000);

                }
            }).fail(function () {
                $("#disposition_error").addClass('text-danger').removeClass('text-success').html("Unable to save disposition");
                $("#disposition_error").fadeOut(6000);
                
            });
        });
        $("input[type=radio][name=disposition]").change(function () {
            $("#save-disposition").attr("disabled", false);
            $("#redial").attr("disabled", false);

        });
        @endif

        $("#start_dialing").on('click', function () {
            var campaign = $("#campaign").val();
            if (campaign != '') {

                $('.form-dialer').submit(function () {
                    $("#start_dialing").prop('disabled', true);
                    return true;
                });

            } else {
                $("#form_error").html("Please select Campaign");
            }
        });

        $("#dialPad").click(function () {
                            $("#dialPadModal").modal('show');

        });

        $("#btn-hangup").click(function () {
            $("input[name=disposition]").prop('checked', false);
            $("#disposition-panel").toggle();
        });
        $("#reload-lead").click(function (event) {
            $("#block-reload-lead").hide();
            event.preventDefault();
            event.stopPropagation();
            location.reload();
        });

        $('.form-control').keypress(function (e) {
            var c = String.fromCharCode(e.which);
            if (c.toUpperCase() === c && c.toLowerCase() !== c && !e.shiftKey) {
                $('#message').show();
            } else {
                $('#message').hide();
            }
        });

        $(window).on('beforeunload', function() {
            //$.ajax({
            //    url: 'logout'
            //});
        });

        
    </script>
    <?php /*?>
    <script type="text/javascript">
        jQuery(document).ready(function () {
          // $("#enable-webphone").change(function() {
                $.ajax({
                    url: 'webphone/switch-access',
                    type: 'POST',
                    data: {
                        is_checked: true
                    },
                    dataType:"json",
                    success: function (response){
                        //toastr.success(response);
                        if(response == "Webphone Enabled"){
                           // window.open("{{url('/webphone')}}", "webphone", "menubar=0,resizable=0,width=300,height=580");
                        }
                    },
                    error: function (response) {
                        console.log(response);
                    }
                });
          //});
        });
    </script>
    <?php */?>

<?php //echo $campaignDetail['dial_mode'];die; ?>

    <?php 
    if(!empty($campaignDetail))
    {
    if($campaignDetail['dial_mode'] === 'predictive_dial')
    {?>

     <script src="{{ asset('asset/js/angular.min.js') }}"></script>

     <script>
        var app = angular.module('myApp', []);
        app.controller('myCtrl', function ($scope, $http, $interval)
        {
            i=0;
            var interval;
            interval = $interval(function () {
                $http.get(
                    "/check_extension_live.php?extension=<?php echo Session::get('extension') ?>&alt_extension=<?php echo Session::get('private_identity');?>&parent_id=<?php echo Session::get('parentId');?>"

                ).then(function (response)
                {
                    $scope.result = response.data;
                    if($scope.result.status == 1 && i==0)
                    {

                        getLead();
                         $("#predictive_dial_add_style").show();
                         $("#show_leads").show();
                         i++;
                    }

                    else
                        if($scope.result.status == 0)
                    {
                        i=0;
                        $("#show_leads").show();
                        $(".widget-user-image").hide();
                        $(".leadBoxUser").show();
                        $("#predictive_dial_add_style").css('display','none');


                        $(".leadBoxUser").html('<div class="alert alert-primary"><h5><i class="icon fa fa-info"></i> Looking for next lead. Please wait...</h5></div>');
                        $("#detail-message").addClass('text-success').removeClass('text-danger').html(response.message);
                        $('#detail-message').fadeOut(6000);

                      //  id="predictive_dial_add_style">$('.news').css('display','none');
                    }
                },

                function myError(response)
                {
                    $scope.result = response.statusText;
                });
            }, 1000);
        });

      </script>

      <?php } }?>

      <script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/2.1.0/sweetalert.min.js"></script>


<script>

    function updateDialerModeStatus(dialer_mode)
    {
        
        

             swal(
        {
            title: `Are you sure you want to change the Dialer Mode Extension?`,
            //text: "If you change this, it will be gone changed.",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        }).then((willDelete)=>
        {
            if (willDelete)
            {
                $("#loading").show();
        $.ajaxSetup({
            headers: 
            {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }});

        jQuery.ajax({
            url: "{{ url('/update/dialer-mode') }}",
            method: 'post',
            data:
            {
                dialer_mode: dialer_mode
            },
            success: function(result)
            {
        $("#loading").hide();

                swal("Success!", "Dialer Mode changed successfully", "success")
                //window.location.reload(1);
            }});
            }
            else
            {
            }
        }
        );
    }
</script>
<script>
document.addEventListener("DOMContentLoaded", function () {
    const tabTriggers = document.querySelectorAll('[data-bs-toggle="tab"]');
    tabTriggers.forEach(trigger => {
        trigger.addEventListener('click', function (e) {
            e.preventDefault();
            const targetSelector = this.getAttribute('href');
            const targetTab = document.querySelector(targetSelector);
            
            if (targetTab) {
                // Remove active class from all tabs & tab panes
                document.querySelectorAll('.tab-pane').forEach(pane => pane.classList.remove('active', 'show'));
                document.querySelectorAll('[data-bs-toggle="tab"]').forEach(btn => btn.classList.remove('active'));
                
                // Add active class to clicked tab & target pane
                this.classList.add('active');
                targetTab.classList.add('active', 'show');
            }
        });
    });
});
</script>


<!-- Flatpickr JS -->
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script>
document.addEventListener("DOMContentLoaded", function () {
    const calendar = flatpickr("#callback-time", {
        dateFormat: "m/d/Y",  // mm/dd/yyyy format
        allowInput: true,
        minDate: "today",     // Disable past dates
        defaultDate: "today", // Today's date by default
        disableMobile: true
    });

    // Open calendar when icon is clicked
    document.querySelector(".form-icon").addEventListener("click", () => {
        calendar.open();
    });
});
</script>

<script>
function closeDispositionOffcanvas() {
    var offcanvasEl = document.getElementById('dispositionOffcanvas');
    if (offcanvasEl) {
        var offcanvas = bootstrap.Offcanvas.getInstance(offcanvasEl);
        if (offcanvas) {
            offcanvas.hide();
        }
    }
}

// Campaign Tab SMS
function ShowSmsPopUpTab() {
    closeDispositionOffcanvas();

    $('#preview_sms_id').val("");
    $("#sms_template_list_tab").prop('selectedIndex','');
    let cont_number_sms = $(this).attr('data-contact');
    $('#send_phone_tab').val(cont_number_sms);

    var popup = $("#popup_value").val();
    $("#send_phone_tab").val(popup);

    // अगर Tab वाले में modal open करना है तो uncomment करें
    // $('#myModal_open_tab').modal('show');
}

// Normal Campaign SMS
function ShowSmsPopUp() {
    closeDispositionOffcanvas();

    $('#preview_sms_id').val("");
    $("#sms_template_list").prop('selectedIndex','');
    let cont_number_sms = $(this).attr('data-contact');
    $('#send_phone').val(cont_number_sms);

    var popup = $("#popup_value").val();
    $("#send_phone").val(popup);

    $('#myModal_open').modal('show');
}

// Callback Campaign SMS
function ShowSmsPopUpCallBack() {
    closeDispositionOffcanvas();

    $(".notes_callback").show();

}


// Retry button show karne ke liye
$(".block-reload-lead").show();   

// Retry button click
$(document).on("click", ".reload-lead", function () {
    console.log("Retry clicked:", this);
    // apna retry logic yaha chalega
});

</script>

@endpush
