@extends('layouts.app')
@section('title', 'Holidays')

@section('content')

<section class="content">
        <!--Call tming div starts-->
        <div class="row">
                    
              <h4 class="box-title text-info mb-0"><i class="fa fa-user fa-sx"></i> Holidays</h4>
              <hr class="my-15">
            <div class="col-md-5"style="margin-top:20px;">
				<div class="box bt-3 border-primary"style="height:290px;">
				  <div class="box-header"style="padding:10px;">
					<h4 class="box-title">Add/Edit <strong>Holiday</strong></h4>
				  </div>

				  <div class="box-body">
                  <form class="form-horizontal" method="post" action="{{url('did/save-holiday')}}">
                                    @csrf
                                    <input type="hidden" name="dept_id" value="" />
                                        <div class="row">
                                            <div class="col-sm-5">
                                                <label class="form-label">Name </label>
                                                <input type="text" class="form-control" name="name" value="{{isset($detail['name']) ? $detail['name'] : ''}}" required=""/>
                                                <input type="hidden" class="form-control" name="holiday_id" value="{{$id}}" />
                                            </div>
                                            <div class="col-sm-3">
                                                <label class="form-label">Date </label>
                                                <select class="form-select" name="date">
                                                    @foreach($arrDates as $date)
                                                    <option value="{{$date}}" {{isset($detail['date']) && $date == $detail['date'] ? "selected" : ''}}>{{$date}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <div class="col-sm-4">
                                                <label class="form-label">Month </label>
                                                <select class="form-select" name="month">
                                                    @foreach($arrMonths as $key => $val)
                                                    <option value="{{$key}}" {{isset($detail['month']) && $key == $detail['month'] ? "selected" : ''}}>{{$val}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="box-footer"style="padding-top:100px;" >
                                            <div class="row" >
                                                <div class="col-sm-12">
                                                    <div class="form-group" style="float:right;">
                                                        <tfoot>
                                                            <tr>
                                                                <td>
                                                                    <button id="submit" class="btn btn-primary btn-md" type="submit"><i class="fa fa-check-square-o fa-lg"></i> 
                                                                        Submit
                                                                    </button>
                                                                    &nbsp;
                                                                    <a type="button" class="btn btn-danger btn-md" style="margin-right: 14px;" href="{{url('/did/holidays')}}">
                                                                        <i class="fa fa-close fa-lg"></i> 
                                                                        Cancel
                                                                    </a>
                                                                </td>
                                                            </tr>
                                                        </tfoot>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
				  </div>
                </form>
			  </div>
                   
                  
            </div>
            <div class="col-md-7"style="margin-top:20px;">
                <div class="box box-primary box-solid bt-3 border-primary">
               

                    <div class="box-body">
                    <h4 class="box-title">Holiday List</h4>

                        <div class="row">
                            <div class="col-sm-12">
                            <div class="table-responsive ">
								<table class="table mt-0 table-hover no-wrap">
									<thead>
										<tr>
											<th>Name</th>
											<th>Date</th>
											<th>Action</th>
										</tr>
									</thead>
									<tbody>
                                    @if(sizeof($holidays) > 0)
                                            @foreach($holidays as $holiday)
										<tr id="holiday_{{$holiday['id']}}">
											<td>{{$holiday['name']}}</td>
											<td>{{$holiday['date']}} {{$arrMonths[$holiday['month']]}}</td>
											<td> 
                                                <!-- <a onclick="deleteHoliday('{{$holiday['id']}}')" href="javascript:void(0);"><i class="fa fa-trash-o"></i></a> &nbsp; -->
                                            <a  class="openHolidayDelete" style="cursor:pointer;margin-right:5px;"data-holidayid="{{$holiday['id']}}" ><i class="fa fa-trash-o fa-lg"></i></a>     
                                                        <a  style="cursor:pointer;"href="{{url('/')}}/holidays/{{$holiday['id']}}"><i class="fa fa-edit fa-lg"></i></a></td>
										</tr>
                                        @endforeach
                                        @else
                                        <tr><td colspan="3" class="text-center">No Holidays Found</td></tr>
                                        @endif
									</tbody>
								</table>
							</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--Call tming div ends-->
        <div class="modal fade" id="delete" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="myModalLabel">Confirm Delete</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>

                <div class="modal-body">
                  <p>You are about to delete <b><i class="title"></i></b>Holiday.</p>
                  <p>Do you want to proceed?</p>
                  <input type="hidden" class="form-control" name="holiday_id" value="" id="holiday_id">
                  
                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                  <button type="submit"name="submit" class="btn btn-danger btn-sm deleteHoliday">Delete</button>
                </div>
              </div>
            </div>
        </div>
      </div>
    </section>



    <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>

    <script>
    $(".openHolidayDelete").click(function () {
        var delete_id = $(this).data('holidayid');
            $("#delete").modal('show');
            $("#holiday_id").val(delete_id);

        });
        $(document).on("click", ".deleteHoliday", function () {
            // if (confirm("Are you sure you want to delete this record?")) {
            var holiday = $("#holiday_id").val();
            //alert(campaign);
            //var account_no = $(this).data('account_no');
            //alert(account_no);
            var el = this;
            $.ajax({
                url:'/did/delete-holiday/' + holiday,
                type: 'get',
                success: function (response) {
                    toastr.success('Holiday has been deleted successfully');
                    window.location.reload(1);
                }
            });
        });
    
  
</script>




@endsection
