@extends('layouts.app')
@section('title', 'Office Hours')

@section('content')

<!-- Main content -->
<section class="content">
<div class="col-md-12">
<!-- Default box -->
<div class="box">
<div class="box-header with-border "style="padding:5px 10px;">            
<h4 class="box-title text-info mb-0 mt-5"><i class="fa fa-user fa-sx"></i> Call Times</h4>
<a href="{{url('/')}}/did/call-timings/0" type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5 mt-5"><i class="fa fa-plus"></i>Add Call Timings</a>
</div>
</div>
</div>

@foreach($arrDep as $name => $department)
<div class="box collapsed-box">
<div class="col-md-12">
<!-- Default box -->
<div class="box">
  <div class="box-header with-border"style="padding:10px;">
    <h4 class="box-title">Call Timings For {{$name}} : {{$department['description']}}</h4>
    <ul class="box-controls pull-right">
      <li><a class="box-btn-slide" href="#"></a></li>	
    </ul>
  </div>

  <div class="box-body">
    <div class="table-responsive">
      <table class="table mt-0 table-hover table-striped no-wrap">
        <thead>
          <tr>
            <th>Day</th>
            <th>From</th>
            <th>To</th>
          </tr>
        </thead>
        <tbody>
          @if($arrDays > 0)
            @foreach($arrDays as $day => $val)
              <tr>
                <th scope="row">{{$day}}</th>
                <td>{{isset($arrResult[$name][$day]['from_time']) ? $arrResult[$name][$day]['from_time'] : '-NA-'}}</td>                        
                <td>{{isset($arrResult[$name][$day]['to_time']) ? $arrResult[$name][$day]['to_time'] : '-NA-'}}</td>                                         
              </tr>
            @endforeach
          @else  
            <tr><td colspan="3" class="text-center">No Call Timings Found</td></tr>
          @endif
        </tbody>
        <tfoot>
          <tr>
            <td colspan="3">
              <a href="{{url('/')}}/did/call-timings/{{$department['id']}}" class="btn btn-primary" type="button" style="float:right;">
                <i class="fa fa-check-square-o"></i> Edit
              </a>
            </td>
          </tr>
        </tfoot>
      </table>
    </div>
  </div>
  <!-- /.box-body -->
</div>
<!-- /.box -->
</div>
</div>
@endforeach
</section>
@endsection
