@extends('layouts.app')
@section('title', 'Document Types List')

@section('content')
<style>
  .badge
{font-size: 1rem;
    font-style: normal;
    font-weight: 400;
    font-family: "IBM Plex Sans", sans-serif;
    line-height: 1.5;}
  </style>
<style>
       .extension-item {
        display: inline-block;
        margin-right: 5px; /* Adjust the margin as needed */
    }
    * {
  user-select: none;
  -webkit-tap-highlight-color: transparent;
}

.switch {
  transform: scale(0.5); /* Adjust the scale value as needed to reduce the size */
}
/* Style for the active state */
.btn-toggle.active {
    background-color: #2196f3; /* Set to the desired green color */
    color: white; /* Set to the desired text color */
    border-color: green; /* Set to the desired border color */
}

/* Style for the inactive state */
.btn-toggle:not(.active) {
    background-color: red; /* Set to the desired red color */
    color: white; /* Set to the desired text color */
    border-color: red; /* Set to the desired border color */
}



    </style>
    <link href="{{asset('assets/css/bootstrap4-toggle.min.css')}}" rel="stylesheet">

<!-- Main content -->
        <section class="content">

      <div class="row">  
        <div class="col-12">
          <div class="box">
            <div class="box-body">           
          
                <div class="d-flex justify-content-between align-items-center">
                    <h4 class="box-title text-info mb-0"><i class="icon-Add-user"><span class="path1"></span><span class="path2"></span></i>Document Types List</h4>
                    <a href="#"data-bs-toggle="modal" data-bs-target="#add-new-events" type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-plus"></i>   Add Document Type</a>
                </div>

              <hr class="my-15">
              <div class="table-responsive">
                <table id="tickets1" class="table mt-0 table-hover no-wrap" data-page-size="10">
                  <thead>
                                        <tr>
											<th>#</th>
											<th>Title</th>
                                            <th>Values</th>
											<th>Status</th>                             
											<th>Action</th>

										</tr>
                  </thead>
                    <tbody>
                              
                                @if(!empty($document_types))
                                        @foreach($document_types as $key => $list)
                                            <tr>
                                                <td>{{$key+1}}</td>
                                                <td>{{$list->title}}</td>
                                                <td>
                                                    @if($list->values !== NULL && (is_array(json_decode($list->values)) && count(json_decode($list->values)) > 0))
                                                        {{ implode(', ', json_decode($list->values)) }}
                                                    @else
                                                        NA
                                                    @endif
                                                </td>


                                                <td>      <button type="button"data-id="{{$list->id}}"  class="btn btn-sm btn-toggle  @if($list->status == '1') active @endif" data-bs-toggle="button" aria-pressed="true" autocomplete="off">
														<div class="handle"></div>
													</button>
                                                </td>

                                                <td>
                                                    
                                                            <a  style="cursor:pointer;margin-right:5px;" href="javascript:void(0)" data-toggle="tooltip"
                                                               data-id="{{$list->id}}" data-title="{{$list->title}}" data-values="{{$list->values}}"
                                                               data-original-title="Edit" class="edit"><i
                                                                    class="fa fa-edit edit fa-lg"></i></a>
                                                      
                                               
                                                                    <a style="cursor:pointer;" href="#" class="show_confirm" data-id="{{$list->id}}"><i class="fa fa-trash-o fa-lg"></i></a>

                                                       
                                                       
                                                        </label>
                                                    
                                                </td>
                                            </tr>
                                        @endforeach
                                @endif                            										
                    </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div class="modal fade none-border" id="delete">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title"><strong>Delete </strong> Document</h4>
					<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
				</div>
				<div class="modal-body">
			
							
							<p>You are about to delete <b><i class="title"></i></b> Document </p>
							<input  type="hidden"name="deleteStatus"id="deleteStatus">
                                    <p>Do you want to proceed?</p>
								</div>
								<div class="card-footer">
									<button type="submit" class="btn btn-danger deleteLead"> Delete</button>
									<a type="button" class="btn btn-primary" data-bs-dismiss="modal">Close</a>
								</div>
						
			    </div>
		   </div>
	    </div>
    </div>

    <div class="modal fade none-border" id="ajaxModel">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title"><strong>Edit </strong> Document Type</h4>
					<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
				</div>
				<div class="modal-body">
                <form method="post" action="{{ route('documenttype.update') }}" id="updateDocumentType">
                            @csrf
                            <input type="hidden" name="documenttype_id" id="documenttype_id">
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="exampleInputEmail1">Title</label>
                                    <input type="text" required class="form-control" id="title" name="title"
                                           placeholder="Title">
                                </div>

                                <div class="form-group">
                                        <label for="exampleInputEmail1">Select Values</label>
                                        <select class="form-select" name="data_type" id="data_type">
                                            <option  value="No">No</option>
                                            <option value="select_option">Yes</option>
                                        </select>

                                    </div>
                                    <div class="form-group">
                                        <div id="select_choices_container_edit">
                                            <span>
                                                <i>Input comma-separated values</i>
                                            </span>
                                            <textarea class="form-control" id="select_choices_edit" placeholder="Write your selection choices..."
                                                  name="select_choices"></textarea>
                                        </div>
                                    </div>
                                   
                            </div>
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary"><i class="fa fa-edit"
                                                                                 aria-hidden="true"></i> Update
                                </button>
                                <a type="button" class="btn btn-danger" data-bs-dismiss="modal">Close</a>

                            </div>
                        </form>
			    </div>
		   </div>
	    </div>
    </div>
  <!-- BEGIN MODAL -->
	<!-- Modal Add Category -->
	<div class="modal fade none-border" id="add-new-events">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title"><strong>Add</strong> Document Type</h4>
					<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
				</div>
				<div class="modal-body">
                <form method="post" id="addLabel">
                                @csrf
                                <div class="card-body">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Title</label>
                                        <input type="text" required class="form-control" name="title"
                                               placeholder="Title">
                                    </div>

                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Select Values</label>
                                        <select class="form-select data_type" name="data_type">
                                            
                                            <option selected value="No">No</option>
                                            <option value="select_option">Yes</option>
                                        </select>

                                    </div>
                                    <div class="form-group">
                                        <div id="select_choices_container">
                                            <span>
                                                <i>Input comma-separated values</i>
                                            </span>
                                            <textarea class="form-control" id="select_choices" placeholder="Write your selection choices..."
                                                  name="select_choices"></textarea>
                                        </div>
                                    </div>
                                   
                                </div>

                                <div class="card-footer">
                                    <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Submit
                                    </button>
                                    <a type="button" class="btn btn-danger" data-bs-dismiss="modal">Close</a>

                                </div>
                            </form>
			</div>
		</div>
	</div>
	<!-- END MODAL -->
 
<!-- edit modal -->
   
	
      <!-- /.row -->

    </section>
  
    <style>
        #select_choices{
            width: 100%;
        }
        #select_choices_container,#select_choices_container_edit span{
            font-size: 12px;
        }
    </style>

<script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>
<script src="{{asset('assets/js/bootstrap4-toggle.min.js')}}"></script>
<script>
       $('.show_confirm').click(function(event)
    {
		$('#delete').modal('show');
		var delete_id = $(this).data('id');
  console.log(delete_id);
   $("#deleteStatus").val(delete_id);
  
    });


    $(document).on("click", ".deleteLead", function() {
    var delete_id = $("#deleteStatus").val();
    var csrfToken = $('meta[name="csrf-token"]').attr('content');
    var deleteUrl = '/document-types/' + delete_id; // Include the ID in the URL

    $.ajax({
        url: deleteUrl,
        type: 'get', 
        headers: {
            'X-CSRF-TOKEN': csrfToken // Include the CSRF token in the headers
        },
        success: function(response) {
            window.location.reload(1);
        },
        error: function(xhr, status, error) {
            console.log("Error: " + error); // Log any errors to the console
        }
    });
});
    </script>
<script>
$(document).ready(function() {
    $('#tickets1').DataTable({
        columnDefs: [
            {
                targets: [0,2,3], // Columns to disable sorting
                orderable: false
            },
            {
                targets: [1], // Name column, enable sorting
                orderable: true
            }
        ]
    });
});
</script>
    <script type="text/javascript">
 
        $('.edit').click(function () {
            var id = $(this).data('id');
            var title = $(this).data('title');
            var values = $(this).data('values');


            if(values[0])
            {
            var data_type = 'select_option';
             $('#data_type').val(data_type);

             $('#data_type').val(data_type);
                $("#select_choices_container_edit").show();
                $('#select_choices_edit').val(values);

             
            }
            else
            {


            var data_type = 'No';

             $('#data_type').val(data_type);


            $("#select_choices_container_edit").hide();
                $('#select_choices_edit').val("");

             

            }



            $('#ajaxModel').modal('show');
            $('#documenttype_id').val(id);
            $('#title').val(title);
           
            $('#required').val(required);
            $('#display_order').val(display_order);



        });

   $(function()
  {
    $("#tickets1").on("click", ".btn-toggle", function ()
    {
      var button = $(this);
        var status = button.hasClass('active') ? 1 : 0;
      var documenttype_id = button.data('id');             

      $.ajax({
        type: "GET",
        dataType: "json",
        url: '/changeDocumentTypeStatus/'+documenttype_id+'/'+status,
        success: function(data)
        {
          if(data.status == 'true')
          {
            $('#loading').show();
          console.log(data.success);
          window.location.reload(1);
          }
          else
          {
            
          }
          
        }
      });
    })
  })

  $(document).ready(function()
  {
    $('#addGroup,#updateDocumentType').submit(function()
    {
      $("#ajaxModel").hide();
      $('#loading').show();
    });
  })

        $(document).ready(function () {
            $('#addLabel,#updateLabel').submit(function () {
                $("#ajaxModel").hide();
                $('#loading').show();
            });

            $("#select_choices_container").hide();
            $("#select_choices_container_edit").hide();


            $( ".data_type" ).change(function() {
                var val = $(".data_type").val();
                if(val=="select_option"){
                    $("#select_choices_container").show();
                } else {
                    $("#select_choices_container").hide();
                }
            });

            $( "#data_type" ).change(function() {
                var val = $("#data_type").val();
                if(val=="select_option"){
                    $("#select_choices_container_edit").show();
                } else {
                    $("#select_choices_container_edit").hide();
                }
            });
        })

    </script>


@endsection
