@extends('layouts.app')
@section('title', 'Do Not Call List')

@section('content')
    <style>
        /* Custom style for pagination links */
        .pagination {
            margin: 0;
            /* Remove default margin */
            padding: 0;
            /* Remove default padding */
            list-style: none;
            /* Remove list bullet points */
            display: flex;
            /* Use flex layout for horizontal alignment */
        }

        .pagination li a {
            padding: 6px;
        }

        .pagination a {
            display: inline-block;
            padding: 0;
            /* Adjust the padding as needed */
            text-decoration: none;
            background-color: #f0f0f0;
            border: 1px solid #ccc;
            color: #333;
            transition: background-color 0.3s ease, color 0.3s ease;
        }

        .pagination a:hover {
            background-color: #ccc;
            color: #fff;
        }

        .pagination .active a {
            background-color: #007bff;
            color: #fff;
        }

        .table>tbody>tr>td,
        .table>tbody>tr>th {
            padding: 0.7rem;
            vertical-align: middle;
        }
    </style>
    <!-- Main content -->
    <section class="content">

        <div class="row">

            <?php
            $url_page = explode('?', str_replace('/', '', $_SERVER['REQUEST_URI']));
            $url = $url_page[0];
            
            if ($page == 1) {
                $currentPage = 1;
            } else {
                $currentPage = isset($_GET['page']) ? (int) $_GET['page'] : 1;
            }
            
            $perPage = $show;
            $paginator = new Illuminate\Pagination\LengthAwarePaginator($dnc_list, $record_count, $perPage, $currentPage, ['path' => url($url)]);
            $record_count = $paginator->total();
            ?>

            <div class="col-12">
                <div class="box">
                    <div class="box-body">

                        <h4 class="box-title text-info mb-0"><i class="fa fa-list fa-sx"></i> Do Not Call List</h4>
                        <a id="openDNCForm" type="submit" style="float:right;margin-left:10px;"
                            class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i
                                class="fa fa-plus"></i>Add DNC</a>
                        <a id="openExcelForm" data-bs-toggle="modal" data-bs-target="#myModalExcel" type="submit"
                            class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"style="float:right;margin-left:10px;"><i
                                class="fa fa-excel-o"></i>Upload Excel </a> &nbsp;
                        <a href="{{ url('/dnc') }}"style="float:right"
                            class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5 ml-10">Back</a>

                        <hr class="my-15">
                        <b>Total Rows :<?= $record_count ?></b>
                        {{-- <form method="GET" action="">
                            <div style="text-align:right;">
                                <label class="form-label"style="margin-top:5px;">Search:</label>
                                <input class="form-control form-control-sm"type="search" name="search"id="search"
                                    placeholder="Number or Extension"value="{{ $searchTerm }}"
                                    style="width:auto;float:right;margin-left:0.5em;display:inline-block;margin:0 10px;padding: 5px 30px 5px 15px;">
                                <!-- <button type="submit"><i class="fa fa-search"></i></button> -->
                            </div>
                            <label class="label-class" for="show">Show:</label>
                            <select class="form-select form-control-sm"name="show"
                                onchange="this.form.submit()"style="width:75px;display:inline-block;">
                                <option value="10" {{ request('show') == 10 ? 'selected' : '' }}selected>10</option>
                                <option value="25" {{ request('show') == 25 ? 'selected' : '' }}>25</option>
                                <option value="50" {{ request('show') == 50 ? 'selected' : '' }}>50</option>
                                <option value="100" {{ request('show') == 100 ? 'selected' : '' }}>100</option>
                            </select>
                            <label for="entries">entries</label>

                        </form> --}}
                        <div class="table-responsive">
                            <table class="table mt-0 table-hover no-wrap" id="dncTable">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Number</th>
                                        <th>Extension</th>
                                        <th>Comment</th>
                                        @if (session()->get('level') >= 7)
                                            <th>Action</th>
                                        @endif

                                    </tr>
                                </thead>
                                <tbody>
                                    {{-- @foreach ($dnc_list as $key => $dnc)
                                        <tr>
                                            <th scope="row">
                                                {{ ($paginator->currentPage() - 1) * $paginator->perPage() + $key + 1 }}
                                            </th>
                                            <td class="phone">{{ $dnc->number }}</td>
                                            <td> {{ $dnc->extension }}</td>
                                            <td>{{ $dnc->comment }}</td>
                                            <td>
                                                @if (session()->get('level') >= 7)
                                                    <a style="cursor:pointer;margin-right:5px;"title="Edit" class='editDnc'
                                                        data-number="{{ $dnc->number }}"><i
                                                            class="fa fa-edit fa-lg"></i></a>
                                                    <a style="cursor:pointer;"title="Delete" class='openDncDelete'
                                                        data-number="{{ $dnc->number }}"><i
                                                            class="fa fa-trash-o fa-lg"></i></a>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach --}}
                                </tbody>
                            </table>
                            {{-- <div style="float:right;">
                                {{ $paginator->appends(Request::all())->links() }}
                            </div> --}}
                        </div><!-- /.box-body -->




                    </div>

                </div>
            </div>
        </div>
        </div>
        <!-- /.row -->

        <!-- Button trigger modal -->


        <!-- Modal -->
        <div class="modal fade" id="myModalExcel" tabindex="-1" aria-labelledby="myModalExcelLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="upload-excel">Upload Excel</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form method="post" action="" enctype="multipart/form-data">
                        @csrf
                        <div class="modal-body">
                            <input type="hidden" class="form-control" name="dnc" value="">
                            <label class="form-label" for="inputEmail3" class="col-form-label closed">Excel</label>
                            <input class="form-control closed" type="file" required name="dnc_file" id="dnc_file"
                                placeholder="Select Excel File">

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                            <button type="submit"name="submit" class="btn btn-primary btn-sm">Save changes</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>


        <!-- Modal -->
        <div class="modal fade" id="myModal" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="add-edit"></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form method="post" action="" enctype="multipart/form-data">
                        @csrf
                        <div class="modal-body">
                            <input type="hidden" class="form-control" name="dnc" value="" id="id">
                            <div class="form-group">
                                <label for="inputEmail3" class="form-label closed number">Number </label>
                                <div class="input-group mb-3">
                                    <input type="tel" class="form-control closed" required name="number" id="number"
                                        placeholder="Please enter 10-digit phone number">
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="inputEmail3" class="form-label ">Extension </label>
                                <div class="input-group mb-3">
                                    <span class="input-group-text"><i class="ti-user"></i></span>
                                    <select class="form-select" required name="extension" id="extension">
                                        <option value="" selected>Please Select Extension</option>
                                        @foreach ($extension_list as $key => $extensions)
                                            @if (request()->session()->get('level') > 9)
                                                @if ($extensions->user_level <= 9 || $extensions->extension == request()->session()->get('extension'))
                                                    <option value="{{ $extensions->extension }}">{{ $extensions->name }}
                                                        - {{ $extensions->extension }}</option>
                                                @endif
                                            @elseif($extensions->user_level < 9 || $extensions->extension == request()->session()->get('extension'))
                                                <option value="{{ $extensions->extension }} ">{{ $extensions->name }} -
                                                    {{ $extensions->extension }}</option>
                                            @endif
                                        @endforeach

                                    </select>
                                </div>
                            </div>
                            <div class="form-group">

                                <label for="inputPassword3" id="" class="form-label">Comments </label>
                                <textarea class="form-control" required name="comment" id="comment" placeholder="Enter comments here"></textarea>
                                <span id="rchars">300</span> Character(s) Remaining
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary btn-sm"
                                data-bs-dismiss="modal">Close</button>
                            <button type="submit"name="submit" class="btn btn-primary btn-sm">Save</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="modal fade" id="delete" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="myModalLabel">Confirm Delete</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <div class="modal-body">
                        <p>You are about to delete <b><i class="title"></i></b> Do Not Call record.</p>
                        <p>Do you want to proceed?</p>
                        <input type="hidden" class="form-control" name="dnc_number" value="" id="dnc_number">

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                        <button type="submit"name="submit" class="btn btn-danger btn-sm deleteDNC">Delete</button>
                    </div>
                </div>
            </div>
        </div>

        <?php ?>
        </div>
    </section>
    <!-- /.content -->
    <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM="
        crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/imask"></script>
    <script>
        var phoneInput = document.getElementById('number');
        var phoneMask = new IMask(phoneInput, {
            mask: '(000) 000-0000'
        });

        $(document).ready(function() {
            // Format mobile numbers
            $('.phone').each(function() {
                const phoneText = $(this).text();

                const countryCode = phoneText.slice(0, -10); // Extract the country code from the beginning
                const phoneNumber = phoneText.slice(-10); // Extract the last 10 digits

                const formattedMobile =
                    `${countryCode}(${phoneNumber.substr(0, 3)})-${phoneNumber.substr(3, 3)}-${phoneNumber.substr(6)}`;

                $(this).text(formattedMobile);
            });
        });
    </script>
    <script>
        var maxLength = 300;
        $('#comment').keyup(function() {
            var textlen = maxLength - $(this).val().length;
            $('#rchars').text(textlen);
        });
    </script>
    <script>
        $("#openExcelForm").click(function() {
            $("#myModalExcel").modal();
            $("#name").val('');
            $("#status").val('1');
            $("#id").val('');
            $(".closed").show();
            $("#upload-excel").html('Upload Excel');
            console.log('dnc_file');
        });

        $('#dncTable').on("click", ".openDncDelete", function() {

            // $(".openDncDelete").click(function() {
            var dnc_number = $(this).data('number');
            $("#delete").modal('show');
            $("#dnc_number").val(dnc_number);
        });

        $(document).on("click", ".deleteDNC", function() {
            var delete_id = $("#dnc_number").val();

            var el = this;
            $.ajax({
                url: 'deleteDnc/' + delete_id,
                type: 'get',
                success: function(response) {
                    window.location.reload(1);
                }
            });

        });
        $(document).on("click", ".editDnc", function() {
            $("#myModal").modal('show');
            $("#add-edit").html('Edit DNC');

            var edit_number = $(this).data('number');
            var data_index = $(this).data('index');

            //$(".closed").hide();
            $(".number").hide();
            $("#number").hide();

            $.ajax({
                url: 'editDnc/' + edit_number,
                type: 'get',
                success: function(response) {

                    $("#number").val(response[data_index].number);


                    $("#extension").val(response[data_index].extension);
                    $("#comment").val(response[data_index].comment);

                    $("#id").val(response[data_index].number);
                }
            });
        });

        $("#openDNCForm").click(function() {

            $("#myModal").modal('show');
            $("#number").val('');
            $("#extension").val('');
            $("#comment").val('');

            $(".closed").show();
            $("#add-edit").html('Add DNC');
        });
    </script>


    <script>
        $(document).ready(function() {
            $('#dncTable').DataTable({
                processing: true,
                serverSide: true,
                pageLength: 10, // 👈 LIMIT TO 10 RECORDS PER PAGE
                ajax: "{{ url('dnc') }}",
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'number',
                        name: 'number'
                    },
                    {
                        data: 'extension',
                        name: 'extension'
                    },
                    {
                        data: 'comment',
                        name: 'comment'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ],
                error: function(xhr, error, thrown) {
                    console.error("DataTables Error: ", thrown);
                },
language: {
    processing: `
        <span style="display:flex; align-items:center; justify-content:center; gap:8px;">
            <img src="https://i.gifer.com/ZZ5H.gif"
                 alt="Loading..." style="width:20px; height:20px;">
            Processing...
        </span>
    `
}
            });
        });
    </script>




@endsection
