@extends('layouts.app')
@section('title', 'Exclude Number')

@section('content')

    <!-- Main content -->
    <section class="content">

        <div class="row">

            <?php
            $url_page = explode('?', str_replace('/', '', $_SERVER['REQUEST_URI']));
            $url = $url_page[0];
            
            if ($page == 1) {
                $currentPage = 1;
            } else {
                $currentPage = isset($_GET['page']) ? (int) $_GET['page'] : 1;
            }
            
            $perPage = $show;
            $paginator = new Illuminate\Pagination\LengthAwarePaginator($exclude_list, $record_count, $perPage, $currentPage, ['path' => url($url)]);
            $record_count = $paginator->total();
            ?>

            <div class="col-12">
                <div class="box">
                    <div class="box-body">

                        <h4 class="box-title text-info mb-0"><i class="fa fa-list fa-sx"></i> Exclude Number</h4>
                        <a id="openExcludeForm" type="submit" style="float:right;margin-left:10px;"
                            class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i
                                class="fa fa-plus"></i>Add Exclude No</a>
                        <a id="openExcelForm" type="submit"
                            class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"style="float:right;margin-left:10px;"><i
                                class="fa fa-excel-o"></i>Upload Excel </a> &nbsp;
                        <a href="{{ url('/exclude-from-list') }}"style="float:right"
                            class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5 ml-10">Back</a>


                        <hr class="my-15">
                        <b>Total Rows :<?= $record_count ?></b>
                        {{-- <form method="GET" action="">
                            <!-- <div style="margin-bottom:10px;text-align:right;">
                                <label class="label-class">Search:</label>
                                    <input class="form-control-sm"type="search" name="search"id="search" placeholder=""value="{{ $searchTerm }}">
                                    </div> -->
                            <div style="text-align:right;">
                                <label class="form-label"style="margin-top:5px;">Search:</label>
                                <input class="form-control form-control-sm"type="search" name="search"id="search"
                                    placeholder=""value="{{ $searchTerm }}"
                                    style="width:auto;float:right;margin-left:0.5em;display:inline-block;margin:0 10px;padding: 5px 30px 5px 15px;">
                                <!-- <button type="submit"><i class="fa fa-search"></i></button> -->
                            </div>
                            <label class="label-class" for="show">Show:</label>
                            <select class="form-select form-control-sm"name="show"
                                onchange="this.form.submit()"style="width:75px;display:inline-block;">
                                <option value="10" {{ request('show') == 10 ? 'selected' : '' }}selected>10</option>
                                <option value="25" {{ request('show') == 25 ? 'selected' : '' }}>25</option>
                                <option value="50" {{ request('show') == 50 ? 'selected' : '' }}>50</option>
                                <option value="100" {{ request('show') == 100 ? 'selected' : '' }}>100</option>
                            </select>
                            <label for="entries">entries</label>

                        </form> --}}
                        <div class="table-responsive">
                            <table class="table mt-0 table-hover no-wrap" id="exclude">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>First Name</th>
                                        <th>Last Name</th>
                                        <th>Company Name</th>
                                        <th>Mobile</th>
                                        <th>Action</th>


                                    </tr>
                                </thead>
                                <tbody>
                                    {{-- @foreach ($exclude_list as $key => $ex_number)
                                        <tr>
                                            <th scope="row">
                                                {{ ($paginator->currentPage() - 1) * $paginator->perPage() + $key + 1 }}
                                            </th>
                                            <td>{{ $ex_number->first_name }}</td>
                                            <td> {{ $ex_number->last_name }}</td>
                                            <td>{{ $ex_number->company_name }}</td>
                                            <td class="phone">{{ $ex_number->number }}</td>
                                            <td>

                                                <a style="cursor:pointer;margin-right:5px;"title="Edit"
                                                    class='editExcludeNo' data-number="{{ $ex_number->number }}"
                                                    data-campaignid = "{{ $ex_number->campaign_id }}"><i
                                                        class="fa fa-edit fa-lg"></i></a>
                                                <a style="cursor:pointer;"title="Delete" class='openExcludeDelete'
                                                    data-number="{{ $ex_number->number }}"
                                                    data-campaignid="{{ $ex_number->campaign_id }}"><i
                                                        class="fa fa-trash-o fa-lg"></i></a>
                                            </td>
                                        </tr>
                                    @endforeach --}}
                                </tbody>
                            </table>

                        </div><!-- /.box-body -->
                        {{-- @if ($paginator->total() > 0)
                            <div class="text-left mt-10"style=margin-left:10px;>
                                Showing {{ $paginator->firstItem() }} to {{ $paginator->lastItem() }} of
                                {{ $paginator->total() }} entries.
                            </div>
                        @endif --}}
                    </div>

                </div>
            </div>
        </div>
        <!-- /.row -->
        <div class="modal fade" id="delete" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="myModalLabel">Confirm Delete</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <div class="modal-body">
                        <p>You are about to delete <b><i class="title"></i></b> Exclude number record..</p>
                        <p>Do you want to proceed?</p>
                        <input type="hidden" class="form-control" name="exclude_id" value="" id ="number_camp">
                        <input type="hidden" class="form-control" name="exclude_id" value="" id ="campaignid">

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                        <button type="submit"name="submit" class="btn btn-danger btn-sm deleteExcludeNo">Delete</button>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal fade" id="myModal" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="add-edit"></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form method="post" action="">
                        @csrf
                        <div class="modal-body">
                            <div class="row">

                                <div class="row">
                                    <div class="form-group col-md-6">

                                        <input type="hidden" class="form-control" name="exclude" value=""
                                            id ="id" required>
                                        <input type="hidden" name="number_raw" id="number_raw" value="">


                                        <label class="form-label">First Name</label>
                                        <div class="input-group mb-3">

                                            <span class="input-group-text"><i class="ti-user"></i></span>
                                            <input type="text" class="form-control" name="first_name" value=""
                                                id="first_name" required="">
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6">

                                        <label class="form-label">Last Name </label>
                                        <div class="input-group mb-3">
                                            <span class="input-group-text"><i class="ti-user"></i></span>
                                            <input type="text" class="form-control" name="last_name" value=""
                                                id="last_name" required="">
                                        </div>
                                    </div>
                                </div>
                                <div class="row ">
                                    <div class="form-group col-md-6">
                                        <label class="form-label">Company Legal Name</label>
                                        <div class="input-group mb-3">
                                            <span class="input-group-text"><i class="ti-user"></i></span>
                                            <input type="text" class="form-control" name="company_name"
                                                value="" id="company_name" required="">
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="form-label">Number </label>
                                        <div class="input-group mb-3">
                                            <span class="input-group-text"><i class="ti-mobile"></i></span>
                                            <input type="text" class="form-control " name="number" id="number"
                                                placeholder="(___) ___-____">
                                        </div>
                                    </div>
                                </div>
                                <div class="row  closed">
                                    <div class="form-group col-md-6">
                                        <label>Campaign</i></label>
                                        <div class="input-group mb-3">
                                            <span class="input-group-text"><i class="ti-user"></i></span>
                                            <select name="campaign_id" class="js-example-basic-single select2" id="campaign_id"
                                                required="">
                                                @foreach ($campaign_list as $cam)
                                                    @if (!empty($cam->title))
                                                        <option value="{{ $cam->id }}">{{ $cam->title }}</option>
                                                    @endif
                                                @endforeach

                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary btn-sm"
                                    data-bs-dismiss="modal">Close</button>
                                <button type="submit" name="submit" value="Save"
                                    class="btn btn-primary btn-sm">Save</button>
                            </div>
                    </form>
                </div>
            </div>
        </div>





        </div>
        <!-- Button trigger modal -->
        <div class="modal fade" id="myModalExcel" tabindex="-1" aria-labelledby="myModalExcelLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="upload-excel"></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form method="post" action="" enctype="multipart/form-data">
                        @csrf
                        <div class="modal-body">
                            <input type="hidden" class="form-control" name="dnc" value="" id="id">
                            <label for="inputEmail3" class="col-form-label closed">Excel </label>
                            <input type="file" class="form-control closed" required name="exclude_file"
                                id="exclude_file" placeholder="Select Excel File">


                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary btn-sm"
                                data-bs-dismiss="modal">Close</button>
                            <button type="submit"name="submit" class="btn btn-primary btn-sm ">Save</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <?php ?>
        </div>
    </section>
    <!-- /.content -->
    <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM="
        crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/imask"></script>
    <script>
        $(function() {
            var phoneInput = document.getElementById('number');
            var phoneMask = new IMask(phoneInput, {
                mask: '(000) 000-0000'
            });

            $("#number").on('input', function() {
                // Retrieve the raw (unformatted) value
                var rawPhoneNumber = phoneMask.unmaskedValue;

                // Set the value of the 'number' input field
                $("#number_raw").val(rawPhoneNumber);
                // Display the rawPhoneNumber in an alert
            });
        });




        $(document).ready(function() {
            // Format mobile numbers
            $('.phone').each(function() {
                const phoneText = $(this).text();

                const countryCode = phoneText.slice(0, -10); // Extract the country code from the beginning
                const phoneNumber = phoneText.slice(-10); // Extract the last 10 digits

                const formattedMobile =
                    `${countryCode}(${phoneNumber.substr(0, 3)})-${phoneNumber.substr(3, 3)}-${phoneNumber.substr(6)}`;

                $(this).text(formattedMobile);
            });
        });
    </script>
    <script>
        $('#exclude').on("click", ".openExcludeDelete", function() {

            $('#delete').modal('show');
            var number_camp = $(this).data('number');
            var campaignid = $(this).data('campaignid');
            $("#number_camp").val(number_camp);
            $("#campaignid").val(campaignid);

        });

        // $('.openExcludeDelete').click(function() {
        //     $('#delete').modal('show');
        //     var number_camp = $(this).data('number');
        //     var campaignid = $(this).data('campaignid');
        //     $("#number_camp").val(number_camp);
        //     $("#campaignid").val(campaignid);

        // });
        $("#openExcludeForm").click(function() {
            $("#myModal").modal('show');
            $(".closed").show();

            $("#name").val('');
            $("#status").val('1');
            $("#number").val('');
            $("#add-edit").html('Add Exclude Number');
        });


        $(document).on("click", ".deleteExcludeNo", function() {


            var number = $("#number_camp").val();
            var campaign_id = $("#campaignid").val();


            var el = this;
            $.ajax({
                url: 'deleteExcludeNo/' + number + '/' + campaign_id,
                type: 'get',
                success: function(response) {
                    //$(el).closest( "tr" ).remove();
                    window.location.reload(1);
                }
            });

        });
        $(document).on("click", ".editExcludeNo", function() {
            $("#myModal").modal('show');
            $("#add-edit").html('Edit Exclude Number');

            var number = $(this).data('number');
            var campaign_id = $(this).data('campaignid');

            // Set the 'number' value in the modal
            $("#number").val(number);

            // Set the 'campaign_id' value in the 'exclude' input field
            $("#id").val(campaign_id);

            // Display the 'number' value in the '#numberDisplay' element
            $("#numberDisplay").text("Number: " + number);

            $(".closed").hide();

            $.ajax({
                url: 'editExcludeNumber/' + number + '/' + campaign_id,
                type: 'get',
                success: function(response) {
                    console.log(response);
                    $("#first_name").val(response[0].first_name);
                    $("#last_name").val(response[0].last_name);
                    $("#company_name").val(response[0].company_name);
                }
            });
        });

        $("#openExcelForm").click(function() {

            $("#myModalExcel").modal('show');
            $("#name").val('');
            $("#status").val('1');
            $("#id").val('');
            $(".closed").show();
            $("#upload-excel").html('Upload Excel');
        });
    </script>


    <script>
        $(document).ready(function() {
            $('#exclude').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ url('exclude-from-list') }}", // Update to match your route
                    type: 'GET',
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'first_name',
                        name: 'first_name'
                    },
                    {
                        data: 'last_name',
                        name: 'last_name'
                    },
                    {
                        data: 'company_name',
                        name: 'company_name'
                    },
                    {
                        data: 'number',
                        name: 'number'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ],
language: {
    processing: `
        <span style="display:flex; align-items:center; justify-content:center; gap:8px;">
            <img src="https://i.gifer.com/ZZ5H.gif"
                 alt="Loading..." style="width:20px; height:20px;">
            Processing...
        </span>
    `
}
            });
        });
    </script>

<script>
$(document).ready(function() {
   
    function initializeSelect2() {
        $('.js-example-basic-single.select2').select2({
            width: '80%',
            dropdownParent: $('#myModal') 
        });
    }

   
    $('#myModal').on('shown.bs.modal', function() {
        initializeSelect2(); 
    });


    if ($('#myModal').hasClass('show')) {
        initializeSelect2();
    }
});
</script>

@endsection
