@extends('layouts.app')
@section('title', 'Edit Drip Campaign')
@section('content')
<!-- Content Wrapper. Contains page content -->


    <!-- Main content -->
    <section class="content">
        <div class="row">
        <div class="col-lg-12 col-12">
                <div class="box">

                  
                             <div class="box-body"><!--bg-lightest-->
                             <h4 class="box-title text-info mb-0"><i class="fa fa-edit"></i> Edit Drip Campaign</h4>
            <a href="{{url('/drip-campaigns')}}" type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-eye fa-sx"></i> Campaigns</a>
            <hr class="my-15">

                    <div class="row col-md-12">
             
                   
              

                    <form method="post">
                    @csrf
                    
               <input type="hidden" class="form-control" required name="marketing_id" id="marketing_id">
        <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label">Title</label>
                <div class="input-group mb-3">
                <span class="input-group-text"><i class="ti-user"></i></span>
               <input type="text" class="form-control" required name="title" id="title"value="{{$drip_campaign['title']}}">
              </div>
              </div>
            </div>
            <!-- /.col -->
            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label">Description</label>
                <div class="input-group mb-3">
                <span class="input-group-text"><i class="ti-user"></i></span>
               <input type="text" class="form-control" required name="description" id="description"value="{{$drip_campaign['description']}}">
               </div>
              </div>

            </div>
            <div class="row">
            <div class="col-md-6 form-group row email_via">
                        <label for="inputEmail3" class="form-label closed number">Select Email via </label>
                                    <!-- <div class="col-sm-6 radio email_via">

                                       
                                            <input type="radio" checked="checked" id="email_lead_status" name="email_via" value="upload" />
                                            <label for="ivr_audio_option_upload_file" class="form-label">  Lead Status 
                                        </label>
                                    </div>
                                    <div class="col-sm-6 radio ivr_type_txt_to_speech">
                                        
                                            <input type="radio" id="email_list" name="email_via" value="email_list" />
                                            <label for="email_list" class="form-label"> List
                                        </label>
                                    </div> -->
                                    <div class="c-inputs-stacked radio email_via">
        <!-- Lead Status Radio with Bootstrap custom style -->
        <input type="radio" id="email_lead_status" name="email_via" value="upload" checked class="custom-radio" />
        <label for="email_lead_status" class="form-label">Lead Status</label>
            <!-- List Radio with Bootstrap custom style -->
            <input type="radio" id="email_list" name="email_via" value="email_list" class="custom-radio" />
        <label for="email_list" class="form-label">List</label>
    </div>
  
                                
                                </div>
</div>
                                <div class="form-group"id="list_div" style="display: none;">									
                              <label for="inputEmail3" class="form-label closed number">Select List </label>
                                <div class="input-group mb-3">
                                  <span class="input-group-text"><i class="ti-user"></i></span>
                                  <select class="form-select" name="list_id" id="list_id">
                                                    <option value="">Select List</option>
                                                    @if(!empty($list))
                                                        @foreach($list as $key => $clists)
                                                            <option value="{{$clists->list_id}}" >{{$clists->list}}</option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                                <span style="color:red;" id="errorlist_id"></span>                                
                                            </div>
                          </div>
                                  <div class="form-group"id="hidden_listheader" style="display: none;">	
                                    <label for="inputEmail3" class="form-label ">Select column having email </label>
                                    <div class="input-group mb-3">
                                      <span class="input-group-text"><i class="ti-user"></i></span>
                                      <select class="form-select" name="listheader" id="listheader">
                                                    </select>
                                    <span style="color:red;" id="errorlistheader"></span>
                                    </div>
                                  </div>
                                  <div class="col-md-6 form-group" id="lead_status_div">	
    <label for="lead_status_id" class="form-label">Lead Status</label>
    <div class="input-group mb-3">
        <span class="input-group-text"><i class="ti-user"></i></span>
        <select class="form-select" name="lead_status_id" id="lead_status_id">
            <option value="">Select Status</option>
            @if(!empty($lead_status))
                @foreach($lead_status as $key => $clists)
                    <option value="{{ $clists->id }}" 
                        @if(isset($schedule[0]) && $schedule[0]['lead_status_id'] == $clists->id) selected @endif>
                        {{ $clists->title }}
                    </option>
                @endforeach
            @endif
        </select>
        <span style="color:red;" id="errorlead_status_id"></span>
    </div>
</div>


                                  <div class="col-md-6 form-group">	
                                    <label for="inputEmail3" class="form-label ">Email Template </label>
                                    <div class="input-group mb-3">
                                      <span class="input-group-text"><i class="ti-user"></i></span>
                                      <select class="form-select" name="email_template_id" id="email_template_id">
                                                    <option value="">Select Template</option>
                                                    @if(!empty($email_templates))
                                                        @foreach($email_templates as $key => $clists)
                                                            <option value="{{$clists->id}}"@if(isset($schedule[0]) && $schedule[0]['email_template_id'] == $clists->id) selected @endif >{{$clists->template_name}}</option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                                <span style="color:red;" id="erroremail_template_id"></span>
                                    </div>
                                  </div>
                                  <div class="col-md-6 form-group">	
                                    <label for="inputEmail3" class="form-label ">SMTP for sending email [Host - From Email - From Name]  </label>
                                    <div class="input-group mb-3">
                                      <span class="input-group-text"><i class="ti-user"></i></span>
                              
                                                <select class="form-select" name="email_setting_id" id="email_setting_id">
                                        <option value="">Email Setting</option>
                                        @if(!empty($smtp_setting))
                                            @foreach($smtp_setting as $key => $setting)
                                                @if($setting) <!-- Check if the setting exists -->
                                                    <option value="{{$setting->id}}"@if(isset($schedule[0]) && $schedule[0]['email_setting_id'] == $setting->id) selected @endif >
                                                        {{$setting->mail_host}}:{{$setting->mail_port}} - {{$setting->sender_email}} - {{$setting->sender_name}}
                                                    </option>
                                                @endif
                                            @endforeach
                                        @endif
                                    </select>

                                                <span style="color:red;" id="erroremail_setting_id"></span>
                                    </div>
                                  </div>
                                
                                  <div class="col-md-6 form-group">	
                                    <label for="inputEmail3" class="form-label ">Schedule </label>
                                    <div class="input-group mb-3">
                                      <span class="input-group-text"><i class="ti-user"></i></span>
                                      <select class="form-select" name="run_time_id" id="run_time_id" onchange="toggleRunTimeInputs()">
                                                    <option value="daily"@if(isset($schedule[0]) && $schedule[0]['schedule'] == 'daily') selected @endif>Daily</option>
                                                    <option value="weekly"@if(isset($schedule[0]) && $schedule[0]['schedule'] == 'weekly') selected @endif>Weekly</option>

                                                </select>
                                                <span style="color:red;" id="errorrun_time_id"></span>
                                    </div>
                                  </div>
                                  <div class="col-md-6 form-group">
                                    <label class="form-label">Schedule Day & Time</label>
                                    <div class="row mb-3">
                                        <!-- Weekly: Day Selector -->
                                        <div class="col-md-6 mb-3" id="dayContainer" style="display: none;">
                                            <select class="form-select" id="run_day" name="schedule_day" onchange="setWeeklyDate()">
                                                <option value="monday"@if(isset($schedule[0]) && $schedule[0]['schedule_day'] == 'monday') selected @endif>Monday</option>
                                                <option value="tuesday"@if(isset($schedule[0]) && $schedule[0]['schedule_day'] == 'tuesday') selected @endif>Tuesday</option>
                                                <option value="wednesday"@if(isset($schedule[0]) && $schedule[0]['schedule_day'] == 'wednesday') selected @endif>Wednesday</option>
                                                <option value="thursday"@if(isset($schedule[0]) && $schedule[0]['schedule_day'] == 'thursday') selected @endif>Thursday</option>
                                                <option value="friday"@if(isset($schedule[0]) && $schedule[0]['schedule_day'] == 'friday') selected @endif>Friday</option>
                                                <option value="saturday"@if(isset($schedule[0]) && $schedule[0]['schedule_day'] == 'saturday') selected @endif>Saturday</option>
                                                <option value="sunday"@if(isset($schedule[0]) && $schedule[0]['schedule_day'] == 'sunday') selected @endif>Sunday</option>
                                            </select>
                                        </div>

                                    

                                        <!-- Time Input (Visible in Both Cases) -->
                                        <div class="col-md-6 mb-3" id="timeContainer">
                                        <input type="time" class="form-control" id="run_time" name="run_time"
                                        value="{{ isset($schedule[0]['run_time']) ? $schedule[0]['run_time'] : '' }}">
                                            <input type="hidden" value="" id="email_run_time_utc" name="email_run_time_utc">
                                        </div>
                                    </div>
            </div>
      
     

            </div>
      





             
                </div>

            
                    <div class="box-footer text-end">
                    <input type="hidden" class="form-select" name="username" value="" id ="first-name" required>
                    <button type="submit" name="submit" value="Save" class="btn btn btn-primary waves-effect waves-light">Save</button>
                </div>
            </form>
                    </div>
                <div class="row lead_status">
                </div>
            
                    </div><!-- /.box-body -->
                </div><!-- /.box -->

            </div><!-- /.col -->
        </div><!-- /.row -->
    </section><!-- /.content -->
</div>

<script>
    function toggleRunTimeInputs() {
        const runTimeSelect = document.getElementById("run_time_id").value;
        const dayContainer = document.getElementById("dayContainer");

        if (runTimeSelect === "daily") {
            dayContainer.style.display = "none";
            setDailyDate();
        } else if (runTimeSelect === "weekly") {
            dayContainer.style.display = "block";
            setWeeklyDate();
        }
    }

    function setDailyDate() {
        // Set the date to today's date for "Daily" selection
        const today = new Date().toISOString().split('T')[0];
        document.getElementById("run_date").value = today;
    }

    function setWeeklyDate() {
        // Get the selected day of the week
        const selectedDay = document.getElementById("run_day").value;
        const today = new Date();
        let nextDate = new Date(today);
        
        // Set the next occurrence of the selected day
        const daysOfWeek = {
            sunday: 0,
            monday: 1,
            tuesday: 2,
            wednesday: 3,
            thursday: 4,
            friday: 5,
            saturday: 6
        };
        
        const dayIndex = daysOfWeek[selectedDay.toLowerCase()];
        nextDate.setDate(today.getDate() + ((dayIndex + 7 - today.getDay()) % 7 || 7));
        
        // Format date to 'YYYY-MM-DD' and set the value
        const formattedDate = nextDate.toISOString().split('T')[0];
        document.getElementById("run_date").value = formattedDate;
    }

    // Call once on page load to set initial visibility
    toggleRunTimeInputs();
</script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const leadStatusRadio = document.getElementById('email_lead_status');
    const listRadio = document.getElementById('email_list');
    const leadStatusDiv = document.getElementById('lead_status_div');
    const listDiv = document.getElementById('list_div');

    function toggleVisibility() {
        if (leadStatusRadio.checked) {
            leadStatusDiv.style.display = 'block';
            listDiv.style.display = 'none';
        } else if (listRadio.checked) {
            leadStatusDiv.style.display = 'none';
            listDiv.style.display = 'none';
        }
    }

    // Attach event listeners to radio buttons
    leadStatusRadio.addEventListener('change', toggleVisibility);
    listRadio.addEventListener('change', toggleVisibility);

    // Initial toggle based on the default selection
    toggleVisibility();
});
</script>

@endsection
