@extends('layouts.app')
@section('title', 'Email Templates')

@section('content')
<style>
.badge
{font-size: 1rem;
    font-style: normal;
    font-weight: 400;
    font-family: "IBM Plex Sans", sans-serif;
    line-height: 1.5;
  margin-top:5px;}
  /* Style for the active state */
.btn-toggle.active {
    background-color: #2196f3; /* Set to the desired green color */
    color: white; /* Set to the desired text color */
    border-color: green; /* Set to the desired border color */
}

/* Style for the inactive state */
.btn-toggle:not(.active) {
    background-color: red; /* Set to the desired red color */
    color: white; /* Set to the desired text color */
    border-color: red; /* Set to the desired border color */
}
  </style>
<!-- Main content -->
<link href="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/css/bootstrap4-toggle.min.css" rel="stylesheet">

        <section class="content">

      <div class="row">

       
        
        <div class="col-12">
          <div class="box">
           <div class="box-body">           
              <h4 class="box-title text-info mb-0"><i class="fa fa-user fa-sx"></i>  Email Template List</h4>
              <a href="{{ url('/email-template') }}" type="submit"  style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-plus"></i>  Add Email Template</a>
             <hr class="my-15">
              <div class="table-responsive">
                <table id="tickets" class="table mt-0 table-hover no-wrap" data-page-size="10">
                  <thead>
                    <tr>
                    <th>#</th>
                                    <th>Template Name</th>
                                    <th>Template Html</th>
                                    <th>Status</th>                                    
                                    <th>Action</th>

                            </tr>
                  </thead>
                  <tbody>

                  @if(!empty($email_templates))
                                @foreach($email_templates as $key => $template)
                                <tr>
                                  <th scope="row">{{$key+1}}</th>
                                  <td>{{$template->template_name}}</td>                                     
                                  <td>{{strip_tags(substr($template->template_html,0,100))}}....</td>
                                  <td>
                                     <!-- @if($template->status == '1')
                                    <span class="badge  badge-success">Active</span>
                                    @else ($template->status == '0')
                                    <span class="badge  badge-warning">Inactive</span>
                                    @endif -->
                                    <button type="button"data-listid="{{$template->id}}" class="btn btn-sm btn-toggle  @if($template->status == '1') active @endif" data-bs-toggle="button" aria-pressed="true" autocomplete="off">
                                        <div class="handle"></div>
                                 </td>                                 
                                 <td><a style="cursor:pointer;margin-right:5px;"  href="{{url('email-template')}}/{{ $template->id}}" class='editEG'><i class="fa fa-edit fa-lg"></i></a>
                                 <!-- <a @if($template->status == 1) style="cursor:pointer;color:green;margin-right:5px;" @else style="cursor:pointer;color:red;" @endif   class='openEmailTemplete' data-status={{$template->status}} data-id={{$template->id}}> @if($template->status == 1) <i class="fa fa-check fa-lg"></i> @else <i class="fa fa-check fa-lg"></i> @endif </a> -->
                                        <!-- <a style="cursor:pointer;"href="javascript:deleteEmailTemplate({{ $template->id }})" id='delete-{{ $template->id }}'><i class="fa fa-trash-o fa-lg"></i></a> -->
                                        <a  class="openTemplateDelete" style="cursor:pointer;"data-templateid="{{$template->id}}" ><i class="fa fa-trash-o fa-lg"></i></a>     

                                       </td>

                             
                                </tr>

  
                            @endforeach
                         @endif
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
     
      
        <div class="modal fade" id="changeStatus" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="myModalLabel">Confirm Change</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
   
      <div class="modal-body">
      <p>You are about to change <b><i class="title"></i></b>Email Template status.</p>
         <p>Do you want to proceed?</p>
         <input type="hidden" class="form-control" name="temp_id" value="" id="temp_id">
         <input type="hidden" class="form-control" name="status" value="" id="status">    
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
        <button type="submit"name="submit" class="btn btn-danger btn-sm deleteEmailTemp">Confirm</button>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="delete" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="myModalLabel">Confirm Delete</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
   
      <div class="modal-body">
      <p>You are about to delete <b><i class="title"></i></b>Email Template.</p>
         <p>Do you want to proceed?</p>
         <input type="hidden" class="form-control" name="template_id" value="" id="template_id">
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
        <button type="submit"name="submit" class="btn btn-danger btn-sm deleteTemplate">Delete</button>
      </div>
    </div>
  </div>
</div>
      </div>
      <!-- /.row -->

    </section>
        <!-- /.content -->

        <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>
        <script src="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/js/bootstrap4-toggle.min.js"></script>

        <script language="javascript">

$(".openEmailTemplete").click(function() {
    var delete_id = $(this).data('id');
    var status = $(this).data('status');

    $("#changeStatus").modal('show');
    $("#temp_id").val(delete_id);
    $("#status").val(status);


});


// function deleteEmailTemplate(id) {

//     if(!confirm('Are you sure to delete?')){
//         e.preventDefault();
//         return false;
//     }

//     $("#delete-" + id).hide();
//     postData = {
//         "_token": "{{ csrf_token() }}"
//     };

//     $.ajax({
//         type: "POST",
//         url: "/email-template-delete/" + id,
//         data: postData,
//         dataType: "json",

//         success: function (data) {
//             console.log(data);
//             if (data.success) {
//                 $("#alert-success").html(data.message).show();
//                 setTimeout(function(){
//                     window.location.reload(1);
//                 }, 2000);
//             }
//             else {
//                 $("#alert-errors").html(data.message).show();
//             }
//         },

//         error: function (xhr, status, error) {
//             $("#alert-errors").html(error).show();
//         }
//     });
// }

$(document).on("click", ".deleteEmailTemp", function() {
    //if(confirm("Are you sure you want to delete this record?")){
    var temp_id = $('#temp_id').val();
    var status = $('#status').val();

    /* alert(temp_id);
     alert(status);*/

    //var account_no = $(this).data('account_no');
    //alert(account_no);
    var el = this;
    $.ajax({
        url: 'deleteEmailTemplete/' + temp_id +'/'+status,
        type: 'get',
        success: function(response) {
            window.location.reload(1);
            // alert(response);
        }
    });
    //window.location.reload(1);

});

</script>
<script>
$(function()
{
    $("#tickets").on("click", ".btn-toggle", function ()
    {
       console.log('hi');
      var status = $(this).hasClass('active') ? 1 : 0;
        var listid = $(this).data('listid');    


        $.ajax({
            type: "GET",
            dataType: "json",
            url: '/updateEmailTemplateStatus/'+listid+ '/' +status,

            success: function(data)
            {
                if(data.status == 'true')
                {
                    toastr.success(data.message);
                }
                else
                {
                    toastr.error(data.message);

                }

                console.log(data.success);
                window.location.reload(1);
            }
        });
    })
})
$(".openTemplateDelete").click(function() {
        var delete_id = $(this).data('templateid');

        $("#delete").modal('show');
        $("#template_id").val(delete_id);


    });
    $(document).on("click", ".deleteTemplate", function() {
        //if(confirm("Are you sure you want to delete this record?")){
        var temp_id = $('#template_id').val();

        /* alert(temp_id);
         alert(status);*/

        //var account_no = $(this).data('account_no');
        //alert(account_no);
        var el = this;
        $.ajax({
            url: 'email-template-delete/' + temp_id,
            type: 'get',
            success: function(response) {
              toastr.success('Email Template has been deleted successfully');
                    window.location.reload(1);
            }
        });

    });
</script>
@endsection
